/*! © SpryMedia Ltd, Afshin Mehrabani - datatables.net/license */

/**
 * Sorting in Javascript can be difficult to get right with non-Roman
 * characters - for which special consideration must be made. This plug-in
 * performs correct sorting on Persian characters.
 *
 *  @name Persian
 *  @summary Sort Persian strings alphabetically
 *  @author [Afshin Mehrabani](http://www.afshinm.name/)
 *
 *  @example
 *    $('#example').dataTable( {
 *       columnDefs: [
 *         { type: 'pstring', targets: 0 }
 *       ]
 *    } );
 */

import DataTable from 'datatables.net';

var persianSort = [
	'آ',
	'ا',
	'ب',
	'پ',
	'ت',
	'ث',
	'ج',
	'چ',
	'ح',
	'خ',
	'د',
	'ذ',
	'ر',
	'ز',
	'ژ',
	'س',
	'ش',
	'ص',
	'ط',
	'ظ',
	'ع',
	'غ',
	'ف',
	'ق',
	'ک',
	'گ',
	'ل',
	'م',
	'ن',
	'و',
	'ه',
	'ی',
	'ي',
];

function GetUniCode(source) {
	source = source.trim();
	var result = '';
	var i, index;
	for (i = 0; i < source.length; i++) {
		index = persianSort.indexOf(source.charAt(i));

		if (index < 0) {
			index = source.charCodeAt(i);
		}

		if (index < 10) {
			index = '0' + index;
		}

		result += '00' + index;
	}

	return 'a' + result;
}

DataTable.ext.order['pstring-pre'] = function (a, b) {
	return GetUniCode(a.toLowerCase());
};
