/**
 * Use instead of `new Date(Date.UTC(...))` to support years below 100 which doesn't work
 * otherwise due to the nature of the
 * [`Date` constructor](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date#interpretation_of_two-digit_years.
 *
 * For `Date.UTC(...)`, use `newDateUTC(...).getTime()`.
 */
export default function newDateUTC(fullYear, month, day, hour, minute, second, millisecond) {
  var utcDate = new Date(0)
  utcDate.setUTCFullYear(fullYear, month, day)
  utcDate.setUTCHours(hour, minute, second, millisecond)
  return utcDate
}
