import buildLocalizeFn from '../../../_lib/buildLocalizeFn/index.js';
import buildLocalizeArrayFn from '../../../_lib/buildLocalizeArrayFn/index.js';
var weekdayValues = {
  narrow: ['ne', 'po', 'ut', 'sr', 'če', 'pe', 'su'],
  short: ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'],
  long: ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda', 'četvrtak', 'petak', 'subota']
};
var monthValues = {
  short: ['sij', 'velj', 'ožu', 'tra', 'svi', 'lip', 'srp', 'kol', 'ruj', 'lis', 'stu', 'pro'],
  long: ['siječanj', 'veljača', 'ožujak', 'travanj', 'svibanj', 'lipanj', 'srpanj', 'kolovoz', 'rujan', 'listopad', 'studeni', 'prosinac']
};
var timeOfDayValues = {
  long: ['ujutro', 'popodne']
};

function ordinalNumber(dirtyNumber) {
  var number = Number(dirtyNumber);
  return number + '.';
}

var localize = {
  ordinalNumber: ordinalNumber,
  weekday: buildLocalizeFn(weekdayValues, 'long'),
  weekdays: buildLocalizeArrayFn(weekdayValues, 'long'),
  month: buildLocalizeFn(monthValues, 'long'),
  months: buildLocalizeArrayFn(monthValues, 'long'),
  timeOfDay: buildLocalizeFn(timeOfDayValues, 'long', function (hours) {
    return hours / 12 >= 1 ? 1 : 0;
  }),
  timesOfDay: buildLocalizeArrayFn(timeOfDayValues, 'long')
};
export default localize;