"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = differenceInBusinessDays;

var _index = _interopRequireDefault(require("../compareAsc/index.js"));

var _index2 = _interopRequireDefault(require("../eachDayOfInterval/index.js"));

var _index3 = _interopRequireDefault(require("../isValid/index.js"));

var _index4 = _interopRequireDefault(require("../isWeekend/index.js"));

var _index5 = _interopRequireDefault(require("../toDate/index.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @name differenceInBusinessDays
 * @category Day Helpers
 * @summary Get the number of business days between the given dates.
 *
 * @description
 * Get the number of business day periods between the given dates.
 * Business days being days that arent in the weekend.
 * Like `differenceInCalendarDays`, the function removes the times from
 * the dates before calculating the difference.
 *
 * @param {Date|Number} dateLeft - the later date
 * @param {Date|Number} dateRight - the earlier date
 * @returns {Number} the number of business days
 * @throws {TypeError} 2 arguments required
 *
 * @example
 * // How many business days are between
 * // 10 January 2014 and 20 July 2014?
 * var result = differenceInBusinessDays(
 *   new Date(2014, 6, 20),
 *   new Date(2014, 0, 10)
 * )
 * //=> 136
 */
function differenceInBusinessDays(dirtyDateLeft, dirtyDateRight) {
  if (arguments.length < 2) {
    throw new TypeError('2 arguments required, but only ' + arguments.length + ' present');
  }

  var dateLeft = (0, _index5.default)(dirtyDateLeft);
  var dateRight = (0, _index5.default)(dirtyDateRight);
  if (!(0, _index3.default)(dateLeft) || !(0, _index3.default)(dateRight)) return new Date(NaN);
  var sign = (0, _index.default)(dateLeft, dateRight);
  var interval = sign > 0 ? {
    start: dateRight,
    end: dateLeft
  } : {
    start: dateLeft,
    end: dateRight
  };
  var daysOfInterval = (0, _index2.default)(interval);
  var difference = daysOfInterval.filter(function (day) {
    return !(0, _index4.default)(day);
  }); // Substruct 1 because interval contains both starting and ending dates

  var result = sign * (difference.length - 1); // Prevent negative zero

  return result === 0 ? 0 : result;
}

module.exports = exports.default;