# Vietnamese (vi) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                        | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                   | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                      | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                   | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                      | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | I                                                      | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II                                                     | Invalid Date             |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                     | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | quý I                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | quý II                                                 | 2019-01-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                      | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | I                                                      | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II                                                     | Invalid Date             |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                     | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | Quý 1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Quý 2                                                  | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                      | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | thg 2                                                  | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | thg 7                                                  | Invalid Date             |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | tháng 02                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | tháng 07                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | 02                                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 07                                                     | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                      | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | Thg 2                                                  | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | Thg 7                                                  | Invalid Date             |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | Tháng Hai                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Tháng Bảy                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | 2                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                      | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | thứ nhất                                               | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | thứ 48                                                 | Invalid Date             |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | thứ nhất                                               | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | thứ 48                                                 | Invalid Date             |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                     | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | thứ 42                                                 | Invalid Date             |
|                                 |              | 2019-12-31T12:13:14.015Z | thứ 365                                                | Invalid Date             |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Thứ Hai                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ Sáu                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | T2                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | T6                                                     | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Th 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Th 6                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | thứ 6                                                  | Invalid Date             |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Thứ Hai                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ Sáu                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | T2                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | T6                                                     | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Th 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Th 6                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | thứ 6                                                  | Invalid Date             |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Thứ Hai                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ Sáu                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | T2                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | T6                                                     | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Th 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Th 6                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | thứ 6                                                  | Invalid Date             |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Thứ 2                                                  | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ 6                                                  | Invalid Date             |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Thứ Hai                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Thứ Sáu                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | T2                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | T6                                                     | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Th 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Th 6                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | SA                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | CH                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | CH                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | SA                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | am                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                     | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                     | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | SA                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | CH                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | CH                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | SA                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | am                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                     | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                     | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                     | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | sáng                                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | chiều                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | tối                                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | đêm                                                    | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | sáng                                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | chiều                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | tối                                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | đêm                                                    | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | sáng                                                   | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | chiều                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | tối                                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | đêm                                                    | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | vào buổi sáng                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | vào buổi chiều                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | vào buổi tối                                           | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | vào ban đêm                                            | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | sg                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ch                                                     | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | tối                                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | đêm                                                    | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                     | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                     | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                     | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                     | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                     | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                     | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                     | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                     | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                      | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                     | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                      | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                     | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                             | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 thg 2 năm 1987                                      | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 thg 5 năm 1453                                      | Invalid Date             |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | ngày 11 tháng 02 năm 1987                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ngày 29 tháng 05 năm 1453                              | 1453-03-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | Thứ Tư, ngày 11 tháng 02 năm 1987                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Chủ Nhật, ngày 29 tháng 05 năm 1453                    | 1453-03-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                  | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                               | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                         | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                     | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987 12:13                                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453 23:59                                       | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 thg 2 năm 1987 12:13:14                             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 thg 5 năm 1453 23:59:59                             | Invalid Date             |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | ngày 11 tháng 02 năm 1987 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | ngày 29 tháng 05 năm 1453 23:59:59 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | Thứ Tư, ngày 11 tháng 02 năm 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Chủ Nhật, ngày 29 tháng 05 năm 1453 23:59:59 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result         | `includeSeconds: true` | `addSuffix: true`    |
| ------------------------ | -------------- | ---------------------- | -------------------- |
| 2006-01-01T00:00:00.000Z | khoảng 6 năm   | khoảng 6 năm           | khoảng 6 năm nữa     |
| 2005-01-01T00:00:00.000Z | khoảng 5 năm   | khoảng 5 năm           | khoảng 5 năm nữa     |
| 2004-01-01T00:00:00.000Z | khoảng 4 năm   | khoảng 4 năm           | khoảng 4 năm nữa     |
| 2003-01-01T00:00:00.000Z | khoảng 3 năm   | khoảng 3 năm           | khoảng 3 năm nữa     |
| 2002-01-01T00:00:00.000Z | khoảng 2 năm   | khoảng 2 năm           | khoảng 2 năm nữa     |
| 2001-06-01T00:00:00.000Z | hơn 1 năm      | hơn 1 năm              | hơn 1 năm nữa        |
| 2001-02-01T00:00:00.000Z | khoảng 1 năm   | khoảng 1 năm           | khoảng 1 năm nữa     |
| 2001-01-01T00:00:00.000Z | khoảng 1 năm   | khoảng 1 năm           | khoảng 1 năm nữa     |
| 2000-06-01T00:00:00.000Z | 5 tháng        | 5 tháng                | 5 tháng nữa          |
| 2000-03-01T00:00:00.000Z | 2 tháng        | 2 tháng                | 2 tháng nữa          |
| 2000-02-01T00:00:00.000Z | khoảng 1 tháng | khoảng 1 tháng         | khoảng 1 tháng nữa   |
| 2000-01-15T00:00:00.000Z | 14 ngày        | 14 ngày                | 14 ngày nữa          |
| 2000-01-02T00:00:00.000Z | 1 ngày         | 1 ngày                 | 1 ngày nữa           |
| 2000-01-01T06:00:00.000Z | khoảng 6 giờ   | khoảng 6 giờ           | khoảng 6 giờ nữa     |
| 2000-01-01T01:00:00.000Z | khoảng 1 giờ   | khoảng 1 giờ           | khoảng 1 giờ nữa     |
| 2000-01-01T00:45:00.000Z | khoảng 1 giờ   | khoảng 1 giờ           | khoảng 1 giờ nữa     |
| 2000-01-01T00:30:00.000Z | 30 phút        | 30 phút                | 30 phút nữa          |
| 2000-01-01T00:15:00.000Z | 15 phút        | 15 phút                | 15 phút nữa          |
| 2000-01-01T00:01:00.000Z | 1 phút         | 1 phút                 | 1 phút nữa           |
| 2000-01-01T00:00:25.000Z | dưới 1 phút    | nửa phút               | dưới 1 phút nữa      |
| 2000-01-01T00:00:15.000Z | dưới 1 phút    | dưới 20 giây           | dưới 1 phút nữa      |
| 2000-01-01T00:00:05.000Z | dưới 1 phút    | dưới 10 giây           | dưới 1 phút nữa      |
| 2000-01-01T00:00:00.000Z | dưới 1 phút    | dưới 5 giây            | dưới 1 phút trước    |
| 1999-12-31T23:59:55.000Z | dưới 1 phút    | dưới 10 giây           | dưới 1 phút trước    |
| 1999-12-31T23:59:45.000Z | dưới 1 phút    | dưới 20 giây           | dưới 1 phút trước    |
| 1999-12-31T23:59:35.000Z | dưới 1 phút    | nửa phút               | dưới 1 phút trước    |
| 1999-12-31T23:59:00.000Z | 1 phút         | 1 phút                 | 1 phút trước         |
| 1999-12-31T23:45:00.000Z | 15 phút        | 15 phút                | 15 phút trước        |
| 1999-12-31T23:30:00.000Z | 30 phút        | 30 phút                | 30 phút trước        |
| 1999-12-31T23:15:00.000Z | khoảng 1 giờ   | khoảng 1 giờ           | khoảng 1 giờ trước   |
| 1999-12-31T23:00:00.000Z | khoảng 1 giờ   | khoảng 1 giờ           | khoảng 1 giờ trước   |
| 1999-12-31T18:00:00.000Z | khoảng 6 giờ   | khoảng 6 giờ           | khoảng 6 giờ trước   |
| 1999-12-30T00:00:00.000Z | 2 ngày         | 2 ngày                 | 2 ngày trước         |
| 1999-12-15T00:00:00.000Z | 17 ngày        | 17 ngày                | 17 ngày trước        |
| 1999-12-01T00:00:00.000Z | khoảng 1 tháng | khoảng 1 tháng         | khoảng 1 tháng trước |
| 1999-11-01T00:00:00.000Z | 2 tháng        | 2 tháng                | 2 tháng trước        |
| 1999-06-01T00:00:00.000Z | 7 tháng        | 7 tháng                | 7 tháng trước        |
| 1999-01-01T00:00:00.000Z | khoảng 1 năm   | khoảng 1 năm           | khoảng 1 năm trước   |
| 1998-12-01T00:00:00.000Z | khoảng 1 năm   | khoảng 1 năm           | khoảng 1 năm trước   |
| 1998-06-01T00:00:00.000Z | hơn 1 năm      | hơn 1 năm              | hơn 1 năm trước      |
| 1998-01-01T00:00:00.000Z | khoảng 2 năm   | khoảng 2 năm           | khoảng 2 năm trước   |
| 1997-01-01T00:00:00.000Z | khoảng 3 năm   | khoảng 3 năm           | khoảng 3 năm trước   |
| 1996-01-01T00:00:00.000Z | khoảng 4 năm   | khoảng 4 năm           | khoảng 4 năm trước   |
| 1995-01-01T00:00:00.000Z | khoảng 5 năm   | khoảng 5 năm           | khoảng 5 năm trước   |
| 1994-01-01T00:00:00.000Z | khoảng 6 năm   | khoảng 6 năm           | khoảng 6 năm trước   |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result  | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 năm   | 6 năm nữa         | 52608 giờ                      |
| 2005-01-01T00:00:00.000Z | 5 năm   | 5 năm nữa         | 43848 giờ                      |
| 2004-01-01T00:00:00.000Z | 4 năm   | 4 năm nữa         | 35064 giờ                      |
| 2003-01-01T00:00:00.000Z | 3 năm   | 3 năm nữa         | 26304 giờ                      |
| 2002-01-01T00:00:00.000Z | 2 năm   | 2 năm nữa         | 17544 giờ                      |
| 2001-06-01T00:00:00.000Z | 1 năm   | 1 năm nữa         | 12408 giờ                      |
| 2001-02-01T00:00:00.000Z | 1 năm   | 1 năm nữa         | 9528 giờ                       |
| 2001-01-01T00:00:00.000Z | 1 năm   | 1 năm nữa         | 8784 giờ                       |
| 2000-06-01T00:00:00.000Z | 5 tháng | 5 tháng nữa       | 3648 giờ                       |
| 2000-03-01T00:00:00.000Z | 2 tháng | 2 tháng nữa       | 1440 giờ                       |
| 2000-02-01T00:00:00.000Z | 1 tháng | 1 tháng nữa       | 744 giờ                        |
| 2000-01-15T00:00:00.000Z | 14 ngày | 14 ngày nữa       | 336 giờ                        |
| 2000-01-02T00:00:00.000Z | 1 ngày  | 1 ngày nữa        | 24 giờ                         |
| 2000-01-01T06:00:00.000Z | 6 giờ   | 6 giờ nữa         | 6 giờ                          |
| 2000-01-01T01:00:00.000Z | 1 giờ   | 1 giờ nữa         | 1 giờ                          |
| 2000-01-01T00:45:00.000Z | 45 phút | 45 phút nữa       | 1 giờ                          |
| 2000-01-01T00:30:00.000Z | 30 phút | 30 phút nữa       | 1 giờ                          |
| 2000-01-01T00:15:00.000Z | 15 phút | 15 phút nữa       | 0 giờ                          |
| 2000-01-01T00:01:00.000Z | 1 phút  | 1 phút nữa        | 0 giờ                          |
| 2000-01-01T00:00:25.000Z | 25 giây | 25 giây nữa       | 0 giờ                          |
| 2000-01-01T00:00:15.000Z | 15 giây | 15 giây nữa       | 0 giờ                          |
| 2000-01-01T00:00:05.000Z | 5 giây  | 5 giây nữa        | 0 giờ                          |
| 2000-01-01T00:00:00.000Z | 0 giây  | 0 giây trước      | 0 giờ                          |
| 1999-12-31T23:59:55.000Z | 5 giây  | 5 giây trước      | 0 giờ                          |
| 1999-12-31T23:59:45.000Z | 15 giây | 15 giây trước     | 0 giờ                          |
| 1999-12-31T23:59:35.000Z | 25 giây | 25 giây trước     | 0 giờ                          |
| 1999-12-31T23:59:00.000Z | 1 phút  | 1 phút trước      | 0 giờ                          |
| 1999-12-31T23:45:00.000Z | 15 phút | 15 phút trước     | 0 giờ                          |
| 1999-12-31T23:30:00.000Z | 30 phút | 30 phút trước     | 1 giờ                          |
| 1999-12-31T23:15:00.000Z | 45 phút | 45 phút trước     | 1 giờ                          |
| 1999-12-31T23:00:00.000Z | 1 giờ   | 1 giờ trước       | 1 giờ                          |
| 1999-12-31T18:00:00.000Z | 6 giờ   | 6 giờ trước       | 6 giờ                          |
| 1999-12-30T00:00:00.000Z | 2 ngày  | 2 ngày trước      | 48 giờ                         |
| 1999-12-15T00:00:00.000Z | 17 ngày | 17 ngày trước     | 408 giờ                        |
| 1999-12-01T00:00:00.000Z | 1 tháng | 1 tháng trước     | 744 giờ                        |
| 1999-11-01T00:00:00.000Z | 2 tháng | 2 tháng trước     | 1464 giờ                       |
| 1999-06-01T00:00:00.000Z | 7 tháng | 7 tháng trước     | 5136 giờ                       |
| 1999-01-01T00:00:00.000Z | 1 năm   | 1 năm trước       | 8760 giờ                       |
| 1998-12-01T00:00:00.000Z | 1 năm   | 1 năm trước       | 9504 giờ                       |
| 1998-06-01T00:00:00.000Z | 2 năm   | 2 năm trước       | 13896 giờ                      |
| 1998-01-01T00:00:00.000Z | 2 năm   | 2 năm trước       | 17520 giờ                      |
| 1997-01-01T00:00:00.000Z | 3 năm   | 3 năm trước       | 26280 giờ                      |
| 1996-01-01T00:00:00.000Z | 4 năm   | 4 năm trước       | 35064 giờ                      |
| 1995-01-01T00:00:00.000Z | 5 năm   | 5 năm trước       | 43824 giờ                      |
| 1994-01-01T00:00:00.000Z | 6 năm   | 6 năm trước       | 52584 giờ                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                           |
| ------------------------ | -------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                       |
| 2000-01-05T00:00:00.000Z | Thứ Tư tới vào lúc 00:00         |
| 2000-01-02T00:00:00.000Z | ngày mai vào lúc 00:00           |
| 2000-01-01T00:00:00.000Z | hôm nay vào lúc 00:00            |
| 1999-12-31T00:00:00.000Z | hôm qua vào lúc 00:00            |
| 1999-12-27T00:00:00.000Z | Thứ Hai tuần trước vào lúc 00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999                       |
