# Portuguese (pt) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                             | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987º                                                       | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                                          | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987º                                                       | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4º                                                          | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1º                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | T1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1º trimestre                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                           | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1º                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | T1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1º trimestre                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                                | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2º                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                          | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | fev                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | fevereiro                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julho                                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | f                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                           | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2º                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                          | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | fev                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | fevereiro                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julho                                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | f                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                           | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1º                                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                         | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1º                                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                         | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11º                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28º                                                         | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42º                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365º                                                        | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | segunda-feira                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sexta-feira                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1º                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                          | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | segunda-feira                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sexta-feira                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1º                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                          | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | segunda-feira                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sexta-feira                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1º                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | segunda-feira                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sexta-feira                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | s                                                           | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | seg                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | sex                                                         | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                          | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | da manhã                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da noite                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | da madrugada                                                | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | da manhã                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da noite                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | da madrugada                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | da manhã                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da noite                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | da madrugada                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | da manhã                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da noite                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | da madrugada                                                | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | da manhã                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da noite                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | da madrugada                                                | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11º                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11º                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11º                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                         | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11º                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                         | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1º                                                          | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55º                                                         | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1º                                                          | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55º                                                         | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                                  | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 de fev de 1987                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mai de 1453                                           | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 de fevereiro de 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de maio de 1453                                          | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | quarta-feira, 11 de fevereiro de 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de maio de 1453                                 | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                       | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                                    | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                    | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                              | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                          | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                          | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                           | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 de fev de 1987, 12:13:14                                 | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de mai de 1453, 23:59:59                                 | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 de fevereiro de 1987 às 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de maio de 1453 às 23:59:59 GMT+0                        | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | quarta-feira, 11 de fevereiro de 1987 às 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de maio de 1453 às 23:59:59 GMT+00:00           | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  | `includeSeconds: true`  | `addSuffix: true`               |
| ------------------------ | ----------------------- | ----------------------- | ------------------------------- |
| 2006-01-01T00:00:00.000Z | aproximadamente 6 anos  | aproximadamente 6 anos  | daqui a aproximadamente 6 anos  |
| 2005-01-01T00:00:00.000Z | aproximadamente 5 anos  | aproximadamente 5 anos  | daqui a aproximadamente 5 anos  |
| 2004-01-01T00:00:00.000Z | aproximadamente 4 anos  | aproximadamente 4 anos  | daqui a aproximadamente 4 anos  |
| 2003-01-01T00:00:00.000Z | aproximadamente 3 anos  | aproximadamente 3 anos  | daqui a aproximadamente 3 anos  |
| 2002-01-01T00:00:00.000Z | aproximadamente 2 anos  | aproximadamente 2 anos  | daqui a aproximadamente 2 anos  |
| 2001-06-01T00:00:00.000Z | mais de 1 ano           | mais de 1 ano           | daqui a mais de 1 ano           |
| 2001-02-01T00:00:00.000Z | aproximadamente 1 ano   | aproximadamente 1 ano   | daqui a aproximadamente 1 ano   |
| 2001-01-01T00:00:00.000Z | aproximadamente 1 ano   | aproximadamente 1 ano   | daqui a aproximadamente 1 ano   |
| 2000-06-01T00:00:00.000Z | 5 meses                 | 5 meses                 | daqui a 5 meses                 |
| 2000-03-01T00:00:00.000Z | 2 meses                 | 2 meses                 | daqui a 2 meses                 |
| 2000-02-01T00:00:00.000Z | aproximadamente 1 mês   | aproximadamente 1 mês   | daqui a aproximadamente 1 mês   |
| 2000-01-15T00:00:00.000Z | 14 dias                 | 14 dias                 | daqui a 14 dias                 |
| 2000-01-02T00:00:00.000Z | 1 dia                   | 1 dia                   | daqui a 1 dia                   |
| 2000-01-01T06:00:00.000Z | aproximadamente 6 horas | aproximadamente 6 horas | daqui a aproximadamente 6 horas |
| 2000-01-01T01:00:00.000Z | aproximadamente 1 hora  | aproximadamente 1 hora  | daqui a aproximadamente 1 hora  |
| 2000-01-01T00:45:00.000Z | aproximadamente 1 hora  | aproximadamente 1 hora  | daqui a aproximadamente 1 hora  |
| 2000-01-01T00:30:00.000Z | 30 minutos              | 30 minutos              | daqui a 30 minutos              |
| 2000-01-01T00:15:00.000Z | 15 minutos              | 15 minutos              | daqui a 15 minutos              |
| 2000-01-01T00:01:00.000Z | 1 minuto                | 1 minuto                | daqui a 1 minuto                |
| 2000-01-01T00:00:25.000Z | menos de um minuto      | meio minuto             | daqui a menos de um minuto      |
| 2000-01-01T00:00:15.000Z | menos de um minuto      | menos de 20 segundos    | daqui a menos de um minuto      |
| 2000-01-01T00:00:05.000Z | menos de um minuto      | menos de 10 segundos    | daqui a menos de um minuto      |
| 2000-01-01T00:00:00.000Z | menos de um minuto      | menos de 5 segundos     | há menos de um minuto           |
| 1999-12-31T23:59:55.000Z | menos de um minuto      | menos de 10 segundos    | há menos de um minuto           |
| 1999-12-31T23:59:45.000Z | menos de um minuto      | menos de 20 segundos    | há menos de um minuto           |
| 1999-12-31T23:59:35.000Z | menos de um minuto      | meio minuto             | há menos de um minuto           |
| 1999-12-31T23:59:00.000Z | 1 minuto                | 1 minuto                | há 1 minuto                     |
| 1999-12-31T23:45:00.000Z | 15 minutos              | 15 minutos              | há 15 minutos                   |
| 1999-12-31T23:30:00.000Z | 30 minutos              | 30 minutos              | há 30 minutos                   |
| 1999-12-31T23:15:00.000Z | aproximadamente 1 hora  | aproximadamente 1 hora  | há aproximadamente 1 hora       |
| 1999-12-31T23:00:00.000Z | aproximadamente 1 hora  | aproximadamente 1 hora  | há aproximadamente 1 hora       |
| 1999-12-31T18:00:00.000Z | aproximadamente 6 horas | aproximadamente 6 horas | há aproximadamente 6 horas      |
| 1999-12-30T00:00:00.000Z | 2 dias                  | 2 dias                  | há 2 dias                       |
| 1999-12-15T00:00:00.000Z | 17 dias                 | 17 dias                 | há 17 dias                      |
| 1999-12-01T00:00:00.000Z | aproximadamente 1 mês   | aproximadamente 1 mês   | há aproximadamente 1 mês        |
| 1999-11-01T00:00:00.000Z | 2 meses                 | 2 meses                 | há 2 meses                      |
| 1999-06-01T00:00:00.000Z | 7 meses                 | 7 meses                 | há 7 meses                      |
| 1999-01-01T00:00:00.000Z | aproximadamente 1 ano   | aproximadamente 1 ano   | há aproximadamente 1 ano        |
| 1998-12-01T00:00:00.000Z | aproximadamente 1 ano   | aproximadamente 1 ano   | há aproximadamente 1 ano        |
| 1998-06-01T00:00:00.000Z | mais de 1 ano           | mais de 1 ano           | há mais de 1 ano                |
| 1998-01-01T00:00:00.000Z | aproximadamente 2 anos  | aproximadamente 2 anos  | há aproximadamente 2 anos       |
| 1997-01-01T00:00:00.000Z | aproximadamente 3 anos  | aproximadamente 3 anos  | há aproximadamente 3 anos       |
| 1996-01-01T00:00:00.000Z | aproximadamente 4 anos  | aproximadamente 4 anos  | há aproximadamente 4 anos       |
| 1995-01-01T00:00:00.000Z | aproximadamente 5 anos  | aproximadamente 5 anos  | há aproximadamente 5 anos       |
| 1994-01-01T00:00:00.000Z | aproximadamente 6 anos  | aproximadamente 6 anos  | há aproximadamente 6 anos       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 anos      | daqui a 6 anos      | 52608 horas                    |
| 2005-01-01T00:00:00.000Z | 5 anos      | daqui a 5 anos      | 43848 horas                    |
| 2004-01-01T00:00:00.000Z | 4 anos      | daqui a 4 anos      | 35064 horas                    |
| 2003-01-01T00:00:00.000Z | 3 anos      | daqui a 3 anos      | 26304 horas                    |
| 2002-01-01T00:00:00.000Z | 2 anos      | daqui a 2 anos      | 17544 horas                    |
| 2001-06-01T00:00:00.000Z | 1 ano       | daqui a 1 ano       | 12408 horas                    |
| 2001-02-01T00:00:00.000Z | 1 ano       | daqui a 1 ano       | 9528 horas                     |
| 2001-01-01T00:00:00.000Z | 1 ano       | daqui a 1 ano       | 8784 horas                     |
| 2000-06-01T00:00:00.000Z | 5 meses     | daqui a 5 meses     | 3648 horas                     |
| 2000-03-01T00:00:00.000Z | 2 meses     | daqui a 2 meses     | 1440 horas                     |
| 2000-02-01T00:00:00.000Z | 1 mês       | daqui a 1 mês       | 744 horas                      |
| 2000-01-15T00:00:00.000Z | 14 dias     | daqui a 14 dias     | 336 horas                      |
| 2000-01-02T00:00:00.000Z | 1 dia       | daqui a 1 dia       | 24 horas                       |
| 2000-01-01T06:00:00.000Z | 6 horas     | daqui a 6 horas     | 6 horas                        |
| 2000-01-01T01:00:00.000Z | 1 hora      | daqui a 1 hora      | 1 hora                         |
| 2000-01-01T00:45:00.000Z | 45 minutos  | daqui a 45 minutos  | 1 hora                         |
| 2000-01-01T00:30:00.000Z | 30 minutos  | daqui a 30 minutos  | 1 hora                         |
| 2000-01-01T00:15:00.000Z | 15 minutos  | daqui a 15 minutos  | 0 horas                        |
| 2000-01-01T00:01:00.000Z | 1 minuto    | daqui a 1 minuto    | 0 horas                        |
| 2000-01-01T00:00:25.000Z | 25 segundos | daqui a 25 segundos | 0 horas                        |
| 2000-01-01T00:00:15.000Z | 15 segundos | daqui a 15 segundos | 0 horas                        |
| 2000-01-01T00:00:05.000Z | 5 segundos  | daqui a 5 segundos  | 0 horas                        |
| 2000-01-01T00:00:00.000Z | 0 segundos  | há 0 segundos       | 0 horas                        |
| 1999-12-31T23:59:55.000Z | 5 segundos  | há 5 segundos       | 0 horas                        |
| 1999-12-31T23:59:45.000Z | 15 segundos | há 15 segundos      | 0 horas                        |
| 1999-12-31T23:59:35.000Z | 25 segundos | há 25 segundos      | 0 horas                        |
| 1999-12-31T23:59:00.000Z | 1 minuto    | há 1 minuto         | 0 horas                        |
| 1999-12-31T23:45:00.000Z | 15 minutos  | há 15 minutos       | 0 horas                        |
| 1999-12-31T23:30:00.000Z | 30 minutos  | há 30 minutos       | 1 hora                         |
| 1999-12-31T23:15:00.000Z | 45 minutos  | há 45 minutos       | 1 hora                         |
| 1999-12-31T23:00:00.000Z | 1 hora      | há 1 hora           | 1 hora                         |
| 1999-12-31T18:00:00.000Z | 6 horas     | há 6 horas          | 6 horas                        |
| 1999-12-30T00:00:00.000Z | 2 dias      | há 2 dias           | 48 horas                       |
| 1999-12-15T00:00:00.000Z | 17 dias     | há 17 dias          | 408 horas                      |
| 1999-12-01T00:00:00.000Z | 1 mês       | há 1 mês            | 744 horas                      |
| 1999-11-01T00:00:00.000Z | 2 meses     | há 2 meses          | 1464 horas                     |
| 1999-06-01T00:00:00.000Z | 7 meses     | há 7 meses          | 5136 horas                     |
| 1999-01-01T00:00:00.000Z | 1 ano       | há 1 ano            | 8760 horas                     |
| 1998-12-01T00:00:00.000Z | 1 ano       | há 1 ano            | 9504 horas                     |
| 1998-06-01T00:00:00.000Z | 2 anos      | há 2 anos           | 13896 horas                    |
| 1998-01-01T00:00:00.000Z | 2 anos      | há 2 anos           | 17520 horas                    |
| 1997-01-01T00:00:00.000Z | 3 anos      | há 3 anos           | 26280 horas                    |
| 1996-01-01T00:00:00.000Z | 4 anos      | há 4 anos           | 35064 horas                    |
| 1995-01-01T00:00:00.000Z | 5 anos      | há 5 anos           | 43824 horas                    |
| 1994-01-01T00:00:00.000Z | 6 anos      | há 6 anos           | 52584 horas                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                           |
| ------------------------ | -------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                       |
| 2000-01-05T00:00:00.000Z | quarta-feira às 00:00            |
| 2000-01-02T00:00:00.000Z | amanhã às 00:00                  |
| 2000-01-01T00:00:00.000Z | hoje às 00:00                    |
| 1999-12-31T00:00:00.000Z | ontem às 00:00                   |
| 1999-12-27T00:00:00.000Z | na última segunda-feira às 00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999                       |
