import { formatDistance } from "./de/_lib/formatDistance.js";
import { formatLong } from "./de/_lib/formatLong.js";
import { formatRelative } from "./de/_lib/formatRelative.js";
import { match } from "./de/_lib/match.js";

// difference to 'de' locale
import { localize } from "./de-AT/_lib/localize.js";

/**
 * @category Locales
 * @summary German locale (Austria).
 * @language German
 * @iso-639-2 deu
 * @author Christoph Tobias Stenglein [@cstenglein](https://github.com/cstenglein)
 */
export const deAT = {
  code: "de-AT",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default deAT;
