import { formatDistance } from "./it/_lib/formatDistance.js";
import { formatLong } from "./it/_lib/formatLong.js";
import { formatRelative } from "./it/_lib/formatRelative.js";
import { localize } from "./it/_lib/localize.js";
import { match } from "./it/_lib/match.js";

/**
 * @category Locales
 * @summary Italian locale.
 * @language Italian
 * @iso-639-2 ita
 * @author Alberto Restifo [@albertorestifo](https://github.com/albertorestifo)
 * @author Giovanni Polimeni [@giofilo](https://github.com/giofilo)
 * @author Vincenzo Carrese [@vin-car](https://github.com/vin-car)
 */
export const it = {
  code: "it",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default it;
