"use strict";
exports.oc = void 0;
var _index = require("./oc/_lib/formatDistance.cjs");
var _index2 = require("./oc/_lib/formatLong.cjs");
var _index3 = require("./oc/_lib/formatRelative.cjs");
var _index4 = require("./oc/_lib/localize.cjs");
var _index5 = require("./oc/_lib/match.cjs");

/**
 * @category Locales
 * @summary Occitan locale.
 * @language Occitan
 * @iso-639-2 oci
 * @author Quentin PAGÈS
 */
const oc = (exports.oc = {
  code: "oc",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
