# date-fp

[![Circle CI](https://circleci.com/gh/cullophid/date-fp.svg?style=svg)](https://circleci.com/gh/cullophid/date-fp)
[![npm version](https://badge.fury.io/js/date-fp.svg)](https://badge.fury.io/js/date-fp)
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/cullophid/date-fp?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

**date-fp** is a utility library for working with JavaScript dates.

## Motivation
There are several excellent JavaScript libraries for managing dates in JavaScript but they are generally built to be used in the object-oriented programming paradigm. This makes them cumbersome to include in a functional context.

All functions in **date-fp** are pure, autocurried and will not mutate the date objects they are applied to.

*If you are not familiar with functional programming in JavaScript read [Professor Frisby's Mostly Adequate Guide to  Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide/content/)*

*Also check out [Ramda](http://ramdajs.com) (A great library for functional programming with JavaScript)*

## Documentation

Read the full [documentation](https://cullophid.github.io/date-fp)

## Contributing
Yes please!

Something to note is that we automatically release to NPM on every successful commit and we also strictly follow SemVer so please update the version number in `package.json` appropriately when submitting a Pull Request.
