'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var steps = {
  milliseconds: 1,
  seconds: 1000,
  minutes: 60 * 1000,
  hours: 60 * 60 * 1000,
  days: 24 * 60 * 60 * 1000
}; //@flow


var _addMonth = function _addMonth(count, date) {
  var clone = new Date(date);

  clone.setMonth(date.getMonth() + count);
  if (clone.getMonth() !== (date.getMonth() + count) % 12) {
    return new Date('invalid');
  }
  return clone;
};

var _addYear = function _addYear(count, date) {
  var clone = new Date(date);

  clone.setFullYear(date.getFullYear() + count);
  return clone;
};

exports.default = (0, _lodash2.default)(function (step, count, date) {
  switch (step) {
    case 'months':
      return _addMonth(count, date);
    case 'years':
      return _addYear(count, date);
    default:
      if (steps[step] === void 0) {
        return new Date('invalid');
      }
      return new Date(steps[step] * count + date.getTime());
  }
});