'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _isValid = require('./isValid');

var _isValid2 = _interopRequireDefault(_isValid);

var _constants = require('./helpers/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var convertTo = function convertTo(unit, date) {
  return Math.round(date.getTime() / _constants.DATE_UNITS[unit]);
}; //@flow
exports.default = (0, _lodash2.default)(function (unit, date) {
  if (!_constants.DATE_UNITS.hasOwnProperty(unit)) {
    return NaN;
  }
  return (0, _isValid2.default)(date) ? convertTo(unit, date) : NaN;
});