'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _get = require('./get');

var _get2 = _interopRequireDefault(_get);

var _constants = require('./helpers/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _lodash2.default)(function (unit, date1, date2) {
  if (unit === 'years') {
    return (0, _get2.default)('year', date2) - (0, _get2.default)('year', date1);
  }

  if (unit === 'months') {
    return ((0, _get2.default)('year', date2) - (0, _get2.default)('year', date1)) * 12 + ((0, _get2.default)('month', date2) - (0, _get2.default)('month', date1));
  }

  if (!_constants.DATE_UNITS[unit]) return NaN;

  return Math.round((date2 - date1) / _constants.DATE_UNITS[unit]);
}); //@flow