'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _constants = require('./helpers/constants');

var _util = require('./helpers/util');

var _isValid = require('./isValid');

var _isValid2 = _interopRequireDefault(_isValid);

var _get = require('./get');

var _get2 = _interopRequireDefault(_get);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var tokenFunctions = {
  YYYY: function YYYY(d) {
    return (0, _util.fill)(4, d.getFullYear());
  },
  YY: function YY(d) {
    return (0, _util.lastN)(2, (0, _util.fill)(4, d.getFullYear()));
  },
  MMMM: function MMMM(d) {
    return _constants.MONTHS[d.getMonth()];
  },
  MMM: function MMM(d) {
    return (0, _util.firstN)(3, _constants.MONTHS[d.getMonth()]);
  },
  MM: function MM(d) {
    return (0, _util.fill)(2, d.getMonth() + 1);
  },
  M: function M(d) {
    return d.getMonth() + 1;
  },
  w: function w(d) {
    return (0, _get2.default)('week', d);
  },
  ww: function ww(d) {
    return (0, _util.fill)(2, (0, _get2.default)('week', d));
  },
  DD: function DD(d) {
    return (0, _util.fill)(2, d.getDate());
  },
  D: function D(d) {
    return d.getDate();
  },
  dddd: function dddd(d) {
    return _constants.WEEKDAYS[d.getDay()];
  },
  ddd: function ddd(d) {
    return (0, _util.firstN)(3, _constants.WEEKDAYS[d.getDay()]);
  },
  dd: function dd(d) {
    return (0, _util.firstN)(2, _constants.WEEKDAYS[d.getDay()]);
  },
  d: function d(_d) {
    return _d.getDay();
  },
  HH: function HH(d) {
    return (0, _util.fill)(2, d.getHours());
  },
  H: function H(d) {
    return d.getHours();
  },
  hh: function hh(d) {
    return (0, _util.fill)(2, modCeiling(12, d.getHours()));
  },
  h: function h(d) {
    return modCeiling(12, d.getHours());
  },
  mm: function mm(d) {
    return (0, _util.fill)(2, d.getMinutes());
  },
  m: function m(d) {
    return d.getMinutes();
  },
  ss: function ss(d) {
    return (0, _util.fill)(2, d.getSeconds());
  },
  s: function s(d) {
    return d.getSeconds();
  },
  A: function A(d) {
    return d.getHours() > 11 ? 'PM' : 'AM';
  },
  a: function a(d) {
    return d.getHours() > 11 ? 'pm' : 'am';
  },
  SSS: function SSS(d) {
    return (0, _util.fill)(3, d.getMilliseconds());
  },
  SS: function SS(d) {
    return (0, _util.firstN)(2, (0, _util.fill)(3, d.getMilliseconds()));
  },
  S: function S(d) {
    return (0, _util.firstN)(1, (0, _util.fill)(3, d.getMilliseconds()));
  },
  Q: function Q(d) {
    return Math.ceil((d.getMonth() + 1) / 3);
  }
}; //@flow


var modCeiling = function modCeiling(mod, val) {
  return val % mod || mod;
};

var swapTokenWithValue = (0, _lodash2.default)(function (date, token) {
  return tokenFunctions[token] ? tokenFunctions[token](date) : token;
});

exports.default = (0, _lodash2.default)(function (format, date) {
  if ((0, _isValid2.default)(date) === false) return 'Invalid Date';

  return format.match(_constants.DATE_TOKENS).map(swapTokenWithValue(date)).join('');
});