'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _constants = require('./helpers/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//@flow
var getWeek = function getWeek(_date) {
  var getWeekDay = function getWeekDay(d) {
    return d.getDay() ? d.getDay() : 7;
  };
  var date = new Date(_date);
  // 4th of jan is always week 1. This is because week numbers are ridiculous and make no logical sense
  var firstWeek = new Date(date.getFullYear(), 0, 4);
  // set the weekday to sunday
  date.setDate(date.getDate() + (7 - getWeekDay(date)));
  firstWeek.setDate(firstWeek.getDate() + (7 - getWeekDay(firstWeek)));
  // return the diff in weeks. add 1 because we are starting at week 1
  return 1 + Math.round((date.getTime() - firstWeek.getTime()) / _constants.DATE_UNITS.weeks);
};

var getters = {
  'milliseconds': function milliseconds(date) {
    return date.getMilliseconds();
  },
  'seconds': function seconds(date) {
    return date.getSeconds();
  },
  'minutes': function minutes(date) {
    return date.getMinutes();
  },
  'hours': function hours(date) {
    return date.getHours();
  },
  'date': function date(_date2) {
    return _date2.getDate();
  },
  'day': function day(date) {
    return date.getDay();
  },
  'week': getWeek,
  'month': function month(date) {
    return date.getMonth() + 1;
  },
  'year': function year(date) {
    return date.getFullYear();
  },
  'timezoneOffset': function timezoneOffset(date) {
    return date.getTimezoneOffset();
  }
};

exports.default = (0, _lodash2.default)(function (prop, date) {
  if (!getters.hasOwnProperty(prop)) return NaN;

  return getters[prop](date);
});