'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromPairs = exports.set = exports.checkDate = exports.checkNaN = exports.any = exports.find = exports.fill = exports.firstN = exports.lastN = undefined;

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _isValid = require('../isValid');

var _isValid2 = _interopRequireDefault(_isValid);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint no-self-compare: 0*/
var ZEROS = '00000000';

var lastN = exports.lastN = (0, _lodash2.default)(function (n, str) {
  return str.substring(str.length - n, str.length);
});
var firstN = exports.firstN = (0, _lodash2.default)(function (n, str) {
  return str.substring(0, n);
});
var fill = exports.fill = (0, _lodash2.default)(function (digits, n) {
  return lastN(digits, ZEROS + n);
});

var find = exports.find = (0, _lodash2.default)(function (f, array) {
  var filtered = array.filter(_isValid2.default);

  return filtered.length === 0 ? new Date('invalid') : new Date(filtered.reduce(function (memo, date) {
    return f(memo, date);
  }));
});

var any = exports.any = (0, _lodash2.default)(function (f, coll) {
  return coll.reduce(function (r, e) {
    return r || f(e);
  }, false);
});

var checkNaN = exports.checkNaN = function checkNaN(n) {
  return n !== n;
}; // NaN is the only number that is not equal to itself

var checkDate = exports.checkDate = function checkDate(date) {
  return Object.prototype.toString.call(date) === "[object Date]";
};
var set = exports.set = (0, _lodash2.default)(function (prop, value, obj) {
  obj[prop] = value;
  return obj;
});

var fromPairs = exports.fromPairs = function fromPairs(pairs) {
  return pairs.reduce(function (obj, pair) {
    return set(pair[0], pair[1], obj);
  }, {});
};