'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash.curry');

var _lodash2 = _interopRequireDefault(_lodash);

var _get = require('./get');

var _get2 = _interopRequireDefault(_get);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//@flow
var setters = {
  'milliseconds': function milliseconds(value, date) {
    return date.setMilliseconds(value);
  },
  'seconds': function seconds(value, date) {
    return date.setSeconds(value);
  },
  'minutes': function minutes(value, date) {
    return date.setMinutes(value);
  },
  'hours': function hours(value, date) {
    return date.setHours(value);
  },
  'date': function date(value, _date) {
    return _date.setDate(value);
  },
  'month': function month(value, date) {
    return date.setMonth(value - 1);
  },
  'year': function year(value, date) {
    return date.setFullYear(value);
  }
};

exports.default = (0, _lodash2.default)(function (step, value, date) {
  if (!setters.hasOwnProperty(step)) return new Date('invalid');

  var clone = new Date(date.getTime());

  setters[step](value, clone);

  return (0, _get2.default)(step, clone) === value ? clone : new Date('invalid');
});