import { IObject, IEventMap } from "./types";
export declare function $<K extends keyof HTMLElementTagNameMap>(selectors: K, multi: true): NodeListOf<HTMLElementTagNameMap[K]>;
export declare function $<K extends keyof SVGElementTagNameMap>(selectors: K, multi: true): NodeListOf<SVGElementTagNameMap[K]>;
export declare function $<E extends Element = Element>(selectors: string, multi: true): NodeListOf<E>;
export declare function $<K extends keyof HTMLElementTagNameMap>(selectors: K, multi?: false): HTMLElementTagNameMap[K] | null;
export declare function $<K extends keyof SVGElementTagNameMap>(selectors: K, multi?: false): SVGElementTagNameMap[K] | null;
export declare function $<E extends Element = Element>(selectors: string, multi?: false): E | null;
export declare function hasClass(element: Element, className: string): boolean;
export declare function addClass(element: Element, className: string): void;
export declare function removeClass(element: Element, className: string): void;
export declare function fromCSS(elements: Element | Element[] | NodeListOf<Element>, properties: string[]): IObject<any>;
export declare function addEvent<K extends keyof IEventMap>(el: EventTarget, type: K, listener: (e: IEventMap[K]) => void, options?: boolean | AddEventListenerOptions): void;
export declare function removeEvent<K extends keyof IEventMap>(el: EventTarget, type: K, listener: (e: IEventMap[K]) => void, options?: boolean | EventListenerOptions): void;
export declare function getDocument(el?: Node): Document;
export declare function getDocumentElement(el?: Node): HTMLElement;
export declare function getDocumentBody(el?: Node): HTMLElement;
export declare function getWindow(el?: Node): Window & typeof globalThis;
export declare function isWindow(val: any): val is Window;
export declare function isNode(el?: any): el is Node;
