'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-9ca39ddf.js');

const dbCardCss = "@charset \"UTF-8\";:where(html,:host){line-height:1.15;-webkit-text-size-adjust:100%;-moz-text-size-adjust:100%;-ms-text-size-adjust:100%;text-size-adjust:100%}:where(h1){font-size:2em;-webkit-margin-after:0.67em;margin-block-end:0.67em;-webkit-margin-before:0.67em;margin-block-start:0.67em}:where(dl,ol,ul) :where(dl,ol,ul){-webkit-margin-after:0;margin-block-end:0;-webkit-margin-before:0;margin-block-start:0}:where(hr){-webkit-box-sizing:content-box;box-sizing:content-box;color:inherit;height:0}:where(abbr[title]){text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}:where(b,strong){font-weight:bolder}:where(code,kbd,pre,samp){font-family:monospace, monospace;font-size:1em}:where(small){font-size:80%}:where(table){border-color:currentColor;text-indent:0}:where(button,input,select){margin:0}:where(button){text-transform:none}:where(button,input:is([type=button i],[type=reset i],[type=submit i])){-webkit-appearance:button}:where(progress){vertical-align:baseline}:where(select){text-transform:none}:where(textarea){margin:0}:where(input[type=search i]){-webkit-appearance:textfield;outline-offset:-2px}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}::-webkit-input-placeholder{color:inherit;opacity:0.54}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}:where(button,input:is([type=button i],[type=color i],[type=reset i],[type=submit i]))::-moz-focus-inner{border-style:none;padding:0}:where(button,input:is([type=button i],[type=color i],[type=reset i],[type=submit i]))::-moz-focusring{outline:1px dotted ButtonText}:where(:-moz-ui-invalid){box-shadow:none}:where(dialog){background-color:#fff;border:solid;color:#000;height:-webkit-fit-content;height:-moz-fit-content;height:fit-content;left:0;margin:auto;padding:1em;position:absolute;right:0;width:-webkit-fit-content;width:-moz-fit-content;width:fit-content}:where(dialog:not([open])){display:none}:where(summary){display:list-item}html,:host{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}*,:after,:before{-webkit-box-sizing:inherit;box-sizing:inherit}embed,iframe,img,object,video{height:auto;max-width:100%}iframe{border:0}[role=navigation] ol,[role=navigation] ul,nav ol,nav ul{list-style:url(\"data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E\");margin:0;padding:0}:root{--db-focus-outline-offset:1px;--db-focus-outline-color:#2c95c4}:is(a,button,input,textarea,summary){--db-focus-outline-size:max(2px,0.08em)}:is(a,button,input,textarea,summary):focus-visible{outline:var(--db-focus-outline-size) var(--db-focus-outline-style, solid) var(--db-focus-outline-color, currentColor);outline-offset:var(--db-focus-outline-offset, var(--db-focus-outline-size))}:where(ul){list-style-type:\"•   \"}:where(ul) li::marker{color:#ec0016}details>*,details>:after,details>:before{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}body,:host,button,div,input,select,textarea{color:#282d37;font-family:DB Screen Sans, Helvetica, Arial, sans-serif;font-size:1rem;font-weight:400;line-height:1.5}.cmp-card{background-color:#fff;border-radius:8px;-webkit-box-shadow:0 0 5px rgba(0, 0, 0, 0.08), 0 5px 30px rgba(0, 0, 0, 0.05);box-shadow:0 0 5px rgba(0, 0, 0, 0.08), 0 5px 30px rgba(0, 0, 0, 0.05)}.cmp-card>a{text-decoration:none}.cmp-card figure{margin:1rem 1rem 1rem 0.5rem}.cmp-card[data-variant=banner] figure{display:-ms-flexbox;display:flex}.cmp-card[data-variant=banner] figcaption{margin-left:1rem}.cmp-card[data-variant=banner] figcaption h1,.cmp-card[data-variant=banner] figcaption h2,.cmp-card[data-variant=banner] figcaption h3,.cmp-card[data-variant=banner] figcaption h4,.cmp-card[data-variant=banner] figcaption h5,.cmp-card[data-variant=banner] figcaption h6{font-size:1.125rem}.cmp-card[data-variant=banner] figcaption h1,.cmp-card[data-variant=banner] figcaption h1~p,.cmp-card[data-variant=banner] figcaption h2,.cmp-card[data-variant=banner] figcaption h2~p,.cmp-card[data-variant=banner] figcaption h3,.cmp-card[data-variant=banner] figcaption h3~p,.cmp-card[data-variant=banner] figcaption h4,.cmp-card[data-variant=banner] figcaption h4~p,.cmp-card[data-variant=banner] figcaption h5,.cmp-card[data-variant=banner] figcaption h5~p,.cmp-card[data-variant=banner] figcaption h6,.cmp-card[data-variant=banner] figcaption h6~p{margin:0.125rem 0}.cmp-card[data-variant=banner] figcaption p{font-size:0.875rem;max-width:18.125rem}.cmp-card[data-variant=tile]{text-align:center}.cmp-card figcaption{max-width:60ch}.cmp-card{padding:1rem 1rem 1rem 0.5rem}.cmp-card figure{margin:0}.cmp-card svg,.cmp-card img[src$=\".svg\"]{margin:auto 0}";
const DbCardStyle0 = dbCardCss;

const DbCard = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.illustrationPaths = {
            account: 'action/db_ic_il_account.svg',
            alarm_clock: 'action/db_ic_il_alarm_clock.svg',
            ar_icon: 'action/db_ic_il_ar_icon.svg',
            calendar: 'action/db_ic_il_calendar.svg',
            christmas: 'action/db_ic_il_christmas.svg',
            clock_moving: 'action/db_ic_il_clock_moving.svg',
            compass: 'action/db_ic_il_compass.svg',
            construction_sign: 'action/db_ic_il_construction_sign.svg',
            construction_worker: 'action/db_ic_il_construction_worker.svg',
            db_clock: 'action/db_ic_il_db_clock.svg',
            diamond: 'action/db_ic_il_diamond.svg',
            fokus: 'action/db_ic_il_fokus.svg',
            gift: 'action/db_ic_il_gift.svg',
            handshake: 'action/db_ic_il_handshake.svg',
            heart: 'action/db_ic_il_heart.svg',
            information: 'action/db_ic_il_information.svg',
            onlineshop_brand: 'action/db_ic_il_onlineshop_brand.svg',
            onlineshop_feature: 'action/db_ic_il_onlineshop_feature.svg',
            pdf: 'action/db_ic_il_pdf.svg',
            printer: 'action/db_ic_il_printer.svg',
            savings: 'action/db_ic_il_savings.svg',
            search: 'action/db_ic_il_search.svg',
            tips: 'action/db_ic_il_tips.svg',
            trash: 'action/db_ic_il_trash.svg',
            broken: 'communication/db_ic_il_broken.svg',
            chat: 'communication/db_ic_il_chat.svg',
            customer_feedback: 'communication/db_ic_il_customer_feedback.svg',
            envelope_closed: 'communication/db_ic_il_envelope_closed.svg',
            envelope_open: 'communication/db_ic_il_envelope_open.svg',
            error: 'communication/db_ic_il_error.svg',
            hashtag: 'communication/db_ic_il_hashtag.svg',
            wifi: 'communication/db_ic_il_wifi.svg',
            '2g_rule': 'covid_19/db_ic_il_2g_rule.svg',
            '3g_rule': 'covid_19/db_ic_il_3g_rule.svg',
            distance: 'covid_19/db_ic_il_distance.svg',
            ffp2_mask: 'covid_19/db_ic_il_ffp2_mask.svg',
            ffp2_mask_with_sign: 'covid_19/db_ic_il_ffp2_mask_with_sign.svg',
            handwashing: 'covid_19/db_ic_il_handwashing.svg',
            no_handshaking: 'covid_19/db_ic_il_no_handshaking.svg',
            recovered: 'covid_19/db_ic_il_recovered.svg',
            single_entry: 'covid_19/db_ic_il_single_entry.svg',
            test_antigen: 'covid_19/db_ic_il_test_antigen.svg',
            test_pcr: 'covid_19/db_ic_il_test_pcr.svg',
            vaccinated: 'covid_19/db_ic_il_vaccinated.svg',
            laptop: 'devices/db_ic_il_laptop.svg',
            smartphone: 'devices/db_ic_il_smartphone.svg',
            tablet: 'devices/db_ic_il_tablet.svg',
            der_kleine_ice: 'entertainment/db_ic_il_der_kleine_ice.svg',
            gaming: 'entertainment/db_ic_il_gaming.svg',
            gaming_no_wire: 'entertainment/db_ic_il_gaming_no_wire.svg',
            movie: 'entertainment/db_ic_il_movie.svg',
            podcast: 'entertainment/db_ic_il_podcast.svg',
            sport: 'entertainment/db_ic_il_sport.svg',
            green: 'feature/db_ic_il_green.svg',
            green_energy: 'feature/db_ic_il_green_energy.svg',
            mobile_payment: 'feature/db_ic_il_mobile_payment.svg',
            nfc_scan: 'feature/db_ic_il_nfc_scan.svg',
            whats_schmutzig: 'feature/db_ic_il_whats_schmutzig.svg',
            coffee_cup: 'food/db_ic_il_coffee_cup.svg',
            restaurant: 'food/db_ic_il_restaurant.svg',
            home: 'maps/db_ic_il_home.svg',
            location: 'maps/db_ic_il_location.svg',
            disruptions: 'news/db_ic_il_disruptions.svg',
            news: 'news/db_ic_il_news.svg',
            newsletter: 'news/db_ic_il_newsletter.svg',
            newspaper: 'news/db_ic_il_newspaper.svg',
            s_bahn_magazin_muenchen: 'news/db_ic_il_s_bahn_magazin_muenchen.svg',
            db_ticket_shop: 'station/db_ic_il_db_ticket_shop.svg',
            db_ticket_vending_machine: 'station/db_ic_il_db_ticket_vending_machine.svg',
            db_trainstation: 'station/db_ic_il_db_trainstation.svg',
            db_trainstation_with_train: 'station/db_ic_il_db_trainstation_with_train.svg',
            db_travel_center: 'station/db_ic_il_db_travel_center.svg',
            db_video_travel_center: 'station/db_ic_il_db_video_travel_center.svg',
            kiosk: 'station/db_ic_il_kiosk.svg',
            mini_store: 'station/db_ic_il_mini_store.svg',
            classic_printout: 'ticket/db_ic_il_classic_printout.svg',
            mobileticket_brand: 'ticket/db_ic_il_mobileticket_brand.svg',
            mobileticket_feature: 'ticket/db_ic_il_mobileticket_feature.svg',
            onlineticket_brand: 'ticket/db_ic_il_onlineticket_brand.svg',
            onlineticket_feature: 'ticket/db_ic_il_onlineticket_feature.svg',
            scan_ticket_printout: 'ticket/db_ic_il_scan_ticket_printout.svg',
            show_ticket: 'ticket/db_ic_il_show_ticket.svg',
            tickets: 'ticket/db_ic_il_tickets.svg',
            airplane: 'transportation/db_ic_il_airplane.svg',
            airplane_2: 'transportation/db_ic_il_airplane_2.svg',
            bicycle: 'transportation/db_ic_il_bicycle.svg',
            bike_trailer: 'transportation/db_ic_il_bike_trailer.svg',
            buggy: 'transportation/db_ic_il_buggy.svg',
            bus_side_view: 'transportation/db_ic_il_bus_side_view.svg',
            call_a_bike: 'transportation/db_ic_il_call_a_bike.svg',
            car: 'transportation/db_ic_il_car.svg',
            car_side_view: 'transportation/db_ic_il_car_side_view.svg',
            commuter_train: 'transportation/db_ic_il_commuter_train.svg',
            electric_scooter: 'transportation/db_ic_il_electric_scooter.svg',
            ev_car: 'transportation/db_ic_il_ev_car.svg',
            ferry: 'transportation/db_ic_il_ferry.svg',
            handcart: 'transportation/db_ic_il_handcart.svg',
            ice: 'transportation/db_ic_il_ice.svg',
            intercity_train: 'transportation/db_ic_il_intercity_train.svg',
            local_bus: 'transportation/db_ic_il_local_bus.svg',
            local_train: 'transportation/db_ic_il_local_train.svg',
            long_distance_bus: 'transportation/db_ic_il_long_distance_bus.svg',
            scooter: 'transportation/db_ic_il_scooter.svg',
            self_driving_side_view: 'transportation/db_ic_il_self_driving_side_view.svg',
            speedboat: 'transportation/db_ic_il_speedboat.svg',
            subway: 'transportation/db_ic_il_subway.svg',
            taxi: 'transportation/db_ic_il_taxi.svg',
            tram: 'transportation/db_ic_il_tram.svg',
            advertising_transportation: 'travel/db_ic_il_advertising_transportation.svg',
            bear: 'travel/db_ic_il_bear.svg',
            db_comfort_checkin: 'travel/db_ic_il_db_comfort_checkin.svg',
            delayed: 'travel/db_ic_il_delayed.svg',
            dog: 'travel/db_ic_il_dog.svg',
            id_card: 'travel/db_ic_il_id_card.svg',
            itinerary: 'travel/db_ic_il_itinerary.svg',
            lost_and_found: 'travel/db_ic_il_lost_and_found.svg',
            luggage: 'travel/db_ic_il_luggage.svg',
            passenger_rights: 'travel/db_ic_il_passenger_rights.svg',
            poi_berlin: 'travel/db_ic_il_poi_berlin.svg',
            poi_berlin_alternative: 'travel/db_ic_il_poi_berlin_alternative.svg',
            suitcase: 'travel/db_ic_il_suitcase.svg',
            timetable: 'travel/db_ic_il_timetable.svg',
            zuginformation: 'travel/db_ic_il_zuginformation.svg',
            blizzard: 'weather/db_ic_il_blizzard.svg',
            thunderstorm: 'weather/db_ic_il_thunderstorm.svg'
        };
        this.alt = undefined;
        this.header = undefined;
        this.content = undefined;
        this.image = undefined;
        this.illustration = undefined;
        this.uiCoreIllustrationPath = './icons/illustrative';
        this.variant = 'banner';
    }
    render() {
        return (index.h("div", { key: 'd9ce61b10892d953b375a63ff212eb2f23d8a7e6', class: "cmp-card", "data-variant": this.variant }, index.h("figure", { key: 'be8ab8a686e02aabab90daa708b31e56698d825d' }, this.illustration && (index.h("svg", { key: 'e8145c32943ea3656d97f95868761b74c81d8d41', xmlns: "http://www.w3.org/2000/svg", width: "64", height: "64", "aria-hidden": "true" }, index.h("use", { key: 'b63b609c758ce9397b394be17831239474d51d9b', href: `${this.uiCoreIllustrationPath}/${this.illustrationPaths[this.illustration]}#icon` }))), !this.illustration && this.image && (index.h("img", { key: '7974a83a2a9dc49a4042f133a3a49dfdb74322a4', src: this.image, height: "64", width: "64", alt: this.alt })), index.h("figcaption", { key: '61e6fb92d007708857eace97743e85254ceb6f60' }, this.header && index.h("db-headline", { key: 'f015fe29e9f84ef37a39e522c4c64d497de9ec8f' }, this.header), this.content && index.h("p", { key: 'c9a469236b9c322e40eed5622e410da894df116c' }, this.content), !this.header && !this.content && index.h("slot", { key: '2f583498ca0576022d5ba2a59e5bec78086a8151' })))));
    }
};
DbCard.style = DbCardStyle0;

exports.db_card = DbCard;

//# sourceMappingURL=db-card.cjs.entry.js.map