'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-9ca39ddf.js');
const utils = require('./utils-eeddc73b.js');

const dbInputCss = "@charset \"UTF-8\";.sc-db-input:where(html,).sc-db-input-h{line-height:1.15;-webkit-text-size-adjust:100%;-moz-text-size-adjust:100%;-ms-text-size-adjust:100%;text-size-adjust:100%}.sc-db-input:where(h1){font-size:2em;-webkit-margin-after:0.67em;margin-block-end:0.67em;-webkit-margin-before:0.67em;margin-block-start:0.67em}.sc-db-input:where(dl,ol.sc-db-input,ul).sc-db-input .sc-db-input:where(dl,ol.sc-db-input,ul).sc-db-input{-webkit-margin-after:0;margin-block-end:0;-webkit-margin-before:0;margin-block-start:0}.sc-db-input:where(hr){-webkit-box-sizing:content-box;box-sizing:content-box;color:inherit;height:0}.sc-db-input:where(abbr[title]){text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}.sc-db-input:where(b,strong).sc-db-input{font-weight:bolder}.sc-db-input:where(code,kbd.sc-db-input,pre.sc-db-input,samp).sc-db-input{font-family:monospace, monospace;font-size:1em}.sc-db-input:where(small){font-size:80%}.sc-db-input:where(table){border-color:currentColor;text-indent:0}.sc-db-input:where(button,input.sc-db-input,select).sc-db-input{margin:0}.sc-db-input:where(button){text-transform:none}.sc-db-input:where(button,input.sc-db-input:is([type=button i],[type=reset i].sc-db-input,[type=submit i])).sc-db-input{-webkit-appearance:button}.sc-db-input:where(progress){vertical-align:baseline}.sc-db-input:where(select){text-transform:none}.sc-db-input:where(textarea){margin:0}.sc-db-input:where(input[type=search i]){-webkit-appearance:textfield;outline-offset:-2px}.sc-db-input::-webkit-inner-spin-button,.sc-db-input::-webkit-outer-spin-button{height:auto}.sc-db-input::-webkit-input-placeholder{color:inherit;opacity:0.54}.sc-db-input::-webkit-search-decoration{-webkit-appearance:none}.sc-db-input::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}.sc-db-input:where(button,input.sc-db-input:is([type=button i],[type=color i].sc-db-input,[type=reset i].sc-db-input,[type=submit i])).sc-db-input::-moz-focus-inner{border-style:none;padding:0}.sc-db-input:where(button,input.sc-db-input:is([type=button i],[type=color i].sc-db-input,[type=reset i].sc-db-input,[type=submit i])).sc-db-input::-moz-focusring{outline:1px dotted ButtonText}.sc-db-input:where(:-moz-ui-invalid){box-shadow:none}.sc-db-input:where(dialog){background-color:#fff;border:solid;color:#000;height:-webkit-fit-content;height:-moz-fit-content;height:fit-content;left:0;margin:auto;padding:1em;position:absolute;right:0;width:-webkit-fit-content;width:-moz-fit-content;width:fit-content}.sc-db-input:where(dialog:not([open])){display:none}.sc-db-input:where(summary){display:list-item}html.sc-db-input,.sc-db-input-h{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}*.sc-db-input,.sc-db-input:after,.sc-db-input:before{-webkit-box-sizing:inherit;box-sizing:inherit}embed.sc-db-input,iframe.sc-db-input,img.sc-db-input,object.sc-db-input,video.sc-db-input{height:auto;max-width:100%}iframe.sc-db-input{border:0}[role=navigation].sc-db-input ol.sc-db-input,[role=navigation].sc-db-input ul.sc-db-input,nav.sc-db-input ol.sc-db-input,nav.sc-db-input ul.sc-db-input{list-style:url(\"data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E\");margin:0;padding:0}.sc-db-input:root{--db-focus-outline-offset:1px;--db-focus-outline-color:#2c95c4}.sc-db-input:is(a,button.sc-db-input,input.sc-db-input,textarea.sc-db-input,summary).sc-db-input{--db-focus-outline-size:max(2px,0.08em)}.sc-db-input:is(a,button.sc-db-input,input.sc-db-input,textarea.sc-db-input,summary).sc-db-input:focus-visible{outline:var(--db-focus-outline-size) var(--db-focus-outline-style, solid) var(--db-focus-outline-color, currentColor);outline-offset:var(--db-focus-outline-offset, var(--db-focus-outline-size))}.sc-db-input:where(ul){list-style-type:\"•   \"}.sc-db-input:where(ul) li.sc-db-input::marker{color:#ec0016}details.sc-db-input>*.sc-db-input,details.sc-db-input>.sc-db-input:after,details.sc-db-input>.sc-db-input:before{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}body.sc-db-input,.sc-db-input-h,button.sc-db-input,div.sc-db-input,input.sc-db-input,select.sc-db-input,textarea.sc-db-input{color:#282d37;font-family:DB Screen Sans, Helvetica, Arial, sans-serif;font-size:1rem;font-weight:400;line-height:1.5}a.sc-db-input{color:inherit}.elm-input.sc-db-input{--formElement---borderTopColor:var(\n  \t--formElement---borderColor,\n  \ttransparent\n  );--formElement---borderRightColor:var(\n  \t--formElement---borderColor,\n  \ttransparent\n  );--formElement---borderBottomColor:var(\n  \t--formElement---borderColor,\n  \trgba(40, 45, 55, 0.5)\n  );--formElement---borderLeftColor:var(\n  \t--formElement---borderColor,\n  \ttransparent\n  );border-radius:4px;caret-color:#ec0016;color:#282d37}.elm-input.sc-db-input~.description.sc-db-input{color:#646973;font-size:0.875rem;padding:0.375rem 0.625rem}.elm-input[type=color].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=date].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=datetime-local].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=email].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=month].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=number].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=password].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=tel].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=text].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=time].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=url].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input,.elm-input[type=week].sc-db-input+[data-label-hidden=true].elm-label.sc-db-input{clip:rect(0, 0, 0, 0);height:1px;overflow:hidden;position:absolute !important;white-space:nowrap;width:1px}.sc-db-input:not(.cmp-sitesearch)>.elm-input[type=search].sc-db-input,.elm-input[type=color][data-variant=semitransparent].sc-db-input,.elm-input[type=date][data-variant=semitransparent].sc-db-input,.elm-input[type=datetime-local][data-variant=semitransparent].sc-db-input,.elm-input[type=email][data-variant=semitransparent].sc-db-input,.elm-input[type=month][data-variant=semitransparent].sc-db-input,.elm-input[type=number][data-variant=semitransparent].sc-db-input,.elm-input[type=password][data-variant=semitransparent].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][data-variant=semitransparent].sc-db-input,.elm-input[type=tel][data-variant=semitransparent].sc-db-input,.elm-input[type=text][data-variant=semitransparent].sc-db-input,.elm-input[type=time][data-variant=semitransparent].sc-db-input,.elm-input[type=url][data-variant=semitransparent].sc-db-input,.elm-input[type=week][data-variant=semitransparent].sc-db-input,.sc-db-input:where(.elm-input[type=color],.elm-input[type=date].sc-db-input,.elm-input[type=datetime-local].sc-db-input,.elm-input[type=email].sc-db-input,.elm-input[type=month].sc-db-input,.elm-input[type=number].sc-db-input,.elm-input[type=password].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input,.elm-input[type=tel].sc-db-input,.elm-input[type=text].sc-db-input,.elm-input[type=time].sc-db-input,.elm-input[type=url].sc-db-input,.elm-input[type=week]).sc-db-input{--formElement---borderColor:rgba(40, 45, 55, 0.5);background-color:rgba(40, 45, 55, 0.05);border-bottom:1px solid var(--formElement---borderBottomColor);border-left:1px solid var(--formElement---borderLeftColor);border-left-color:transparent;border-right:1px solid var(--formElement---borderRightColor);border-right-color:transparent;border-top:1px solid var(--formElement---borderTopColor);border-top-color:transparent}.elm-input[type=color][data-variant=white].sc-db-input,.elm-input[type=date][data-variant=white].sc-db-input,.elm-input[type=datetime-local][data-variant=white].sc-db-input,.elm-input[type=email][data-variant=white].sc-db-input,.elm-input[type=month][data-variant=white].sc-db-input,.elm-input[type=number][data-variant=white].sc-db-input,.elm-input[type=password][data-variant=white].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][data-variant=white].sc-db-input,.elm-input[type=tel][data-variant=white].sc-db-input,.elm-input[type=text][data-variant=white].sc-db-input,.elm-input[type=time][data-variant=white].sc-db-input,.elm-input[type=url][data-variant=white].sc-db-input,.elm-input[type=week][data-variant=white].sc-db-input{--formElement---borderColor:rgba(40, 45, 55, 0.5);background-color:#ffffff;border-bottom:1px solid var(--formElement---borderBottomColor);border-left:1px solid var(--formElement---borderLeftColor);border-left-color:transparent;border-right:1px solid var(--formElement---borderRightColor);border-right-color:transparent;border-top:1px solid var(--formElement---borderTopColor);border-top-color:transparent}.elm-input[type=color][data-variant=solid].sc-db-input,.elm-input[type=date][data-variant=solid].sc-db-input,.elm-input[type=datetime-local][data-variant=solid].sc-db-input,.elm-input[type=email][data-variant=solid].sc-db-input,.elm-input[type=month][data-variant=solid].sc-db-input,.elm-input[type=number][data-variant=solid].sc-db-input,.elm-input[type=password][data-variant=solid].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][data-variant=solid].sc-db-input,.elm-input[type=tel][data-variant=solid].sc-db-input,.elm-input[type=text][data-variant=solid].sc-db-input,.elm-input[type=time][data-variant=solid].sc-db-input,.elm-input[type=url][data-variant=solid].sc-db-input,.elm-input[type=week][data-variant=solid].sc-db-input{--formElement---borderColor:rgba(40, 45, 55, 0.5);background-color:#f0f3f5;border-bottom:1px solid var(--formElement---borderBottomColor);border-left:1px solid var(--formElement---borderLeftColor);border-left-color:transparent;border-right:1px solid var(--formElement---borderRightColor);border-right-color:transparent;border-top:1px solid var(--formElement---borderTopColor);border-top-color:transparent}.elm-input[type=color][data-variant=outline].sc-db-input,.elm-input[type=date][data-variant=outline].sc-db-input,.elm-input[type=datetime-local][data-variant=outline].sc-db-input,.elm-input[type=email][data-variant=outline].sc-db-input,.elm-input[type=month][data-variant=outline].sc-db-input,.elm-input[type=number][data-variant=outline].sc-db-input,.elm-input[type=password][data-variant=outline].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][data-variant=outline].sc-db-input,.elm-input[type=tel][data-variant=outline].sc-db-input,.elm-input[type=text][data-variant=outline].sc-db-input,.elm-input[type=time][data-variant=outline].sc-db-input,.elm-input[type=url][data-variant=outline].sc-db-input,.elm-input[type=week][data-variant=outline].sc-db-input{--formElement---borderColor:rgba(40, 45, 55, 0.25);background-color:transparent;border-bottom:1px solid var(--formElement---borderBottomColor);border-left:1px solid var(--formElement---borderLeftColor);border-right:1px solid var(--formElement---borderRightColor);border-top:1px solid var(--formElement---borderTopColor)}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):valid{--formElement---borderColor:#2a7230}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):valid{--formElement---borderColor:#2a7230}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:placeholder-shown):valid{--formElement---borderColor:#2a7230}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:-moz-placeholder-shown):invalid{--formElement---borderColor:#ec0016}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:-ms-input-placeholder):invalid{--formElement---borderColor:#ec0016}.elm-input[type=color].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=date].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=datetime-local].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=email].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=month].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=number].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=password].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=tel].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=text].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=time].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=url].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid,.elm-input[type=week].sc-db-input:not([aria-invalid]):not(:placeholder-shown):invalid{--formElement---borderColor:#ec0016}[aria-invalid=true].elm-input[type=color].sc-db-input,[aria-invalid=true].elm-input[type=date].sc-db-input,[aria-invalid=true].elm-input[type=datetime-local].sc-db-input,[aria-invalid=true].elm-input[type=email].sc-db-input,[aria-invalid=true].elm-input[type=month].sc-db-input,[aria-invalid=true].elm-input[type=number].sc-db-input,[aria-invalid=true].elm-input[type=password].sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>[aria-invalid=true].elm-input[type=search].sc-db-input,[aria-invalid=true].elm-input[type=tel].sc-db-input,[aria-invalid=true].elm-input[type=text].sc-db-input,[aria-invalid=true].elm-input[type=time].sc-db-input,[aria-invalid=true].elm-input[type=url].sc-db-input,[aria-invalid=true].elm-input[type=week].sc-db-input{--formElement---borderColor:#ec0016}.elm-input.sc-db-input:is([type=email],[type=password].sc-db-input,[type=search].sc-db-input,[type=tel].sc-db-input,[type=text].sc-db-input,[type=url]).sc-db-input+label.sc-db-input+output.sc-db-input:has(+.description).sc-db-input{float:right}@supports (inset-area: block-end span-inline-start){.elm-input.sc-db-input:is([type=email],[type=password].sc-db-input,[type=search].sc-db-input,[type=tel].sc-db-input,[type=text].sc-db-input,[type=url]).sc-db-input+label.sc-db-input+output.sc-db-input:not(:has(+.description)).sc-db-input{position:absolute;inset-area:block-end span-inline-start}}.elm-input.sc-db-input:is([type=email],[type=password].sc-db-input,[type=search].sc-db-input,[type=tel].sc-db-input,[type=text].sc-db-input,[type=url]).sc-db-input+label.sc-db-input+output.sc-db-input,.elm-input.sc-db-input:is([type=email],[type=password].sc-db-input,[type=search].sc-db-input,[type=tel].sc-db-input,[type=text].sc-db-input,[type=url]).sc-db-input+label.sc-db-input+output.sc-db-input+.description.sc-db-input{color:#646973;font-size:0.875rem;padding:0.375rem 0.625rem}.elm-input.sc-db-input{color:#282d37;font-size:1rem;height:2.75rem;line-height:1.5rem;max-width:100%;width:100%;padding-inline:1rem}.elm-input.sc-db-input:not(:has(+label[data-label-hidden=true])).sc-db-input{padding-block:0.5rem}.elm-input[list].sc-db-input::-webkit-calendar-picker-indicator{margin-right:-1rem}.elm-input.sc-db-input:not(:-moz-placeholder-shown){padding-bottom:0}.elm-input.sc-db-input:not(:-ms-input-placeholder){padding-bottom:0}.elm-input.sc-db-input:not(:placeholder-shown){padding-bottom:0}.elm-input.sc-db-input:not(:-moz-placeholder-shown):not(:has(+label[data-label-hidden=true])).sc-db-input{padding-top:1rem}.elm-input.sc-db-input:not(:-ms-input-placeholder):not(:has(+label[data-label-hidden=true])).sc-db-input{padding-top:1rem}.elm-input.sc-db-input:not(:placeholder-shown):not(:has(+label[data-label-hidden=true])).sc-db-input{padding-top:1rem}.elm-input.sc-db-input:focus:not(:disabled),.elm-input.sc-db-input:hover:not(:disabled){--formElement---borderColor:#878c96}.elm-input.sc-db-input:disabled,.elm-input.sc-db-input:disabled+.elm-label.sc-db-input,fieldset.sc-db-input:disabled .elm-input.sc-db-input,fieldset.sc-db-input:disabled .elm-input.sc-db-input+.elm-label.sc-db-input{opacity:0.4}.elm-input[type=color].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=date].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=datetime-local].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=email].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=month].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=number].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=password].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=tel].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=text].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=time].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=url].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=week].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input{-webkit-transition:opacity, -webkit-transform 250ms;transition:opacity, -webkit-transform 250ms;transition:opacity, transform 250ms;transition:opacity, transform 250ms, -webkit-transform 250ms}@media (prefers-reduced-motion: reduce){.elm-input[type=color].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=date].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=datetime-local].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=email].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=month].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=number].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=password].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=tel].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=text].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=time].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=url].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input,.elm-input[type=week].sc-db-input:not([type=date]):not([type=datetime-local]):not([type=month]):not([type=time]):not([type=week])+.elm-label.sc-db-input{-webkit-transition-duration:0.01s !important;transition-duration:0.01s !important}}.elm-input[type=color].sc-db-input+.elm-label.sc-db-input,.elm-input[type=date].sc-db-input+.elm-label.sc-db-input,.elm-input[type=datetime-local].sc-db-input+.elm-label.sc-db-input,.elm-input[type=email].sc-db-input+.elm-label.sc-db-input,.elm-input[type=month].sc-db-input+.elm-label.sc-db-input,.elm-input[type=number].sc-db-input+.elm-label.sc-db-input,.elm-input[type=password].sc-db-input+.elm-label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input+.elm-label.sc-db-input,.elm-input[type=tel].sc-db-input+.elm-label.sc-db-input,.elm-input[type=text].sc-db-input+.elm-label.sc-db-input,.elm-input[type=time].sc-db-input+.elm-label.sc-db-input,.elm-input[type=url].sc-db-input+.elm-label.sc-db-input,.elm-input[type=week].sc-db-input+.elm-label.sc-db-input{color:#646973;display:block;font-size:0.75rem;margin-bottom:-1.125rem;-webkit-transform:translate(1rem, -2.5625rem);transform:translate(1rem, -2.5625rem)}.elm-input[type=color].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=color].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=date].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=date].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=datetime-local].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=datetime-local].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=email].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=email].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=month].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=month].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=number].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=number].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=password].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=password].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=tel].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=tel].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=text].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=text].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=time].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=time].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=url].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=url].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input,.elm-input[type=week].sc-db-input+.elm-label.sc-db-input+output.sc-db-input,.elm-input[type=week].sc-db-input+.elm-label.sc-db-input~.description.sc-db-input{margin-top:0}.elm-input[type=color][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=date][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=datetime-local][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=email][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=month][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=number][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=password][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=tel][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=text][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=time][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=url][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input,.elm-input[type=week][placeholder].sc-db-input:-moz-placeholder-shown+label.sc-db-input{opacity:0}.elm-input[type=color][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=date][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=datetime-local][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=email][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=month][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=number][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=password][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=tel][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=text][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=time][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=url][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input,.elm-input[type=week][placeholder].sc-db-input:-ms-input-placeholder+label.sc-db-input{opacity:0}.elm-input[type=color][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=date][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=datetime-local][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=email][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=month][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=number][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=password][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=tel][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=text][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=time][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=url][placeholder].sc-db-input:placeholder-shown+label.sc-db-input,.elm-input[type=week][placeholder].sc-db-input:placeholder-shown+label.sc-db-input{opacity:0}.elm-input[type=color].sc-db-input::-webkit-input-placeholder,.elm-input[type=date].sc-db-input::-webkit-input-placeholder,.elm-input[type=datetime-local].sc-db-input::-webkit-input-placeholder,.elm-input[type=email].sc-db-input::-webkit-input-placeholder,.elm-input[type=month].sc-db-input::-webkit-input-placeholder,.elm-input[type=number].sc-db-input::-webkit-input-placeholder,.elm-input[type=password].sc-db-input::-webkit-input-placeholder,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input::-webkit-input-placeholder,.elm-input[type=tel].sc-db-input::-webkit-input-placeholder,.elm-input[type=text].sc-db-input::-webkit-input-placeholder,.elm-input[type=time].sc-db-input::-webkit-input-placeholder,.elm-input[type=url].sc-db-input::-webkit-input-placeholder,.elm-input[type=week].sc-db-input::-webkit-input-placeholder{color:#646973}.elm-input[type=color].sc-db-input::-moz-placeholder,.elm-input[type=date].sc-db-input::-moz-placeholder,.elm-input[type=datetime-local].sc-db-input::-moz-placeholder,.elm-input[type=email].sc-db-input::-moz-placeholder,.elm-input[type=month].sc-db-input::-moz-placeholder,.elm-input[type=number].sc-db-input::-moz-placeholder,.elm-input[type=password].sc-db-input::-moz-placeholder,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input::-moz-placeholder,.elm-input[type=tel].sc-db-input::-moz-placeholder,.elm-input[type=text].sc-db-input::-moz-placeholder,.elm-input[type=time].sc-db-input::-moz-placeholder,.elm-input[type=url].sc-db-input::-moz-placeholder,.elm-input[type=week].sc-db-input::-moz-placeholder{color:#646973}.elm-input[type=color].sc-db-input:-ms-input-placeholder,.elm-input[type=date].sc-db-input:-ms-input-placeholder,.elm-input[type=datetime-local].sc-db-input:-ms-input-placeholder,.elm-input[type=email].sc-db-input:-ms-input-placeholder,.elm-input[type=month].sc-db-input:-ms-input-placeholder,.elm-input[type=number].sc-db-input:-ms-input-placeholder,.elm-input[type=password].sc-db-input:-ms-input-placeholder,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input:-ms-input-placeholder,.elm-input[type=tel].sc-db-input:-ms-input-placeholder,.elm-input[type=text].sc-db-input:-ms-input-placeholder,.elm-input[type=time].sc-db-input:-ms-input-placeholder,.elm-input[type=url].sc-db-input:-ms-input-placeholder,.elm-input[type=week].sc-db-input:-ms-input-placeholder{color:#646973}.elm-input[type=color].sc-db-input::-ms-input-placeholder,.elm-input[type=date].sc-db-input::-ms-input-placeholder,.elm-input[type=datetime-local].sc-db-input::-ms-input-placeholder,.elm-input[type=email].sc-db-input::-ms-input-placeholder,.elm-input[type=month].sc-db-input::-ms-input-placeholder,.elm-input[type=number].sc-db-input::-ms-input-placeholder,.elm-input[type=password].sc-db-input::-ms-input-placeholder,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input::-ms-input-placeholder,.elm-input[type=tel].sc-db-input::-ms-input-placeholder,.elm-input[type=text].sc-db-input::-ms-input-placeholder,.elm-input[type=time].sc-db-input::-ms-input-placeholder,.elm-input[type=url].sc-db-input::-ms-input-placeholder,.elm-input[type=week].sc-db-input::-ms-input-placeholder{color:#646973}.elm-input[type=color].sc-db-input::placeholder,.elm-input[type=date].sc-db-input::placeholder,.elm-input[type=datetime-local].sc-db-input::placeholder,.elm-input[type=email].sc-db-input::placeholder,.elm-input[type=month].sc-db-input::placeholder,.elm-input[type=number].sc-db-input::placeholder,.elm-input[type=password].sc-db-input::placeholder,.sc-db-input:where(:not(.cmp-sitesearch))>.elm-input[type=search].sc-db-input::placeholder,.elm-input[type=tel].sc-db-input::placeholder,.elm-input[type=text].sc-db-input::placeholder,.elm-input[type=time].sc-db-input::placeholder,.elm-input[type=url].sc-db-input::placeholder,.elm-input[type=week].sc-db-input::placeholder{color:#646973}.elm-input[type=search].sc-db-input{background:var(--db-ic-search-24, url(../../../../icons/functional/images/action/db_ic_search_24.svg)) no-repeat 0.375rem 0.75rem;background-size:1.1875rem;padding-left:2rem}.sc-db-input:not(.cmp-sitesearch)>.elm-input[type=search].sc-db-input+.elm-label.sc-db-input{margin-left:1rem}.sc-db-input-h{--db-ic-search-24:url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAV9JREFUSEu1le0xBEEURc9GgAjIABkQATIgAyEIQQaIABkQARlYESAC6qjXVV1T3f22dme7an5Nzzv3vq9ZsOWz2HJ8RoBL4Aw4AXaBb+AFeAIeVhXWAhwAj8DRIMg7cAEsM9AUYPC3UPwDXAMG89HFOXAD7Iej03jX5UwBBjoEXiOYaZkeQfeRPu8fj1zUAHN+B6hcJ63gJZYQg+vkKoBNTg2weBZ1+EEVpQh6DrcpQMU7YVl12dHFV1zqdmP94je73CCm39SA4mAvyX/h2MZ23GfULE3RujWw4xzGFFCK5vDYelkXfcRsrNxFKihz4EpwUntz4KSreqjegK1JFmI36cSptQ0FmXOH8DaUF0FOc9dtbxdZD4P1jsptU+8oqAvJtqm7x+Hz2C26ck34CDCVQ8im/4MUsilAZ0PIHIAhZC7AFGJtLPzwl5ktu9b7ki7b9n+653SQrop1FKff/AH2BVIZMfA02AAAAABJRU5ErkJggg==\")}.elm-input.sc-db-input:is([type=email],[type=password].sc-db-input,[type=search].sc-db-input,[type=tel].sc-db-input,[type=text].sc-db-input,[type=url]).sc-db-input+label.sc-db-input+output.sc-db-input:not(:has(+.description)).sc-db-input{float:right;position:initial}";
const DbInputStyle0 = dbInputCss;

const DbInput = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.dbChange = index.createEvent(this, "dbChange", 7);
        this.valueSize = 0;
        this.ariainvalid = null;
        this.ariarequired = null;
        this.autocomplete = null;
        this.autofocus = false;
        this.description = undefined;
        this.dirname = undefined;
        this.disabled = false;
        this.input_id = 'input-' + utils.uuid();
        this.label = undefined;
        this.list = undefined;
        this.maxlength = undefined;
        this.minlength = undefined;
        this.name = undefined;
        this.pattern = undefined;
        this.step = undefined;
        this.min = undefined;
        this.max = undefined;
        this.placeholder = undefined;
        this.readonly = undefined;
        this.required = undefined;
        this.size = undefined;
        this.type = 'text';
        this.value = undefined;
        this.variant = 'semitransparent';
        this.labelHidden = undefined;
    }
    handleChange(event) {
        this.dbChange.emit(event);
    }
    componentDidRender() {
        var _a, _b;
        this.valueSize = ((_b = (_a = this.inputElement) === null || _a === void 0 ? void 0 : _a.value) === null || _b === void 0 ? void 0 : _b.length) || 0;
    }
    render() {
        return (index.h(index.Host, { key: '25b8190b2aa8f6ccc6a80bfcc38d934431ad8ce2' }, index.h("input", { key: 'f7e9ea73c122036503bb7b952cb0d15f8338ec49', type: this.type, class: "elm-input", id: this.input_id, "aria-invalid": this.ariainvalid, "aria-required": this.ariarequired, autocomplete: this.autocomplete, autofocus: this.autofocus, "data-dirname": this.dirname, disabled: this.disabled, list: this.list, max: this.max, maxlength: this.maxlength, min: this.min, minlength: this.minlength, name: this.name, pattern: this.pattern, placeholder: this.placeholder, readonly: this.readonly, required: this.required, size: this.size, step: this.step, value: this.value, "aria-labelledby": this.input_id + '-label', "data-variant": this.variant, onChange: (event) => this.handleChange(event), onInput: (event) => {
                this.valueSize = event.target.value.length;
            }, ref: (el) => (this.inputElement = el) }), index.h("label", { key: '1ad92f074d7a2f8aab068e63ea9b17ebcaa1dee1', class: "elm-label", htmlFor: this.input_id, "aria-hidden": "true", id: this.input_id + '-label', "data-label-hidden": this.labelHidden }, this.label), this.maxlength && (index.h("output", { key: 'ab6f61748b5ee96b3ea10990e7c140093c0e4671', htmlFor: this.input_id, id: `${this.input_id}-result` }, `${this.valueSize} / ${this.maxlength}`)), this.description && (index.h("p", { key: '6c3b282369d021ee6c54a8d12f914acdcbed3c76', id: this.input_id + '-hint', class: "description" }, this.description)), this.list ? (index.h("datalist", { id: this.list }, index.h("slot", null))) : ('')));
    }
};
DbInput.style = DbInputStyle0;

exports.db_input = DbInput;

//# sourceMappingURL=db-input.cjs.entry.js.map