'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-9ca39ddf.js');
const utils = require('./utils-eeddc73b.js');

const dbProgressCss = "@charset \"UTF-8\";.sc-db-progress:where(html,).sc-db-progress-h{line-height:1.15;-webkit-text-size-adjust:100%;-moz-text-size-adjust:100%;-ms-text-size-adjust:100%;text-size-adjust:100%}.sc-db-progress:where(h1){font-size:2em;-webkit-margin-after:0.67em;margin-block-end:0.67em;-webkit-margin-before:0.67em;margin-block-start:0.67em}.sc-db-progress:where(dl,ol.sc-db-progress,ul).sc-db-progress .sc-db-progress:where(dl,ol.sc-db-progress,ul).sc-db-progress{-webkit-margin-after:0;margin-block-end:0;-webkit-margin-before:0;margin-block-start:0}.sc-db-progress:where(hr){-webkit-box-sizing:content-box;box-sizing:content-box;color:inherit;height:0}.sc-db-progress:where(abbr[title]){text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}.sc-db-progress:where(b,strong).sc-db-progress{font-weight:bolder}.sc-db-progress:where(code,kbd.sc-db-progress,pre.sc-db-progress,samp).sc-db-progress{font-family:monospace, monospace;font-size:1em}.sc-db-progress:where(small){font-size:80%}.sc-db-progress:where(table){border-color:currentColor;text-indent:0}.sc-db-progress:where(button,input.sc-db-progress,select).sc-db-progress{margin:0}.sc-db-progress:where(button){text-transform:none}.sc-db-progress:where(button,input.sc-db-progress:is([type=button i],[type=reset i].sc-db-progress,[type=submit i])).sc-db-progress{-webkit-appearance:button}.sc-db-progress:where(progress){vertical-align:baseline}.sc-db-progress:where(select){text-transform:none}.sc-db-progress:where(textarea){margin:0}.sc-db-progress:where(input[type=search i]){-webkit-appearance:textfield;outline-offset:-2px}.sc-db-progress::-webkit-inner-spin-button,.sc-db-progress::-webkit-outer-spin-button{height:auto}.sc-db-progress::-webkit-input-placeholder{color:inherit;opacity:0.54}.sc-db-progress::-webkit-search-decoration{-webkit-appearance:none}.sc-db-progress::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}.sc-db-progress:where(button,input.sc-db-progress:is([type=button i],[type=color i].sc-db-progress,[type=reset i].sc-db-progress,[type=submit i])).sc-db-progress::-moz-focus-inner{border-style:none;padding:0}.sc-db-progress:where(button,input.sc-db-progress:is([type=button i],[type=color i].sc-db-progress,[type=reset i].sc-db-progress,[type=submit i])).sc-db-progress::-moz-focusring{outline:1px dotted ButtonText}.sc-db-progress:where(:-moz-ui-invalid){box-shadow:none}.sc-db-progress:where(dialog){background-color:#fff;border:solid;color:#000;height:-webkit-fit-content;height:-moz-fit-content;height:fit-content;left:0;margin:auto;padding:1em;position:absolute;right:0;width:-webkit-fit-content;width:-moz-fit-content;width:fit-content}.sc-db-progress:where(dialog:not([open])){display:none}.sc-db-progress:where(summary){display:list-item}html.sc-db-progress,.sc-db-progress-h{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}*.sc-db-progress,.sc-db-progress:after,.sc-db-progress:before{-webkit-box-sizing:inherit;box-sizing:inherit}embed.sc-db-progress,iframe.sc-db-progress,img.sc-db-progress,object.sc-db-progress,video.sc-db-progress{height:auto;max-width:100%}iframe.sc-db-progress{border:0}[role=navigation].sc-db-progress ol.sc-db-progress,[role=navigation].sc-db-progress ul.sc-db-progress,nav.sc-db-progress ol.sc-db-progress,nav.sc-db-progress ul.sc-db-progress{list-style:url(\"data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E\");margin:0;padding:0}.sc-db-progress:root{--db-focus-outline-offset:1px;--db-focus-outline-color:#2c95c4}.sc-db-progress:is(a,button.sc-db-progress,input.sc-db-progress,textarea.sc-db-progress,summary).sc-db-progress{--db-focus-outline-size:max(2px,0.08em)}.sc-db-progress:is(a,button.sc-db-progress,input.sc-db-progress,textarea.sc-db-progress,summary).sc-db-progress:focus-visible{outline:var(--db-focus-outline-size) var(--db-focus-outline-style, solid) var(--db-focus-outline-color, currentColor);outline-offset:var(--db-focus-outline-offset, var(--db-focus-outline-size))}.sc-db-progress:where(ul){list-style-type:\"•   \"}.sc-db-progress:where(ul) li.sc-db-progress::marker{color:#ec0016}details.sc-db-progress>*.sc-db-progress,details.sc-db-progress>.sc-db-progress:after,details.sc-db-progress>.sc-db-progress:before{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}body.sc-db-progress,.sc-db-progress-h,button.sc-db-progress,div.sc-db-progress,input.sc-db-progress,select.sc-db-progress,textarea.sc-db-progress{color:#282d37;font-family:DB Screen Sans, Helvetica, Arial, sans-serif;font-size:1rem;font-weight:400;line-height:1.5}a.sc-db-progress{color:inherit}.elm-progress.sc-db-progress progress.sc-db-progress{--progress-value--backgroundColor:#ec0016}.elm-progress.sc-db-progress progress.sc-db-progress{-webkit-appearance:none;-moz-appearance:none;appearance:none;background-color:#fcfdfd;border:none;height:0.25rem;vertical-align:middle}.elm-progress.sc-db-progress progress.sc-db-progress::-webkit-progress-bar{background-color:#fcfdfd}.elm-progress.sc-db-progress progress.sc-db-progress::-webkit-progress-value{background-color:var(--progress-value--backgroundColor)}.elm-progress.sc-db-progress progress.sc-db-progress::-moz-progress-bar{background-color:var(--progress-value--backgroundColor)}.elm-progress.sc-db-progress progress.sc-db-progress::-ms-fill{background-color:var(--progress-value--backgroundColor);border:none}.elm-progress.sc-db-progress progress.sc-db-progress:not([style^=\"--progress-conic:\"])::-webkit-progress-value{border-radius:12px}.elm-progress.sc-db-progress progress.sc-db-progress:not([style^=\"--progress-conic:\"])::-moz-progress-bar{border-radius:12px}.elm-progress.sc-db-progress progress.sc-db-progress:not([style^=\"--progress-conic:\"])::-ms-fill{border-radius:12px}.elm-progress.sc-db-progress progress.sc-db-progress:indeterminate{-webkit-animation-duration:2.1s;animation-duration:2.1s;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-name:elmProgressMoveIndeterminate;animation-name:elmProgressMoveIndeterminate;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-timing-function:cubic-bezier(0.65, 0.815, 0.735, 0.395);animation-timing-function:cubic-bezier(0.65, 0.815, 0.735, 0.395);background-color:#fcfdfd;background-image:-webkit-gradient(linear, left top, right top, color-stop(100%, #ec0016), to(#fcfdfd));background-image:linear-gradient(to right, #ec0016 100%, #fcfdfd 100%);background-position:top left;background-repeat:no-repeat;background-size:150% 150%}@media (prefers-reduced-motion: reduce){.elm-progress.sc-db-progress progress.sc-db-progress:indeterminate{-webkit-animation-duration:15s;animation-duration:15s}}.elm-progress.sc-db-progress progress.sc-db-progress:indeterminate::-webkit-progress-bar{background-color:transparent}.elm-progress.sc-db-progress progress.sc-db-progress:indeterminate::-moz-progress-bar{background-color:transparent}@supports (background: conic-gradient(#000, #fff)){.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress{--fill:calc(var(--progress-conic) * 1%);background:conic-gradient(var(--progress-value--backgroundColor) var(--fill), #fff 0);border:0;border-radius:50%;height:4.6875rem;width:4.6875rem}.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress::-webkit-progress-inner-element,.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress::-webkit-progress-bar,.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress::-webkit-progress-value{display:none}.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress::-moz-progress-bar{background:none}.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress+output.sc-db-progress,.elm-progress.sc-db-progress progress[style^=\"--progress-conic:\"].sc-db-progress+label.sc-db-progress{-ms-flex-align:center;align-items:center;background:#fdfdfd;border-radius:50%;display:block;display:-ms-flexbox;display:flex;height:3.4375rem;-ms-flex-pack:center;justify-content:center;position:absolute;-webkit-transform:translate(0.625rem, -4.0625rem);transform:translate(0.625rem, -4.0625rem);width:3.4375rem}}@-webkit-keyframes elmProgressMoveIndeterminate{0%{background-position:-35% 0;background-size:35% 100%}60%{background-position:101% 0;background-size:65% 100%}100%{background-position:101% 0;background-size:1% 100%}}@keyframes elmProgressMoveIndeterminate{0%{background-position:-35% 0;background-size:35% 100%}60%{background-position:101% 0;background-size:65% 100%}100%{background-position:101% 0;background-size:1% 100%}}";
const DbProgressStyle0 = dbProgressCss;

const DbProgress = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.value = undefined;
        this.max = undefined;
        this.htmlid = 'progress-' + utils.uuid();
        this.percentagesign = '%';
        this.circle = undefined;
        this.indeterminate = false;
    }
    render() {
        return (index.h("div", { key: '8aca985075fc3863e4f1f2697bba270f05ef2ec8', class: "elm-progress" }, index.h("progress", { key: 'd6449dd253c23970ac911b54f1114bc0311c934d', value: this.value, max: this.max, id: this.htmlid, indeterminate: this.indeterminate, style: this.circle === true
                ? { ['--progress-conic']: `${this.value}` }
                : { ['']: '' }, "aria-describedby": this.htmlid + '-label' }), !this.indeterminate && (index.h("label", { key: 'd2dc4f84e190ff8e2f621d9df974e8eafc59e42a', htmlFor: this.htmlid, id: this.htmlid + '-label', "aria-hidden": "true" }, this.value, this.percentagesign))));
    }
};
DbProgress.style = DbProgressStyle0;

exports.db_progress = DbProgress;

//# sourceMappingURL=db-progress.cjs.entry.js.map