'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-9ca39ddf.js');

const githubVersionSwitcherCss = ".gh-version-switcher select{max-width:196px}";
const GithubVersionSwitcherStyle0 = githubVersionSwitcherCss;

const GithubVersionSwitcher = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this._defaultBranch = 'latest';
        this.stripString = (value) => {
            return value.replace(/[^a-zA-Z0-9-]/g, '');
        };
        this.fetchFromGitHubApi = async (url) => {
            const response = await fetch(url);
            return await response.json();
        };
        this.setCurrentBranch = (branchNames) => {
            const currentUrl = window.location.href;
            const foundBranch = branchNames.find((branch) => currentUrl.includes(branch));
            if (foundBranch) {
                this.currentBranch = foundBranch;
            }
        };
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.setBranches = (data) => {
            const branchNames = data
                .map((branch) => branch.name)
                .filter((branch) => branch !== 'gh-pages' && !branch.includes('dependabot'));
            branchNames.forEach((branch) => {
                const foundGroup = this.groups.find((grp) => branch.startsWith(grp.prefix));
                if (foundGroup) {
                    foundGroup.branches.push(branch);
                }
                else {
                    this.groups.at(-1).branches.push(branch);
                }
            });
            this.setCurrentBranch(branchNames);
        };
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.setTags = (data) => {
            const tagNames = data.map((tag) => tag.name);
            tagNames.forEach((tag) => {
                this.groups[0].branches.push(tag);
            });
            this.setCurrentBranch(tagNames);
        };
        this.owner = undefined;
        this.repo = undefined;
        this.groups = [
            { prefix: 'v', name: 'Versions', branches: [] },
            { prefix: 'test', name: 'Tests', branches: [] },
            { prefix: 'feat', name: 'Features', branches: [] },
            { prefix: 'fix', name: 'Bugfixes', branches: [] },
            { prefix: 'chore', name: 'Chore', branches: [] },
            { prefix: 'docs', name: 'Docs', branches: [] },
            { prefix: 'refactor', name: 'Refactors', branches: [] },
            { prefix: 'style', name: 'Styles', branches: [] },
            { prefix: 'ci', name: 'CI', branches: [] },
            { prefix: 'perf', name: 'Perf', branches: [] },
            { prefix: '', name: 'Other', branches: [] }
        ];
        this.currentBranch = this._defaultBranch;
        this.cleanOwner = undefined;
        this.cleanRepo = undefined;
    }
    get defaultBranch() {
        return this._defaultBranch;
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    async componentWillLoad() {
        const cOwner = this.stripString(this.owner);
        this.cleanOwner = cOwner;
        const cRepo = this.stripString(this.repo);
        this.cleanRepo = cRepo;
        const branchesData = await this.fetchFromGitHubApi(`https://api.github.com/repos/${cOwner}/${cRepo}/branches`);
        this.setBranches(branchesData);
        const tagsData = await this.fetchFromGitHubApi(`https://api.github.com/repos/${cOwner}/${cRepo}/tags`);
        this.setTags(tagsData);
    }
    // eslint-disable-next-line @stencil-community/own-methods-must-be-private
    handleChange(branch, localOwner, localRepo) {
        if (localOwner && localRepo) {
            const currentUrl = top.location.href;
            const urlPaths = currentUrl.split('?');
            const lastPath = urlPaths[urlPaths.length - 1];
            const isTag = branch.split('.').length === 3 && branch.startsWith('v');
            top.location = `https://${localOwner}.github.io/${localRepo}${this._defaultBranch === branch
                ? ''
                : `${isTag ? '/version' : '/review'}/${branch}`}/?${lastPath}`;
        }
    }
    render() {
        var _a;
        return (index.h(index.Host, { key: '66a2543e72839abc7f67cb93aecc3a6cd0fbac1e' }, ((_a = this.groups) === null || _a === void 0 ? void 0 : _a.length) > 0 && (index.h("db-select", { key: '0069b07f3c022517f0037fbb3af6a7d1bb6ca8c2', class: "gh-version-switcher", label: "Version", name: "Theme", onDbChange: (event) => this.handleChange(event.target.value, this.cleanOwner, this.cleanRepo) }, index.h("option", { key: 'cd968ac0508b919a08ee39108366e02f124a7830', value: this._defaultBranch, selected: this.currentBranch === this._defaultBranch }, this._defaultBranch), this.groups
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            .filter((group) => { var _a; return ((_a = group.branches) === null || _a === void 0 ? void 0 : _a.length) > 0; })
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            .map((group) => (index.h("optgroup", { key: group.name, label: group.name }, group.branches.map((branch, index$1) => (index.h("option", { key: `${group.name}-${branch}-${index$1}`, value: branch, selected: this.currentBranch === branch }, branch))))))))));
    }
};
GithubVersionSwitcher.style = GithubVersionSwitcherStyle0;

exports.github_version_switcher = GithubVersionSwitcher;

//# sourceMappingURL=github-version-switcher.cjs.entry.js.map