/* eslint-disable @stencil-community/decorators-style */
import { h } from "@stencil/core";
export class DbCard {
    constructor() {
        this.illustrationPaths = {
            account: 'action/db_ic_il_account.svg',
            alarm_clock: 'action/db_ic_il_alarm_clock.svg',
            ar_icon: 'action/db_ic_il_ar_icon.svg',
            calendar: 'action/db_ic_il_calendar.svg',
            christmas: 'action/db_ic_il_christmas.svg',
            clock_moving: 'action/db_ic_il_clock_moving.svg',
            compass: 'action/db_ic_il_compass.svg',
            construction_sign: 'action/db_ic_il_construction_sign.svg',
            construction_worker: 'action/db_ic_il_construction_worker.svg',
            db_clock: 'action/db_ic_il_db_clock.svg',
            diamond: 'action/db_ic_il_diamond.svg',
            fokus: 'action/db_ic_il_fokus.svg',
            gift: 'action/db_ic_il_gift.svg',
            handshake: 'action/db_ic_il_handshake.svg',
            heart: 'action/db_ic_il_heart.svg',
            information: 'action/db_ic_il_information.svg',
            onlineshop_brand: 'action/db_ic_il_onlineshop_brand.svg',
            onlineshop_feature: 'action/db_ic_il_onlineshop_feature.svg',
            pdf: 'action/db_ic_il_pdf.svg',
            printer: 'action/db_ic_il_printer.svg',
            savings: 'action/db_ic_il_savings.svg',
            search: 'action/db_ic_il_search.svg',
            tips: 'action/db_ic_il_tips.svg',
            trash: 'action/db_ic_il_trash.svg',
            broken: 'communication/db_ic_il_broken.svg',
            chat: 'communication/db_ic_il_chat.svg',
            customer_feedback: 'communication/db_ic_il_customer_feedback.svg',
            envelope_closed: 'communication/db_ic_il_envelope_closed.svg',
            envelope_open: 'communication/db_ic_il_envelope_open.svg',
            error: 'communication/db_ic_il_error.svg',
            hashtag: 'communication/db_ic_il_hashtag.svg',
            wifi: 'communication/db_ic_il_wifi.svg',
            '2g_rule': 'covid_19/db_ic_il_2g_rule.svg',
            '3g_rule': 'covid_19/db_ic_il_3g_rule.svg',
            distance: 'covid_19/db_ic_il_distance.svg',
            ffp2_mask: 'covid_19/db_ic_il_ffp2_mask.svg',
            ffp2_mask_with_sign: 'covid_19/db_ic_il_ffp2_mask_with_sign.svg',
            handwashing: 'covid_19/db_ic_il_handwashing.svg',
            no_handshaking: 'covid_19/db_ic_il_no_handshaking.svg',
            recovered: 'covid_19/db_ic_il_recovered.svg',
            single_entry: 'covid_19/db_ic_il_single_entry.svg',
            test_antigen: 'covid_19/db_ic_il_test_antigen.svg',
            test_pcr: 'covid_19/db_ic_il_test_pcr.svg',
            vaccinated: 'covid_19/db_ic_il_vaccinated.svg',
            laptop: 'devices/db_ic_il_laptop.svg',
            smartphone: 'devices/db_ic_il_smartphone.svg',
            tablet: 'devices/db_ic_il_tablet.svg',
            der_kleine_ice: 'entertainment/db_ic_il_der_kleine_ice.svg',
            gaming: 'entertainment/db_ic_il_gaming.svg',
            gaming_no_wire: 'entertainment/db_ic_il_gaming_no_wire.svg',
            movie: 'entertainment/db_ic_il_movie.svg',
            podcast: 'entertainment/db_ic_il_podcast.svg',
            sport: 'entertainment/db_ic_il_sport.svg',
            green: 'feature/db_ic_il_green.svg',
            green_energy: 'feature/db_ic_il_green_energy.svg',
            mobile_payment: 'feature/db_ic_il_mobile_payment.svg',
            nfc_scan: 'feature/db_ic_il_nfc_scan.svg',
            whats_schmutzig: 'feature/db_ic_il_whats_schmutzig.svg',
            coffee_cup: 'food/db_ic_il_coffee_cup.svg',
            restaurant: 'food/db_ic_il_restaurant.svg',
            home: 'maps/db_ic_il_home.svg',
            location: 'maps/db_ic_il_location.svg',
            disruptions: 'news/db_ic_il_disruptions.svg',
            news: 'news/db_ic_il_news.svg',
            newsletter: 'news/db_ic_il_newsletter.svg',
            newspaper: 'news/db_ic_il_newspaper.svg',
            s_bahn_magazin_muenchen: 'news/db_ic_il_s_bahn_magazin_muenchen.svg',
            db_ticket_shop: 'station/db_ic_il_db_ticket_shop.svg',
            db_ticket_vending_machine: 'station/db_ic_il_db_ticket_vending_machine.svg',
            db_trainstation: 'station/db_ic_il_db_trainstation.svg',
            db_trainstation_with_train: 'station/db_ic_il_db_trainstation_with_train.svg',
            db_travel_center: 'station/db_ic_il_db_travel_center.svg',
            db_video_travel_center: 'station/db_ic_il_db_video_travel_center.svg',
            kiosk: 'station/db_ic_il_kiosk.svg',
            mini_store: 'station/db_ic_il_mini_store.svg',
            classic_printout: 'ticket/db_ic_il_classic_printout.svg',
            mobileticket_brand: 'ticket/db_ic_il_mobileticket_brand.svg',
            mobileticket_feature: 'ticket/db_ic_il_mobileticket_feature.svg',
            onlineticket_brand: 'ticket/db_ic_il_onlineticket_brand.svg',
            onlineticket_feature: 'ticket/db_ic_il_onlineticket_feature.svg',
            scan_ticket_printout: 'ticket/db_ic_il_scan_ticket_printout.svg',
            show_ticket: 'ticket/db_ic_il_show_ticket.svg',
            tickets: 'ticket/db_ic_il_tickets.svg',
            airplane: 'transportation/db_ic_il_airplane.svg',
            airplane_2: 'transportation/db_ic_il_airplane_2.svg',
            bicycle: 'transportation/db_ic_il_bicycle.svg',
            bike_trailer: 'transportation/db_ic_il_bike_trailer.svg',
            buggy: 'transportation/db_ic_il_buggy.svg',
            bus_side_view: 'transportation/db_ic_il_bus_side_view.svg',
            call_a_bike: 'transportation/db_ic_il_call_a_bike.svg',
            car: 'transportation/db_ic_il_car.svg',
            car_side_view: 'transportation/db_ic_il_car_side_view.svg',
            commuter_train: 'transportation/db_ic_il_commuter_train.svg',
            electric_scooter: 'transportation/db_ic_il_electric_scooter.svg',
            ev_car: 'transportation/db_ic_il_ev_car.svg',
            ferry: 'transportation/db_ic_il_ferry.svg',
            handcart: 'transportation/db_ic_il_handcart.svg',
            ice: 'transportation/db_ic_il_ice.svg',
            intercity_train: 'transportation/db_ic_il_intercity_train.svg',
            local_bus: 'transportation/db_ic_il_local_bus.svg',
            local_train: 'transportation/db_ic_il_local_train.svg',
            long_distance_bus: 'transportation/db_ic_il_long_distance_bus.svg',
            scooter: 'transportation/db_ic_il_scooter.svg',
            self_driving_side_view: 'transportation/db_ic_il_self_driving_side_view.svg',
            speedboat: 'transportation/db_ic_il_speedboat.svg',
            subway: 'transportation/db_ic_il_subway.svg',
            taxi: 'transportation/db_ic_il_taxi.svg',
            tram: 'transportation/db_ic_il_tram.svg',
            advertising_transportation: 'travel/db_ic_il_advertising_transportation.svg',
            bear: 'travel/db_ic_il_bear.svg',
            db_comfort_checkin: 'travel/db_ic_il_db_comfort_checkin.svg',
            delayed: 'travel/db_ic_il_delayed.svg',
            dog: 'travel/db_ic_il_dog.svg',
            id_card: 'travel/db_ic_il_id_card.svg',
            itinerary: 'travel/db_ic_il_itinerary.svg',
            lost_and_found: 'travel/db_ic_il_lost_and_found.svg',
            luggage: 'travel/db_ic_il_luggage.svg',
            passenger_rights: 'travel/db_ic_il_passenger_rights.svg',
            poi_berlin: 'travel/db_ic_il_poi_berlin.svg',
            poi_berlin_alternative: 'travel/db_ic_il_poi_berlin_alternative.svg',
            suitcase: 'travel/db_ic_il_suitcase.svg',
            timetable: 'travel/db_ic_il_timetable.svg',
            zuginformation: 'travel/db_ic_il_zuginformation.svg',
            blizzard: 'weather/db_ic_il_blizzard.svg',
            thunderstorm: 'weather/db_ic_il_thunderstorm.svg'
        };
        this.alt = undefined;
        this.header = undefined;
        this.content = undefined;
        this.image = undefined;
        this.illustration = undefined;
        this.uiCoreIllustrationPath = './icons/illustrative';
        this.variant = 'banner';
    }
    render() {
        return (h("div", { key: 'd9ce61b10892d953b375a63ff212eb2f23d8a7e6', class: "cmp-card", "data-variant": this.variant }, h("figure", { key: 'be8ab8a686e02aabab90daa708b31e56698d825d' }, this.illustration && (h("svg", { key: 'e8145c32943ea3656d97f95868761b74c81d8d41', xmlns: "http://www.w3.org/2000/svg", width: "64", height: "64", "aria-hidden": "true" }, h("use", { key: 'b63b609c758ce9397b394be17831239474d51d9b', href: `${this.uiCoreIllustrationPath}/${this.illustrationPaths[this.illustration]}#icon` }))), !this.illustration && this.image && (h("img", { key: '7974a83a2a9dc49a4042f133a3a49dfdb74322a4', src: this.image, height: "64", width: "64", alt: this.alt })), h("figcaption", { key: '61e6fb92d007708857eace97743e85254ceb6f60' }, this.header && h("db-headline", { key: 'f015fe29e9f84ef37a39e522c4c64d497de9ec8f' }, this.header), this.content && h("p", { key: 'c9a469236b9c322e40eed5622e410da894df116c' }, this.content), !this.header && !this.content && h("slot", { key: '2f583498ca0576022d5ba2a59e5bec78086a8151' })))));
    }
    static get is() { return "db-card"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-card.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-card.css"]
        };
    }
    static get properties() {
        return {
            "alt": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The alt attribute for the image."
                },
                "attribute": "alt",
                "reflect": true
            },
            "header": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The header represents the title of the card. It's optional and you can use slot for custom tags."
                },
                "attribute": "header",
                "reflect": true
            },
            "content": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The content represents the content of the card. It's optional and you can use slot for custom tags."
                },
                "attribute": "content",
                "reflect": true
            },
            "image": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The prop image can be used instead of illustration to show a custom img."
                },
                "attribute": "image",
                "reflect": true
            },
            "illustration": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "| 'alarm-clock'\n    | 'bicycle'\n    | 'blizzard'\n    | 'broken'\n    | 'buggy'\n    | 'bus'\n    | 'calendar'\n    | 'car'\n    | 'chat'\n    | 'christmas'\n    | 'clock-moving'\n    | 'coffee-cup'\n    | 'compass'\n    | 'construction-sign'\n    | 'construction-worker'\n    | 'customer-feedback'\n    | 'db-clock'\n    | 'db-comfort-checkin'\n    | 'db-ticket-shop'\n    | 'db-ticket-vending-machine'\n    | 'db-trainstation-with-train'\n    | 'db-trainstation'\n    | 'db-travel-center'\n    | 'db-video-travel-center'\n    | 'delayed'\n    | 'der-kleine-ice'\n    | 'diamond'\n    | 'disruptions'\n    | 'distance'\n    | 'error'\n    | 'ffp2-mask-with-sign'\n    | 'ffp2-mask'\n    | 'fokus'\n    | 'gaming-no-wire'\n    | 'gaming'\n    | 'green-energy'\n    | 'green'\n    | 'handshake'\n    | 'handwashing'\n    | 'hashtag'\n    | 'heart'\n    | 'home'\n    | 'information'\n    | 'itinerary'\n    | 'kiosk'\n    | 'laptop'\n    | 'local-train'\n    | 'location'\n    | 'lost-and-found'\n    | 'luggage'\n    | 'mask'\n    | 'mini-store'\n    | 'mobileticket-brand'\n    | 'mobileticket-feature'\n    | 'movie'\n    | 'news'\n    | 'newsletter'\n    | 'newspaper'\n    | 'no-handshaking'\n    | 'onlineshop-brand'\n    | 'onlineshop-feature'\n    | 'onlineticket-brand'\n    | 'onlineticket-feature'\n    | 'passenger-rights'\n    | 'podcast'\n    | 'poi-berlin-copy'\n    | 'poi-berlin'\n    | 'restaurant'\n    | 'savings'\n    | 'scan-ticket-printout'\n    | 'search'\n    | 'self-driving'\n    | 'show-ticket'\n    | 'single-entry'\n    | 'smartphone'\n    | 'sport'\n    | 'suitcase'\n    | 'tablet'\n    | 'thunderstorm'\n    | 'tickets'\n    | 'timetable'\n    | 'tips'\n    | 'transportation-advertising'\n    | 'whats-schmutzig'\n    | 'wifi'",
                    "resolved": "\"location\" | \"error\" | \"calendar\" | \"compass\" | \"heart\" | \"search\" | \"chat\" | \"wifi\" | \"mask\" | \"buggy\" | \"coffee-cup\" | \"restaurant\" | \"home\" | \"timetable\" | \"bicycle\" | \"car\" | \"local-train\" | \"alarm-clock\" | \"blizzard\" | \"broken\" | \"bus\" | \"christmas\" | \"clock-moving\" | \"construction-sign\" | \"construction-worker\" | \"customer-feedback\" | \"db-clock\" | \"db-comfort-checkin\" | \"db-ticket-shop\" | \"db-ticket-vending-machine\" | \"db-trainstation-with-train\" | \"db-trainstation\" | \"db-travel-center\" | \"db-video-travel-center\" | \"delayed\" | \"der-kleine-ice\" | \"diamond\" | \"disruptions\" | \"distance\" | \"ffp2-mask-with-sign\" | \"ffp2-mask\" | \"fokus\" | \"gaming-no-wire\" | \"gaming\" | \"green-energy\" | \"green\" | \"handshake\" | \"handwashing\" | \"hashtag\" | \"information\" | \"itinerary\" | \"kiosk\" | \"laptop\" | \"lost-and-found\" | \"luggage\" | \"mini-store\" | \"mobileticket-brand\" | \"mobileticket-feature\" | \"movie\" | \"news\" | \"newsletter\" | \"newspaper\" | \"no-handshaking\" | \"onlineshop-brand\" | \"onlineshop-feature\" | \"onlineticket-brand\" | \"onlineticket-feature\" | \"passenger-rights\" | \"podcast\" | \"poi-berlin-copy\" | \"poi-berlin\" | \"savings\" | \"scan-ticket-printout\" | \"self-driving\" | \"show-ticket\" | \"single-entry\" | \"smartphone\" | \"sport\" | \"suitcase\" | \"tablet\" | \"thunderstorm\" | \"tickets\" | \"tips\" | \"transportation-advertising\" | \"whats-schmutzig\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The illustration which will show a predefined svg. -Development: enum can be generated with /scripts/illustration-generator-"
                },
                "attribute": "illustration",
                "reflect": true
            },
            "uiCoreIllustrationPath": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The illustration-path defines the path to DB UI Core illustrations. If you want to use other/custom images use the image prop instead."
                },
                "attribute": "illustration-path",
                "reflect": true,
                "defaultValue": "'./icons/illustrative'"
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'banner' | 'title'",
                    "resolved": "\"banner\" | \"title\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The variant which is banner or title."
                },
                "attribute": "variant",
                "reflect": true,
                "defaultValue": "'banner'"
            }
        };
    }
}
//# sourceMappingURL=db-card.js.map
