import { h, Host } from "@stencil/core";
import { getDefaultLinkData, parseData } from "../../utils/utils";
export class DbLinklist {
    constructor() {
        this.data = undefined;
    }
    get children() {
        return this._children;
    }
    set children(value) {
        this._children = value;
    }
    componentWillLoad() {
        if (this.data) {
            this.compData = parseData(this.data);
        }
        else {
            this._children = Array.from(this.host.children);
            if (this.children.find((child) => child.tagName.toLowerCase() === 'li')) {
                this.hasItemsWrapper = true;
            }
            else {
                this.host.innerHTML = '';
            }
        }
    }
    render() {
        return (h(Host, { key: 'b510259b31c82dfa1bec3d2fafcb595f8a3eb8ef' }, this.compData && (h("ul", { key: '4c1a238f98a8d5a5c1a7a26a15b2b3560884f59f', class: "cmp-link-list", innerHTML: getDefaultLinkData(this.compData) })), !this.compData && (h("ul", { key: '29186cc399e1e7d5daa1696d9e0b279f21e7b703', class: "cmp-link-list" }, !this.hasItemsWrapper &&
            this._children.map((child, index) => (h("li", { key: `cmp-link-list-item-${index}`, innerHTML: child.outerHTML }))), this.hasItemsWrapper && h("slot", { key: '0cd83476621bf2dbee4e3cf7fdab8a7243bface4' })))));
    }
    static get is() { return "db-linklist"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-linklist.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-linklist.css"]
        };
    }
    static get properties() {
        return {
            "data": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The data attribute can be used to generate linklist by data."
                },
                "attribute": "data",
                "reflect": true
            }
        };
    }
    static get elementRef() { return "host"; }
}
//# sourceMappingURL=db-linklist.js.map
