import { h, Host } from "@stencil/core";
import { getDefaultLinkData, parseData } from "../../utils/utils";
export class DbMetanavigation {
    constructor() {
        this.data = undefined;
    }
    get children() {
        return this._children;
    }
    set children(value) {
        this._children = value;
    }
    componentWillLoad() {
        if (this.data) {
            this.compData = parseData(this.data);
        }
        else {
            this._children = Array.from(this.host.children);
            if (this.children.find((child) => child.tagName.toLowerCase() === 'li')) {
                this.hasItemsWrapper = true;
            }
            else {
                this.host.innerHTML = '';
            }
        }
    }
    render() {
        return (h(Host, { key: '830720f861b806409e13806b645c684bd16de6b0' }, this.compData && (h("ul", { key: '2ce71792c698fb8a2bf4510e3db3bc58cba655a4', class: "cmp-metanavigation", innerHTML: getDefaultLinkData(this.compData) })), !this.compData && (h("ul", { key: 'bdc69e1ff7e1e17e8cdc2259561c15fbb038c346', class: "cmp-metanavigation" }, !this.hasItemsWrapper &&
            this._children.map((child, index) => (h("li", { key: `cmp-metanavigation-item-${index}`, innerHTML: child.outerHTML }))), this.hasItemsWrapper && h("slot", { key: 'c375e4759c551b6e4b8a72bc060745a051277969' })))));
    }
    static get is() { return "db-metanavigation"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-metanavigation.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-metanavigation.css"]
        };
    }
    static get properties() {
        return {
            "data": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The data attribute can be used to generate metanavigation by data."
                },
                "attribute": "data",
                "reflect": true
            }
        };
    }
    static get elementRef() { return "host"; }
}
//# sourceMappingURL=db-metanavigation.js.map
