import { h } from "@stencil/core";
import { getDefaultLinkData, parseData } from "../../utils/utils";
export class DbOverflowMenu {
    constructor() {
        this.data = undefined;
        this.opposite = undefined;
        this.summary = '';
    }
    get children() {
        return this._children;
    }
    set children(value) {
        this._children = value;
    }
    componentWillLoad() {
        if (this.data) {
            this.compData = parseData(this.data);
        }
        else {
            this._children = Array.from(this.host.children);
            if (this.children.find((child) => child.tagName.toLowerCase() === 'li')) {
                this.hasItemsWrapper = true;
            }
            else {
                this.host.innerHTML = '';
            }
        }
    }
    render() {
        return (h("details", { key: '4a90e5c579ae0828a13b8d366612f809ac99ff0b', class: "cmp-overflow-menu", "data-horizontal-position": this.opposite && 'opposite' }, h("summary", { key: '91cea27a1801660cbc6b05d473c11498dae503ca' }, this.summary), this.compData && (h("menu", { key: 'cd8ac4516712c258d410dd66515d4e829f6e4ec3', type: "toolbar", innerHTML: getDefaultLinkData(this.compData) })), !this.compData && (h("menu", { key: '721a399f4b37003152999408598b7efaa2e4a402', type: "toolbar" }, !this.hasItemsWrapper &&
            this._children.map((child, index) => (h("li", { key: `cmp-overflow-menu-${index}`, innerHTML: child.outerHTML }))), this.hasItemsWrapper && h("slot", { key: 'cdd72f56225a58c479d9bd663525e62fd32e3b0c' })))));
    }
    static get is() { return "db-overflow-menu"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-overflow-menu.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-overflow-menu.css"]
        };
    }
    static get properties() {
        return {
            "data": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The data attribute can be used to generate overflow-menu by data."
                },
                "attribute": "data",
                "reflect": true
            },
            "opposite": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The opposite attribute, changes the behaviour: overflow-menu -> right."
                },
                "attribute": "opposite",
                "reflect": true
            },
            "summary": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The summary attribute, shows a text for accessibility."
                },
                "attribute": "summary",
                "reflect": true,
                "defaultValue": "''"
            }
        };
    }
    static get elementRef() { return "host"; }
}
//# sourceMappingURL=db-overflow-menu.js.map
