import { Host, h } from "@stencil/core";
import { uuid } from "../../utils/utils";
export class DbTab {
    constructor() {
        this.active = undefined;
        this.label = undefined;
        this.name = undefined;
        this.id = uuid();
    }
    render() {
        return (h(Host, { key: '272494c58ded471d415ecc32cbcea14d4deb049c', class: "cmp-db-tab" }, h("input", { key: '02d61cfac4032c895abe21a935759fcb4dd9c817', type: "radio", name: this.name, id: this.id, checked: this.active }), h("label", { key: '268b8eb627165ba26bebf1ab0a9dc2bbbbf39b8c', htmlFor: this.id, role: "tab" }, this.label), h("section", { key: '5e0e7d7f37c4ec2b1cf32d322a27be0fa8b57430', id: `content-${this.id}`, role: "tabpanel" }, h("slot", { key: '24f03b9a6745701d489ab01a183bf075b8a9b9e3' }))));
    }
    static get is() { return "db-tab"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-tab.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-tab.css"]
        };
    }
    static get properties() {
        return {
            "active": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If the tab is checked/active."
                },
                "attribute": "active",
                "reflect": true
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label of the tab, shown in the tab-bar."
                },
                "attribute": "label",
                "reflect": true
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name of the tab bar, is required for grouping multiple tabs together. Otherwise content won't switch by clicking the tabs."
                },
                "attribute": "name",
                "reflect": true
            }
        };
    }
}
//# sourceMappingURL=db-tab.js.map
