import { Host, h } from "@stencil/core";
import { uuid } from "../../utils/utils";
export class DbToggle {
    constructor() {
        this.htmlid = 'toggle-' + uuid();
        this.disabled = undefined;
        this.checked = undefined;
        this.name = undefined;
    }
    handleChange(event) {
        this.dbChange.emit(event);
    }
    render() {
        return (h(Host, { key: '07812ec1d70ef661892422535fa953b37a004b39' }, h("input", { key: '1ca6344ee497b67595d9d5ac195ee9e0d5832578', type: "checkbox", role: "switch", class: "elm-toggle", disabled: this.disabled, checked: this.checked, id: this.htmlid, name: this.name, onChange: (event) => this.handleChange(event) }), h("label", { key: 'dc25da0c2c94597882d8a79af99f94572d8d128b', class: "elm-label", htmlFor: this.htmlid }, h("slot", { key: '1278c3370cd698ae35d03b464fac8ffb101c3fec' }))));
    }
    static get is() { return "db-toggle"; }
    static get originalStyleUrls() {
        return {
            "$": ["db-toggle.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["db-toggle.css"]
        };
    }
    static get properties() {
        return {
            "htmlid": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional id for the label - otherwise random id will be set"
                },
                "attribute": "htmlid",
                "reflect": false,
                "defaultValue": "'toggle-' + uuid()"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disabled property"
                },
                "attribute": "disabled",
                "reflect": true
            },
            "checked": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Checked property"
                },
                "attribute": "checked",
                "reflect": true
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The name attribute specifies a name for the included input element."
                },
                "attribute": "name",
                "reflect": true
            }
        };
    }
    static get events() {
        return [{
                "method": "dbChange",
                "name": "dbChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Mapping for default change Event"
                },
                "complexType": {
                    "original": "any",
                    "resolved": "any",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=db-toggle.js.map
