import { r as registerInstance, h } from './index-2acd4413.js';

const dbAccordionCss = "@charset \"UTF-8\";:where(html,:host){line-height:1.15;-webkit-text-size-adjust:100%;-moz-text-size-adjust:100%;-ms-text-size-adjust:100%;text-size-adjust:100%}:where(h1){font-size:2em;-webkit-margin-after:0.67em;margin-block-end:0.67em;-webkit-margin-before:0.67em;margin-block-start:0.67em}:where(dl,ol,ul) :where(dl,ol,ul){-webkit-margin-after:0;margin-block-end:0;-webkit-margin-before:0;margin-block-start:0}:where(hr){-webkit-box-sizing:content-box;box-sizing:content-box;color:inherit;height:0}:where(abbr[title]){text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}:where(b,strong){font-weight:bolder}:where(code,kbd,pre,samp){font-family:monospace, monospace;font-size:1em}:where(small){font-size:80%}:where(table){border-color:currentColor;text-indent:0}:where(button,input,select){margin:0}:where(button){text-transform:none}:where(button,input:is([type=button i],[type=reset i],[type=submit i])){-webkit-appearance:button}:where(progress){vertical-align:baseline}:where(select){text-transform:none}:where(textarea){margin:0}:where(input[type=search i]){-webkit-appearance:textfield;outline-offset:-2px}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}::-webkit-input-placeholder{color:inherit;opacity:0.54}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}:where(button,input:is([type=button i],[type=color i],[type=reset i],[type=submit i]))::-moz-focus-inner{border-style:none;padding:0}:where(button,input:is([type=button i],[type=color i],[type=reset i],[type=submit i]))::-moz-focusring{outline:1px dotted ButtonText}:where(:-moz-ui-invalid){box-shadow:none}:where(dialog){background-color:#fff;border:solid;color:#000;height:-webkit-fit-content;height:-moz-fit-content;height:fit-content;left:0;margin:auto;padding:1em;position:absolute;right:0;width:-webkit-fit-content;width:-moz-fit-content;width:fit-content}:where(dialog:not([open])){display:none}:where(summary){display:list-item}html,:host{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}*,:after,:before{-webkit-box-sizing:inherit;box-sizing:inherit}embed,iframe,img,object,video{height:auto;max-width:100%}iframe{border:0}[role=navigation] ol,[role=navigation] ul,nav ol,nav ul{list-style:url(\"data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E\");margin:0;padding:0}:root{--db-focus-outline-offset:1px;--db-focus-outline-color:#2c95c4}:is(a,button,input,textarea,summary){--db-focus-outline-size:max(2px,0.08em)}:is(a,button,input,textarea,summary):focus-visible{outline:var(--db-focus-outline-size) var(--db-focus-outline-style, solid) var(--db-focus-outline-color, currentColor);outline-offset:var(--db-focus-outline-offset, var(--db-focus-outline-size))}:where(ul){list-style-type:\"•   \"}:where(ul) li::marker{color:#ec0016}details>*,details>:after,details>:before{-webkit-box-sizing:var(--db-box-sizing, border-box);box-sizing:var(--db-box-sizing, border-box)}body,:host,button,div,input,select,textarea{color:#282d37;font-family:DB Screen Sans, Helvetica, Arial, sans-serif;font-size:1rem;font-weight:400;line-height:1.5}a{color:inherit}.cmp-accordion{--db-accordion---paddingLeft:0.0625remrem;border-bottom:1px solid #d7dce1;padding-left:var(--db-accordion---paddingLeft);padding-right:1rem}.cmp-accordion summary{--icon-glyph-after:\"⌄\";-ms-flex-align:center;align-items:center;display:-ms-flexbox;display:flex;-ms-flex-pack:justify;justify-content:space-between;padding-block:0.75rem;-webkit-transform:translateX(calc(var(--db-accordion---paddingLeft) * -1));transform:translateX(calc(var(--db-accordion---paddingLeft) * -1));width:calc(\n\t\t\t100% + var(--db-accordion---paddingLeft) + 1rem\n\t\t)}.cmp-accordion summary::after{--icon-font-family:\"icons-24-outline\",\n  \t\"missing-icons\" !important;font-size:var(--icon-font-size-after, var(--icon-font-size, 1.5rem));-webkit-margin-start:var(--icon-margin-before, 0.375rem);margin-inline-start:var(--icon-margin-before, 0.375rem);content:var(--icon-glyph-after);display:inline-block;font-family:var(--icon-font-family) !important;font-style:normal;font-variant:normal;font-weight:normal;font-weight:var(--icon-font-weight, normal);line-height:1;text-transform:none;vertical-align:middle;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;-webkit-alt:\"\";alt:\"\";speak:none;speak:never}@supports (content: \"\"/\"\"){.cmp-accordion summary::after{content:var(--icon-glyph-after)/\"\"}}@media aural{.cmp-accordion summary::after{content:none}}@media speech{.cmp-accordion summary::after{content:none}}.cmp-accordion summary::-webkit-details-marker{display:none}.cmp-accordion summary:first-of-type{list-style-type:none}.cmp-accordion summary::after{--icon-margin-before:0.5rem;margin-right:0.875rem}.cmp-accordion summary+p{margin-top:0}.cmp-accordion[open]>summary::after{content:\"⌃\"}.cmp-accordion[data-emphasis=high]{--db-accordion---paddingLeft:0.5625remrem}.cmp-accordion[data-emphasis=high] summary{font-weight:700;height:3.5rem}.cmp-accordion[data-emphasis=high] summary::after{--icon-font-size:2rem}.cmp-accordion[data-size=small]{--db-accordion---paddingLeft:-0.6875remrem}.cmp-accordion[data-size=small] summary{font-size:0.875rem;padding-block:0.59375rem}.cmp-accordion[data-size=small] summary::after{--icon-font-size:1.25rem;--icon-margin-after:0.375rem;margin-left:0.375rem}.cmp-accordion[data-size=large]{--db-accordion---paddingLeft:0.5625remrem}.cmp-accordion[data-size=large] summary{font-size:1.25rem;padding-block:1rem}.cmp-accordion[data-size=large] summary::after{--icon-font-size:2rem}";
const DbAccordionStyle0 = dbAccordionCss;

const DbAccordion = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.emphasis = undefined;
        this.size = 'regular';
        this.summary = undefined;
        this.open = undefined;
    }
    render() {
        return (h("details", { key: 'a3913820c039fbe2044cf0b9c841330504c3032a', class: "cmp-accordion", "data-emphasis": this.emphasis ? 'high' : false, "data-size": this.size, open: this.open }, h("summary", { key: 'c9e4d40bf11f39643b9893d980862a30ccbb36ce' }, this.summary), h("slot", { key: '9d4cbba7bfb45788d09dfdb3e6839aec2b1fa052' })));
    }
};
DbAccordion.style = DbAccordionStyle0;

export { DbAccordion as db_accordion };

//# sourceMappingURL=db-accordion.entry.js.map