export declare class DbLink {
    /**
     * The current attribute is the state on an element indicates that this element represents the current item within a container or set of related elements.
     */
    current: 'page' | 'step' | 'location' | 'date' | 'time' | 'true' | 'false';
    /**
     * The href attribute represents a hyperlink (a hypertext anchor).
     */
    href: string;
    /**
     * The hreflang attribute gives the language of the linked resource. The value must be a valid BCP 47 language tag.
     */
    hreflang: string;
    /**
     * Define an icon by it's identifier (like e.g. _download_, compare to [DB UI Icons](https://db-ui.github.io/core/patterns/base-icons/index.html)) to get displayed in front of the elements content.
     */
    icon?: string;
    /**
     * The variant attribute specifies the style and size of an icon.
     */
    iconVariant?: '16-filled' | '20-filled' | '24-filled' | '32-filled' | '48-filled' | '64-filled' | '16-outline' | '20-outline' | '24-outline' | '32-outline' | '48-outline' | '64-outline';
    /**
     * Define the text next to the icon specified via the icon Property to get hidden.
     */
    icononly?: boolean;
    /**
     * The media attribute describes for which media the target document was designed. The value must be a valid media query. The default, if the media attribute is omitted, is "all".
     */
    media: string;
    /**
     * The rel attribute controls what kinds of links the elements create. The attribue's value must be a set of space-separated tokens. The allowed keywords and their meanings are defined below.
     */
    rel: 'alternate' | 'appendix' | 'author' | 'bookmark' | 'chapter' | 'contents' | 'copyright' | 'glossary' | 'help' | 'index' | 'license' | 'next' | 'nofollow' | 'noopener' | 'noreferrer' | 'prefetch' | 'prev' | 'search' | 'section' | 'start' | 'subsection' | 'tag';
    /**
     * The target attribute gives the name of the browsing context that will be used. User agents use this name when following hyperlinks.
     */
    target: '_blank' | '_self' | '_parent' | '_top';
    /**
     * The type attribute, if present, gives the MIME type of the linked resource. The value must be a valid MIME type. User agents must not consider the type attribute authoritative — upon fetching the resource, user agents must not use metadata included in the link to the resource to determine its type.
     */
    type: string;
    /**
     * The text attribute can be used to set the text inside the anchor tag without slot.
     */
    text: string;
    host: HTMLDbLinkElement;
    componentWillLoad(): void;
    render(): any;
}
