export declare class DbPagination {
    private pagesFull;
    /**
     * The ellipsisstart attribute only needs to be passed when working with slots.
     * Should to be set to true if an ellipsis needs to be shown at the start of
     * the pagination.
     */
    ellipsisstart: boolean;
    /**
     * The ellipsisend attribute only needs to be passed when working with slots.
     * Should to be set to true if an ellipsis needs to be shown at the end of
     * the pagination.
     */
    ellipsisend: boolean;
    /**
     * The currentpage attribute is a obligatory number attribute and indicates which
     * page number is highlighted in the pagination.
     */
    currentpage: number;
    /**
     * The pages attribute is a obligatory number attribute and indicates how many
     * pages the pagination knows about.
     */
    pages: number;
    /**
     * The count attribute is a number attribute and defines the number of pages
     * displayed apart from the first and last page (except if currentpage is the
     * first or last page, then these pages are included in the count).
     */
    count: number;
    /**
     * The titleprevious attribute is a string attribute and defines the title of
     * the left arrow in the pagination.
     */
    titleprevious: string;
    /**
     * The titlenext attribute is a string attribute and defines the title of
     * the right arrow in the pagination.
     */
    titlenext: string;
    /**
     * The titlepagination attribute is a string attribute and defines the title of
     * each page number (except first and last) displayed in the pagination.
     */
    titlepagination: string;
    /**
     * The textprevious attribute is a string attribute and defines the text
     * content of the left arrow in the pagination.
     */
    textprevious: string;
    /**
     * The textnext attribute is a string attribute and defines the text
     * content of the right arrow in the pagination.
     */
    textnext: string;
    /**
     * The arialabel attribute is a string attribute and defines the text
     * content of the aria-label in the pagination.
     */
    arialabel: string;
    /**
     * Optional id for the caption aria label - otherwise random id will be set
     */
    ariaid: string;
    /**
     * Mapping for default change Event
     */
    dbChange: any;
    private handleChange;
    watchHandler(): void;
    hostElement: HTMLDbPaginationElement;
    componentWillLoad(): void;
    private sliceAndSetDefaults;
    private decorateChild;
    private paginationButtonFragment;
    private navElement;
    private slotChildren;
    private goToPreviousPage;
    private goToNextPage;
    private goToFirstPage;
    private goToLastPage;
    private showMiddlePage;
    private showEllipsis;
    private sliceCenterPages;
    private centerPages;
    render(): any;
}
