(function webpackUniversalModuleDefinition(root, factory) {
  if (typeof exports === 'object' && typeof module === 'object')
    module.exports = factory();
  else if (typeof define === 'function' && define.amd) define([], factory);
        else if (typeof exports === 'object') exports['deck'] = factory();
  else root['deck'] = factory();})(globalThis, function () {
"use strict";
var __exports__ = (() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };

  // external-global-plugin:@deck.gl/layers
  var require_layers = __commonJS({
    "external-global-plugin:@deck.gl/layers"(exports, module) {
      module.exports = globalThis.deck;
    }
  });

  // external-global-plugin:@deck.gl/core
  var require_core = __commonJS({
    "external-global-plugin:@deck.gl/core"(exports, module) {
      module.exports = globalThis.deck;
    }
  });

  // external-global-plugin:@luma.gl/core
  var require_core2 = __commonJS({
    "external-global-plugin:@luma.gl/core"(exports, module) {
      module.exports = globalThis.luma;
    }
  });

  // bundle.ts
  var bundle_exports = {};
  __export(bundle_exports, {
    AGGREGATION_OPERATION: () => AGGREGATION_OPERATION,
    CPUGridLayer: () => CPUGridLayer,
    ContourLayer: () => ContourLayer,
    GPUGridLayer: () => GPUGridLayer,
    GridLayer: () => GridLayer,
    HeatmapLayer: () => HeatmapLayer,
    HexagonLayer: () => HexagonLayer,
    ScreenGridLayer: () => ScreenGridLayer,
    _AggregationLayer: () => AggregationLayer,
    _BinSorter: () => BinSorter,
    _CPUAggregator: () => CPUAggregator,
    _GPUGridAggregator: () => GPUGridAggregator
  });

  // ../layers/bundle/peer-dependency.ts
  var peer_dependency_exports = {};
  var import_layers = __toESM(require_layers());
  __reExport(peer_dependency_exports, __toESM(require_layers()));
  if (!import_layers.GeoJsonLayer) {
    throw new Error("@deck.gl/layers is not found");
  }

  // bundle.ts
  __reExport(bundle_exports, peer_dependency_exports);

  // src/screen-grid-layer/screen-grid-layer.ts
  var import_core13 = __toESM(require_core());

  // ../../node_modules/@luma.gl/constants/dist/esm/index.js
  var esm_default = {
    DEPTH_BUFFER_BIT: 256,
    STENCIL_BUFFER_BIT: 1024,
    COLOR_BUFFER_BIT: 16384,
    POINTS: 0,
    LINES: 1,
    LINE_LOOP: 2,
    LINE_STRIP: 3,
    TRIANGLES: 4,
    TRIANGLE_STRIP: 5,
    TRIANGLE_FAN: 6,
    ZERO: 0,
    ONE: 1,
    SRC_COLOR: 768,
    ONE_MINUS_SRC_COLOR: 769,
    SRC_ALPHA: 770,
    ONE_MINUS_SRC_ALPHA: 771,
    DST_ALPHA: 772,
    ONE_MINUS_DST_ALPHA: 773,
    DST_COLOR: 774,
    ONE_MINUS_DST_COLOR: 775,
    SRC_ALPHA_SATURATE: 776,
    CONSTANT_COLOR: 32769,
    ONE_MINUS_CONSTANT_COLOR: 32770,
    CONSTANT_ALPHA: 32771,
    ONE_MINUS_CONSTANT_ALPHA: 32772,
    FUNC_ADD: 32774,
    FUNC_SUBTRACT: 32778,
    FUNC_REVERSE_SUBTRACT: 32779,
    BLEND_EQUATION: 32777,
    BLEND_EQUATION_RGB: 32777,
    BLEND_EQUATION_ALPHA: 34877,
    BLEND_DST_RGB: 32968,
    BLEND_SRC_RGB: 32969,
    BLEND_DST_ALPHA: 32970,
    BLEND_SRC_ALPHA: 32971,
    BLEND_COLOR: 32773,
    ARRAY_BUFFER_BINDING: 34964,
    ELEMENT_ARRAY_BUFFER_BINDING: 34965,
    LINE_WIDTH: 2849,
    ALIASED_POINT_SIZE_RANGE: 33901,
    ALIASED_LINE_WIDTH_RANGE: 33902,
    CULL_FACE_MODE: 2885,
    FRONT_FACE: 2886,
    DEPTH_RANGE: 2928,
    DEPTH_WRITEMASK: 2930,
    DEPTH_CLEAR_VALUE: 2931,
    DEPTH_FUNC: 2932,
    STENCIL_CLEAR_VALUE: 2961,
    STENCIL_FUNC: 2962,
    STENCIL_FAIL: 2964,
    STENCIL_PASS_DEPTH_FAIL: 2965,
    STENCIL_PASS_DEPTH_PASS: 2966,
    STENCIL_REF: 2967,
    STENCIL_VALUE_MASK: 2963,
    STENCIL_WRITEMASK: 2968,
    STENCIL_BACK_FUNC: 34816,
    STENCIL_BACK_FAIL: 34817,
    STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
    STENCIL_BACK_PASS_DEPTH_PASS: 34819,
    STENCIL_BACK_REF: 36003,
    STENCIL_BACK_VALUE_MASK: 36004,
    STENCIL_BACK_WRITEMASK: 36005,
    VIEWPORT: 2978,
    SCISSOR_BOX: 3088,
    COLOR_CLEAR_VALUE: 3106,
    COLOR_WRITEMASK: 3107,
    UNPACK_ALIGNMENT: 3317,
    PACK_ALIGNMENT: 3333,
    MAX_TEXTURE_SIZE: 3379,
    MAX_VIEWPORT_DIMS: 3386,
    SUBPIXEL_BITS: 3408,
    RED_BITS: 3410,
    GREEN_BITS: 3411,
    BLUE_BITS: 3412,
    ALPHA_BITS: 3413,
    DEPTH_BITS: 3414,
    STENCIL_BITS: 3415,
    POLYGON_OFFSET_UNITS: 10752,
    POLYGON_OFFSET_FACTOR: 32824,
    TEXTURE_BINDING_2D: 32873,
    SAMPLE_BUFFERS: 32936,
    SAMPLES: 32937,
    SAMPLE_COVERAGE_VALUE: 32938,
    SAMPLE_COVERAGE_INVERT: 32939,
    COMPRESSED_TEXTURE_FORMATS: 34467,
    VENDOR: 7936,
    RENDERER: 7937,
    VERSION: 7938,
    IMPLEMENTATION_COLOR_READ_TYPE: 35738,
    IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
    BROWSER_DEFAULT_WEBGL: 37444,
    STATIC_DRAW: 35044,
    STREAM_DRAW: 35040,
    DYNAMIC_DRAW: 35048,
    ARRAY_BUFFER: 34962,
    ELEMENT_ARRAY_BUFFER: 34963,
    BUFFER_SIZE: 34660,
    BUFFER_USAGE: 34661,
    CURRENT_VERTEX_ATTRIB: 34342,
    VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
    VERTEX_ATTRIB_ARRAY_SIZE: 34339,
    VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
    VERTEX_ATTRIB_ARRAY_TYPE: 34341,
    VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
    VERTEX_ATTRIB_ARRAY_POINTER: 34373,
    VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
    CULL_FACE: 2884,
    FRONT: 1028,
    BACK: 1029,
    FRONT_AND_BACK: 1032,
    BLEND: 3042,
    DEPTH_TEST: 2929,
    DITHER: 3024,
    POLYGON_OFFSET_FILL: 32823,
    SAMPLE_ALPHA_TO_COVERAGE: 32926,
    SAMPLE_COVERAGE: 32928,
    SCISSOR_TEST: 3089,
    STENCIL_TEST: 2960,
    NO_ERROR: 0,
    INVALID_ENUM: 1280,
    INVALID_VALUE: 1281,
    INVALID_OPERATION: 1282,
    OUT_OF_MEMORY: 1285,
    CONTEXT_LOST_WEBGL: 37442,
    CW: 2304,
    CCW: 2305,
    DONT_CARE: 4352,
    FASTEST: 4353,
    NICEST: 4354,
    GENERATE_MIPMAP_HINT: 33170,
    BYTE: 5120,
    UNSIGNED_BYTE: 5121,
    SHORT: 5122,
    UNSIGNED_SHORT: 5123,
    INT: 5124,
    UNSIGNED_INT: 5125,
    FLOAT: 5126,
    DOUBLE: 5130,
    DEPTH_COMPONENT: 6402,
    ALPHA: 6406,
    RGB: 6407,
    RGBA: 6408,
    LUMINANCE: 6409,
    LUMINANCE_ALPHA: 6410,
    UNSIGNED_SHORT_4_4_4_4: 32819,
    UNSIGNED_SHORT_5_5_5_1: 32820,
    UNSIGNED_SHORT_5_6_5: 33635,
    FRAGMENT_SHADER: 35632,
    VERTEX_SHADER: 35633,
    COMPILE_STATUS: 35713,
    DELETE_STATUS: 35712,
    LINK_STATUS: 35714,
    VALIDATE_STATUS: 35715,
    ATTACHED_SHADERS: 35717,
    ACTIVE_ATTRIBUTES: 35721,
    ACTIVE_UNIFORMS: 35718,
    MAX_VERTEX_ATTRIBS: 34921,
    MAX_VERTEX_UNIFORM_VECTORS: 36347,
    MAX_VARYING_VECTORS: 36348,
    MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
    MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
    MAX_TEXTURE_IMAGE_UNITS: 34930,
    MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
    SHADER_TYPE: 35663,
    SHADING_LANGUAGE_VERSION: 35724,
    CURRENT_PROGRAM: 35725,
    NEVER: 512,
    ALWAYS: 519,
    LESS: 513,
    EQUAL: 514,
    LEQUAL: 515,
    GREATER: 516,
    GEQUAL: 518,
    NOTEQUAL: 517,
    KEEP: 7680,
    REPLACE: 7681,
    INCR: 7682,
    DECR: 7683,
    INVERT: 5386,
    INCR_WRAP: 34055,
    DECR_WRAP: 34056,
    NEAREST: 9728,
    LINEAR: 9729,
    NEAREST_MIPMAP_NEAREST: 9984,
    LINEAR_MIPMAP_NEAREST: 9985,
    NEAREST_MIPMAP_LINEAR: 9986,
    LINEAR_MIPMAP_LINEAR: 9987,
    TEXTURE_MAG_FILTER: 10240,
    TEXTURE_MIN_FILTER: 10241,
    TEXTURE_WRAP_S: 10242,
    TEXTURE_WRAP_T: 10243,
    TEXTURE_2D: 3553,
    TEXTURE: 5890,
    TEXTURE_CUBE_MAP: 34067,
    TEXTURE_BINDING_CUBE_MAP: 34068,
    TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
    TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
    TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
    TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
    TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
    TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
    MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
    TEXTURE0: 33984,
    ACTIVE_TEXTURE: 34016,
    REPEAT: 10497,
    CLAMP_TO_EDGE: 33071,
    MIRRORED_REPEAT: 33648,
    TEXTURE_WIDTH: 4096,
    TEXTURE_HEIGHT: 4097,
    FLOAT_VEC2: 35664,
    FLOAT_VEC3: 35665,
    FLOAT_VEC4: 35666,
    INT_VEC2: 35667,
    INT_VEC3: 35668,
    INT_VEC4: 35669,
    BOOL: 35670,
    BOOL_VEC2: 35671,
    BOOL_VEC3: 35672,
    BOOL_VEC4: 35673,
    FLOAT_MAT2: 35674,
    FLOAT_MAT3: 35675,
    FLOAT_MAT4: 35676,
    SAMPLER_2D: 35678,
    SAMPLER_CUBE: 35680,
    LOW_FLOAT: 36336,
    MEDIUM_FLOAT: 36337,
    HIGH_FLOAT: 36338,
    LOW_INT: 36339,
    MEDIUM_INT: 36340,
    HIGH_INT: 36341,
    FRAMEBUFFER: 36160,
    RENDERBUFFER: 36161,
    RGBA4: 32854,
    RGB5_A1: 32855,
    RGB565: 36194,
    DEPTH_COMPONENT16: 33189,
    STENCIL_INDEX: 6401,
    STENCIL_INDEX8: 36168,
    DEPTH_STENCIL: 34041,
    RENDERBUFFER_WIDTH: 36162,
    RENDERBUFFER_HEIGHT: 36163,
    RENDERBUFFER_INTERNAL_FORMAT: 36164,
    RENDERBUFFER_RED_SIZE: 36176,
    RENDERBUFFER_GREEN_SIZE: 36177,
    RENDERBUFFER_BLUE_SIZE: 36178,
    RENDERBUFFER_ALPHA_SIZE: 36179,
    RENDERBUFFER_DEPTH_SIZE: 36180,
    RENDERBUFFER_STENCIL_SIZE: 36181,
    FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
    FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
    COLOR_ATTACHMENT0: 36064,
    DEPTH_ATTACHMENT: 36096,
    STENCIL_ATTACHMENT: 36128,
    DEPTH_STENCIL_ATTACHMENT: 33306,
    NONE: 0,
    FRAMEBUFFER_COMPLETE: 36053,
    FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
    FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
    FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
    FRAMEBUFFER_UNSUPPORTED: 36061,
    FRAMEBUFFER_BINDING: 36006,
    RENDERBUFFER_BINDING: 36007,
    READ_FRAMEBUFFER: 36008,
    DRAW_FRAMEBUFFER: 36009,
    MAX_RENDERBUFFER_SIZE: 34024,
    INVALID_FRAMEBUFFER_OPERATION: 1286,
    UNPACK_FLIP_Y_WEBGL: 37440,
    UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
    UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
    READ_BUFFER: 3074,
    UNPACK_ROW_LENGTH: 3314,
    UNPACK_SKIP_ROWS: 3315,
    UNPACK_SKIP_PIXELS: 3316,
    PACK_ROW_LENGTH: 3330,
    PACK_SKIP_ROWS: 3331,
    PACK_SKIP_PIXELS: 3332,
    TEXTURE_BINDING_3D: 32874,
    UNPACK_SKIP_IMAGES: 32877,
    UNPACK_IMAGE_HEIGHT: 32878,
    MAX_3D_TEXTURE_SIZE: 32883,
    MAX_ELEMENTS_VERTICES: 33e3,
    MAX_ELEMENTS_INDICES: 33001,
    MAX_TEXTURE_LOD_BIAS: 34045,
    MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
    MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
    MAX_ARRAY_TEXTURE_LAYERS: 35071,
    MIN_PROGRAM_TEXEL_OFFSET: 35076,
    MAX_PROGRAM_TEXEL_OFFSET: 35077,
    MAX_VARYING_COMPONENTS: 35659,
    FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
    RASTERIZER_DISCARD: 35977,
    VERTEX_ARRAY_BINDING: 34229,
    MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
    MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
    MAX_SERVER_WAIT_TIMEOUT: 37137,
    MAX_ELEMENT_INDEX: 36203,
    RED: 6403,
    RGB8: 32849,
    RGBA8: 32856,
    RGB10_A2: 32857,
    TEXTURE_3D: 32879,
    TEXTURE_WRAP_R: 32882,
    TEXTURE_MIN_LOD: 33082,
    TEXTURE_MAX_LOD: 33083,
    TEXTURE_BASE_LEVEL: 33084,
    TEXTURE_MAX_LEVEL: 33085,
    TEXTURE_COMPARE_MODE: 34892,
    TEXTURE_COMPARE_FUNC: 34893,
    SRGB: 35904,
    SRGB8: 35905,
    SRGB8_ALPHA8: 35907,
    COMPARE_REF_TO_TEXTURE: 34894,
    RGBA32F: 34836,
    RGB32F: 34837,
    RGBA16F: 34842,
    RGB16F: 34843,
    TEXTURE_2D_ARRAY: 35866,
    TEXTURE_BINDING_2D_ARRAY: 35869,
    R11F_G11F_B10F: 35898,
    RGB9_E5: 35901,
    RGBA32UI: 36208,
    RGB32UI: 36209,
    RGBA16UI: 36214,
    RGB16UI: 36215,
    RGBA8UI: 36220,
    RGB8UI: 36221,
    RGBA32I: 36226,
    RGB32I: 36227,
    RGBA16I: 36232,
    RGB16I: 36233,
    RGBA8I: 36238,
    RGB8I: 36239,
    RED_INTEGER: 36244,
    RGB_INTEGER: 36248,
    RGBA_INTEGER: 36249,
    R8: 33321,
    RG8: 33323,
    R16F: 33325,
    R32F: 33326,
    RG16F: 33327,
    RG32F: 33328,
    R8I: 33329,
    R8UI: 33330,
    R16I: 33331,
    R16UI: 33332,
    R32I: 33333,
    R32UI: 33334,
    RG8I: 33335,
    RG8UI: 33336,
    RG16I: 33337,
    RG16UI: 33338,
    RG32I: 33339,
    RG32UI: 33340,
    R8_SNORM: 36756,
    RG8_SNORM: 36757,
    RGB8_SNORM: 36758,
    RGBA8_SNORM: 36759,
    RGB10_A2UI: 36975,
    TEXTURE_IMMUTABLE_FORMAT: 37167,
    TEXTURE_IMMUTABLE_LEVELS: 33503,
    UNSIGNED_INT_2_10_10_10_REV: 33640,
    UNSIGNED_INT_10F_11F_11F_REV: 35899,
    UNSIGNED_INT_5_9_9_9_REV: 35902,
    FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
    UNSIGNED_INT_24_8: 34042,
    HALF_FLOAT: 5131,
    RG: 33319,
    RG_INTEGER: 33320,
    INT_2_10_10_10_REV: 36255,
    CURRENT_QUERY: 34917,
    QUERY_RESULT: 34918,
    QUERY_RESULT_AVAILABLE: 34919,
    ANY_SAMPLES_PASSED: 35887,
    ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
    MAX_DRAW_BUFFERS: 34852,
    DRAW_BUFFER0: 34853,
    DRAW_BUFFER1: 34854,
    DRAW_BUFFER2: 34855,
    DRAW_BUFFER3: 34856,
    DRAW_BUFFER4: 34857,
    DRAW_BUFFER5: 34858,
    DRAW_BUFFER6: 34859,
    DRAW_BUFFER7: 34860,
    DRAW_BUFFER8: 34861,
    DRAW_BUFFER9: 34862,
    DRAW_BUFFER10: 34863,
    DRAW_BUFFER11: 34864,
    DRAW_BUFFER12: 34865,
    DRAW_BUFFER13: 34866,
    DRAW_BUFFER14: 34867,
    DRAW_BUFFER15: 34868,
    MAX_COLOR_ATTACHMENTS: 36063,
    COLOR_ATTACHMENT1: 36065,
    COLOR_ATTACHMENT2: 36066,
    COLOR_ATTACHMENT3: 36067,
    COLOR_ATTACHMENT4: 36068,
    COLOR_ATTACHMENT5: 36069,
    COLOR_ATTACHMENT6: 36070,
    COLOR_ATTACHMENT7: 36071,
    COLOR_ATTACHMENT8: 36072,
    COLOR_ATTACHMENT9: 36073,
    COLOR_ATTACHMENT10: 36074,
    COLOR_ATTACHMENT11: 36075,
    COLOR_ATTACHMENT12: 36076,
    COLOR_ATTACHMENT13: 36077,
    COLOR_ATTACHMENT14: 36078,
    COLOR_ATTACHMENT15: 36079,
    SAMPLER_3D: 35679,
    SAMPLER_2D_SHADOW: 35682,
    SAMPLER_2D_ARRAY: 36289,
    SAMPLER_2D_ARRAY_SHADOW: 36292,
    SAMPLER_CUBE_SHADOW: 36293,
    INT_SAMPLER_2D: 36298,
    INT_SAMPLER_3D: 36299,
    INT_SAMPLER_CUBE: 36300,
    INT_SAMPLER_2D_ARRAY: 36303,
    UNSIGNED_INT_SAMPLER_2D: 36306,
    UNSIGNED_INT_SAMPLER_3D: 36307,
    UNSIGNED_INT_SAMPLER_CUBE: 36308,
    UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
    MAX_SAMPLES: 36183,
    SAMPLER_BINDING: 35097,
    PIXEL_PACK_BUFFER: 35051,
    PIXEL_UNPACK_BUFFER: 35052,
    PIXEL_PACK_BUFFER_BINDING: 35053,
    PIXEL_UNPACK_BUFFER_BINDING: 35055,
    COPY_READ_BUFFER: 36662,
    COPY_WRITE_BUFFER: 36663,
    COPY_READ_BUFFER_BINDING: 36662,
    COPY_WRITE_BUFFER_BINDING: 36663,
    FLOAT_MAT2x3: 35685,
    FLOAT_MAT2x4: 35686,
    FLOAT_MAT3x2: 35687,
    FLOAT_MAT3x4: 35688,
    FLOAT_MAT4x2: 35689,
    FLOAT_MAT4x3: 35690,
    UNSIGNED_INT_VEC2: 36294,
    UNSIGNED_INT_VEC3: 36295,
    UNSIGNED_INT_VEC4: 36296,
    UNSIGNED_NORMALIZED: 35863,
    SIGNED_NORMALIZED: 36764,
    VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
    VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
    TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
    TRANSFORM_FEEDBACK_VARYINGS: 35971,
    TRANSFORM_FEEDBACK_BUFFER_START: 35972,
    TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
    TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
    MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
    INTERLEAVED_ATTRIBS: 35980,
    SEPARATE_ATTRIBS: 35981,
    TRANSFORM_FEEDBACK_BUFFER: 35982,
    TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
    TRANSFORM_FEEDBACK: 36386,
    TRANSFORM_FEEDBACK_PAUSED: 36387,
    TRANSFORM_FEEDBACK_ACTIVE: 36388,
    TRANSFORM_FEEDBACK_BINDING: 36389,
    FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
    FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
    FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
    FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
    FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
    FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
    FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
    FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
    FRAMEBUFFER_DEFAULT: 33304,
    DEPTH24_STENCIL8: 35056,
    DRAW_FRAMEBUFFER_BINDING: 36006,
    READ_FRAMEBUFFER_BINDING: 36010,
    RENDERBUFFER_SAMPLES: 36011,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
    FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
    UNIFORM_BUFFER: 35345,
    UNIFORM_BUFFER_BINDING: 35368,
    UNIFORM_BUFFER_START: 35369,
    UNIFORM_BUFFER_SIZE: 35370,
    MAX_VERTEX_UNIFORM_BLOCKS: 35371,
    MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
    MAX_COMBINED_UNIFORM_BLOCKS: 35374,
    MAX_UNIFORM_BUFFER_BINDINGS: 35375,
    MAX_UNIFORM_BLOCK_SIZE: 35376,
    MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
    MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
    UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
    ACTIVE_UNIFORM_BLOCKS: 35382,
    UNIFORM_TYPE: 35383,
    UNIFORM_SIZE: 35384,
    UNIFORM_BLOCK_INDEX: 35386,
    UNIFORM_OFFSET: 35387,
    UNIFORM_ARRAY_STRIDE: 35388,
    UNIFORM_MATRIX_STRIDE: 35389,
    UNIFORM_IS_ROW_MAJOR: 35390,
    UNIFORM_BLOCK_BINDING: 35391,
    UNIFORM_BLOCK_DATA_SIZE: 35392,
    UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
    UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
    UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
    UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
    OBJECT_TYPE: 37138,
    SYNC_CONDITION: 37139,
    SYNC_STATUS: 37140,
    SYNC_FLAGS: 37141,
    SYNC_FENCE: 37142,
    SYNC_GPU_COMMANDS_COMPLETE: 37143,
    UNSIGNALED: 37144,
    SIGNALED: 37145,
    ALREADY_SIGNALED: 37146,
    TIMEOUT_EXPIRED: 37147,
    CONDITION_SATISFIED: 37148,
    WAIT_FAILED: 37149,
    SYNC_FLUSH_COMMANDS_BIT: 1,
    COLOR: 6144,
    DEPTH: 6145,
    STENCIL: 6146,
    MIN: 32775,
    MAX: 32776,
    DEPTH_COMPONENT24: 33190,
    STREAM_READ: 35041,
    STREAM_COPY: 35042,
    STATIC_READ: 35045,
    STATIC_COPY: 35046,
    DYNAMIC_READ: 35049,
    DYNAMIC_COPY: 35050,
    DEPTH_COMPONENT32F: 36012,
    DEPTH32F_STENCIL8: 36013,
    INVALID_INDEX: 4294967295,
    TIMEOUT_IGNORED: -1,
    MAX_CLIENT_WAIT_TIMEOUT_WEBGL: 37447,
    VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 35070,
    UNMASKED_VENDOR_WEBGL: 37445,
    UNMASKED_RENDERER_WEBGL: 37446,
    MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047,
    TEXTURE_MAX_ANISOTROPY_EXT: 34046,
    COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
    COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
    COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
    COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
    COMPRESSED_R11_EAC: 37488,
    COMPRESSED_SIGNED_R11_EAC: 37489,
    COMPRESSED_RG11_EAC: 37490,
    COMPRESSED_SIGNED_RG11_EAC: 37491,
    COMPRESSED_RGB8_ETC2: 37492,
    COMPRESSED_RGBA8_ETC2_EAC: 37493,
    COMPRESSED_SRGB8_ETC2: 37494,
    COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37495,
    COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37496,
    COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37497,
    COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
    COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
    COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
    COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
    COMPRESSED_RGB_ETC1_WEBGL: 36196,
    COMPRESSED_RGB_ATC_WEBGL: 35986,
    COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL: 35986,
    COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL: 34798,
    UNSIGNED_INT_24_8_WEBGL: 34042,
    HALF_FLOAT_OES: 36193,
    RGBA32F_EXT: 34836,
    RGB32F_EXT: 34837,
    FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 33297,
    UNSIGNED_NORMALIZED_EXT: 35863,
    MIN_EXT: 32775,
    MAX_EXT: 32776,
    SRGB_EXT: 35904,
    SRGB_ALPHA_EXT: 35906,
    SRGB8_ALPHA8_EXT: 35907,
    FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 33296,
    FRAGMENT_SHADER_DERIVATIVE_HINT_OES: 35723,
    COLOR_ATTACHMENT0_WEBGL: 36064,
    COLOR_ATTACHMENT1_WEBGL: 36065,
    COLOR_ATTACHMENT2_WEBGL: 36066,
    COLOR_ATTACHMENT3_WEBGL: 36067,
    COLOR_ATTACHMENT4_WEBGL: 36068,
    COLOR_ATTACHMENT5_WEBGL: 36069,
    COLOR_ATTACHMENT6_WEBGL: 36070,
    COLOR_ATTACHMENT7_WEBGL: 36071,
    COLOR_ATTACHMENT8_WEBGL: 36072,
    COLOR_ATTACHMENT9_WEBGL: 36073,
    COLOR_ATTACHMENT10_WEBGL: 36074,
    COLOR_ATTACHMENT11_WEBGL: 36075,
    COLOR_ATTACHMENT12_WEBGL: 36076,
    COLOR_ATTACHMENT13_WEBGL: 36077,
    COLOR_ATTACHMENT14_WEBGL: 36078,
    COLOR_ATTACHMENT15_WEBGL: 36079,
    DRAW_BUFFER0_WEBGL: 34853,
    DRAW_BUFFER1_WEBGL: 34854,
    DRAW_BUFFER2_WEBGL: 34855,
    DRAW_BUFFER3_WEBGL: 34856,
    DRAW_BUFFER4_WEBGL: 34857,
    DRAW_BUFFER5_WEBGL: 34858,
    DRAW_BUFFER6_WEBGL: 34859,
    DRAW_BUFFER7_WEBGL: 34860,
    DRAW_BUFFER8_WEBGL: 34861,
    DRAW_BUFFER9_WEBGL: 34862,
    DRAW_BUFFER10_WEBGL: 34863,
    DRAW_BUFFER11_WEBGL: 34864,
    DRAW_BUFFER12_WEBGL: 34865,
    DRAW_BUFFER13_WEBGL: 34866,
    DRAW_BUFFER14_WEBGL: 34867,
    DRAW_BUFFER15_WEBGL: 34868,
    MAX_COLOR_ATTACHMENTS_WEBGL: 36063,
    MAX_DRAW_BUFFERS_WEBGL: 34852,
    VERTEX_ARRAY_BINDING_OES: 34229,
    QUERY_COUNTER_BITS_EXT: 34916,
    CURRENT_QUERY_EXT: 34917,
    QUERY_RESULT_EXT: 34918,
    QUERY_RESULT_AVAILABLE_EXT: 34919,
    TIME_ELAPSED_EXT: 35007,
    TIMESTAMP_EXT: 36392,
    GPU_DISJOINT_EXT: 36795
  };

  // src/utils/gpu-grid-aggregation/gpu-grid-aggregator.js
  var import_core2 = __toESM(require_core2());

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64-utils.js
  function fp64ify(a) {
    let out = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : [];
    let startIndex = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 0;
    const hiPart = Math.fround(a);
    const loPart = a - hiPart;
    out[startIndex] = hiPart;
    out[startIndex + 1] = loPart;
    return out;
  }
  function fp64LowPart(a) {
    return a - Math.fround(a);
  }
  function fp64ifyMatrix4(matrix) {
    const matrixFP64 = new Float32Array(32);
    for (let i = 0; i < 4; ++i) {
      for (let j = 0; j < 4; ++j) {
        const index = i * 4 + j;
        fp64ify(matrix[j * 4 + i], matrixFP64, index * 2);
      }
    }
    return matrixFP64;
  }

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64-arithmetic.glsl.js
  var fp64_arithmetic_glsl_default = "uniform float ONE;\nvec2 split(float a) {\n  const float SPLIT = 4097.0;\n  float t = a * SPLIT;\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float a_hi = t * ONE - (t - a);\n  float a_lo = a * ONE - a_hi;\n#else\n  float a_hi = t - (t - a);\n  float a_lo = a - a_hi;\n#endif\n  return vec2(a_hi, a_lo);\n}\nvec2 split2(vec2 a) {\n  vec2 b = split(a.x);\n  b.y += a.y;\n  return b;\n}\nvec2 quickTwoSum(float a, float b) {\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float sum = (a + b) * ONE;\n  float err = b - (sum - a) * ONE;\n#else\n  float sum = a + b;\n  float err = b - (sum - a);\n#endif\n  return vec2(sum, err);\n}\nvec2 twoSum(float a, float b) {\n  float s = (a + b);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float v = (s * ONE - a) * ONE;\n  float err = (a - (s - v) * ONE) * ONE * ONE * ONE + (b - v);\n#else\n  float v = s - a;\n  float err = (a - (s - v)) + (b - v);\n#endif\n  return vec2(s, err);\n}\n\nvec2 twoSub(float a, float b) {\n  float s = (a - b);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float v = (s * ONE - a) * ONE;\n  float err = (a - (s - v) * ONE) * ONE * ONE * ONE - (b + v);\n#else\n  float v = s - a;\n  float err = (a - (s - v)) - (b + v);\n#endif\n  return vec2(s, err);\n}\n\nvec2 twoSqr(float a) {\n  float prod = a * a;\n  vec2 a_fp64 = split(a);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float err = ((a_fp64.x * a_fp64.x - prod) * ONE + 2.0 * a_fp64.x *\n    a_fp64.y * ONE * ONE) + a_fp64.y * a_fp64.y * ONE * ONE * ONE;\n#else\n  float err = ((a_fp64.x * a_fp64.x - prod) + 2.0 * a_fp64.x * a_fp64.y) + a_fp64.y * a_fp64.y;\n#endif\n  return vec2(prod, err);\n}\n\nvec2 twoProd(float a, float b) {\n  float prod = a * b;\n  vec2 a_fp64 = split(a);\n  vec2 b_fp64 = split(b);\n  float err = ((a_fp64.x * b_fp64.x - prod) + a_fp64.x * b_fp64.y +\n    a_fp64.y * b_fp64.x) + a_fp64.y * b_fp64.y;\n  return vec2(prod, err);\n}\n\nvec2 sum_fp64(vec2 a, vec2 b) {\n  vec2 s, t;\n  s = twoSum(a.x, b.x);\n  t = twoSum(a.y, b.y);\n  s.y += t.x;\n  s = quickTwoSum(s.x, s.y);\n  s.y += t.y;\n  s = quickTwoSum(s.x, s.y);\n  return s;\n}\n\nvec2 sub_fp64(vec2 a, vec2 b) {\n  vec2 s, t;\n  s = twoSub(a.x, b.x);\n  t = twoSub(a.y, b.y);\n  s.y += t.x;\n  s = quickTwoSum(s.x, s.y);\n  s.y += t.y;\n  s = quickTwoSum(s.x, s.y);\n  return s;\n}\n\nvec2 mul_fp64(vec2 a, vec2 b) {\n  vec2 prod = twoProd(a.x, b.x);\n  prod.y += a.x * b.y;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  prod = split2(prod);\n#endif\n  prod = quickTwoSum(prod.x, prod.y);\n  prod.y += a.y * b.x;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  prod = split2(prod);\n#endif\n  prod = quickTwoSum(prod.x, prod.y);\n  return prod;\n}\n\nvec2 div_fp64(vec2 a, vec2 b) {\n  float xn = 1.0 / b.x;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  vec2 yn = mul_fp64(a, vec2(xn, 0));\n#else\n  vec2 yn = a * xn;\n#endif\n  float diff = (sub_fp64(a, mul_fp64(b, yn))).x;\n  vec2 prod = twoProd(xn, diff);\n  return sum_fp64(yn, prod);\n}\n\nvec2 sqrt_fp64(vec2 a) {\n  if (a.x == 0.0 && a.y == 0.0) return vec2(0.0, 0.0);\n  if (a.x < 0.0) return vec2(0.0 / 0.0, 0.0 / 0.0);\n\n  float x = 1.0 / sqrt(a.x);\n  float yn = a.x * x;\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  vec2 yn_sqr = twoSqr(yn) * ONE;\n#else\n  vec2 yn_sqr = twoSqr(yn);\n#endif\n  float diff = sub_fp64(a, yn_sqr).x;\n  vec2 prod = twoProd(x * 0.5, diff);\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  return sum_fp64(split(yn), prod);\n#else\n  return sum_fp64(vec2(yn, 0.0), prod);\n#endif\n}\n";

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64.js
  var CONST_UNIFORMS = {
    ONE: 1
  };
  function getUniforms() {
    return CONST_UNIFORMS;
  }
  var fp64arithmetic = {
    name: "fp64-arithmetic",
    vs: fp64_arithmetic_glsl_default,
    fs: null,
    getUniforms,
    fp64ify,
    fp64LowPart,
    fp64ifyMatrix4
  };

  // src/utils/gpu-grid-aggregation/gpu-grid-aggregator.js
  var import_core3 = __toESM(require_core());

  // src/utils/aggregation-operation-utils.js
  var AGGREGATION_OPERATION = {
    SUM: 1,
    MEAN: 2,
    MIN: 3,
    MAX: 4
  };
  function sumReducer(accu, cur) {
    return accu + cur;
  }
  function maxReducer(accu, cur) {
    return cur > accu ? cur : accu;
  }
  function minReducer(accu, cur) {
    return cur < accu ? cur : accu;
  }
  function getMean(pts, accessor) {
    if (Number.isFinite(accessor)) {
      return pts.length ? accessor : null;
    }
    const filtered = pts.map(accessor).filter(Number.isFinite);
    return filtered.length ? filtered.reduce(sumReducer, 0) / filtered.length : null;
  }
  function getSum(pts, accessor) {
    if (Number.isFinite(accessor)) {
      return pts.length ? pts.length * accessor : null;
    }
    const filtered = pts.map(accessor).filter(Number.isFinite);
    return filtered.length ? filtered.reduce(sumReducer, 0) : null;
  }
  function getMax(pts, accessor) {
    if (Number.isFinite(accessor)) {
      return pts.length ? accessor : null;
    }
    const filtered = pts.map(accessor).filter(Number.isFinite);
    return filtered.length ? filtered.reduce(maxReducer, -Infinity) : null;
  }
  function getMin(pts, accessor) {
    if (Number.isFinite(accessor)) {
      return pts.length ? accessor : null;
    }
    const filtered = pts.map(accessor).filter(Number.isFinite);
    return filtered.length ? filtered.reduce(minReducer, Infinity) : null;
  }
  function getValueFunc(aggregation, accessor, context) {
    const op = AGGREGATION_OPERATION[aggregation] || AGGREGATION_OPERATION.SUM;
    accessor = wrapAccessor(accessor, context);
    switch (op) {
      case AGGREGATION_OPERATION.MIN:
        return (pts) => getMin(pts, accessor);
      case AGGREGATION_OPERATION.SUM:
        return (pts) => getSum(pts, accessor);
      case AGGREGATION_OPERATION.MEAN:
        return (pts) => getMean(pts, accessor);
      case AGGREGATION_OPERATION.MAX:
        return (pts) => getMax(pts, accessor);
      default:
        return null;
    }
  }
  function wrapAccessor(accessor, context = {}) {
    if (Number.isFinite(accessor)) {
      return accessor;
    }
    return (pt) => {
      context.index = pt.index;
      return accessor(pt.source, context);
    };
  }
  function wrapGetValueFunc(getValue, context = {}) {
    return (pts) => {
      context.indices = pts.map((pt) => pt.index);
      return getValue(pts.map((pt) => pt.source), context);
    };
  }

  // src/utils/gpu-grid-aggregation/gpu-grid-aggregator-constants.js
  var DEFAULT_RUN_PARAMS = {
    projectPoints: false,
    viewport: null,
    createBufferObjects: true,
    moduleSettings: {}
  };
  var MAX_32_BIT_FLOAT = 3402823466e29;
  var MIN_BLEND_EQUATION = [esm_default.MIN, esm_default.FUNC_ADD];
  var MAX_BLEND_EQUATION = [esm_default.MAX, esm_default.FUNC_ADD];
  var MAX_MIN_BLEND_EQUATION = [esm_default.MAX, esm_default.MIN];
  var EQUATION_MAP = {
    [AGGREGATION_OPERATION.SUM]: esm_default.FUNC_ADD,
    [AGGREGATION_OPERATION.MEAN]: esm_default.FUNC_ADD,
    [AGGREGATION_OPERATION.MIN]: MIN_BLEND_EQUATION,
    [AGGREGATION_OPERATION.MAX]: MAX_BLEND_EQUATION
  };
  var DEFAULT_WEIGHT_PARAMS = {
    size: 1,
    operation: AGGREGATION_OPERATION.SUM,
    needMin: false,
    needMax: false,
    combineMaxMin: false
  };
  var PIXEL_SIZE = 4;
  var MAX_MIN_TEXTURE_OPTS = {
    format: esm_default.RGBA32F,
    type: esm_default.FLOAT,
    border: 0,
    mipmaps: false,
    parameters: {
      [esm_default.TEXTURE_MAG_FILTER]: esm_default.NEAREST,
      [esm_default.TEXTURE_MIN_FILTER]: esm_default.NEAREST
    },
    dataFormat: esm_default.RGBA,
    width: 1,
    height: 1
  };

  // src/utils/gpu-grid-aggregation/aggregate-to-grid-vs.glsl.js
  var aggregate_to_grid_vs_glsl_default = `#define SHADER_NAME gpu-aggregation-to-grid-vs

attribute vec3 positions;
attribute vec3 positions64Low;
attribute vec3 weights;
uniform vec2 cellSize;
uniform vec2 gridSize;
uniform bool projectPoints;
uniform vec2 translation;
uniform vec3 scaling;

varying vec3 vWeights;

vec2 project_to_pixel(vec4 pos) {
  vec4 result;
  pos.xy = pos.xy/pos.w;
  result = pos + vec4(translation, 0., 0.);
  result.xy = scaling.z > 0. ? result.xy * scaling.xy : result.xy;
  return result.xy;
}

void main(void) {

  vWeights = weights;

  vec4 windowPos = vec4(positions, 1.);
  if (projectPoints) {
    windowPos = project_position_to_clipspace(positions, positions64Low, vec3(0));
  }

  vec2 pos = project_to_pixel(windowPos);

  vec2 pixelXY64[2];
  pixelXY64[0] = vec2(pos.x, 0.);
  pixelXY64[1] = vec2(pos.y, 0.);

  // Transform (0,0):windowSize -> (0, 0): gridSize
  vec2 gridXY64[2];
  gridXY64[0] = div_fp64(pixelXY64[0], vec2(cellSize.x, 0));
  gridXY64[1] = div_fp64(pixelXY64[1], vec2(cellSize.y, 0));
  float x = floor(gridXY64[0].x);
  float y = floor(gridXY64[1].x);
  pos = vec2(x, y);

  // Transform (0,0):gridSize -> (-1, -1):(1,1)
  pos = (pos * (2., 2.) / (gridSize)) - (1., 1.);

  // Move to pixel center, pixel-size in screen sapce (2/gridSize) * 0.5 => 1/gridSize
  vec2 offset = 1.0 / gridSize;
  pos = pos + offset;

  gl_Position = vec4(pos, 0.0, 1.0);

  // Enforce default value for ANGLE issue (https://bugs.chromium.org/p/angleproject/issues/detail?id=3941)
  gl_PointSize = 1.0;
}
`;

  // src/utils/gpu-grid-aggregation/aggregate-to-grid-fs.glsl.js
  var aggregate_to_grid_fs_glsl_default = `#define SHADER_NAME gpu-aggregation-to-grid-fs

precision highp float;

varying vec3 vWeights;

void main(void) {
  gl_FragColor = vec4(vWeights, 1.0);
  DECKGL_FILTER_COLOR(gl_FragColor, geometry);
}
`;

  // src/utils/gpu-grid-aggregation/aggregate-all-vs.glsl.js
  var aggregate_all_vs_glsl_default = `#version 300 es
#define SHADER_NAME gpu-aggregation-all-vs-64

in vec2 position;
uniform ivec2 gridSize;
out vec2 vTextureCoord;

void main(void) {
  // Map each position to single pixel
  vec2 pos = vec2(-1.0, -1.0);

  // Move to pixel center, pixel-size in screen sapce (2/gridSize) * 0.5 => 1/gridSize
  vec2 offset = 1.0 / vec2(gridSize);
  pos = pos + offset;

  gl_Position = vec4(pos, 0.0, 1.0);

  int yIndex = gl_InstanceID / gridSize[0];
  int xIndex = gl_InstanceID - (yIndex * gridSize[0]);

  vec2 yIndexFP64 = vec2(float(yIndex), 0.);
  vec2 xIndexFP64 = vec2(float(xIndex), 0.);
  vec2 gridSizeYFP64 = vec2(gridSize[1], 0.);
  vec2 gridSizeXFP64 = vec2(gridSize[0], 0.);

  vec2 texCoordXFP64 = div_fp64(yIndexFP64, gridSizeYFP64);
  vec2 texCoordYFP64 = div_fp64(xIndexFP64, gridSizeXFP64);

  vTextureCoord = vec2(texCoordYFP64.x, texCoordXFP64.x);
  // Enforce default value for ANGLE issue (https://bugs.chromium.org/p/angleproject/issues/detail?id=3941)
  gl_PointSize = 1.0;
}
`;

  // src/utils/gpu-grid-aggregation/aggregate-all-fs.glsl.js
  var aggregate_all_fs_glsl_default = `#version 300 es
#define SHADER_NAME gpu-aggregation-all-fs

precision highp float;

in vec2 vTextureCoord;
uniform sampler2D uSampler;
uniform bool combineMaxMin;
out vec4 fragColor;
void main(void) {
  vec4 textureColor = texture(uSampler, vec2(vTextureCoord.s, vTextureCoord.t));
  if (textureColor.a == 0.) {
    discard;
  }
  fragColor.rgb = textureColor.rgb;
  // if combineMinMax is true, use Alpha channel for first weights min value.
  fragColor.a = combineMaxMin ? textureColor.r : textureColor.a;
}
`;

  // src/utils/gpu-grid-aggregation/transform-mean-vs.glsl.js
  var transform_mean_vs_glsl_default = `#define SHADER_NAME gpu-aggregation-transform-mean-vs
attribute vec4 aggregationValues;
varying vec4 meanValues;

void main()
{
  // TODO: Use 64-bit division ?? not needed given this is aggregation ??
  bool isCellValid = bool(aggregationValues.w > 0.);
  // aggregationValues:  XYZ contain aggregated values, W contains count
  meanValues.xyz = isCellValid ? aggregationValues.xyz/aggregationValues.w : vec3(0, 0, 0);
  meanValues.w = aggregationValues.w;

  // Enforce default value for ANGLE issue (https://bugs.chromium.org/p/angleproject/issues/detail?id=3941)
  gl_PointSize = 1.0;
}
`;

  // src/utils/resource-utils.js
  var import_core = __toESM(require_core2());
  var DEFAULT_PARAMETERS = {
    [esm_default.TEXTURE_MAG_FILTER]: esm_default.NEAREST,
    [esm_default.TEXTURE_MIN_FILTER]: esm_default.NEAREST
  };
  function getFloatTexture(gl, opts = {}) {
    const {
      width = 1,
      height = 1,
      data = null,
      unpackFlipY = true,
      parameters = DEFAULT_PARAMETERS
    } = opts;
    const texture = new import_core.Texture2D(gl, {
      data,
      format: (0, import_core.isWebGL2)(gl) ? esm_default.RGBA32F : esm_default.RGBA,
      type: esm_default.FLOAT,
      border: 0,
      mipmaps: false,
      parameters,
      dataFormat: esm_default.RGBA,
      width,
      height,
      unpackFlipY
    });
    return texture;
  }
  function getFramebuffer(gl, opts) {
    const {
      id,
      width = 1,
      height = 1,
      texture
    } = opts;
    const fb = new import_core.Framebuffer(gl, {
      id,
      width,
      height,
      attachments: {
        [esm_default.COLOR_ATTACHMENT0]: texture
      }
    });
    return fb;
  }

  // src/utils/gpu-grid-aggregation/gpu-grid-aggregator.js
  var BUFFER_NAMES = ["aggregationBuffer", "maxMinBuffer", "minBuffer", "maxBuffer"];
  var ARRAY_BUFFER_MAP = {
    maxData: "maxBuffer",
    minData: "minBuffer",
    maxMinData: "maxMinBuffer"
  };
  var REQUIRED_FEATURES = [
    import_core2.FEATURES.WEBGL2,
    import_core2.FEATURES.COLOR_ATTACHMENT_RGBA32F,
    import_core2.FEATURES.BLEND_EQUATION_MINMAX,
    import_core2.FEATURES.FLOAT_BLEND,
    import_core2.FEATURES.TEXTURE_FLOAT
  ];
  var GPUGridAggregator = class {
    static getAggregationData({
      aggregationData,
      maxData,
      minData,
      maxMinData,
      pixelIndex
    }) {
      const index = pixelIndex * PIXEL_SIZE;
      const results = {};
      if (aggregationData) {
        results.cellCount = aggregationData[index + 3];
        results.cellWeight = aggregationData[index];
      }
      if (maxMinData) {
        results.maxCellWieght = maxMinData[0];
        results.minCellWeight = maxMinData[3];
      } else {
        if (maxData) {
          results.maxCellWieght = maxData[0];
          results.totalCount = maxData[3];
        }
        if (minData) {
          results.minCellWeight = minData[0];
          results.totalCount = maxData[3];
        }
      }
      return results;
    }
    static getCellData({
      countsData,
      size = 1
    }) {
      const numCells = countsData.length / 4;
      const cellWeights = new Float32Array(numCells * size);
      const cellCounts = new Uint32Array(numCells);
      for (let i = 0; i < numCells; i++) {
        for (let sizeIndex = 0; sizeIndex < size; sizeIndex++) {
          cellWeights[i * size + sizeIndex] = countsData[i * 4 + sizeIndex];
        }
        cellCounts[i] = countsData[i * 4 + 3];
      }
      return {
        cellCounts,
        cellWeights
      };
    }
    static isSupported(gl) {
      return (0, import_core2.hasFeatures)(gl, REQUIRED_FEATURES);
    }
    constructor(gl, opts = {}) {
      this.id = opts.id || "gpu-grid-aggregator";
      this.gl = gl;
      this.state = {
        weightAttributes: {},
        textures: {},
        meanTextures: {},
        buffers: {},
        framebuffers: {},
        maxMinFramebuffers: {},
        minFramebuffers: {},
        maxFramebuffers: {},
        equations: {},
        resources: {},
        results: {}
      };
      this._hasGPUSupport = (0, import_core2.isWebGL2)(gl) && (0, import_core2.hasFeatures)(
        this.gl,
        import_core2.FEATURES.BLEND_EQUATION_MINMAX,
        import_core2.FEATURES.COLOR_ATTACHMENT_RGBA32F,
        import_core2.FEATURES.TEXTURE_FLOAT
      );
      if (this._hasGPUSupport) {
        this._setupModels();
      }
    }
    delete() {
      const {
        gridAggregationModel,
        allAggregationModel,
        meanTransform
      } = this;
      const {
        textures,
        framebuffers,
        maxMinFramebuffers,
        minFramebuffers,
        maxFramebuffers,
        meanTextures,
        resources
      } = this.state;
      gridAggregationModel?.delete();
      allAggregationModel?.delete();
      meanTransform?.delete();
      deleteResources([framebuffers, textures, maxMinFramebuffers, minFramebuffers, maxFramebuffers, meanTextures, resources]);
    }
    run(opts = {}) {
      this.setState({
        results: {}
      });
      const aggregationParams = this._normalizeAggregationParams(opts);
      if (!this._hasGPUSupport) {
        import_core3.log.log(1, "GPUGridAggregator: not supported")();
      }
      return this._runAggregation(aggregationParams);
    }
    getData(weightId) {
      const data = {};
      const results = this.state.results;
      if (!results[weightId].aggregationData) {
        results[weightId].aggregationData = results[weightId].aggregationBuffer.getData();
      }
      data.aggregationData = results[weightId].aggregationData;
      for (const arrayName in ARRAY_BUFFER_MAP) {
        const bufferName = ARRAY_BUFFER_MAP[arrayName];
        if (results[weightId][arrayName] || results[weightId][bufferName]) {
          results[weightId][arrayName] = results[weightId][arrayName] || results[weightId][bufferName].getData();
          data[arrayName] = results[weightId][arrayName];
        }
      }
      return data;
    }
    updateShaders(shaderOptions = {}) {
      this.setState({
        shaderOptions,
        modelDirty: true
      });
    }
    _normalizeAggregationParams(opts) {
      const aggregationParams = {
        ...DEFAULT_RUN_PARAMS,
        ...opts
      };
      const {
        weights
      } = aggregationParams;
      if (weights) {
        aggregationParams.weights = normalizeWeightParams(weights);
      }
      return aggregationParams;
    }
    setState(updateObject) {
      Object.assign(this.state, updateObject);
    }
    _getAggregateData(opts) {
      const results = {};
      const {
        textures,
        framebuffers,
        maxMinFramebuffers,
        minFramebuffers,
        maxFramebuffers,
        resources
      } = this.state;
      const {
        weights
      } = opts;
      for (const id in weights) {
        results[id] = {};
        const {
          needMin,
          needMax,
          combineMaxMin
        } = weights[id];
        results[id].aggregationTexture = textures[id];
        results[id].aggregationBuffer = (0, import_core2.readPixelsToBuffer)(framebuffers[id], {
          target: weights[id].aggregationBuffer,
          sourceType: esm_default.FLOAT
        });
        if (needMin && needMax && combineMaxMin) {
          results[id].maxMinBuffer = (0, import_core2.readPixelsToBuffer)(maxMinFramebuffers[id], {
            target: weights[id].maxMinBuffer,
            sourceType: esm_default.FLOAT
          });
          results[id].maxMinTexture = resources[`${id}-maxMinTexture`];
        } else {
          if (needMin) {
            results[id].minBuffer = (0, import_core2.readPixelsToBuffer)(minFramebuffers[id], {
              target: weights[id].minBuffer,
              sourceType: esm_default.FLOAT
            });
            results[id].minTexture = resources[`${id}-minTexture`];
          }
          if (needMax) {
            results[id].maxBuffer = (0, import_core2.readPixelsToBuffer)(maxFramebuffers[id], {
              target: weights[id].maxBuffer,
              sourceType: esm_default.FLOAT
            });
            results[id].maxTexture = resources[`${id}-maxTexture`];
          }
        }
      }
      this._trackGPUResultBuffers(results, weights);
      return results;
    }
    _renderAggregateData(opts) {
      const {
        cellSize,
        projectPoints,
        attributes,
        moduleSettings,
        numCol,
        numRow,
        weights,
        translation,
        scaling
      } = opts;
      const {
        maxMinFramebuffers,
        minFramebuffers,
        maxFramebuffers
      } = this.state;
      const gridSize = [numCol, numRow];
      const parameters = {
        blend: true,
        depthTest: false,
        blendFunc: [esm_default.ONE, esm_default.ONE]
      };
      const uniforms = {
        cellSize,
        gridSize,
        projectPoints,
        translation,
        scaling
      };
      for (const id in weights) {
        const {
          needMin,
          needMax
        } = weights[id];
        const combineMaxMin = needMin && needMax && weights[id].combineMaxMin;
        this._renderToWeightsTexture({
          id,
          parameters,
          moduleSettings,
          uniforms,
          gridSize,
          attributes,
          weights
        });
        if (combineMaxMin) {
          this._renderToMaxMinTexture({
            id,
            parameters: {
              ...parameters,
              blendEquation: MAX_MIN_BLEND_EQUATION
            },
            gridSize,
            minOrMaxFb: maxMinFramebuffers[id],
            clearParams: {
              clearColor: [0, 0, 0, MAX_32_BIT_FLOAT]
            },
            combineMaxMin
          });
        } else {
          if (needMin) {
            this._renderToMaxMinTexture({
              id,
              parameters: {
                ...parameters,
                blendEquation: MIN_BLEND_EQUATION
              },
              gridSize,
              minOrMaxFb: minFramebuffers[id],
              clearParams: {
                clearColor: [MAX_32_BIT_FLOAT, MAX_32_BIT_FLOAT, MAX_32_BIT_FLOAT, 0]
              },
              combineMaxMin
            });
          }
          if (needMax) {
            this._renderToMaxMinTexture({
              id,
              parameters: {
                ...parameters,
                blendEquation: MAX_BLEND_EQUATION
              },
              gridSize,
              minOrMaxFb: maxFramebuffers[id],
              clearParams: {
                clearColor: [0, 0, 0, 0]
              },
              combineMaxMin
            });
          }
        }
      }
    }
    _renderToMaxMinTexture(opts) {
      const {
        id,
        parameters,
        gridSize,
        minOrMaxFb,
        combineMaxMin,
        clearParams = {}
      } = opts;
      const {
        framebuffers
      } = this.state;
      const {
        gl,
        allAggregationModel
      } = this;
      (0, import_core2.withParameters)(gl, {
        ...clearParams,
        framebuffer: minOrMaxFb,
        viewport: [0, 0, gridSize[0], gridSize[1]]
      }, () => {
        gl.clear(gl.COLOR_BUFFER_BIT);
        allAggregationModel.draw({
          parameters,
          uniforms: {
            uSampler: framebuffers[id].texture,
            gridSize,
            combineMaxMin
          }
        });
      });
    }
    _renderToWeightsTexture(opts) {
      const {
        id,
        parameters,
        moduleSettings,
        uniforms,
        gridSize,
        weights
      } = opts;
      const {
        framebuffers,
        equations,
        weightAttributes
      } = this.state;
      const {
        gl,
        gridAggregationModel
      } = this;
      const {
        operation
      } = weights[id];
      const clearColor = operation === AGGREGATION_OPERATION.MIN ? [MAX_32_BIT_FLOAT, MAX_32_BIT_FLOAT, MAX_32_BIT_FLOAT, 0] : [0, 0, 0, 0];
      (0, import_core2.withParameters)(gl, {
        framebuffer: framebuffers[id],
        viewport: [0, 0, gridSize[0], gridSize[1]],
        clearColor
      }, () => {
        gl.clear(gl.COLOR_BUFFER_BIT);
        const attributes = {
          weights: weightAttributes[id]
        };
        gridAggregationModel.draw({
          parameters: {
            ...parameters,
            blendEquation: equations[id]
          },
          moduleSettings,
          uniforms,
          attributes
        });
      });
      if (operation === AGGREGATION_OPERATION.MEAN) {
        const {
          meanTextures,
          textures
        } = this.state;
        const transformOptions = {
          _sourceTextures: {
            aggregationValues: meanTextures[id]
          },
          _targetTexture: textures[id],
          elementCount: textures[id].width * textures[id].height
        };
        if (this.meanTransform) {
          this.meanTransform.update(transformOptions);
        } else {
          this.meanTransform = getMeanTransform(gl, transformOptions);
        }
        this.meanTransform.run({
          parameters: {
            blend: false,
            depthTest: false
          }
        });
        framebuffers[id].attach({
          [esm_default.COLOR_ATTACHMENT0]: textures[id]
        });
      }
    }
    _runAggregation(opts) {
      this._updateModels(opts);
      this._setupFramebuffers(opts);
      this._renderAggregateData(opts);
      const results = this._getAggregateData(opts);
      this.setState({
        results
      });
      return results;
    }
    _setupFramebuffers(opts) {
      const {
        textures,
        framebuffers,
        maxMinFramebuffers,
        minFramebuffers,
        maxFramebuffers,
        meanTextures,
        equations
      } = this.state;
      const {
        weights
      } = opts;
      const {
        numCol,
        numRow
      } = opts;
      const framebufferSize = {
        width: numCol,
        height: numRow
      };
      for (const id in weights) {
        const {
          needMin,
          needMax,
          combineMaxMin,
          operation
        } = weights[id];
        textures[id] = weights[id].aggregationTexture || textures[id] || getFloatTexture(this.gl, {
          id: `${id}-texture`,
          width: numCol,
          height: numRow
        });
        textures[id].resize(framebufferSize);
        let texture = textures[id];
        if (operation === AGGREGATION_OPERATION.MEAN) {
          meanTextures[id] = meanTextures[id] || getFloatTexture(this.gl, {
            id: `${id}-mean-texture`,
            width: numCol,
            height: numRow
          });
          meanTextures[id].resize(framebufferSize);
          texture = meanTextures[id];
        }
        if (framebuffers[id]) {
          framebuffers[id].attach({
            [esm_default.COLOR_ATTACHMENT0]: texture
          });
        } else {
          framebuffers[id] = getFramebuffer(this.gl, {
            id: `${id}-fb`,
            width: numCol,
            height: numRow,
            texture
          });
        }
        framebuffers[id].resize(framebufferSize);
        equations[id] = EQUATION_MAP[operation] || EQUATION_MAP.SUM;
        if (needMin || needMax) {
          if (needMin && needMax && combineMaxMin) {
            if (!maxMinFramebuffers[id]) {
              texture = weights[id].maxMinTexture || this._getMinMaxTexture(`${id}-maxMinTexture`);
              maxMinFramebuffers[id] = getFramebuffer(this.gl, {
                id: `${id}-maxMinFb`,
                texture
              });
            }
          } else {
            if (needMin) {
              if (!minFramebuffers[id]) {
                texture = weights[id].minTexture || this._getMinMaxTexture(`${id}-minTexture`);
                minFramebuffers[id] = getFramebuffer(this.gl, {
                  id: `${id}-minFb`,
                  texture
                });
              }
            }
            if (needMax) {
              if (!maxFramebuffers[id]) {
                texture = weights[id].maxTexture || this._getMinMaxTexture(`${id}-maxTexture`);
                maxFramebuffers[id] = getFramebuffer(this.gl, {
                  id: `${id}-maxFb`,
                  texture
                });
              }
            }
          }
        }
      }
    }
    _getMinMaxTexture(name) {
      const {
        resources
      } = this.state;
      if (!resources[name]) {
        resources[name] = getFloatTexture(this.gl, {
          id: `resourceName`
        });
      }
      return resources[name];
    }
    _setupModels({
      numCol = 0,
      numRow = 0
    } = {}) {
      const {
        gl
      } = this;
      const {
        shaderOptions
      } = this.state;
      this.gridAggregationModel?.delete();
      this.gridAggregationModel = getAggregationModel(gl, shaderOptions);
      if (!this.allAggregationModel) {
        const instanceCount = numCol * numRow;
        this.allAggregationModel = getAllAggregationModel(gl, instanceCount);
      }
    }
    _setupWeightAttributes(opts) {
      const {
        weightAttributes
      } = this.state;
      const {
        weights
      } = opts;
      for (const id in weights) {
        weightAttributes[id] = opts.attributes[id];
      }
    }
    _trackGPUResultBuffers(results, weights) {
      const {
        resources
      } = this.state;
      for (const id in results) {
        if (results[id]) {
          for (const bufferName of BUFFER_NAMES) {
            if (results[id][bufferName] && weights[id][bufferName] !== results[id][bufferName]) {
              const name = `gpu-result-${id}-${bufferName}`;
              if (resources[name]) {
                resources[name].delete();
              }
              resources[name] = results[id][bufferName];
            }
          }
        }
      }
    }
    _updateModels(opts) {
      const {
        vertexCount,
        attributes,
        numCol,
        numRow
      } = opts;
      const {
        modelDirty
      } = this.state;
      if (modelDirty) {
        this._setupModels(opts);
        this.setState({
          modelDirty: false
        });
      }
      this._setupWeightAttributes(opts);
      this.gridAggregationModel.setVertexCount(vertexCount);
      this.gridAggregationModel.setAttributes(attributes);
      this.allAggregationModel.setInstanceCount(numCol * numRow);
    }
  };
  function normalizeWeightParams(weights) {
    const result = {};
    for (const id in weights) {
      result[id] = {
        ...DEFAULT_WEIGHT_PARAMS,
        ...weights[id]
      };
    }
    return result;
  }
  function deleteResources(resources) {
    resources = Array.isArray(resources) ? resources : [resources];
    resources.forEach((obj) => {
      for (const name in obj) {
        obj[name].delete();
      }
    });
  }
  function getAggregationModel(gl, shaderOptions) {
    const shaders = (0, import_core3._mergeShaders)({
      vs: aggregate_to_grid_vs_glsl_default,
      fs: aggregate_to_grid_fs_glsl_default,
      modules: [fp64arithmetic, import_core3.project32]
    }, shaderOptions);
    return new import_core2.Model(gl, {
      id: "Gird-Aggregation-Model",
      vertexCount: 1,
      drawMode: esm_default.POINTS,
      ...shaders
    });
  }
  function getAllAggregationModel(gl, instanceCount) {
    return new import_core2.Model(gl, {
      id: "All-Aggregation-Model",
      vs: aggregate_all_vs_glsl_default,
      fs: aggregate_all_fs_glsl_default,
      modules: [fp64arithmetic],
      vertexCount: 1,
      drawMode: esm_default.POINTS,
      isInstanced: true,
      instanceCount,
      attributes: {
        position: [0, 0]
      }
    });
  }
  function getMeanTransform(gl, opts) {
    return new import_core2.Transform(gl, {
      vs: transform_mean_vs_glsl_default,
      _targetTextureVarying: "meanValues",
      ...opts
    });
  }

  // src/screen-grid-layer/screen-grid-cell-layer.ts
  var import_core4 = __toESM(require_core2());
  var import_core5 = __toESM(require_core());

  // src/utils/color-utils.ts
  var defaultColorRange = [[255, 255, 178], [254, 217, 118], [254, 178, 76], [253, 141, 60], [240, 59, 32], [189, 0, 38]];
  function colorRangeToFlatArray(colorRange, normalize = false, ArrayType = Float32Array) {
    let flatArray;
    if (Number.isFinite(colorRange[0])) {
      flatArray = new ArrayType(colorRange);
    } else {
      flatArray = new ArrayType(colorRange.length * 4);
      let index = 0;
      for (let i = 0; i < colorRange.length; i++) {
        const color = colorRange[i];
        flatArray[index++] = color[0];
        flatArray[index++] = color[1];
        flatArray[index++] = color[2];
        flatArray[index++] = Number.isFinite(color[3]) ? color[3] : 255;
      }
    }
    if (normalize) {
      for (let i = 0; i < flatArray.length; i++) {
        flatArray[i] /= 255;
      }
    }
    return flatArray;
  }

  // src/screen-grid-layer/screen-grid-layer-vertex.glsl.ts
  var screen_grid_layer_vertex_glsl_default = `#define SHADER_NAME screen-grid-layer-vertex-shader
#define RANGE_COUNT 6

attribute vec3 positions;
attribute vec3 instancePositions;
attribute vec4 instanceCounts;
attribute vec3 instancePickingColors;

uniform float opacity;
uniform vec3 cellScale;
uniform vec4 minColor;
uniform vec4 maxColor;
uniform vec4 colorRange[RANGE_COUNT];
uniform vec2 colorDomain;
uniform bool shouldUseMinMax;
uniform sampler2D maxTexture;

varying vec4 vColor;
varying float vSampleCount;

vec4 quantizeScale(vec2 domain, vec4 range[RANGE_COUNT], float value) {
  vec4 outColor = vec4(0., 0., 0., 0.);
  if (value >= domain.x && value <= domain.y) {
    float domainRange = domain.y - domain.x;
    if (domainRange <= 0.) {
      outColor = colorRange[0];
    } else {
      float rangeCount = float(RANGE_COUNT);
      float rangeStep = domainRange / rangeCount;
      float idx = floor((value - domain.x) / rangeStep);
      idx = clamp(idx, 0., rangeCount - 1.);
      int intIdx = int(idx);
      outColor = colorRange[intIdx];
    }
  }
  outColor = outColor / 255.;
  return outColor;
}

void main(void) {
  vSampleCount = instanceCounts.a;

  float weight = instanceCounts.r;
  float maxWeight = texture2D(maxTexture, vec2(0.5)).r;

  float step = weight / maxWeight;
  vec4 minMaxColor = mix(minColor, maxColor, step) / 255.;

  vec2 domain = colorDomain;
  float domainMaxValid = float(colorDomain.y != 0.);
  domain.y = mix(maxWeight, colorDomain.y, domainMaxValid);
  vec4 rangeColor = quantizeScale(domain, colorRange, weight);

  float rangeMinMax = float(shouldUseMinMax);
  vec4 color = mix(rangeColor, minMaxColor, rangeMinMax);
  vColor = vec4(color.rgb, color.a * opacity);

  // Set color to be rendered to picking fbo (also used to check for selection highlight).
  picking_setPickingColor(instancePickingColors);

  gl_Position = vec4(instancePositions + positions * cellScale, 1.);
}
`;

  // src/screen-grid-layer/screen-grid-layer-fragment.glsl.ts
  var screen_grid_layer_fragment_glsl_default = `#define SHADER_NAME screen-grid-layer-fragment-shader

precision highp float;

varying vec4 vColor;
varying float vSampleCount;

void main(void) {
  if (vSampleCount <= 0.0) {
    discard;
  }
  gl_FragColor = vColor;

  DECKGL_FILTER_COLOR(gl_FragColor, geometry);
}
`;

  // src/screen-grid-layer/screen-grid-cell-layer.ts
  var DEFAULT_MINCOLOR = [0, 0, 0, 0];
  var DEFAULT_MAXCOLOR = [0, 255, 0, 255];
  var COLOR_PROPS = ["minColor", "maxColor", "colorRange", "colorDomain"];
  var defaultProps = {
    cellSizePixels: {
      value: 100,
      min: 1
    },
    cellMarginPixels: {
      value: 2,
      min: 0,
      max: 5
    },
    colorDomain: null,
    colorRange: defaultColorRange
  };
  var ScreenGridCellLayer = class extends import_core5.Layer {
    static isSupported(gl) {
      return (0, import_core4.hasFeatures)(gl, [import_core4.FEATURES.TEXTURE_FLOAT]);
    }
    getShaders() {
      return {
        vs: screen_grid_layer_vertex_glsl_default,
        fs: screen_grid_layer_fragment_glsl_default,
        modules: [import_core5.picking]
      };
    }
    initializeState() {
      const {
        gl
      } = this.context;
      const attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          update: this.calculateInstancePositions
        },
        instanceCounts: {
          size: 4,
          noAlloc: true
        }
      });
      this.setState({
        model: this._getModel(gl)
      });
    }
    shouldUpdateState({
      changeFlags
    }) {
      return changeFlags.somethingChanged;
    }
    updateState(params) {
      super.updateState(params);
      const {
        oldProps,
        props,
        changeFlags
      } = params;
      const attributeManager = this.getAttributeManager();
      if (props.numInstances !== oldProps.numInstances) {
        attributeManager.invalidateAll();
      } else if (oldProps.cellSizePixels !== props.cellSizePixels) {
        attributeManager.invalidate("instancePositions");
      }
      this._updateUniforms(oldProps, props, changeFlags);
    }
    draw({
      uniforms
    }) {
      const {
        parameters,
        maxTexture
      } = this.props;
      const minColor = this.props.minColor || DEFAULT_MINCOLOR;
      const maxColor = this.props.maxColor || DEFAULT_MAXCOLOR;
      const colorDomain = this.props.colorDomain || [1, 0];
      const {
        model
      } = this.state;
      model.setUniforms(uniforms).setUniforms({
        minColor,
        maxColor,
        maxTexture,
        colorDomain
      }).draw({
        parameters: {
          depthTest: false,
          depthMask: false,
          ...parameters
        }
      });
    }
    calculateInstancePositions(attribute, {
      numInstances
    }) {
      const {
        width,
        height
      } = this.context.viewport;
      const {
        cellSizePixels
      } = this.props;
      const numCol = Math.ceil(width / cellSizePixels);
      const {
        value,
        size
      } = attribute;
      for (let i = 0; i < numInstances; i++) {
        const x = i % numCol;
        const y = Math.floor(i / numCol);
        value[i * size + 0] = x * cellSizePixels / width * 2 - 1;
        value[i * size + 1] = 1 - y * cellSizePixels / height * 2;
        value[i * size + 2] = 0;
      }
    }
    _getModel(gl) {
      return new import_core4.Model(gl, {
        ...this.getShaders(),
        id: this.props.id,
        geometry: new import_core4.Geometry({
          drawMode: esm_default.TRIANGLE_FAN,
          attributes: {
            positions: new Float32Array([0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0])
          }
        }),
        isInstanced: true
      });
    }
    _shouldUseMinMax() {
      const {
        minColor,
        maxColor,
        colorDomain,
        colorRange
      } = this.props;
      if (minColor || maxColor) {
        import_core5.log.deprecated("ScreenGridLayer props: minColor and maxColor", "colorRange, colorDomain")();
        return true;
      }
      if (colorDomain || colorRange) {
        return false;
      }
      return true;
    }
    _updateUniforms(oldProps, props, changeFlags) {
      const {
        model
      } = this.state;
      if (COLOR_PROPS.some((key) => oldProps[key] !== props[key])) {
        model.setUniforms({
          shouldUseMinMax: this._shouldUseMinMax()
        });
      }
      if (oldProps.colorRange !== props.colorRange) {
        model.setUniforms({
          colorRange: colorRangeToFlatArray(props.colorRange)
        });
      }
      if (oldProps.cellMarginPixels !== props.cellMarginPixels || oldProps.cellSizePixels !== props.cellSizePixels || changeFlags.viewportChanged) {
        const {
          width,
          height
        } = this.context.viewport;
        const {
          cellSizePixels,
          cellMarginPixels
        } = this.props;
        const margin = cellSizePixels > cellMarginPixels ? cellMarginPixels : 0;
        const cellScale = new Float32Array([(cellSizePixels - margin) / width * 2, -(cellSizePixels - margin) / height * 2, 1]);
        model.setUniforms({
          cellScale
        });
      }
    }
  };
  __publicField(ScreenGridCellLayer, "layerName", "ScreenGridCellLayer");
  __publicField(ScreenGridCellLayer, "defaultProps", defaultProps);

  // src/aggregation-layer.ts
  var import_core6 = __toESM(require_core());
  var import_core7 = __toESM(require_core2());

  // src/utils/prop-utils.js
  function filterProps(props, filterKeys) {
    const filteredProps = {};
    for (const key in props) {
      if (!filterKeys.includes(key)) {
        filteredProps[key] = props[key];
      }
    }
    return filteredProps;
  }

  // src/aggregation-layer.ts
  var AggregationLayer = class extends import_core6.CompositeLayer {
    initializeAggregationLayer(dimensions) {
      super.initializeState(this.context);
      this.setState({
        ignoreProps: filterProps(this.constructor._propTypes, dimensions.data.props),
        dimensions
      });
    }
    updateState(opts) {
      super.updateState(opts);
      const {
        changeFlags
      } = opts;
      if (changeFlags.extensionsChanged) {
        const shaders = this.getShaders({});
        if (shaders && shaders.defines) {
          shaders.defines.NON_INSTANCED_MODEL = 1;
        }
        this.updateShaders(shaders);
      }
      this._updateAttributes();
    }
    updateAttributes(changedAttributes) {
      this.setState({
        changedAttributes
      });
    }
    getAttributes() {
      return this.getAttributeManager().getShaderAttributes();
    }
    getModuleSettings() {
      const {
        viewport,
        mousePosition,
        gl
      } = this.context;
      const moduleSettings = Object.assign(Object.create(this.props), {
        viewport,
        mousePosition,
        pickingActive: 0,
        devicePixelRatio: (0, import_core7.cssToDeviceRatio)(gl)
      });
      return moduleSettings;
    }
    updateShaders(shaders) {
    }
    isAggregationDirty(updateOpts, params = {}) {
      const {
        props,
        oldProps,
        changeFlags
      } = updateOpts;
      const {
        compareAll = false,
        dimension
      } = params;
      const {
        ignoreProps
      } = this.state;
      const {
        props: dataProps,
        accessors = []
      } = dimension;
      const {
        updateTriggersChanged
      } = changeFlags;
      if (changeFlags.dataChanged) {
        return true;
      }
      if (updateTriggersChanged) {
        if (updateTriggersChanged.all) {
          return true;
        }
        for (const accessor of accessors) {
          if (updateTriggersChanged[accessor]) {
            return true;
          }
        }
      }
      if (compareAll) {
        if (changeFlags.extensionsChanged) {
          return true;
        }
        return (0, import_core6._compareProps)({
          oldProps,
          newProps: props,
          ignoreProps,
          propTypes: this.constructor._propTypes
        });
      }
      for (const name of dataProps) {
        if (props[name] !== oldProps[name]) {
          return true;
        }
      }
      return false;
    }
    isAttributeChanged(name) {
      const {
        changedAttributes
      } = this.state;
      if (!name) {
        return !isObjectEmpty(changedAttributes);
      }
      return changedAttributes && changedAttributes[name] !== void 0;
    }
    _getAttributeManager() {
      return new import_core6.AttributeManager(this.context.gl, {
        id: this.props.id,
        stats: this.context.stats
      });
    }
  };
  __publicField(AggregationLayer, "layerName", "AggregationLayer");
  function isObjectEmpty(obj) {
    let isEmpty = true;
    for (const key in obj) {
      isEmpty = false;
      break;
    }
    return isEmpty;
  }

  // src/grid-aggregation-layer.ts
  var import_core11 = __toESM(require_core2());
  var import_core12 = __toESM(require_core());

  // src/utils/scale-utils.js
  var import_core8 = __toESM(require_core());
  function getScale(domain, range, scaleFunction) {
    const scale = scaleFunction;
    scale.domain = () => domain;
    scale.range = () => range;
    return scale;
  }
  function getQuantizeScale(domain, range) {
    const scaleFunction = (value) => quantizeScale(domain, range, value);
    return getScale(domain, range, scaleFunction);
  }
  function getLinearScale(domain, range) {
    const scaleFunction = (value) => linearScale(domain, range, value);
    return getScale(domain, range, scaleFunction);
  }
  function getQuantileScale(domain, range) {
    const sortedDomain = domain.sort(ascending);
    let i = 0;
    const n = Math.max(1, range.length);
    const thresholds = new Array(n - 1);
    while (++i < n) {
      thresholds[i - 1] = threshold(sortedDomain, i / n);
    }
    const scaleFunction = (value) => thresholdsScale(thresholds, range, value);
    scaleFunction.thresholds = () => thresholds;
    return getScale(domain, range, scaleFunction);
  }
  function ascending(a, b) {
    return a - b;
  }
  function threshold(domain, fraction) {
    const domainLength = domain.length;
    if (fraction <= 0 || domainLength < 2) {
      return domain[0];
    }
    if (fraction >= 1) {
      return domain[domainLength - 1];
    }
    const domainFraction = (domainLength - 1) * fraction;
    const lowIndex = Math.floor(domainFraction);
    const low = domain[lowIndex];
    const high = domain[lowIndex + 1];
    return low + (high - low) * (domainFraction - lowIndex);
  }
  function bisectRight(a, x) {
    let lo = 0;
    let hi = a.length;
    while (lo < hi) {
      const mid = lo + hi >>> 1;
      if (ascending(a[mid], x) > 0) {
        hi = mid;
      } else {
        lo = mid + 1;
      }
    }
    return lo;
  }
  function thresholdsScale(thresholds, range, value) {
    return range[bisectRight(thresholds, value)];
  }
  function ordinalScale(domain, domainMap, range, value) {
    const key = `${value}`;
    let d = domainMap.get(key);
    if (d === void 0) {
      d = domain.push(value);
      domainMap.set(key, d);
    }
    return range[(d - 1) % range.length];
  }
  function getOrdinalScale(domain, range) {
    const domainMap = /* @__PURE__ */ new Map();
    const uniqueDomain = [];
    for (const d of domain) {
      const key = `${d}`;
      if (!domainMap.has(key)) {
        domainMap.set(key, uniqueDomain.push(d));
      }
    }
    const scaleFunction = (value) => ordinalScale(uniqueDomain, domainMap, range, value);
    return getScale(domain, range, scaleFunction);
  }
  function quantizeScale(domain, range, value) {
    const domainRange = domain[1] - domain[0];
    if (domainRange <= 0) {
      import_core8.log.warn("quantizeScale: invalid domain, returning range[0]")();
      return range[0];
    }
    const step = domainRange / range.length;
    const idx = Math.floor((value - domain[0]) / step);
    const clampIdx = Math.max(Math.min(idx, range.length - 1), 0);
    return range[clampIdx];
  }
  function linearScale(domain, range, value) {
    return (value - domain[0]) / (domain[1] - domain[0]) * (range[1] - range[0]) + range[0];
  }
  function notNullOrUndefined(d) {
    return d !== void 0 && d !== null;
  }
  function unique(values) {
    const results = [];
    values.forEach((v) => {
      if (!results.includes(v) && notNullOrUndefined(v)) {
        results.push(v);
      }
    });
    return results;
  }
  function getTruthyValues(data, valueAccessor) {
    const values = typeof valueAccessor === "function" ? data.map(valueAccessor) : data;
    return values.filter(notNullOrUndefined);
  }
  function getQuantileDomain(data, valueAccessor) {
    return getTruthyValues(data, valueAccessor);
  }
  function getOrdinalDomain(data, valueAccessor) {
    return unique(getTruthyValues(data, valueAccessor));
  }
  function clamp(value, min, max) {
    return Math.max(min, Math.min(max, value));
  }
  function getScaleFunctionByScaleType(scaleType) {
    switch (scaleType) {
      case "quantize":
        return getQuantizeScale;
      case "linear":
        return getLinearScale;
      case "quantile":
        return getQuantileScale;
      case "ordinal":
        return getOrdinalScale;
      default:
        return getQuantizeScale;
    }
  }

  // src/utils/bin-sorter.ts
  var defaultGetValue = (points) => points.length;
  var MAX_32_BIT_FLOAT2 = 3402823466e29;
  var defaultGetPoints = (bin) => bin.points;
  var defaultGetIndex = (bin) => bin.index;
  var ascending2 = (a, b) => a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  var defaultProps2 = {
    getValue: defaultGetValue,
    getPoints: defaultGetPoints,
    getIndex: defaultGetIndex,
    filterData: null
  };
  var BinSorter = class {
    constructor(bins = [], props = defaultProps2) {
      this.aggregatedBins = this.getAggregatedBins(bins, props);
      this._updateMinMaxValues();
      this.binMap = this.getBinMap();
    }
    getAggregatedBins(bins, props) {
      const {
        getValue = defaultGetValue,
        getPoints = defaultGetPoints,
        getIndex = defaultGetIndex,
        filterData
      } = props;
      const hasFilter = typeof filterData === "function";
      const binCount = bins.length;
      const aggregatedBins = [];
      let index = 0;
      for (let binIndex = 0; binIndex < binCount; binIndex++) {
        const bin = bins[binIndex];
        const points = getPoints(bin);
        const i = getIndex(bin);
        const filteredPoints = hasFilter ? points.filter(filterData) : points;
        bin.filteredPoints = hasFilter ? filteredPoints : null;
        const value = filteredPoints.length ? getValue(filteredPoints) : null;
        if (value !== null && value !== void 0) {
          aggregatedBins[index] = {
            i: Number.isFinite(i) ? i : binIndex,
            value,
            counts: filteredPoints.length
          };
          index++;
        }
      }
      return aggregatedBins;
    }
    _percentileToIndex(percentileRange) {
      const len = this.sortedBins.length;
      if (len < 2) {
        return [0, 0];
      }
      const [lower, upper] = percentileRange.map((n) => clamp(n, 0, 100));
      const lowerIdx = Math.ceil(lower / 100 * (len - 1));
      const upperIdx = Math.floor(upper / 100 * (len - 1));
      return [lowerIdx, upperIdx];
    }
    getBinMap() {
      const binMap = {};
      for (const bin of this.aggregatedBins) {
        binMap[bin.i] = bin;
      }
      return binMap;
    }
    _updateMinMaxValues() {
      let maxCount = 0;
      let maxValue = 0;
      let minValue = MAX_32_BIT_FLOAT2;
      let totalCount = 0;
      for (const x of this.aggregatedBins) {
        maxCount = maxCount > x.counts ? maxCount : x.counts;
        maxValue = maxValue > x.value ? maxValue : x.value;
        minValue = minValue < x.value ? minValue : x.value;
        totalCount += x.counts;
      }
      this.maxCount = maxCount;
      this.maxValue = maxValue;
      this.minValue = minValue;
      this.totalCount = totalCount;
    }
    getValueRange(percentileRange) {
      if (!this.sortedBins) {
        this.sortedBins = this.aggregatedBins.sort((a, b) => ascending2(a.value, b.value));
      }
      if (!this.sortedBins.length) {
        return [];
      }
      let lowerIdx = 0;
      let upperIdx = this.sortedBins.length - 1;
      if (Array.isArray(percentileRange)) {
        const idxRange = this._percentileToIndex(percentileRange);
        lowerIdx = idxRange[0];
        upperIdx = idxRange[1];
      }
      return [this.sortedBins[lowerIdx].value, this.sortedBins[upperIdx].value];
    }
    getValueDomainByScale(scale, [lower = 0, upper = 100] = []) {
      if (!this.sortedBins) {
        this.sortedBins = this.aggregatedBins.sort((a, b) => ascending2(a.value, b.value));
      }
      if (!this.sortedBins.length) {
        return [];
      }
      const indexEdge = this._percentileToIndex([lower, upper]);
      return this._getScaleDomain(scale, indexEdge);
    }
    _getScaleDomain(scaleType, [lowerIdx, upperIdx]) {
      const bins = this.sortedBins;
      switch (scaleType) {
        case "quantize":
        case "linear":
          return [bins[lowerIdx].value, bins[upperIdx].value];
        case "quantile":
          return getQuantileDomain(bins.slice(lowerIdx, upperIdx + 1), (d) => d.value);
        case "ordinal":
          return getOrdinalDomain(bins, (d) => d.value);
        default:
          return [bins[lowerIdx].value, bins[upperIdx].value];
      }
    }
  };

  // src/cpu-grid-layer/grid-aggregator.js
  var import_core10 = __toESM(require_core());

  // src/utils/grid-aggregation-utils.js
  var import_core9 = __toESM(require_core());
  var R_EARTH = 6378e3;
  function toFinite(n) {
    return Number.isFinite(n) ? n : 0;
  }
  function getBoundingBox(attributes, vertexCount) {
    const positions = attributes.positions.value;
    let yMin = Infinity;
    let yMax = -Infinity;
    let xMin = Infinity;
    let xMax = -Infinity;
    let y;
    let x;
    for (let i = 0; i < vertexCount; i++) {
      x = positions[i * 3];
      y = positions[i * 3 + 1];
      yMin = y < yMin ? y : yMin;
      yMax = y > yMax ? y : yMax;
      xMin = x < xMin ? x : xMin;
      xMax = x > xMax ? x : xMax;
    }
    const boundingBox = {
      xMin: toFinite(xMin),
      xMax: toFinite(xMax),
      yMin: toFinite(yMin),
      yMax: toFinite(yMax)
    };
    return boundingBox;
  }
  function getTranslation(boundingBox, gridOffset, coordinateSystem, viewport) {
    const {
      width,
      height
    } = viewport;
    const worldOrigin = coordinateSystem === import_core9.COORDINATE_SYSTEM.CARTESIAN ? [-width / 2, -height / 2] : [-180, -90];
    import_core9.log.assert(coordinateSystem === import_core9.COORDINATE_SYSTEM.CARTESIAN || coordinateSystem === import_core9.COORDINATE_SYSTEM.LNGLAT || coordinateSystem === import_core9.COORDINATE_SYSTEM.DEFAULT);
    const {
      xMin,
      yMin
    } = boundingBox;
    return [
      -1 * (alignToCell(xMin - worldOrigin[0], gridOffset.xOffset) + worldOrigin[0]),
      -1 * (alignToCell(yMin - worldOrigin[1], gridOffset.yOffset) + worldOrigin[1])
    ];
  }
  function alignToCell(inValue, cellSize) {
    const sign = inValue < 0 ? -1 : 1;
    let value = sign < 0 ? Math.abs(inValue) + cellSize : Math.abs(inValue);
    value = Math.floor(value / cellSize) * cellSize;
    return value * sign;
  }
  function getGridOffset(boundingBox, cellSize, convertToMeters = true) {
    if (!convertToMeters) {
      return {
        xOffset: cellSize,
        yOffset: cellSize
      };
    }
    const {
      yMin,
      yMax
    } = boundingBox;
    const centerLat = (yMin + yMax) / 2;
    return calculateGridLatLonOffset(cellSize, centerLat);
  }
  function getGridParams(boundingBox, cellSize, viewport, coordinateSystem) {
    const gridOffset = getGridOffset(boundingBox, cellSize, coordinateSystem !== import_core9.COORDINATE_SYSTEM.CARTESIAN);
    const translation = getTranslation(boundingBox, gridOffset, coordinateSystem, viewport);
    const {
      xMin,
      yMin,
      xMax,
      yMax
    } = boundingBox;
    const width = xMax - xMin + gridOffset.xOffset;
    const height = yMax - yMin + gridOffset.yOffset;
    const numCol = Math.ceil(width / gridOffset.xOffset);
    const numRow = Math.ceil(height / gridOffset.yOffset);
    return {
      gridOffset,
      translation,
      width,
      height,
      numCol,
      numRow
    };
  }
  function calculateGridLatLonOffset(cellSize, latitude) {
    const yOffset = calculateLatOffset(cellSize);
    const xOffset = calculateLonOffset(latitude, cellSize);
    return {
      yOffset,
      xOffset
    };
  }
  function calculateLatOffset(dy) {
    return dy / R_EARTH * (180 / Math.PI);
  }
  function calculateLonOffset(lat, dx) {
    return dx / R_EARTH * (180 / Math.PI) / Math.cos(lat * Math.PI / 180);
  }

  // src/cpu-grid-layer/grid-aggregator.js
  function pointToDensityGridDataCPU(props, aggregationParams) {
    const hashInfo = pointsToGridHashing(props, aggregationParams);
    const result = getGridLayerDataFromGridHash(hashInfo);
    return {
      gridHash: hashInfo.gridHash,
      gridOffset: hashInfo.gridOffset,
      data: result
    };
  }
  function pointsToGridHashing(props, aggregationParams) {
    const {
      data = [],
      cellSize
    } = props;
    const {
      attributes,
      viewport,
      projectPoints,
      numInstances
    } = aggregationParams;
    const positions = attributes.positions.value;
    const {
      size
    } = attributes.positions.getAccessor();
    const boundingBox = aggregationParams.boundingBox || getPositionBoundingBox(attributes.positions, numInstances);
    const offsets = aggregationParams.posOffset || [180, 90];
    const gridOffset = aggregationParams.gridOffset || getGridOffset(boundingBox, cellSize);
    if (gridOffset.xOffset <= 0 || gridOffset.yOffset <= 0) {
      return {
        gridHash: {},
        gridOffset
      };
    }
    const {
      width,
      height
    } = viewport;
    const numCol = Math.ceil(width / gridOffset.xOffset);
    const numRow = Math.ceil(height / gridOffset.yOffset);
    const gridHash = {};
    const {
      iterable,
      objectInfo
    } = (0, import_core10.createIterable)(data);
    const position = new Array(3);
    for (const pt of iterable) {
      objectInfo.index++;
      position[0] = positions[objectInfo.index * size];
      position[1] = positions[objectInfo.index * size + 1];
      position[2] = size >= 3 ? positions[objectInfo.index * size + 2] : 0;
      const [x, y] = projectPoints ? viewport.project(position) : position;
      if (Number.isFinite(x) && Number.isFinite(y)) {
        const yIndex = Math.floor((y + offsets[1]) / gridOffset.yOffset);
        const xIndex = Math.floor((x + offsets[0]) / gridOffset.xOffset);
        if (!projectPoints || xIndex >= 0 && xIndex < numCol && yIndex >= 0 && yIndex < numRow) {
          const key = `${yIndex}-${xIndex}`;
          gridHash[key] = gridHash[key] || {
            count: 0,
            points: [],
            lonIdx: xIndex,
            latIdx: yIndex
          };
          gridHash[key].count += 1;
          gridHash[key].points.push({
            source: pt,
            index: objectInfo.index
          });
        }
      }
    }
    return {
      gridHash,
      gridOffset,
      offsets: [offsets[0] * -1, offsets[1] * -1]
    };
  }
  function getGridLayerDataFromGridHash({
    gridHash,
    gridOffset,
    offsets
  }) {
    const data = new Array(Object.keys(gridHash).length);
    let i = 0;
    for (const key in gridHash) {
      const idxs = key.split("-");
      const latIdx = parseInt(idxs[0], 10);
      const lonIdx = parseInt(idxs[1], 10);
      const index = i++;
      data[index] = {
        index,
        position: [offsets[0] + gridOffset.xOffset * lonIdx, offsets[1] + gridOffset.yOffset * latIdx],
        ...gridHash[key]
      };
    }
    return data;
  }
  function getPositionBoundingBox(positionAttribute, numInstance) {
    const positions = positionAttribute.value;
    const {
      size
    } = positionAttribute.getAccessor();
    let yMin = Infinity;
    let yMax = -Infinity;
    let xMin = Infinity;
    let xMax = -Infinity;
    let y;
    let x;
    for (let i = 0; i < numInstance; i++) {
      x = positions[i * size];
      y = positions[i * size + 1];
      if (Number.isFinite(x) && Number.isFinite(y)) {
        yMin = y < yMin ? y : yMin;
        yMax = y > yMax ? y : yMax;
        xMin = x < xMin ? x : xMin;
        xMax = x > xMax ? x : xMax;
      }
    }
    return {
      xMin,
      xMax,
      yMin,
      yMax
    };
  }

  // src/grid-aggregation-layer.ts
  var GridAggregationLayer = class extends AggregationLayer {
    initializeAggregationLayer({
      dimensions
    }) {
      const {
        gl
      } = this.context;
      super.initializeAggregationLayer(dimensions);
      this.setState({
        layerData: {},
        gpuGridAggregator: new GPUGridAggregator(gl, {
          id: `${this.id}-gpu-aggregator`
        }),
        cpuGridAggregator: pointToDensityGridDataCPU
      });
    }
    updateState(opts) {
      super.updateState(opts);
      this.updateAggregationState(opts);
      const {
        aggregationDataDirty,
        aggregationWeightsDirty,
        gpuAggregation
      } = this.state;
      if (this.getNumInstances() <= 0) {
        return;
      }
      let aggregationDirty = false;
      if (aggregationDataDirty || gpuAggregation && aggregationWeightsDirty) {
        this._updateAggregation(opts);
        aggregationDirty = true;
      }
      if (!gpuAggregation && (aggregationDataDirty || aggregationWeightsDirty)) {
        this._updateWeightBins();
        this._uploadAggregationResults();
        aggregationDirty = true;
      }
      this.setState({
        aggregationDirty
      });
    }
    finalizeState(context) {
      const {
        count
      } = this.state.weights;
      if (count && count.aggregationBuffer) {
        count.aggregationBuffer.delete();
      }
      this.state.gpuGridAggregator?.delete();
      super.finalizeState(context);
    }
    updateShaders(shaders) {
      if (this.state.gpuAggregation) {
        this.state.gpuGridAggregator.updateShaders(shaders);
      }
    }
    updateAggregationState(opts) {
      import_core12.log.assert(false);
    }
    allocateResources(numRow, numCol) {
      if (this.state.numRow !== numRow || this.state.numCol !== numCol) {
        const dataBytes = numCol * numRow * 4 * 4;
        const gl = this.context.gl;
        const {
          weights
        } = this.state;
        for (const name in weights) {
          const weight = weights[name];
          if (weight.aggregationBuffer) {
            weight.aggregationBuffer.delete();
          }
          weight.aggregationBuffer = new import_core11.Buffer(gl, {
            byteLength: dataBytes,
            accessor: {
              size: 4,
              type: esm_default.FLOAT,
              divisor: 1
            }
          });
        }
      }
    }
    updateResults({
      aggregationData,
      maxMinData,
      maxData,
      minData
    }) {
      const {
        count
      } = this.state.weights;
      if (count) {
        count.aggregationData = aggregationData;
        count.maxMinData = maxMinData;
        count.maxData = maxData;
        count.minData = minData;
      }
    }
    _updateAggregation(opts) {
      const {
        cpuGridAggregator,
        gpuGridAggregator,
        gridOffset,
        posOffset,
        translation = [0, 0],
        scaling = [0, 0, 0],
        boundingBox,
        projectPoints,
        gpuAggregation,
        numCol,
        numRow
      } = this.state;
      const {
        props
      } = opts;
      const {
        viewport
      } = this.context;
      const attributes = this.getAttributes();
      const vertexCount = this.getNumInstances();
      if (!gpuAggregation) {
        const result = cpuGridAggregator(props, {
          gridOffset,
          projectPoints,
          attributes,
          viewport,
          posOffset,
          boundingBox
        });
        this.setState({
          layerData: result
        });
      } else {
        const {
          weights
        } = this.state;
        gpuGridAggregator.run({
          weights,
          cellSize: [gridOffset.xOffset, gridOffset.yOffset],
          numCol,
          numRow,
          translation,
          scaling,
          vertexCount,
          projectPoints,
          attributes,
          moduleSettings: this.getModuleSettings()
        });
      }
    }
    _updateWeightBins() {
      const {
        getValue
      } = this.state;
      const sortedBins = new BinSorter(this.state.layerData.data || [], {
        getValue
      });
      this.setState({
        sortedBins
      });
    }
    _uploadAggregationResults() {
      const {
        numCol,
        numRow
      } = this.state;
      const {
        data
      } = this.state.layerData;
      const {
        aggregatedBins,
        minValue,
        maxValue,
        totalCount
      } = this.state.sortedBins;
      const ELEMENTCOUNT = 4;
      const aggregationSize = numCol * numRow * ELEMENTCOUNT;
      const aggregationData = new Float32Array(aggregationSize).fill(0);
      for (const bin of aggregatedBins) {
        const {
          lonIdx,
          latIdx
        } = data[bin.i];
        const {
          value,
          counts
        } = bin;
        const cellIndex = (lonIdx + latIdx * numCol) * ELEMENTCOUNT;
        aggregationData[cellIndex] = value;
        aggregationData[cellIndex + ELEMENTCOUNT - 1] = counts;
      }
      const maxMinData = new Float32Array([maxValue, 0, 0, minValue]);
      const maxData = new Float32Array([maxValue, 0, 0, totalCount]);
      const minData = new Float32Array([minValue, 0, 0, totalCount]);
      this.updateResults({
        aggregationData,
        maxMinData,
        maxData,
        minData
      });
    }
  };
  __publicField(GridAggregationLayer, "layerName", "GridAggregationLayer");

  // src/screen-grid-layer/screen-grid-layer.ts
  var defaultProps3 = {
    ...ScreenGridCellLayer.defaultProps,
    getPosition: {
      type: "accessor",
      value: (d) => d.position
    },
    getWeight: {
      type: "accessor",
      value: 1
    },
    gpuAggregation: true,
    aggregation: "SUM"
  };
  var POSITION_ATTRIBUTE_NAME = "positions";
  var DIMENSIONS = {
    data: {
      props: ["cellSizePixels"]
    },
    weights: {
      props: ["aggregation"],
      accessors: ["getWeight"]
    }
  };
  var ScreenGridLayer = class extends GridAggregationLayer {
    initializeState() {
      const {
        gl
      } = this.context;
      if (!ScreenGridCellLayer.isSupported(gl)) {
        this.setState({
          supported: false
        });
        import_core13.log.error(`ScreenGridLayer: ${this.id} is not supported on this browser`)();
        return;
      }
      super.initializeAggregationLayer({
        dimensions: DIMENSIONS,
        getCellSize: (props) => props.cellSizePixels
      });
      const weights = {
        count: {
          size: 1,
          operation: AGGREGATION_OPERATION.SUM,
          needMax: true,
          maxTexture: getFloatTexture(gl, {
            id: `${this.id}-max-texture`
          })
        }
      };
      this.setState({
        supported: true,
        projectPoints: true,
        weights,
        subLayerData: {
          attributes: {}
        },
        maxTexture: weights.count.maxTexture,
        positionAttributeName: "positions",
        posOffset: [0, 0],
        translation: [1, -1]
      });
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        [POSITION_ATTRIBUTE_NAME]: {
          size: 3,
          accessor: "getPosition",
          type: esm_default.DOUBLE,
          fp64: this.use64bitPositions()
        },
        count: {
          size: 3,
          accessor: "getWeight"
        }
      });
    }
    shouldUpdateState({
      changeFlags
    }) {
      return this.state.supported && changeFlags.somethingChanged;
    }
    updateState(opts) {
      super.updateState(opts);
    }
    renderLayers() {
      if (!this.state.supported) {
        return [];
      }
      const {
        maxTexture,
        numRow,
        numCol,
        weights
      } = this.state;
      const {
        updateTriggers
      } = this.props;
      const {
        aggregationBuffer
      } = weights.count;
      const CellLayerClass = this.getSubLayerClass("cells", ScreenGridCellLayer);
      return new CellLayerClass(this.props, this.getSubLayerProps({
        id: "cell-layer",
        updateTriggers
      }), {
        data: {
          attributes: {
            instanceCounts: aggregationBuffer
          }
        },
        maxTexture,
        numInstances: numRow * numCol
      });
    }
    finalizeState(context) {
      super.finalizeState(context);
      const {
        aggregationBuffer,
        maxBuffer,
        maxTexture
      } = this.state;
      aggregationBuffer?.delete();
      maxBuffer?.delete();
      maxTexture?.delete();
    }
    getPickingInfo({
      info
    }) {
      const {
        index
      } = info;
      if (index >= 0) {
        const {
          gpuGridAggregator,
          gpuAggregation,
          weights
        } = this.state;
        const aggregationResults = gpuAggregation ? gpuGridAggregator.getData("count") : weights.count;
        info.object = GPUGridAggregator.getAggregationData({
          pixelIndex: index,
          ...aggregationResults
        });
      }
      return info;
    }
    updateResults({
      aggregationData,
      maxData
    }) {
      const {
        count
      } = this.state.weights;
      count.aggregationData = aggregationData;
      count.aggregationBuffer.setData({
        data: aggregationData
      });
      count.maxData = maxData;
      count.maxTexture.setImageData({
        data: maxData
      });
    }
    updateAggregationState(opts) {
      const cellSize = opts.props.cellSizePixels;
      const cellSizeChanged = opts.oldProps.cellSizePixels !== cellSize;
      const {
        viewportChanged
      } = opts.changeFlags;
      let gpuAggregation = opts.props.gpuAggregation;
      if (this.state.gpuAggregation !== opts.props.gpuAggregation) {
        if (gpuAggregation && !GPUGridAggregator.isSupported(this.context.gl)) {
          import_core13.log.warn("GPU Grid Aggregation not supported, falling back to CPU")();
          gpuAggregation = false;
        }
      }
      const gpuAggregationChanged = gpuAggregation !== this.state.gpuAggregation;
      this.setState({
        gpuAggregation
      });
      const positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME);
      const {
        dimensions
      } = this.state;
      const {
        data,
        weights
      } = dimensions;
      const aggregationDataDirty = positionsChanged || gpuAggregationChanged || viewportChanged || this.isAggregationDirty(opts, {
        compareAll: gpuAggregation,
        dimension: data
      });
      const aggregationWeightsDirty = this.isAggregationDirty(opts, {
        dimension: weights
      });
      this.setState({
        aggregationDataDirty,
        aggregationWeightsDirty
      });
      const {
        viewport
      } = this.context;
      if (viewportChanged || cellSizeChanged) {
        const {
          width,
          height
        } = viewport;
        const numCol = Math.ceil(width / cellSize);
        const numRow = Math.ceil(height / cellSize);
        this.allocateResources(numRow, numCol);
        this.setState({
          scaling: [width / 2, -height / 2, 1],
          gridOffset: {
            xOffset: cellSize,
            yOffset: cellSize
          },
          width,
          height,
          numCol,
          numRow
        });
      }
      if (aggregationWeightsDirty) {
        this._updateAccessors(opts);
      }
      if (aggregationDataDirty || aggregationWeightsDirty) {
        this._resetResults();
      }
    }
    _updateAccessors(opts) {
      const {
        getWeight,
        aggregation,
        data
      } = opts.props;
      const {
        count
      } = this.state.weights;
      if (count) {
        count.getWeight = getWeight;
        count.operation = AGGREGATION_OPERATION[aggregation];
      }
      this.setState({
        getValue: getValueFunc(aggregation, getWeight, {
          data
        })
      });
    }
    _resetResults() {
      const {
        count
      } = this.state.weights;
      if (count) {
        count.aggregationData = null;
      }
    }
  };
  __publicField(ScreenGridLayer, "layerName", "ScreenGridLayer");
  __publicField(ScreenGridLayer, "defaultProps", defaultProps3);

  // src/cpu-grid-layer/cpu-grid-layer.ts
  var import_layers2 = __toESM(require_layers());

  // src/utils/cpu-aggregator.js
  function nop() {
  }
  var dimensionSteps = ["getBins", "getDomain", "getScaleFunc"];
  var defaultDimensions = [{
    key: "fillColor",
    accessor: "getFillColor",
    pickingInfo: "colorValue",
    getBins: {
      triggers: {
        value: {
          prop: "getColorValue",
          updateTrigger: "getColorValue"
        },
        weight: {
          prop: "getColorWeight",
          updateTrigger: "getColorWeight"
        },
        aggregation: {
          prop: "colorAggregation"
        },
        filterData: {
          prop: "_filterData",
          updateTrigger: "_filterData"
        }
      }
    },
    getDomain: {
      triggers: {
        lowerPercentile: {
          prop: "lowerPercentile"
        },
        upperPercentile: {
          prop: "upperPercentile"
        },
        scaleType: {
          prop: "colorScaleType"
        }
      }
    },
    getScaleFunc: {
      triggers: {
        domain: {
          prop: "colorDomain"
        },
        range: {
          prop: "colorRange"
        }
      },
      onSet: {
        props: "onSetColorDomain"
      }
    },
    nullValue: [0, 0, 0, 0]
  }, {
    key: "elevation",
    accessor: "getElevation",
    pickingInfo: "elevationValue",
    getBins: {
      triggers: {
        value: {
          prop: "getElevationValue",
          updateTrigger: "getElevationValue"
        },
        weight: {
          prop: "getElevationWeight",
          updateTrigger: "getElevationWeight"
        },
        aggregation: {
          prop: "elevationAggregation"
        },
        filterData: {
          prop: "_filterData",
          updateTrigger: "_filterData"
        }
      }
    },
    getDomain: {
      triggers: {
        lowerPercentile: {
          prop: "elevationLowerPercentile"
        },
        upperPercentile: {
          prop: "elevationUpperPercentile"
        },
        scaleType: {
          prop: "elevationScaleType"
        }
      }
    },
    getScaleFunc: {
      triggers: {
        domain: {
          prop: "elevationDomain"
        },
        range: {
          prop: "elevationRange"
        }
      },
      onSet: {
        props: "onSetElevationDomain"
      }
    },
    nullValue: -1
  }];
  var defaultGetCellSize = (props) => props.cellSize;
  var CPUAggregator = class {
    constructor(opts) {
      this.state = {
        layerData: {},
        dimensions: {}
      };
      this.changeFlags = {};
      this.dimensionUpdaters = {};
      this._getCellSize = opts.getCellSize || defaultGetCellSize;
      this._getAggregator = opts.getAggregator;
      this._addDimension(opts.dimensions || defaultDimensions);
    }
    static defaultDimensions() {
      return defaultDimensions;
    }
    updateState(opts, aggregationParams) {
      const {
        oldProps,
        props,
        changeFlags
      } = opts;
      this.updateGetValueFuncs(oldProps, props, changeFlags);
      const reprojectNeeded = this.needsReProjectPoints(oldProps, props, changeFlags);
      let aggregationDirty = false;
      if (changeFlags.dataChanged || reprojectNeeded) {
        this.getAggregatedData(props, aggregationParams);
        aggregationDirty = true;
      } else {
        const dimensionChanges = this.getDimensionChanges(oldProps, props, changeFlags) || [];
        dimensionChanges.forEach((f) => typeof f === "function" && f());
        aggregationDirty = true;
      }
      this.setState({
        aggregationDirty
      });
      return this.state;
    }
    setState(updateObject) {
      this.state = {
        ...this.state,
        ...updateObject
      };
    }
    setDimensionState(key, updateObject) {
      this.setState({
        dimensions: {
          ...this.state.dimensions,
          [key]: {
            ...this.state.dimensions[key],
            ...updateObject
          }
        }
      });
    }
    normalizeResult(result = {}) {
      if (result.hexagons) {
        return {
          data: result.hexagons,
          ...result
        };
      } else if (result.layerData) {
        return {
          data: result.layerData,
          ...result
        };
      }
      return result;
    }
    getAggregatedData(props, aggregationParams) {
      const aggregator = this._getAggregator(props);
      const result = aggregator(props, aggregationParams);
      this.setState({
        layerData: this.normalizeResult(result)
      });
      this.changeFlags = {
        layerData: true
      };
      this.getSortedBins(props);
    }
    updateGetValueFuncs(oldProps, props, changeFlags) {
      for (const key in this.dimensionUpdaters) {
        const {
          value,
          weight,
          aggregation
        } = this.dimensionUpdaters[key].getBins.triggers;
        let getValue = props[value.prop];
        const getValueChanged = this.needUpdateDimensionStep(this.dimensionUpdaters[key].getBins, oldProps, props, changeFlags);
        if (getValueChanged) {
          if (getValue) {
            getValue = wrapGetValueFunc(getValue, {
              data: props.data
            });
          } else {
            getValue = getValueFunc(props[aggregation.prop], props[weight.prop], {
              data: props.data
            });
          }
        }
        if (getValue) {
          this.setDimensionState(key, {
            getValue
          });
        }
      }
    }
    needsReProjectPoints(oldProps, props, changeFlags) {
      return this._getCellSize(oldProps) !== this._getCellSize(props) || this._getAggregator(oldProps) !== this._getAggregator(props) || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPosition);
    }
    addDimension(dimensions) {
      this._addDimension(dimensions);
    }
    _addDimension(dimensions = []) {
      dimensions.forEach((dimension) => {
        const {
          key
        } = dimension;
        this.dimensionUpdaters[key] = this.getDimensionUpdaters(dimension);
        this.state.dimensions[key] = {
          getValue: null,
          domain: null,
          sortedBins: null,
          scaleFunc: nop
        };
      });
    }
    getDimensionUpdaters({
      key,
      accessor,
      pickingInfo,
      getBins,
      getDomain,
      getScaleFunc,
      nullValue
    }) {
      return {
        key,
        accessor,
        pickingInfo,
        getBins: {
          updater: this.getDimensionSortedBins,
          ...getBins
        },
        getDomain: {
          updater: this.getDimensionValueDomain,
          ...getDomain
        },
        getScaleFunc: {
          updater: this.getDimensionScale,
          ...getScaleFunc
        },
        attributeAccessor: this.getSubLayerDimensionAttribute(key, nullValue)
      };
    }
    needUpdateDimensionStep(dimensionStep, oldProps, props, changeFlags) {
      return Object.values(dimensionStep.triggers).some((item) => {
        if (item.updateTrigger) {
          return changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged[item.updateTrigger]);
        }
        return oldProps[item.prop] !== props[item.prop];
      });
    }
    getDimensionChanges(oldProps, props, changeFlags) {
      const updaters = [];
      for (const key in this.dimensionUpdaters) {
        const needUpdate = dimensionSteps.find((step) => this.needUpdateDimensionStep(this.dimensionUpdaters[key][step], oldProps, props, changeFlags));
        if (needUpdate) {
          updaters.push(this.dimensionUpdaters[key][needUpdate].updater.bind(this, props, this.dimensionUpdaters[key]));
        }
      }
      return updaters.length ? updaters : null;
    }
    getUpdateTriggers(props) {
      const _updateTriggers = props.updateTriggers || {};
      const updateTriggers = {};
      for (const key in this.dimensionUpdaters) {
        const {
          accessor
        } = this.dimensionUpdaters[key];
        updateTriggers[accessor] = {};
        dimensionSteps.forEach((step) => {
          Object.values(this.dimensionUpdaters[key][step].triggers).forEach(({
            prop,
            updateTrigger
          }) => {
            if (updateTrigger) {
              const fromProp = _updateTriggers[updateTrigger];
              if (typeof fromProp === "object" && !Array.isArray(fromProp)) {
                Object.assign(updateTriggers[accessor], fromProp);
              } else if (fromProp !== void 0) {
                updateTriggers[accessor][prop] = fromProp;
              }
            } else {
              updateTriggers[accessor][prop] = props[prop];
            }
          });
        });
      }
      return updateTriggers;
    }
    getSortedBins(props) {
      for (const key in this.dimensionUpdaters) {
        this.getDimensionSortedBins(props, this.dimensionUpdaters[key]);
      }
    }
    getDimensionSortedBins(props, dimensionUpdater) {
      const {
        key
      } = dimensionUpdater;
      const {
        getValue
      } = this.state.dimensions[key];
      const sortedBins = new BinSorter(this.state.layerData.data || [], {
        getValue,
        filterData: props._filterData
      });
      this.setDimensionState(key, {
        sortedBins
      });
      this.getDimensionValueDomain(props, dimensionUpdater);
    }
    getDimensionValueDomain(props, dimensionUpdater) {
      const {
        getDomain,
        key
      } = dimensionUpdater;
      const {
        triggers: {
          lowerPercentile,
          upperPercentile,
          scaleType
        }
      } = getDomain;
      const valueDomain = this.state.dimensions[key].sortedBins.getValueDomainByScale(props[scaleType.prop], [props[lowerPercentile.prop], props[upperPercentile.prop]]);
      this.setDimensionState(key, {
        valueDomain
      });
      this.getDimensionScale(props, dimensionUpdater);
    }
    getDimensionScale(props, dimensionUpdater) {
      const {
        key,
        getScaleFunc,
        getDomain
      } = dimensionUpdater;
      const {
        domain,
        range
      } = getScaleFunc.triggers;
      const {
        scaleType
      } = getDomain.triggers;
      const {
        onSet
      } = getScaleFunc;
      const dimensionRange = props[range.prop];
      const dimensionDomain = props[domain.prop] || this.state.dimensions[key].valueDomain;
      const getScaleFunction = getScaleFunctionByScaleType(scaleType && props[scaleType.prop]);
      const scaleFunc = getScaleFunction(dimensionDomain, dimensionRange);
      if (typeof onSet === "object" && typeof props[onSet.props] === "function") {
        props[onSet.props](scaleFunc.domain());
      }
      this.setDimensionState(key, {
        scaleFunc
      });
    }
    getSubLayerDimensionAttribute(key, nullValue) {
      return (cell) => {
        const {
          sortedBins,
          scaleFunc
        } = this.state.dimensions[key];
        const bin = sortedBins.binMap[cell.index];
        if (bin && bin.counts === 0) {
          return nullValue;
        }
        const cv = bin && bin.value;
        const domain = scaleFunc.domain();
        const isValueInDomain = cv >= domain[0] && cv <= domain[domain.length - 1];
        return isValueInDomain ? scaleFunc(cv) : nullValue;
      };
    }
    getSubLayerAccessors(props) {
      const accessors = {};
      for (const key in this.dimensionUpdaters) {
        const {
          accessor
        } = this.dimensionUpdaters[key];
        accessors[accessor] = this.getSubLayerDimensionAttribute(props, key);
      }
      return accessors;
    }
    getPickingInfo({
      info
    }) {
      const isPicked = info.picked && info.index > -1;
      let object = null;
      if (isPicked) {
        const cell = this.state.layerData.data[info.index];
        const binInfo = {};
        for (const key in this.dimensionUpdaters) {
          const {
            pickingInfo
          } = this.dimensionUpdaters[key];
          const {
            sortedBins
          } = this.state.dimensions[key];
          const value = sortedBins.binMap[cell.index] && sortedBins.binMap[cell.index].value;
          binInfo[pickingInfo] = value;
        }
        object = Object.assign(binInfo, cell, {
          points: cell.filteredPoints || cell.points
        });
      }
      info.picked = Boolean(object);
      info.object = object;
      return info;
    }
    getAccessor(dimensionKey) {
      if (!this.dimensionUpdaters.hasOwnProperty(dimensionKey)) {
        return nop;
      }
      return this.dimensionUpdaters[dimensionKey].attributeAccessor;
    }
  };

  // src/cpu-grid-layer/cpu-grid-layer.ts
  function nop2() {
  }
  var defaultProps4 = {
    colorDomain: null,
    colorRange: defaultColorRange,
    getColorValue: {
      type: "accessor",
      value: null
    },
    getColorWeight: {
      type: "accessor",
      value: 1
    },
    colorAggregation: "SUM",
    lowerPercentile: {
      type: "number",
      min: 0,
      max: 100,
      value: 0
    },
    upperPercentile: {
      type: "number",
      min: 0,
      max: 100,
      value: 100
    },
    colorScaleType: "quantize",
    onSetColorDomain: nop2,
    elevationDomain: null,
    elevationRange: [0, 1e3],
    getElevationValue: {
      type: "accessor",
      value: null
    },
    getElevationWeight: {
      type: "accessor",
      value: 1
    },
    elevationAggregation: "SUM",
    elevationLowerPercentile: {
      type: "number",
      min: 0,
      max: 100,
      value: 0
    },
    elevationUpperPercentile: {
      type: "number",
      min: 0,
      max: 100,
      value: 100
    },
    elevationScale: {
      type: "number",
      min: 0,
      value: 1
    },
    elevationScaleType: "linear",
    onSetElevationDomain: nop2,
    gridAggregator: pointToDensityGridDataCPU,
    cellSize: {
      type: "number",
      min: 0,
      max: 1e3,
      value: 1e3
    },
    coverage: {
      type: "number",
      min: 0,
      max: 1,
      value: 1
    },
    getPosition: {
      type: "accessor",
      value: (x) => x.position
    },
    extruded: false,
    material: true,
    _filterData: {
      type: "function",
      value: null,
      optional: true
    }
  };
  var CPUGridLayer = class extends AggregationLayer {
    initializeState() {
      const cpuAggregator = new CPUAggregator({
        getAggregator: (props) => props.gridAggregator,
        getCellSize: (props) => props.cellSize
      });
      this.state = {
        cpuAggregator,
        aggregatorState: cpuAggregator.state
      };
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          type: esm_default.DOUBLE,
          accessor: "getPosition"
        }
      });
    }
    updateState(opts) {
      super.updateState(opts);
      this.setState({
        aggregatorState: this.state.cpuAggregator.updateState(opts, {
          viewport: this.context.viewport,
          attributes: this.getAttributes(),
          numInstances: this.getNumInstances()
        })
      });
    }
    getPickingInfo({
      info
    }) {
      return this.state.cpuAggregator.getPickingInfo({
        info
      });
    }
    _onGetSublayerColor(cell) {
      return this.state.cpuAggregator.getAccessor("fillColor")(cell);
    }
    _onGetSublayerElevation(cell) {
      return this.state.cpuAggregator.getAccessor("elevation")(cell);
    }
    _getSublayerUpdateTriggers() {
      return this.state.cpuAggregator.getUpdateTriggers(this.props);
    }
    renderLayers() {
      const {
        elevationScale,
        extruded,
        cellSize,
        coverage,
        material,
        transitions
      } = this.props;
      const {
        cpuAggregator
      } = this.state;
      const SubLayerClass = this.getSubLayerClass("grid-cell", import_layers2.GridCellLayer);
      const updateTriggers = this._getSublayerUpdateTriggers();
      return new SubLayerClass({
        cellSize,
        coverage,
        material,
        elevationScale,
        extruded,
        getFillColor: this._onGetSublayerColor.bind(this),
        getElevation: this._onGetSublayerElevation.bind(this),
        transitions: transitions && {
          getFillColor: transitions.getColorValue || transitions.getColorWeight,
          getElevation: transitions.getElevationValue || transitions.getElevationWeight
        }
      }, this.getSubLayerProps({
        id: "grid-cell",
        updateTriggers
      }), {
        data: cpuAggregator.state.layerData.data
      });
    }
  };
  __publicField(CPUGridLayer, "layerName", "CPUGridLayer");
  __publicField(CPUGridLayer, "defaultProps", defaultProps4);

  // src/hexagon-layer/hexagon-layer.ts
  var import_core15 = __toESM(require_core());
  var import_layers3 = __toESM(require_layers());

  // ../../node_modules/d3-hexbin/src/hexbin.js
  var thirdPi = Math.PI / 3;
  var angles = [0, thirdPi, 2 * thirdPi, 3 * thirdPi, 4 * thirdPi, 5 * thirdPi];
  function pointX(d) {
    return d[0];
  }
  function pointY(d) {
    return d[1];
  }
  function hexbin_default() {
    var x0 = 0, y0 = 0, x1 = 1, y1 = 1, x = pointX, y = pointY, r, dx, dy;
    function hexbin(points) {
      var binsById = {}, bins = [], i, n = points.length;
      for (i = 0; i < n; ++i) {
        if (isNaN(px = +x.call(null, point = points[i], i, points)) || isNaN(py = +y.call(null, point, i, points)))
          continue;
        var point, px, py, pj = Math.round(py = py / dy), pi = Math.round(px = px / dx - (pj & 1) / 2), py1 = py - pj;
        if (Math.abs(py1) * 3 > 1) {
          var px1 = px - pi, pi2 = pi + (px < pi ? -1 : 1) / 2, pj2 = pj + (py < pj ? -1 : 1), px2 = px - pi2, py2 = py - pj2;
          if (px1 * px1 + py1 * py1 > px2 * px2 + py2 * py2)
            pi = pi2 + (pj & 1 ? 1 : -1) / 2, pj = pj2;
        }
        var id = pi + "-" + pj, bin = binsById[id];
        if (bin)
          bin.push(point);
        else {
          bins.push(bin = binsById[id] = [point]);
          bin.x = (pi + (pj & 1) / 2) * dx;
          bin.y = pj * dy;
        }
      }
      return bins;
    }
    function hexagon(radius) {
      var x02 = 0, y02 = 0;
      return angles.map(function(angle) {
        var x12 = Math.sin(angle) * radius, y12 = -Math.cos(angle) * radius, dx2 = x12 - x02, dy2 = y12 - y02;
        x02 = x12, y02 = y12;
        return [dx2, dy2];
      });
    }
    hexbin.hexagon = function(radius) {
      return "m" + hexagon(radius == null ? r : +radius).join("l") + "z";
    };
    hexbin.centers = function() {
      var centers = [], j = Math.round(y0 / dy), i = Math.round(x0 / dx);
      for (var y2 = j * dy; y2 < y1 + r; y2 += dy, ++j) {
        for (var x2 = i * dx + (j & 1) * dx / 2; x2 < x1 + dx / 2; x2 += dx) {
          centers.push([x2, y2]);
        }
      }
      return centers;
    };
    hexbin.mesh = function() {
      var fragment = hexagon(r).slice(0, 4).join("l");
      return hexbin.centers().map(function(p) {
        return "M" + p + "m" + fragment;
      }).join("");
    };
    hexbin.x = function(_) {
      return arguments.length ? (x = _, hexbin) : x;
    };
    hexbin.y = function(_) {
      return arguments.length ? (y = _, hexbin) : y;
    };
    hexbin.radius = function(_) {
      return arguments.length ? (r = +_, dx = r * 2 * Math.sin(thirdPi), dy = r * 1.5, hexbin) : r;
    };
    hexbin.size = function(_) {
      return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], hexbin) : [x1 - x0, y1 - y0];
    };
    hexbin.extent = function(_) {
      return arguments.length ? (x0 = +_[0][0], y0 = +_[0][1], x1 = +_[1][0], y1 = +_[1][1], hexbin) : [[x0, y0], [x1, y1]];
    };
    return hexbin.radius(1);
  }

  // src/hexagon-layer/hexagon-aggregator.js
  var import_core14 = __toESM(require_core());
  function pointToHexbin(props, aggregationParams) {
    const {
      data,
      radius
    } = props;
    const {
      viewport,
      attributes
    } = aggregationParams;
    const centerLngLat = data.length ? getPointsCenter(data, aggregationParams) : null;
    const radiusCommon = getRadiusInCommon(radius, viewport, centerLngLat);
    const screenPoints = [];
    const {
      iterable,
      objectInfo
    } = (0, import_core14.createIterable)(data);
    const positions = attributes.positions.value;
    const {
      size
    } = attributes.positions.getAccessor();
    for (const object of iterable) {
      objectInfo.index++;
      const posIndex = objectInfo.index * size;
      const position = [positions[posIndex], positions[posIndex + 1]];
      const arrayIsFinite = Number.isFinite(position[0]) && Number.isFinite(position[1]);
      if (arrayIsFinite) {
        screenPoints.push({
          screenCoord: viewport.projectFlat(position),
          source: object,
          index: objectInfo.index
        });
      } else {
        import_core14.log.warn("HexagonLayer: invalid position")();
      }
    }
    const newHexbin = hexbin_default().radius(radiusCommon).x((d) => d.screenCoord[0]).y((d) => d.screenCoord[1]);
    const hexagonBins = newHexbin(screenPoints);
    return {
      hexagons: hexagonBins.map((hex, index) => ({
        position: viewport.unprojectFlat([hex.x, hex.y]),
        points: hex,
        index
      })),
      radiusCommon
    };
  }
  function getPointsCenter(data, aggregationParams) {
    const {
      attributes
    } = aggregationParams;
    const positions = attributes.positions.value;
    const {
      size
    } = attributes.positions.getAccessor();
    let minX = Infinity;
    let minY = Infinity;
    let maxX = -Infinity;
    let maxY = -Infinity;
    let i;
    for (i = 0; i < size * data.length; i += size) {
      const x = positions[i];
      const y = positions[i + 1];
      const arrayIsFinite = Number.isFinite(x) && Number.isFinite(y);
      if (arrayIsFinite) {
        minX = Math.min(x, minX);
        maxX = Math.max(x, maxX);
        minY = Math.min(y, minY);
        maxY = Math.max(y, maxY);
      }
    }
    return [minX, minY, maxX, maxY].every(Number.isFinite) ? [(minX + maxX) / 2, (minY + maxY) / 2] : null;
  }
  function getRadiusInCommon(radius, viewport, center) {
    const {
      unitsPerMeter
    } = viewport.getDistanceScales(center);
    return radius * unitsPerMeter[0];
  }

  // src/hexagon-layer/hexagon-layer.ts
  function nop3() {
  }
  var defaultProps5 = {
    colorDomain: null,
    colorRange: defaultColorRange,
    getColorValue: {
      type: "accessor",
      value: null
    },
    getColorWeight: {
      type: "accessor",
      value: 1
    },
    colorAggregation: "SUM",
    lowerPercentile: {
      type: "number",
      value: 0,
      min: 0,
      max: 100
    },
    upperPercentile: {
      type: "number",
      value: 100,
      min: 0,
      max: 100
    },
    colorScaleType: "quantize",
    onSetColorDomain: nop3,
    elevationDomain: null,
    elevationRange: [0, 1e3],
    getElevationValue: {
      type: "accessor",
      value: null
    },
    getElevationWeight: {
      type: "accessor",
      value: 1
    },
    elevationAggregation: "SUM",
    elevationLowerPercentile: {
      type: "number",
      value: 0,
      min: 0,
      max: 100
    },
    elevationUpperPercentile: {
      type: "number",
      value: 100,
      min: 0,
      max: 100
    },
    elevationScale: {
      type: "number",
      min: 0,
      value: 1
    },
    elevationScaleType: "linear",
    onSetElevationDomain: nop3,
    radius: {
      type: "number",
      value: 1e3,
      min: 1
    },
    coverage: {
      type: "number",
      min: 0,
      max: 1,
      value: 1
    },
    extruded: false,
    hexagonAggregator: pointToHexbin,
    getPosition: {
      type: "accessor",
      value: (x) => x.position
    },
    material: true,
    _filterData: {
      type: "function",
      value: null,
      optional: true
    }
  };
  var HexagonLayer = class extends AggregationLayer {
    initializeState() {
      const cpuAggregator = new CPUAggregator({
        getAggregator: (props) => props.hexagonAggregator,
        getCellSize: (props) => props.radius
      });
      this.state = {
        cpuAggregator,
        aggregatorState: cpuAggregator.state,
        vertices: null
      };
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          type: esm_default.DOUBLE,
          accessor: "getPosition"
        }
      });
    }
    updateState(opts) {
      super.updateState(opts);
      if (opts.changeFlags.propsOrDataChanged) {
        const aggregatorState = this.state.cpuAggregator.updateState(opts, {
          viewport: this.context.viewport,
          attributes: this.getAttributes()
        });
        if (this.state.aggregatorState.layerData !== aggregatorState.layerData) {
          const {
            hexagonVertices
          } = aggregatorState.layerData || {};
          this.setState({
            vertices: hexagonVertices && this.convertLatLngToMeterOffset(hexagonVertices)
          });
        }
        this.setState({
          aggregatorState
        });
      }
    }
    convertLatLngToMeterOffset(hexagonVertices) {
      const {
        viewport
      } = this.context;
      if (Array.isArray(hexagonVertices) && hexagonVertices.length === 6) {
        const vertex0 = hexagonVertices[0];
        const vertex3 = hexagonVertices[3];
        const centroid = [(vertex0[0] + vertex3[0]) / 2, (vertex0[1] + vertex3[1]) / 2];
        const centroidFlat = viewport.projectFlat(centroid);
        const {
          metersPerUnit
        } = viewport.getDistanceScales(centroid);
        const vertices = hexagonVertices.map((vt) => {
          const vtFlat = viewport.projectFlat(vt);
          return [(vtFlat[0] - centroidFlat[0]) * metersPerUnit[0], (vtFlat[1] - centroidFlat[1]) * metersPerUnit[1]];
        });
        return vertices;
      }
      import_core15.log.error("HexagonLayer: hexagonVertices needs to be an array of 6 points")();
      return null;
    }
    getPickingInfo({
      info
    }) {
      return this.state.cpuAggregator.getPickingInfo({
        info
      });
    }
    _onGetSublayerColor(cell) {
      return this.state.cpuAggregator.getAccessor("fillColor")(cell);
    }
    _onGetSublayerElevation(cell) {
      return this.state.cpuAggregator.getAccessor("elevation")(cell);
    }
    _getSublayerUpdateTriggers() {
      return this.state.cpuAggregator.getUpdateTriggers(this.props);
    }
    renderLayers() {
      const {
        elevationScale,
        extruded,
        coverage,
        material,
        transitions
      } = this.props;
      const {
        aggregatorState,
        vertices
      } = this.state;
      const SubLayerClass = this.getSubLayerClass("hexagon-cell", import_layers3.ColumnLayer);
      const updateTriggers = this._getSublayerUpdateTriggers();
      const geometry = vertices ? {
        vertices,
        radius: 1
      } : {
        radius: aggregatorState.layerData.radiusCommon || 1,
        radiusUnits: "common",
        angle: 90
      };
      return new SubLayerClass({
        ...geometry,
        diskResolution: 6,
        elevationScale,
        extruded,
        coverage,
        material,
        getFillColor: this._onGetSublayerColor.bind(this),
        getElevation: this._onGetSublayerElevation.bind(this),
        transitions: transitions && {
          getFillColor: transitions.getColorValue || transitions.getColorWeight,
          getElevation: transitions.getElevationValue || transitions.getElevationWeight
        }
      }, this.getSubLayerProps({
        id: "hexagon-cell",
        updateTriggers
      }), {
        data: aggregatorState.layerData.data
      });
    }
  };
  __publicField(HexagonLayer, "layerName", "HexagonLayer");
  __publicField(HexagonLayer, "defaultProps", defaultProps5);

  // src/contour-layer/contour-layer.ts
  var import_layers4 = __toESM(require_layers());

  // src/contour-layer/marching-squares.ts
  var import_core16 = __toESM(require_core());

  // src/contour-layer/marching-squares-codes.ts
  var HALF = 0.5;
  var ONE6TH = 1 / 6;
  var OFFSET = {
    N: [0, HALF],
    E: [HALF, 0],
    S: [0, -HALF],
    W: [-HALF, 0],
    NE: [HALF, HALF],
    NW: [-HALF, HALF],
    SE: [HALF, -HALF],
    SW: [-HALF, -HALF]
  };
  var SW_TRIANGLE = [OFFSET.W, OFFSET.SW, OFFSET.S];
  var SE_TRIANGLE = [OFFSET.S, OFFSET.SE, OFFSET.E];
  var NE_TRIANGLE = [OFFSET.E, OFFSET.NE, OFFSET.N];
  var NW_TRIANGLE = [OFFSET.NW, OFFSET.W, OFFSET.N];
  var SW_TRAPEZOID = [[-HALF, ONE6TH], [-HALF, -ONE6TH], [-ONE6TH, -HALF], [ONE6TH, -HALF]];
  var SE_TRAPEZOID = [[-ONE6TH, -HALF], [ONE6TH, -HALF], [HALF, -ONE6TH], [HALF, ONE6TH]];
  var NE_TRAPEZOID = [[HALF, -ONE6TH], [HALF, ONE6TH], [ONE6TH, HALF], [-ONE6TH, HALF]];
  var NW_TRAPEZOID = [[-HALF, ONE6TH], [-HALF, -ONE6TH], [ONE6TH, HALF], [-ONE6TH, HALF]];
  var S_RECTANGLE = [OFFSET.W, OFFSET.SW, OFFSET.SE, OFFSET.E];
  var E_RECTANGLE = [OFFSET.S, OFFSET.SE, OFFSET.NE, OFFSET.N];
  var N_RECTANGLE = [OFFSET.NW, OFFSET.W, OFFSET.E, OFFSET.NE];
  var W_RECTANGLE = [OFFSET.NW, OFFSET.SW, OFFSET.S, OFFSET.N];
  var EW_RECTANGEL = [[-HALF, ONE6TH], [-HALF, -ONE6TH], [HALF, -ONE6TH], [HALF, ONE6TH]];
  var SN_RECTANGEL = [[-ONE6TH, -HALF], [ONE6TH, -HALF], [ONE6TH, HALF], [-ONE6TH, HALF]];
  var SQUARE = [OFFSET.NW, OFFSET.SW, OFFSET.SE, OFFSET.NE];
  var SW_PENTAGON = [OFFSET.NW, OFFSET.SW, OFFSET.SE, OFFSET.E, OFFSET.N];
  var SE_PENTAGON = [OFFSET.W, OFFSET.SW, OFFSET.SE, OFFSET.NE, OFFSET.N];
  var NE_PENTAGON = [OFFSET.NW, OFFSET.W, OFFSET.S, OFFSET.SE, OFFSET.NE];
  var NW_PENTAGON = [OFFSET.NW, OFFSET.SW, OFFSET.S, OFFSET.E, OFFSET.NE];
  var NW_N_PENTAGON = [OFFSET.NW, OFFSET.W, [HALF, -ONE6TH], [HALF, ONE6TH], OFFSET.N];
  var NE_E_PENTAGON = [[-ONE6TH, -HALF], [ONE6TH, -HALF], OFFSET.E, OFFSET.NE, OFFSET.N];
  var SE_S_PENTAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], OFFSET.S, OFFSET.SE, OFFSET.E];
  var SW_W_PENTAGON = [OFFSET.W, OFFSET.SW, OFFSET.S, [ONE6TH, HALF], [-ONE6TH, HALF]];
  var NW_W_PENTAGON = [OFFSET.NW, OFFSET.W, [-ONE6TH, -HALF], [ONE6TH, -HALF], OFFSET.N];
  var NE_N_PENTAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], OFFSET.E, OFFSET.NE, OFFSET.N];
  var SE_E_PENTAGON = [OFFSET.S, OFFSET.SE, OFFSET.E, [ONE6TH, HALF], [-ONE6TH, HALF]];
  var SW_S_PENTAGON = [OFFSET.W, OFFSET.SW, OFFSET.S, [HALF, -ONE6TH], [HALF, ONE6TH]];
  var S_HEXAGON = [OFFSET.W, OFFSET.SW, OFFSET.SE, OFFSET.E, [ONE6TH, HALF], [-ONE6TH, HALF]];
  var E_HEXAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], OFFSET.S, OFFSET.SE, OFFSET.NE, OFFSET.N];
  var N_HEXAGON = [OFFSET.NW, OFFSET.W, [-ONE6TH, -HALF], [ONE6TH, -HALF], OFFSET.E, OFFSET.NE];
  var W_HEXAGON = [OFFSET.NW, OFFSET.SW, OFFSET.S, [HALF, -ONE6TH], [HALF, ONE6TH], OFFSET.N];
  var SW_NE_HEXAGON = [OFFSET.W, OFFSET.SW, OFFSET.S, OFFSET.E, OFFSET.NE, OFFSET.N];
  var NW_SE_HEXAGON = [OFFSET.NW, OFFSET.W, OFFSET.S, OFFSET.SE, OFFSET.E, OFFSET.N];
  var NE_HEPTAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], [-ONE6TH, -HALF], [ONE6TH, -HALF], OFFSET.E, OFFSET.NE, OFFSET.N];
  var SW_HEPTAGON = [OFFSET.W, OFFSET.SW, OFFSET.S, [HALF, -ONE6TH], [HALF, ONE6TH], [ONE6TH, HALF], [-ONE6TH, HALF]];
  var NW_HEPTAGON = [OFFSET.NW, OFFSET.W, [-ONE6TH, -HALF], [ONE6TH, -HALF], [HALF, -ONE6TH], [HALF, ONE6TH], OFFSET.N];
  var SE_HEPTAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], OFFSET.S, OFFSET.SE, OFFSET.E, [ONE6TH, HALF], [-ONE6TH, HALF]];
  var OCTAGON = [[-HALF, ONE6TH], [-HALF, -ONE6TH], [-ONE6TH, -HALF], [ONE6TH, -HALF], [HALF, -ONE6TH], [HALF, ONE6TH], [ONE6TH, HALF], [-ONE6TH, HALF]];
  var ISOLINES_CODE_OFFSET_MAP = {
    0: [],
    1: [[OFFSET.W, OFFSET.S]],
    2: [[OFFSET.S, OFFSET.E]],
    3: [[OFFSET.W, OFFSET.E]],
    4: [[OFFSET.N, OFFSET.E]],
    5: {
      0: [[OFFSET.W, OFFSET.S], [OFFSET.N, OFFSET.E]],
      1: [[OFFSET.W, OFFSET.N], [OFFSET.S, OFFSET.E]]
    },
    6: [[OFFSET.N, OFFSET.S]],
    7: [[OFFSET.W, OFFSET.N]],
    8: [[OFFSET.W, OFFSET.N]],
    9: [[OFFSET.N, OFFSET.S]],
    10: {
      0: [[OFFSET.W, OFFSET.N], [OFFSET.S, OFFSET.E]],
      1: [[OFFSET.W, OFFSET.S], [OFFSET.N, OFFSET.E]]
    },
    11: [[OFFSET.N, OFFSET.E]],
    12: [[OFFSET.W, OFFSET.E]],
    13: [[OFFSET.S, OFFSET.E]],
    14: [[OFFSET.W, OFFSET.S]],
    15: []
  };
  function ternaryToIndex(ternary) {
    return parseInt(ternary, 4);
  }
  var ISOBANDS_CODE_OFFSET_MAP = {
    [ternaryToIndex("0000")]: [],
    [ternaryToIndex("2222")]: [],
    [ternaryToIndex("2221")]: [SW_TRIANGLE],
    [ternaryToIndex("2212")]: [SE_TRIANGLE],
    [ternaryToIndex("2122")]: [NE_TRIANGLE],
    [ternaryToIndex("1222")]: [NW_TRIANGLE],
    [ternaryToIndex("0001")]: [SW_TRIANGLE],
    [ternaryToIndex("0010")]: [SE_TRIANGLE],
    [ternaryToIndex("0100")]: [NE_TRIANGLE],
    [ternaryToIndex("1000")]: [NW_TRIANGLE],
    [ternaryToIndex("2220")]: [SW_TRAPEZOID],
    [ternaryToIndex("2202")]: [SE_TRAPEZOID],
    [ternaryToIndex("2022")]: [NE_TRAPEZOID],
    [ternaryToIndex("0222")]: [NW_TRAPEZOID],
    [ternaryToIndex("0002")]: [SW_TRAPEZOID],
    [ternaryToIndex("0020")]: [SE_TRAPEZOID],
    [ternaryToIndex("0200")]: [NE_TRAPEZOID],
    [ternaryToIndex("2000")]: [NW_TRAPEZOID],
    [ternaryToIndex("0011")]: [S_RECTANGLE],
    [ternaryToIndex("0110")]: [E_RECTANGLE],
    [ternaryToIndex("1100")]: [N_RECTANGLE],
    [ternaryToIndex("1001")]: [W_RECTANGLE],
    [ternaryToIndex("2211")]: [S_RECTANGLE],
    [ternaryToIndex("2112")]: [E_RECTANGLE],
    [ternaryToIndex("1122")]: [N_RECTANGLE],
    [ternaryToIndex("1221")]: [W_RECTANGLE],
    [ternaryToIndex("2200")]: [EW_RECTANGEL],
    [ternaryToIndex("2002")]: [SN_RECTANGEL],
    [ternaryToIndex("0022")]: [EW_RECTANGEL],
    [ternaryToIndex("0220")]: [SN_RECTANGEL],
    [ternaryToIndex("1111")]: [SQUARE],
    [ternaryToIndex("1211")]: [SW_PENTAGON],
    [ternaryToIndex("2111")]: [SE_PENTAGON],
    [ternaryToIndex("1112")]: [NE_PENTAGON],
    [ternaryToIndex("1121")]: [NW_PENTAGON],
    [ternaryToIndex("1011")]: [SW_PENTAGON],
    [ternaryToIndex("0111")]: [SE_PENTAGON],
    [ternaryToIndex("1110")]: [NE_PENTAGON],
    [ternaryToIndex("1101")]: [NW_PENTAGON],
    [ternaryToIndex("1200")]: [NW_N_PENTAGON],
    [ternaryToIndex("0120")]: [NE_E_PENTAGON],
    [ternaryToIndex("0012")]: [SE_S_PENTAGON],
    [ternaryToIndex("2001")]: [SW_W_PENTAGON],
    [ternaryToIndex("1022")]: [NW_N_PENTAGON],
    [ternaryToIndex("2102")]: [NE_E_PENTAGON],
    [ternaryToIndex("2210")]: [SE_S_PENTAGON],
    [ternaryToIndex("0221")]: [SW_W_PENTAGON],
    [ternaryToIndex("1002")]: [NW_W_PENTAGON],
    [ternaryToIndex("2100")]: [NE_N_PENTAGON],
    [ternaryToIndex("0210")]: [SE_E_PENTAGON],
    [ternaryToIndex("0021")]: [SW_S_PENTAGON],
    [ternaryToIndex("1220")]: [NW_W_PENTAGON],
    [ternaryToIndex("0122")]: [NE_N_PENTAGON],
    [ternaryToIndex("2012")]: [SE_E_PENTAGON],
    [ternaryToIndex("2201")]: [SW_S_PENTAGON],
    [ternaryToIndex("0211")]: [S_HEXAGON],
    [ternaryToIndex("2110")]: [E_HEXAGON],
    [ternaryToIndex("1102")]: [N_HEXAGON],
    [ternaryToIndex("1021")]: [W_HEXAGON],
    [ternaryToIndex("2011")]: [S_HEXAGON],
    [ternaryToIndex("0112")]: [E_HEXAGON],
    [ternaryToIndex("1120")]: [N_HEXAGON],
    [ternaryToIndex("1201")]: [W_HEXAGON],
    [ternaryToIndex("2101")]: [SW_NE_HEXAGON],
    [ternaryToIndex("0121")]: [SW_NE_HEXAGON],
    [ternaryToIndex("1012")]: [NW_SE_HEXAGON],
    [ternaryToIndex("1210")]: [NW_SE_HEXAGON],
    [ternaryToIndex("0101")]: {
      0: [SW_TRIANGLE, NE_TRIANGLE],
      1: [SW_NE_HEXAGON],
      2: [SW_NE_HEXAGON]
    },
    [ternaryToIndex("1010")]: {
      0: [NW_TRIANGLE, SE_TRIANGLE],
      1: [NW_SE_HEXAGON],
      2: [NW_SE_HEXAGON]
    },
    [ternaryToIndex("2121")]: {
      0: [SW_NE_HEXAGON],
      1: [SW_NE_HEXAGON],
      2: [SW_TRIANGLE, NE_TRIANGLE]
    },
    [ternaryToIndex("1212")]: {
      0: [NW_SE_HEXAGON],
      1: [NW_SE_HEXAGON],
      2: [NW_TRIANGLE, SE_TRIANGLE]
    },
    [ternaryToIndex("2120")]: {
      0: [NE_HEPTAGON],
      1: [NE_HEPTAGON],
      2: [SW_TRAPEZOID, NE_TRIANGLE]
    },
    [ternaryToIndex("2021")]: {
      0: [SW_HEPTAGON],
      1: [SW_HEPTAGON],
      2: [SW_TRIANGLE, NE_TRAPEZOID]
    },
    [ternaryToIndex("1202")]: {
      0: [NW_HEPTAGON],
      1: [NW_HEPTAGON],
      2: [NW_TRIANGLE, SE_TRAPEZOID]
    },
    [ternaryToIndex("0212")]: {
      0: [SE_HEPTAGON],
      1: [SE_HEPTAGON],
      2: [SE_TRIANGLE, NW_TRAPEZOID]
    },
    [ternaryToIndex("0102")]: {
      0: [SW_TRAPEZOID, NE_TRIANGLE],
      1: [NE_HEPTAGON],
      2: [NE_HEPTAGON]
    },
    [ternaryToIndex("0201")]: {
      0: [SW_TRIANGLE, NE_TRAPEZOID],
      1: [SW_HEPTAGON],
      2: [SW_HEPTAGON]
    },
    [ternaryToIndex("1020")]: {
      0: [NW_TRIANGLE, SE_TRAPEZOID],
      1: [NW_HEPTAGON],
      2: [NW_HEPTAGON]
    },
    [ternaryToIndex("2010")]: {
      0: [SE_TRIANGLE, NW_TRAPEZOID],
      1: [SE_HEPTAGON],
      2: [SE_HEPTAGON]
    },
    [ternaryToIndex("2020")]: {
      0: [NW_TRAPEZOID, SE_TRAPEZOID],
      1: [OCTAGON],
      2: [SW_TRAPEZOID, NE_TRAPEZOID]
    },
    [ternaryToIndex("0202")]: {
      0: [NE_TRAPEZOID, SW_TRAPEZOID],
      1: [OCTAGON],
      2: [NW_TRAPEZOID, SE_TRAPEZOID]
    }
  };

  // src/contour-layer/marching-squares.ts
  var CONTOUR_TYPE = {
    ISO_LINES: 1,
    ISO_BANDS: 2
  };
  var DEFAULT_THRESHOLD_DATA = {
    zIndex: 0,
    zOffset: 5e-3
  };
  function getVertexCode(weight, threshold2) {
    if (Array.isArray(threshold2)) {
      if (weight < threshold2[0]) {
        return 0;
      }
      return weight < threshold2[1] ? 1 : 2;
    }
    return weight >= threshold2 ? 1 : 0;
  }
  function getCode(opts) {
    const {
      cellWeights,
      x,
      y,
      width,
      height
    } = opts;
    let threshold2 = opts.threshold;
    if (opts.thresholdValue) {
      import_core16.log.deprecated("thresholdValue", "threshold")();
      threshold2 = opts.thresholdValue;
    }
    const isLeftBoundary = x < 0;
    const isRightBoundary = x >= width - 1;
    const isBottomBoundary = y < 0;
    const isTopBoundary = y >= height - 1;
    const isBoundary = isLeftBoundary || isRightBoundary || isBottomBoundary || isTopBoundary;
    const weights = {};
    const codes = {};
    if (isLeftBoundary || isTopBoundary) {
      codes.top = 0;
    } else {
      weights.top = cellWeights[(y + 1) * width + x];
      codes.top = getVertexCode(weights.top, threshold2);
    }
    if (isRightBoundary || isTopBoundary) {
      codes.topRight = 0;
    } else {
      weights.topRight = cellWeights[(y + 1) * width + x + 1];
      codes.topRight = getVertexCode(weights.topRight, threshold2);
    }
    if (isRightBoundary || isBottomBoundary) {
      codes.right = 0;
    } else {
      weights.right = cellWeights[y * width + x + 1];
      codes.right = getVertexCode(weights.right, threshold2);
    }
    if (isLeftBoundary || isBottomBoundary) {
      codes.current = 0;
    } else {
      weights.current = cellWeights[y * width + x];
      codes.current = getVertexCode(weights.current, threshold2);
    }
    const {
      top,
      topRight,
      right,
      current
    } = codes;
    let code = -1;
    if (Number.isFinite(threshold2)) {
      code = top << 3 | topRight << 2 | right << 1 | current;
    }
    if (Array.isArray(threshold2)) {
      code = top << 6 | topRight << 4 | right << 2 | current;
    }
    let meanCode = 0;
    if (!isBoundary) {
      meanCode = getVertexCode((weights.top + weights.topRight + weights.right + weights.current) / 4, threshold2);
    }
    return {
      code,
      meanCode
    };
  }
  function getVertices(opts) {
    const {
      gridOrigin,
      cellSize,
      x,
      y,
      code,
      meanCode,
      type = CONTOUR_TYPE.ISO_LINES
    } = opts;
    const thresholdData = {
      ...DEFAULT_THRESHOLD_DATA,
      ...opts.thresholdData
    };
    let offsets = type === CONTOUR_TYPE.ISO_BANDS ? ISOBANDS_CODE_OFFSET_MAP[code] : ISOLINES_CODE_OFFSET_MAP[code];
    if (!Array.isArray(offsets)) {
      offsets = offsets[meanCode];
    }
    const vZ = thresholdData.zIndex * thresholdData.zOffset;
    const rX = (x + 1) * cellSize[0];
    const rY = (y + 1) * cellSize[1];
    const refVertexX = gridOrigin[0] + rX;
    const refVertexY = gridOrigin[1] + rY;
    if (type === CONTOUR_TYPE.ISO_BANDS) {
      const polygons = [];
      offsets.forEach((polygonOffsets) => {
        const polygon = [];
        polygonOffsets.forEach((xyOffset) => {
          const vX = refVertexX + xyOffset[0] * cellSize[0];
          const vY = refVertexY + xyOffset[1] * cellSize[1];
          polygon.push([vX, vY, vZ]);
        });
        polygons.push(polygon);
      });
      return polygons;
    }
    const lines = [];
    offsets.forEach((xyOffsets) => {
      xyOffsets.forEach((offset) => {
        const vX = refVertexX + offset[0] * cellSize[0];
        const vY = refVertexY + offset[1] * cellSize[1];
        lines.push([vX, vY, vZ]);
      });
    });
    return lines;
  }

  // src/contour-layer/contour-utils.ts
  function generateContours({
    thresholdData,
    cellWeights,
    gridSize,
    gridOrigin,
    cellSize
  }) {
    const contourSegments = [];
    const contourPolygons = [];
    const width = gridSize[0];
    const height = gridSize[1];
    let segmentIndex = 0;
    let polygonIndex = 0;
    for (const data of thresholdData) {
      const {
        contour
      } = data;
      const {
        threshold: threshold2
      } = contour;
      for (let x = -1; x < width; x++) {
        for (let y = -1; y < height; y++) {
          const {
            code,
            meanCode
          } = getCode({
            cellWeights,
            threshold: threshold2,
            x,
            y,
            width,
            height
          });
          const opts = {
            type: CONTOUR_TYPE.ISO_BANDS,
            gridOrigin,
            cellSize,
            x,
            y,
            width,
            height,
            code,
            meanCode,
            thresholdData: data
          };
          if (Array.isArray(threshold2)) {
            opts.type = CONTOUR_TYPE.ISO_BANDS;
            const polygons = getVertices(opts);
            for (const polygon of polygons) {
              contourPolygons[polygonIndex++] = {
                vertices: polygon,
                contour
              };
            }
          } else {
            opts.type = CONTOUR_TYPE.ISO_LINES;
            const vertices = getVertices(opts);
            for (let i = 0; i < vertices.length; i += 2) {
              contourSegments[segmentIndex++] = {
                start: vertices[i],
                end: vertices[i + 1],
                contour
              };
            }
          }
        }
      }
    }
    return {
      contourSegments,
      contourPolygons
    };
  }

  // src/contour-layer/contour-layer.ts
  var import_core17 = __toESM(require_core());
  var DEFAULT_COLOR = [255, 255, 255, 255];
  var DEFAULT_STROKE_WIDTH = 1;
  var DEFAULT_THRESHOLD = 1;
  var defaultProps6 = {
    cellSize: {
      type: "number",
      min: 1,
      max: 1e3,
      value: 1e3
    },
    getPosition: {
      type: "accessor",
      value: (x) => x.position
    },
    getWeight: {
      type: "accessor",
      value: 1
    },
    gpuAggregation: true,
    aggregation: "SUM",
    contours: {
      type: "object",
      value: [{
        threshold: DEFAULT_THRESHOLD
      }],
      optional: true,
      compare: 3
    },
    zOffset: 5e-3
  };
  var POSITION_ATTRIBUTE_NAME2 = "positions";
  var DIMENSIONS2 = {
    data: {
      props: ["cellSize"]
    },
    weights: {
      props: ["aggregation"],
      accessors: ["getWeight"]
    }
  };
  var ContourLayer = class extends GridAggregationLayer {
    initializeState() {
      super.initializeAggregationLayer({
        dimensions: DIMENSIONS2
      });
      this.setState({
        contourData: {},
        projectPoints: false,
        weights: {
          count: {
            size: 1,
            operation: AGGREGATION_OPERATION.SUM
          }
        }
      });
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        [POSITION_ATTRIBUTE_NAME2]: {
          size: 3,
          accessor: "getPosition",
          type: esm_default.DOUBLE,
          fp64: this.use64bitPositions()
        },
        count: {
          size: 3,
          accessor: "getWeight"
        }
      });
    }
    updateState(opts) {
      super.updateState(opts);
      let contoursChanged = false;
      const {
        oldProps,
        props
      } = opts;
      const {
        aggregationDirty
      } = this.state;
      if (oldProps.contours !== props.contours || oldProps.zOffset !== props.zOffset) {
        contoursChanged = true;
        this._updateThresholdData(opts.props);
      }
      if (this.getNumInstances() > 0 && (aggregationDirty || contoursChanged)) {
        this._generateContours();
      }
    }
    renderLayers() {
      const {
        contourSegments,
        contourPolygons
      } = this.state.contourData;
      const LinesSubLayerClass = this.getSubLayerClass("lines", import_layers4.LineLayer);
      const BandsSubLayerClass = this.getSubLayerClass("bands", import_layers4.SolidPolygonLayer);
      const lineLayer = contourSegments && contourSegments.length > 0 && new LinesSubLayerClass(this.getSubLayerProps({
        id: "lines"
      }), {
        data: this.state.contourData.contourSegments,
        getSourcePosition: (d) => d.start,
        getTargetPosition: (d) => d.end,
        getColor: (d) => d.contour.color || DEFAULT_COLOR,
        getWidth: (d) => d.contour.strokeWidth || DEFAULT_STROKE_WIDTH
      });
      const bandsLayer = contourPolygons && contourPolygons.length > 0 && new BandsSubLayerClass(this.getSubLayerProps({
        id: "bands"
      }), {
        data: this.state.contourData.contourPolygons,
        getPolygon: (d) => d.vertices,
        getFillColor: (d) => d.contour.color || DEFAULT_COLOR
      });
      return [lineLayer, bandsLayer];
    }
    updateAggregationState(opts) {
      const {
        props,
        oldProps
      } = opts;
      const {
        cellSize,
        coordinateSystem
      } = props;
      const {
        viewport
      } = this.context;
      const cellSizeChanged = oldProps.cellSize !== cellSize;
      let gpuAggregation = props.gpuAggregation;
      if (this.state.gpuAggregation !== props.gpuAggregation) {
        if (gpuAggregation && !GPUGridAggregator.isSupported(this.context.gl)) {
          import_core17.log.warn("GPU Grid Aggregation not supported, falling back to CPU")();
          gpuAggregation = false;
        }
      }
      const gpuAggregationChanged = gpuAggregation !== this.state.gpuAggregation;
      this.setState({
        gpuAggregation
      });
      const {
        dimensions
      } = this.state;
      const positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME2);
      const {
        data,
        weights
      } = dimensions;
      let {
        boundingBox
      } = this.state;
      if (positionsChanged) {
        boundingBox = getBoundingBox(this.getAttributes(), this.getNumInstances());
        this.setState({
          boundingBox
        });
      }
      if (positionsChanged || cellSizeChanged) {
        const {
          gridOffset,
          translation,
          width,
          height,
          numCol,
          numRow
        } = getGridParams(boundingBox, cellSize, viewport, coordinateSystem);
        this.allocateResources(numRow, numCol);
        this.setState({
          gridOffset,
          boundingBox,
          translation,
          posOffset: translation.slice(),
          gridOrigin: [-1 * translation[0], -1 * translation[1]],
          width,
          height,
          numCol,
          numRow
        });
      }
      const aggregationDataDirty = positionsChanged || gpuAggregationChanged || this.isAggregationDirty(opts, {
        dimension: data,
        compareAll: gpuAggregation
      });
      const aggregationWeightsDirty = this.isAggregationDirty(opts, {
        dimension: weights
      });
      if (aggregationWeightsDirty) {
        this._updateAccessors(opts);
      }
      if (aggregationDataDirty || aggregationWeightsDirty) {
        this._resetResults();
      }
      this.setState({
        aggregationDataDirty,
        aggregationWeightsDirty
      });
    }
    _updateAccessors(opts) {
      const {
        getWeight,
        aggregation,
        data
      } = opts.props;
      const {
        count
      } = this.state.weights;
      if (count) {
        count.getWeight = getWeight;
        count.operation = AGGREGATION_OPERATION[aggregation];
      }
      this.setState({
        getValue: getValueFunc(aggregation, getWeight, {
          data
        })
      });
    }
    _resetResults() {
      const {
        count
      } = this.state.weights;
      if (count) {
        count.aggregationData = null;
      }
    }
    _generateContours() {
      const {
        numCol,
        numRow,
        gridOrigin,
        gridOffset,
        thresholdData
      } = this.state;
      const {
        count
      } = this.state.weights;
      let {
        aggregationData
      } = count;
      if (!aggregationData) {
        aggregationData = count.aggregationBuffer.getData();
        count.aggregationData = aggregationData;
      }
      const {
        cellWeights
      } = GPUGridAggregator.getCellData({
        countsData: aggregationData
      });
      const contourData = generateContours({
        thresholdData,
        cellWeights,
        gridSize: [numCol, numRow],
        gridOrigin,
        cellSize: [gridOffset.xOffset, gridOffset.yOffset]
      });
      this.setState({
        contourData
      });
    }
    _updateThresholdData(props) {
      const {
        contours,
        zOffset
      } = props;
      const count = contours.length;
      const thresholdData = new Array(count);
      for (let i = 0; i < count; i++) {
        const contour = contours[i];
        thresholdData[i] = {
          contour,
          zIndex: contour.zIndex || i,
          zOffset
        };
      }
      this.setState({
        thresholdData
      });
    }
  };
  __publicField(ContourLayer, "layerName", "ContourLayer");
  __publicField(ContourLayer, "defaultProps", defaultProps6);

  // src/grid-layer/grid-layer.ts
  var import_core22 = __toESM(require_core());

  // src/gpu-grid-layer/gpu-grid-layer.ts
  var import_core20 = __toESM(require_core2());
  var import_core21 = __toESM(require_core());

  // src/gpu-grid-layer/gpu-grid-cell-layer.ts
  var import_core18 = __toESM(require_core());
  var import_core19 = __toESM(require_core2());

  // src/gpu-grid-layer/gpu-grid-cell-layer-vertex.glsl.ts
  var gpu_grid_cell_layer_vertex_glsl_default = `#version 300 es
#define SHADER_NAME gpu-grid-cell-layer-vertex-shader
#define RANGE_COUNT 6

in vec3 positions;
in vec3 normals;

in vec4 colors;
in vec4 elevations;
in vec3 instancePickingColors;

// Custom uniforms
uniform vec2 offset;
uniform bool extruded;
uniform float cellSize;
uniform float coverage;
uniform float opacity;
uniform float elevationScale;

uniform ivec2 gridSize;
uniform vec2 gridOrigin;
uniform vec2 gridOriginLow;
uniform vec2 gridOffset;
uniform vec2 gridOffsetLow;
uniform vec4 colorRange[RANGE_COUNT];
uniform vec2 elevationRange;

// Domain uniforms
uniform vec2 colorDomain;
uniform bool colorDomainValid;
uniform vec2 elevationDomain;
uniform bool elevationDomainValid;

layout(std140) uniform;
uniform ColorData
{
  vec4 maxMinCount;
} colorData;
uniform ElevationData
{
  vec4 maxMinCount;
} elevationData;

#define EPSILON 0.00001

// Result
out vec4 vColor;

vec4 quantizeScale(vec2 domain, vec4 range[RANGE_COUNT], float value) {
  vec4 outColor = vec4(0., 0., 0., 0.);
  if (value >= (domain.x - EPSILON) && value <= (domain.y + EPSILON)) {
    float domainRange = domain.y - domain.x;
    if (domainRange <= 0.) {
      outColor = colorRange[0];
    } else {
      float rangeCount = float(RANGE_COUNT);
      float rangeStep = domainRange / rangeCount;
      float idx = floor((value - domain.x) / rangeStep);
      idx = clamp(idx, 0., rangeCount - 1.);
      int intIdx = int(idx);
      outColor = colorRange[intIdx];
    }
  }
  return outColor;
}

float linearScale(vec2 domain, vec2 range, float value) {
  if (value >= (domain.x - EPSILON) && value <= (domain.y + EPSILON)) {
    return ((value - domain.x) / (domain.y - domain.x)) * (range.y - range.x) + range.x;
  }
  return -1.;
}

void main(void) {
  vec2 clrDomain = colorDomainValid ? colorDomain : vec2(colorData.maxMinCount.a, colorData.maxMinCount.r);
  vec4 color = quantizeScale(clrDomain, colorRange, colors.r);

  float elevation = 0.0;

  if (extruded) {
    vec2 elvDomain = elevationDomainValid ? elevationDomain : vec2(elevationData.maxMinCount.a, elevationData.maxMinCount.r);
    elevation = linearScale(elvDomain, elevationRange, elevations.r);
    elevation = elevation  * (positions.z + 1.0) / 2.0 * elevationScale;
  }

  // if aggregated color or elevation is 0 do not render
  float shouldRender = float(color.r > 0.0 && elevations.r >= 0.0);
  float dotRadius = cellSize / 2. * coverage * shouldRender;

  int yIndex = (gl_InstanceID / gridSize[0]);
  int xIndex = gl_InstanceID - (yIndex * gridSize[0]);

  vec2 instancePositionXFP64 = mul_fp64(vec2(gridOffset[0], gridOffsetLow[0]), vec2(float(xIndex), 0.));
  instancePositionXFP64 = sum_fp64(instancePositionXFP64, vec2(gridOrigin[0], gridOriginLow[0]));
  vec2 instancePositionYFP64 = mul_fp64(vec2(gridOffset[1], gridOffsetLow[1]), vec2(float(yIndex), 0.));
  instancePositionYFP64 = sum_fp64(instancePositionYFP64, vec2(gridOrigin[1], gridOriginLow[1]));

  vec3 centroidPosition = vec3(instancePositionXFP64[0], instancePositionYFP64[0], elevation);
  vec3 centroidPosition64Low = vec3(instancePositionXFP64[1], instancePositionYFP64[1], 0.0);
  geometry.worldPosition = centroidPosition;
  vec3 pos = vec3(project_size(positions.xy + offset) * dotRadius, 0.);

  // Set color to be rendered to picking fbo (also used to check for selection highlight).
  picking_setPickingColor(instancePickingColors);

  gl_Position = project_position_to_clipspace(centroidPosition, centroidPosition64Low, pos, geometry.position);

  // Light calculations
  // Worldspace is the linear space after Mercator projection

  vec3 normals_commonspace = project_normal(normals);

   if (extruded) {
    vec3 lightColor = lighting_getLightColor(color.rgb, project_uCameraPosition, geometry.position.xyz, normals_commonspace);
    vColor = vec4(lightColor, color.a * opacity) / 255.;
  } else {
    vColor = vec4(color.rgb, color.a * opacity) / 255.;
  }
}
`;

  // src/gpu-grid-layer/gpu-grid-cell-layer-fragment.glsl.ts
  var gpu_grid_cell_layer_fragment_glsl_default = `#version 300 es
#define SHADER_NAME gpu-grid-cell-layer-fragment-shader

precision highp float;

in vec4 vColor;

out vec4 fragColor;

void main(void) {
  fragColor = vColor;
  fragColor = picking_filterColor(fragColor);
}
`;

  // src/gpu-grid-layer/gpu-grid-cell-layer.ts
  var COLOR_DATA_UBO_INDEX = 0;
  var ELEVATION_DATA_UBO_INDEX = 1;
  var defaultProps7 = {
    colorDomain: null,
    colorRange: defaultColorRange,
    elevationDomain: null,
    elevationRange: [0, 1e3],
    elevationScale: {
      type: "number",
      min: 0,
      value: 1
    },
    gridSize: {
      type: "array",
      value: [1, 1]
    },
    gridOrigin: {
      type: "array",
      value: [0, 0]
    },
    gridOffset: {
      type: "array",
      value: [0, 0]
    },
    cellSize: {
      type: "number",
      min: 0,
      max: 1e3,
      value: 1e3
    },
    offset: {
      type: "array",
      value: [1, 1]
    },
    coverage: {
      type: "number",
      min: 0,
      max: 1,
      value: 1
    },
    extruded: true,
    material: true
  };
  var GPUGridCellLayer = class extends import_core18.Layer {
    getShaders() {
      return super.getShaders({
        vs: gpu_grid_cell_layer_vertex_glsl_default,
        fs: gpu_grid_cell_layer_fragment_glsl_default,
        modules: [import_core18.project32, import_core18.gouraudLighting, import_core18.picking, fp64arithmetic]
      });
    }
    initializeState({
      gl
    }) {
      const attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        colors: {
          size: 4,
          noAlloc: true
        },
        elevations: {
          size: 4,
          noAlloc: true
        }
      });
      const model = this._getModel(gl);
      this._setupUniformBuffer(model);
      this.setState({
        model
      });
    }
    _getModel(gl) {
      return new import_core19.Model(gl, {
        ...this.getShaders(),
        id: this.props.id,
        geometry: new import_core19.CubeGeometry(),
        isInstanced: true
      });
    }
    draw({
      uniforms
    }) {
      const {
        cellSize,
        offset,
        extruded,
        elevationScale,
        coverage,
        gridSize,
        gridOrigin,
        gridOffset,
        elevationRange,
        colorMaxMinBuffer,
        elevationMaxMinBuffer
      } = this.props;
      const gridOriginLow = [(0, import_core18.fp64LowPart)(gridOrigin[0]), (0, import_core18.fp64LowPart)(gridOrigin[1])];
      const gridOffsetLow = [(0, import_core18.fp64LowPart)(gridOffset[0]), (0, import_core18.fp64LowPart)(gridOffset[1])];
      const domainUniforms = this.getDomainUniforms();
      const colorRange = colorRangeToFlatArray(this.props.colorRange);
      this.bindUniformBuffers(colorMaxMinBuffer, elevationMaxMinBuffer);
      this.state.model.setUniforms(uniforms).setUniforms(domainUniforms).setUniforms({
        cellSize,
        offset,
        extruded,
        elevationScale,
        coverage,
        gridSize,
        gridOrigin,
        gridOriginLow,
        gridOffset,
        gridOffsetLow,
        colorRange,
        elevationRange
      }).draw();
      this.unbindUniformBuffers(colorMaxMinBuffer, elevationMaxMinBuffer);
    }
    bindUniformBuffers(colorMaxMinBuffer, elevationMaxMinBuffer) {
      colorMaxMinBuffer.bind({
        target: esm_default.UNIFORM_BUFFER,
        index: COLOR_DATA_UBO_INDEX
      });
      elevationMaxMinBuffer.bind({
        target: esm_default.UNIFORM_BUFFER,
        index: ELEVATION_DATA_UBO_INDEX
      });
    }
    unbindUniformBuffers(colorMaxMinBuffer, elevationMaxMinBuffer) {
      colorMaxMinBuffer.unbind({
        target: esm_default.UNIFORM_BUFFER,
        index: COLOR_DATA_UBO_INDEX
      });
      elevationMaxMinBuffer.unbind({
        target: esm_default.UNIFORM_BUFFER,
        index: ELEVATION_DATA_UBO_INDEX
      });
    }
    getDomainUniforms() {
      const {
        colorDomain,
        elevationDomain
      } = this.props;
      const domainUniforms = {};
      if (colorDomain !== null) {
        domainUniforms.colorDomainValid = true;
        domainUniforms.colorDomain = colorDomain;
      } else {
        domainUniforms.colorDomainValid = false;
      }
      if (elevationDomain !== null) {
        domainUniforms.elevationDomainValid = true;
        domainUniforms.elevationDomain = elevationDomain;
      } else {
        domainUniforms.elevationDomainValid = false;
      }
      return domainUniforms;
    }
    _setupUniformBuffer(model) {
      const gl = this.context.gl;
      const programHandle = model.program.handle;
      const colorIndex = gl.getUniformBlockIndex(programHandle, "ColorData");
      const elevationIndex = gl.getUniformBlockIndex(programHandle, "ElevationData");
      gl.uniformBlockBinding(programHandle, colorIndex, COLOR_DATA_UBO_INDEX);
      gl.uniformBlockBinding(programHandle, elevationIndex, ELEVATION_DATA_UBO_INDEX);
    }
  };
  __publicField(GPUGridCellLayer, "layerName", "GPUGridCellLayer");
  __publicField(GPUGridCellLayer, "defaultProps", defaultProps7);

  // src/gpu-grid-layer/gpu-grid-layer.ts
  var defaultProps8 = {
    colorDomain: null,
    colorRange: defaultColorRange,
    getColorWeight: {
      type: "accessor",
      value: 1
    },
    colorAggregation: "SUM",
    elevationDomain: null,
    elevationRange: [0, 1e3],
    getElevationWeight: {
      type: "accessor",
      value: 1
    },
    elevationAggregation: "SUM",
    elevationScale: {
      type: "number",
      min: 0,
      value: 1
    },
    cellSize: {
      type: "number",
      min: 1,
      max: 1e3,
      value: 1e3
    },
    coverage: {
      type: "number",
      min: 0,
      max: 1,
      value: 1
    },
    getPosition: {
      type: "accessor",
      value: (x) => x.position
    },
    extruded: false,
    material: true
  };
  var DIMENSIONS3 = {
    data: {
      props: ["cellSize", "colorAggregation", "elevationAggregation"]
    }
  };
  var POSITION_ATTRIBUTE_NAME3 = "positions";
  var GPUGridLayer = class extends GridAggregationLayer {
    initializeState({
      gl
    }) {
      const isSupported = GPUGridAggregator.isSupported(gl);
      if (!isSupported) {
        import_core21.log.error("GPUGridLayer is not supported on this browser, use GridLayer instead")();
      }
      super.initializeAggregationLayer({
        dimensions: DIMENSIONS3
      });
      this.setState({
        gpuAggregation: true,
        projectPoints: false,
        isSupported,
        weights: {
          color: {
            needMin: true,
            needMax: true,
            combineMaxMin: true,
            maxMinBuffer: new import_core20.Buffer(gl, {
              byteLength: 4 * 4,
              accessor: {
                size: 4,
                type: esm_default.FLOAT,
                divisor: 1
              }
            })
          },
          elevation: {
            needMin: true,
            needMax: true,
            combineMaxMin: true,
            maxMinBuffer: new import_core20.Buffer(gl, {
              byteLength: 4 * 4,
              accessor: {
                size: 4,
                type: esm_default.FLOAT,
                divisor: 1
              }
            })
          }
        },
        positionAttributeName: "positions"
      });
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        [POSITION_ATTRIBUTE_NAME3]: {
          size: 3,
          accessor: "getPosition",
          type: esm_default.DOUBLE,
          fp64: this.use64bitPositions()
        },
        color: {
          size: 3,
          accessor: "getColorWeight"
        },
        elevation: {
          size: 3,
          accessor: "getElevationWeight"
        }
      });
    }
    updateState(opts) {
      if (this.state.isSupported === false) {
        return;
      }
      super.updateState(opts);
      const {
        aggregationDirty
      } = this.state;
      if (aggregationDirty) {
        this.setState({
          gridHash: null
        });
      }
    }
    getHashKeyForIndex(index) {
      const {
        numRow,
        numCol,
        boundingBox,
        gridOffset
      } = this.state;
      const gridSize = [numCol, numRow];
      const gridOrigin = [boundingBox.xMin, boundingBox.yMin];
      const cellSize = [gridOffset.xOffset, gridOffset.yOffset];
      const yIndex = Math.floor(index / gridSize[0]);
      const xIndex = index - yIndex * gridSize[0];
      const latIdx = Math.floor((yIndex * cellSize[1] + gridOrigin[1] + 90 + cellSize[1] / 2) / cellSize[1]);
      const lonIdx = Math.floor((xIndex * cellSize[0] + gridOrigin[0] + 180 + cellSize[0] / 2) / cellSize[0]);
      return `${latIdx}-${lonIdx}`;
    }
    getPositionForIndex(index) {
      const {
        numRow,
        numCol,
        boundingBox,
        gridOffset
      } = this.state;
      const gridSize = [numCol, numRow];
      const gridOrigin = [boundingBox.xMin, boundingBox.yMin];
      const cellSize = [gridOffset.xOffset, gridOffset.yOffset];
      const yIndex = Math.floor(index / gridSize[0]);
      const xIndex = index - yIndex * gridSize[0];
      const yPos = yIndex * cellSize[1] + gridOrigin[1];
      const xPos = xIndex * cellSize[0] + gridOrigin[0];
      return [xPos, yPos];
    }
    getPickingInfo({
      info,
      mode
    }) {
      const {
        index
      } = info;
      let object = null;
      if (index >= 0) {
        const {
          gpuGridAggregator
        } = this.state;
        const position = this.getPositionForIndex(index);
        const colorInfo = GPUGridAggregator.getAggregationData({
          pixelIndex: index,
          ...gpuGridAggregator.getData("color")
        });
        const elevationInfo = GPUGridAggregator.getAggregationData({
          pixelIndex: index,
          ...gpuGridAggregator.getData("elevation")
        });
        object = {
          colorValue: colorInfo.cellWeight,
          elevationValue: elevationInfo.cellWeight,
          count: colorInfo.cellCount || elevationInfo.cellCount,
          position,
          totalCount: colorInfo.totalCount || elevationInfo.totalCount
        };
        if (mode !== "hover") {
          const {
            props
          } = this;
          let {
            gridHash
          } = this.state;
          if (!gridHash) {
            const {
              gridOffset,
              translation,
              boundingBox
            } = this.state;
            const {
              viewport
            } = this.context;
            const attributes = this.getAttributes();
            const cpuAggregation = pointToDensityGridDataCPU(props, {
              gridOffset,
              attributes,
              viewport,
              translation,
              boundingBox
            });
            gridHash = cpuAggregation.gridHash;
            this.setState({
              gridHash
            });
          }
          const key = this.getHashKeyForIndex(index);
          const cpuAggregationData = gridHash[key];
          Object.assign(object, cpuAggregationData);
        }
      }
      info.picked = Boolean(object);
      info.object = object;
      return info;
    }
    renderLayers() {
      if (!this.state.isSupported) {
        return null;
      }
      const {
        elevationScale,
        extruded,
        cellSize: cellSizeMeters,
        coverage,
        material,
        elevationRange,
        colorDomain,
        elevationDomain
      } = this.props;
      const {
        weights,
        numRow,
        numCol,
        gridOrigin,
        gridOffset
      } = this.state;
      const {
        color,
        elevation
      } = weights;
      const colorRange = colorRangeToFlatArray(this.props.colorRange);
      const SubLayerClass = this.getSubLayerClass("gpu-grid-cell", GPUGridCellLayer);
      return new SubLayerClass({
        gridSize: [numCol, numRow],
        gridOrigin,
        gridOffset: [gridOffset.xOffset, gridOffset.yOffset],
        colorRange,
        elevationRange,
        colorDomain,
        elevationDomain,
        cellSize: cellSizeMeters,
        coverage,
        material,
        elevationScale,
        extruded
      }, this.getSubLayerProps({
        id: "gpu-grid-cell"
      }), {
        data: {
          attributes: {
            colors: color.aggregationBuffer,
            elevations: elevation.aggregationBuffer
          }
        },
        colorMaxMinBuffer: color.maxMinBuffer,
        elevationMaxMinBuffer: elevation.maxMinBuffer,
        numInstances: numCol * numRow
      });
    }
    finalizeState(context) {
      const {
        color,
        elevation
      } = this.state.weights;
      [color, elevation].forEach((weight) => {
        const {
          aggregationBuffer,
          maxMinBuffer
        } = weight;
        maxMinBuffer.delete();
        aggregationBuffer?.delete();
      });
      super.finalizeState(context);
    }
    updateAggregationState(opts) {
      const {
        props,
        oldProps
      } = opts;
      const {
        cellSize,
        coordinateSystem
      } = props;
      const {
        viewport
      } = this.context;
      const cellSizeChanged = oldProps.cellSize !== cellSize;
      const {
        dimensions
      } = this.state;
      const positionsChanged = this.isAttributeChanged(POSITION_ATTRIBUTE_NAME3);
      const attributesChanged = positionsChanged || this.isAttributeChanged();
      let {
        boundingBox
      } = this.state;
      if (positionsChanged) {
        boundingBox = getBoundingBox(this.getAttributes(), this.getNumInstances());
        this.setState({
          boundingBox
        });
      }
      if (positionsChanged || cellSizeChanged) {
        const {
          gridOffset,
          translation,
          width,
          height,
          numCol,
          numRow
        } = getGridParams(boundingBox, cellSize, viewport, coordinateSystem);
        this.allocateResources(numRow, numCol);
        this.setState({
          gridOffset,
          translation,
          gridOrigin: [-1 * translation[0], -1 * translation[1]],
          width,
          height,
          numCol,
          numRow
        });
      }
      const aggregationDataDirty = attributesChanged || this.isAggregationDirty(opts, {
        dimension: dimensions.data,
        compareAll: true
      });
      if (aggregationDataDirty) {
        this._updateAccessors(opts);
      }
      this.setState({
        aggregationDataDirty
      });
    }
    _updateAccessors(opts) {
      const {
        colorAggregation,
        elevationAggregation
      } = opts.props;
      const {
        color,
        elevation
      } = this.state.weights;
      color.operation = AGGREGATION_OPERATION[colorAggregation];
      elevation.operation = AGGREGATION_OPERATION[elevationAggregation];
    }
  };
  __publicField(GPUGridLayer, "layerName", "GPUGridLayer");
  __publicField(GPUGridLayer, "defaultProps", defaultProps8);

  // src/grid-layer/grid-layer.ts
  var defaultProps9 = {
    ...GPUGridLayer.defaultProps,
    ...CPUGridLayer.defaultProps,
    gpuAggregation: false
  };
  var GridLayer = class extends import_core22.CompositeLayer {
    initializeState() {
      this.state = {
        useGPUAggregation: true
      };
    }
    updateState({
      props
    }) {
      this.setState({
        useGPUAggregation: this.canUseGPUAggregation(props)
      });
    }
    renderLayers() {
      const {
        data,
        updateTriggers
      } = this.props;
      const id = this.state.useGPUAggregation ? "GPU" : "CPU";
      const LayerType = this.state.useGPUAggregation ? this.getSubLayerClass("GPU", GPUGridLayer) : this.getSubLayerClass("CPU", CPUGridLayer);
      return new LayerType(this.props, this.getSubLayerProps({
        id,
        updateTriggers
      }), {
        data
      });
    }
    canUseGPUAggregation(props) {
      const {
        gpuAggregation,
        lowerPercentile,
        upperPercentile,
        getColorValue,
        getElevationValue,
        colorScaleType
      } = props;
      if (!gpuAggregation) {
        return false;
      }
      if (!GPUGridAggregator.isSupported(this.context.gl)) {
        return false;
      }
      if (lowerPercentile !== 0 || upperPercentile !== 100) {
        return false;
      }
      if (getColorValue !== null || getElevationValue !== null) {
        return false;
      }
      if (colorScaleType === "quantile" || colorScaleType === "ordinal") {
        return false;
      }
      return true;
    }
  };
  __publicField(GridLayer, "layerName", "GridLayer");
  __publicField(GridLayer, "defaultProps", defaultProps9);

  // src/heatmap-layer/heatmap-layer-utils.ts
  var import_core23 = __toESM(require_core2());
  function getBounds(points) {
    const x = points.map((p) => p[0]);
    const y = points.map((p) => p[1]);
    const xMin = Math.min.apply(null, x);
    const xMax = Math.max.apply(null, x);
    const yMin = Math.min.apply(null, y);
    const yMax = Math.max.apply(null, y);
    return [xMin, yMin, xMax, yMax];
  }
  function boundsContain(currentBounds, targetBounds) {
    if (targetBounds[0] >= currentBounds[0] && targetBounds[2] <= currentBounds[2] && targetBounds[1] >= currentBounds[1] && targetBounds[3] <= currentBounds[3]) {
      return true;
    }
    return false;
  }
  var scratchArray = new Float32Array(12);
  function packVertices(points, dimensions = 2) {
    let index = 0;
    for (const point of points) {
      for (let i = 0; i < dimensions; i++) {
        scratchArray[index++] = point[i] || 0;
      }
    }
    return scratchArray;
  }
  function scaleToAspectRatio(boundingBox, width, height) {
    const [xMin, yMin, xMax, yMax] = boundingBox;
    const currentWidth = xMax - xMin;
    const currentHeight = yMax - yMin;
    let newWidth = currentWidth;
    let newHeight = currentHeight;
    if (currentWidth / currentHeight < width / height) {
      newWidth = width / height * currentHeight;
    } else {
      newHeight = height / width * currentWidth;
    }
    if (newWidth < width) {
      newWidth = width;
      newHeight = height;
    }
    const xCenter = (xMax + xMin) / 2;
    const yCenter = (yMax + yMin) / 2;
    return [xCenter - newWidth / 2, yCenter - newHeight / 2, xCenter + newWidth / 2, yCenter + newHeight / 2];
  }
  function getTextureCoordinates(point, bounds) {
    const [xMin, yMin, xMax, yMax] = bounds;
    return [(point[0] - xMin) / (xMax - xMin), (point[1] - yMin) / (yMax - yMin)];
  }
  function getTextureParams({
    gl,
    floatTargetSupport
  }) {
    return floatTargetSupport ? {
      format: (0, import_core23.isWebGL2)(gl) ? esm_default.RGBA32F : esm_default.RGBA,
      type: esm_default.FLOAT
    } : {
      format: esm_default.RGBA,
      type: esm_default.UNSIGNED_BYTE
    };
  }

  // src/heatmap-layer/heatmap-layer.ts
  var import_core26 = __toESM(require_core2());
  var import_core27 = __toESM(require_core());

  // src/heatmap-layer/triangle-layer.ts
  var import_core24 = __toESM(require_core2());
  var import_core25 = __toESM(require_core());

  // src/heatmap-layer/triangle-layer-vertex.glsl.ts
  var triangle_layer_vertex_glsl_default = `#define SHADER_NAME heatp-map-layer-vertex-shader

uniform sampler2D maxTexture;
uniform float intensity;
uniform vec2 colorDomain;
uniform float threshold;
uniform float aggregationMode;

attribute vec3 positions;
attribute vec2 texCoords;

varying vec2 vTexCoords;
varying float vIntensityMin;
varying float vIntensityMax;

void main(void) {
  gl_Position = project_position_to_clipspace(positions, vec3(0.0), vec3(0.0));
  vTexCoords = texCoords;
  vec4 maxTexture = texture2D(maxTexture, vec2(0.5));
  float maxValue = aggregationMode < 0.5 ? maxTexture.r : maxTexture.g;
  float minValue = maxValue * threshold;
  if (colorDomain[1] > 0.) {
    // if user specified custom domain use it.
    maxValue = colorDomain[1];
    minValue = colorDomain[0];
  }
  vIntensityMax = intensity / maxValue;
  vIntensityMin = intensity / minValue;
}
`;

  // src/heatmap-layer/triangle-layer-fragment.glsl.ts
  var triangle_layer_fragment_glsl_default = `#define SHADER_NAME triangle-layer-fragment-shader

precision highp float;

uniform float opacity;
uniform sampler2D texture;
uniform sampler2D colorTexture;
uniform float aggregationMode;

varying vec2 vTexCoords;
varying float vIntensityMin;
varying float vIntensityMax;

vec4 getLinearColor(float value) {
  float factor = clamp(value * vIntensityMax, 0., 1.);
  vec4 color = texture2D(colorTexture, vec2(factor, 0.5));
  color.a *= min(value * vIntensityMin, 1.0);
  return color;
}

void main(void) {
  vec4 weights = texture2D(texture, vTexCoords);
  float weight = weights.r;

  if (aggregationMode > 0.5) {
    weight /= max(1.0, weights.a);
  }

  // discard pixels with 0 weight.
  if (weight <= 0.) {
     discard;
  }

  vec4 linearColor = getLinearColor(weight);
  linearColor.a *= opacity;
  gl_FragColor =linearColor;
}
`;

  // src/heatmap-layer/triangle-layer.ts
  var TriangleLayer = class extends import_core25.Layer {
    getShaders() {
      return {
        vs: triangle_layer_vertex_glsl_default,
        fs: triangle_layer_fragment_glsl_default,
        modules: [import_core25.project32]
      };
    }
    initializeState({
      gl
    }) {
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          noAlloc: true
        },
        texCoords: {
          size: 2,
          noAlloc: true
        }
      });
      this.setState({
        model: this._getModel(gl)
      });
    }
    _getModel(gl) {
      const {
        vertexCount
      } = this.props;
      return new import_core24.Model(gl, {
        ...this.getShaders(),
        id: this.props.id,
        geometry: new import_core24.Geometry({
          drawMode: esm_default.TRIANGLE_FAN,
          vertexCount
        })
      });
    }
    draw({
      uniforms
    }) {
      const {
        model
      } = this.state;
      const {
        texture,
        maxTexture,
        colorTexture,
        intensity,
        threshold: threshold2,
        aggregationMode,
        colorDomain
      } = this.props;
      model.setUniforms({
        ...uniforms,
        texture,
        maxTexture,
        colorTexture,
        intensity,
        threshold: threshold2,
        aggregationMode,
        colorDomain
      }).draw();
    }
  };
  __publicField(TriangleLayer, "layerName", "TriangleLayer");

  // src/heatmap-layer/weights-vs.glsl.ts
  var weights_vs_glsl_default = `attribute vec3 positions;
attribute vec3 positions64Low;
attribute float weights;
varying vec4 weightsTexture;
uniform float radiusPixels;
uniform float textureWidth;
uniform vec4 commonBounds;
uniform float weightsScale;
void main()
{
  weightsTexture = vec4(weights * weightsScale, 0., 0., 1.);

  float radiusTexels  = project_pixel_size(radiusPixels) * textureWidth / (commonBounds.z - commonBounds.x);
  gl_PointSize = radiusTexels * 2.;

  vec3 commonPosition = project_position(positions, positions64Low);

  // map xy from commonBounds to [-1, 1]
  gl_Position.xy = (commonPosition.xy - commonBounds.xy) / (commonBounds.zw - commonBounds.xy) ;
  gl_Position.xy = (gl_Position.xy * 2.) - (1.);
}
`;

  // src/heatmap-layer/weights-fs.glsl.ts
  var weights_fs_glsl_default = `varying vec4 weightsTexture;
// Epanechnikov function, keeping for reference
// float epanechnikovKDE(float u) {
//   return 0.75 * (1.0 - u * u);
// }
float gaussianKDE(float u){
  return pow(2.71828, -u*u/0.05555)/(1.77245385*0.166666);
}
void main()
{
  float dist = length(gl_PointCoord - vec2(0.5, 0.5));
  if (dist > 0.5) {
    discard;
  }
  gl_FragColor = weightsTexture * gaussianKDE(2. * dist);
  DECKGL_FILTER_COLOR(gl_FragColor, geometry);
}
`;

  // src/heatmap-layer/max-vs.glsl.ts
  var max_vs_glsl_default = `attribute vec4 inTexture;
varying vec4 outTexture;

void main()
{
outTexture = inTexture;
gl_Position = vec4(0, 0, 0, 1.);
// Enforce default value for ANGLE issue (https://bugs.chromium.org/p/angleproject/issues/detail?id=3941)
gl_PointSize = 1.0;
}
`;

  // src/heatmap-layer/max-fs.glsl.ts
  var max_fs_glsl_default = `varying vec4 outTexture;
void main() {
  gl_FragColor = outTexture;
  gl_FragColor.g = outTexture.r / max(1.0, outTexture.a);
}
`;

  // src/heatmap-layer/heatmap-layer.ts
  var RESOLUTION = 2;
  var TEXTURE_OPTIONS = {
    mipmaps: false,
    parameters: {
      [esm_default.TEXTURE_MAG_FILTER]: esm_default.LINEAR,
      [esm_default.TEXTURE_MIN_FILTER]: esm_default.LINEAR,
      [esm_default.TEXTURE_WRAP_S]: esm_default.CLAMP_TO_EDGE,
      [esm_default.TEXTURE_WRAP_T]: esm_default.CLAMP_TO_EDGE
    },
    dataFormat: esm_default.RGBA
  };
  var DEFAULT_COLOR_DOMAIN = [0, 0];
  var AGGREGATION_MODE = {
    SUM: 0,
    MEAN: 1
  };
  var defaultProps10 = {
    getPosition: {
      type: "accessor",
      value: (x) => x.position
    },
    getWeight: {
      type: "accessor",
      value: 1
    },
    intensity: {
      type: "number",
      min: 0,
      value: 1
    },
    radiusPixels: {
      type: "number",
      min: 1,
      max: 100,
      value: 50
    },
    colorRange: defaultColorRange,
    threshold: {
      type: "number",
      min: 0,
      max: 1,
      value: 0.05
    },
    colorDomain: {
      type: "array",
      value: null,
      optional: true
    },
    aggregation: "SUM",
    weightsTextureSize: {
      type: "number",
      min: 128,
      max: 2048,
      value: 2048
    },
    debounceTimeout: {
      type: "number",
      min: 0,
      max: 1e3,
      value: 500
    }
  };
  var REQUIRED_FEATURES2 = [
    import_core26.FEATURES.BLEND_EQUATION_MINMAX,
    import_core26.FEATURES.TEXTURE_FLOAT
  ];
  var FLOAT_TARGET_FEATURES = [
    import_core26.FEATURES.COLOR_ATTACHMENT_RGBA32F,
    import_core26.FEATURES.FLOAT_BLEND
  ];
  var DIMENSIONS4 = {
    data: {
      props: ["radiusPixels"]
    }
  };
  var HeatmapLayer = class extends AggregationLayer {
    initializeState() {
      const {
        gl
      } = this.context;
      if (!(0, import_core26.hasFeatures)(gl, REQUIRED_FEATURES2)) {
        this.setState({
          supported: false
        });
        import_core27.log.error(`HeatmapLayer: ${this.id} is not supported on this browser`)();
        return;
      }
      super.initializeAggregationLayer(DIMENSIONS4);
      this.setState({
        supported: true,
        colorDomain: DEFAULT_COLOR_DOMAIN
      });
      this._setupTextureParams();
      this._setupAttributes();
      this._setupResources();
    }
    shouldUpdateState({
      changeFlags
    }) {
      return changeFlags.somethingChanged;
    }
    updateState(opts) {
      if (!this.state.supported) {
        return;
      }
      super.updateState(opts);
      this._updateHeatmapState(opts);
    }
    _updateHeatmapState(opts) {
      const {
        props,
        oldProps
      } = opts;
      const changeFlags = this._getChangeFlags(opts);
      if (changeFlags.dataChanged || changeFlags.viewportChanged) {
        changeFlags.boundsChanged = this._updateBounds(changeFlags.dataChanged);
        this._updateTextureRenderingBounds();
      }
      if (changeFlags.dataChanged || changeFlags.boundsChanged) {
        clearTimeout(this.state.updateTimer);
        this.setState({
          isWeightMapDirty: true
        });
      } else if (changeFlags.viewportZoomChanged) {
        this._debouncedUpdateWeightmap();
      }
      if (props.colorRange !== oldProps.colorRange) {
        this._updateColorTexture(opts);
      }
      if (this.state.isWeightMapDirty) {
        this._updateWeightmap();
      }
      this.setState({
        zoom: opts.context.viewport.zoom
      });
    }
    renderLayers() {
      if (!this.state.supported) {
        return [];
      }
      const {
        weightsTexture,
        triPositionBuffer,
        triTexCoordBuffer,
        maxWeightsTexture,
        colorTexture,
        colorDomain
      } = this.state;
      const {
        updateTriggers,
        intensity,
        threshold: threshold2,
        aggregation
      } = this.props;
      const TriangleLayerClass = this.getSubLayerClass("triangle", TriangleLayer);
      return new TriangleLayerClass(this.getSubLayerProps({
        id: "triangle-layer",
        updateTriggers
      }), {
        coordinateSystem: import_core27.COORDINATE_SYSTEM.DEFAULT,
        data: {
          attributes: {
            positions: triPositionBuffer,
            texCoords: triTexCoordBuffer
          }
        },
        vertexCount: 4,
        maxTexture: maxWeightsTexture,
        colorTexture,
        aggregationMode: AGGREGATION_MODE[aggregation] || 0,
        texture: weightsTexture,
        intensity,
        threshold: threshold2,
        colorDomain
      });
    }
    finalizeState(context) {
      super.finalizeState(context);
      const {
        weightsTransform,
        weightsTexture,
        maxWeightTransform,
        maxWeightsTexture,
        triPositionBuffer,
        triTexCoordBuffer,
        colorTexture,
        updateTimer
      } = this.state;
      weightsTransform?.delete();
      weightsTexture?.delete();
      maxWeightTransform?.delete();
      maxWeightsTexture?.delete();
      triPositionBuffer?.delete();
      triTexCoordBuffer?.delete();
      colorTexture?.delete();
      if (updateTimer) {
        clearTimeout(updateTimer);
      }
    }
    _getAttributeManager() {
      return new import_core27.AttributeManager(this.context.gl, {
        id: this.props.id,
        stats: this.context.stats
      });
    }
    _getChangeFlags(opts) {
      const changeFlags = {};
      const {
        dimensions
      } = this.state;
      changeFlags.dataChanged = this.isAttributeChanged() || this.isAggregationDirty(opts, {
        compareAll: true,
        dimension: dimensions.data
      });
      changeFlags.viewportChanged = opts.changeFlags.viewportChanged;
      const {
        zoom
      } = this.state;
      if (!opts.context.viewport || opts.context.viewport.zoom !== zoom) {
        changeFlags.viewportZoomChanged = true;
      }
      return changeFlags;
    }
    _createTextures() {
      const {
        gl
      } = this.context;
      const {
        textureSize,
        format,
        type
      } = this.state;
      this.setState({
        weightsTexture: new import_core26.Texture2D(gl, {
          width: textureSize,
          height: textureSize,
          format,
          type,
          ...TEXTURE_OPTIONS
        }),
        maxWeightsTexture: new import_core26.Texture2D(gl, {
          format,
          type,
          ...TEXTURE_OPTIONS
        })
      });
    }
    _setupAttributes() {
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          type: esm_default.DOUBLE,
          accessor: "getPosition"
        },
        weights: {
          size: 1,
          accessor: "getWeight"
        }
      });
      this.setState({
        positionAttributeName: "positions"
      });
    }
    _setupTextureParams() {
      const {
        gl
      } = this.context;
      const {
        weightsTextureSize
      } = this.props;
      const textureSize = Math.min(weightsTextureSize, (0, import_core26.getParameters)(gl, gl.MAX_TEXTURE_SIZE));
      const floatTargetSupport = (0, import_core26.hasFeatures)(gl, FLOAT_TARGET_FEATURES);
      const {
        format,
        type
      } = getTextureParams({
        gl,
        floatTargetSupport
      });
      const weightsScale = floatTargetSupport ? 1 : 1 / 255;
      this.setState({
        textureSize,
        format,
        type,
        weightsScale
      });
      if (!floatTargetSupport) {
        import_core27.log.warn(`HeatmapLayer: ${this.id} rendering to float texture not supported, fallingback to low precession format`)();
      }
    }
    getShaders(type) {
      return super.getShaders(type === "max-weights-transform" ? {
        vs: max_vs_glsl_default,
        _fs: max_fs_glsl_default
      } : {
        vs: weights_vs_glsl_default,
        _fs: weights_fs_glsl_default
      });
    }
    _createWeightsTransform(shaders = {}) {
      const {
        gl
      } = this.context;
      let {
        weightsTransform
      } = this.state;
      const {
        weightsTexture
      } = this.state;
      weightsTransform?.delete();
      weightsTransform = new import_core26.Transform(gl, {
        id: `${this.id}-weights-transform`,
        elementCount: 1,
        _targetTexture: weightsTexture,
        _targetTextureVarying: "weightsTexture",
        ...shaders
      });
      this.setState({
        weightsTransform
      });
    }
    _setupResources() {
      const {
        gl
      } = this.context;
      this._createTextures();
      const {
        textureSize,
        weightsTexture,
        maxWeightsTexture
      } = this.state;
      const weightsTransformShaders = this.getShaders("weights-transform");
      this._createWeightsTransform(weightsTransformShaders);
      const maxWeightsTransformShaders = this.getShaders("max-weights-transform");
      const maxWeightTransform = new import_core26.Transform(gl, {
        id: `${this.id}-max-weights-transform`,
        _sourceTextures: {
          inTexture: weightsTexture
        },
        _targetTexture: maxWeightsTexture,
        _targetTextureVarying: "outTexture",
        ...maxWeightsTransformShaders,
        elementCount: textureSize * textureSize
      });
      this.setState({
        weightsTexture,
        maxWeightsTexture,
        maxWeightTransform,
        zoom: null,
        triPositionBuffer: new import_core26.Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 3
          }
        }),
        triTexCoordBuffer: new import_core26.Buffer(gl, {
          byteLength: 48,
          accessor: {
            size: 2
          }
        })
      });
    }
    updateShaders(shaderOptions) {
      this._createWeightsTransform(shaderOptions);
    }
    _updateMaxWeightValue() {
      const {
        maxWeightTransform
      } = this.state;
      maxWeightTransform.run({
        parameters: {
          blend: true,
          depthTest: false,
          blendFunc: [esm_default.ONE, esm_default.ONE],
          blendEquation: esm_default.MAX
        }
      });
    }
    _updateBounds(forceUpdate = false) {
      const {
        viewport
      } = this.context;
      const viewportCorners = [viewport.unproject([0, 0]), viewport.unproject([viewport.width, 0]), viewport.unproject([viewport.width, viewport.height]), viewport.unproject([0, viewport.height])].map((p) => p.map(Math.fround));
      const visibleWorldBounds = getBounds(viewportCorners);
      const newState = {
        visibleWorldBounds,
        viewportCorners
      };
      let boundsChanged = false;
      if (forceUpdate || !this.state.worldBounds || !boundsContain(this.state.worldBounds, visibleWorldBounds)) {
        const scaledCommonBounds = this._worldToCommonBounds(visibleWorldBounds);
        const worldBounds = this._commonToWorldBounds(scaledCommonBounds);
        if (this.props.coordinateSystem === import_core27.COORDINATE_SYSTEM.LNGLAT) {
          worldBounds[1] = Math.max(worldBounds[1], -85.051129);
          worldBounds[3] = Math.min(worldBounds[3], 85.051129);
          worldBounds[0] = Math.max(worldBounds[0], -360);
          worldBounds[2] = Math.min(worldBounds[2], 360);
        }
        const normalizedCommonBounds = this._worldToCommonBounds(worldBounds);
        newState.worldBounds = worldBounds;
        newState.normalizedCommonBounds = normalizedCommonBounds;
        boundsChanged = true;
      }
      this.setState(newState);
      return boundsChanged;
    }
    _updateTextureRenderingBounds() {
      const {
        triPositionBuffer,
        triTexCoordBuffer,
        normalizedCommonBounds,
        viewportCorners
      } = this.state;
      const {
        viewport
      } = this.context;
      triPositionBuffer.subData(packVertices(viewportCorners, 3));
      const textureBounds = viewportCorners.map((p) => getTextureCoordinates(viewport.projectPosition(p), normalizedCommonBounds));
      triTexCoordBuffer.subData(packVertices(textureBounds, 2));
    }
    _updateColorTexture(opts) {
      const {
        colorRange
      } = opts.props;
      let {
        colorTexture
      } = this.state;
      const colors = colorRangeToFlatArray(colorRange, false, Uint8Array);
      if (colorTexture) {
        colorTexture.setImageData({
          data: colors,
          width: colorRange.length
        });
      } else {
        colorTexture = new import_core26.Texture2D(this.context.gl, {
          data: colors,
          width: colorRange.length,
          height: 1,
          ...TEXTURE_OPTIONS
        });
      }
      this.setState({
        colorTexture
      });
    }
    _updateWeightmap() {
      const {
        radiusPixels,
        colorDomain,
        aggregation
      } = this.props;
      const {
        weightsTransform,
        worldBounds,
        textureSize,
        weightsTexture,
        weightsScale
      } = this.state;
      this.state.isWeightMapDirty = false;
      const commonBounds = this._worldToCommonBounds(worldBounds, {
        useLayerCoordinateSystem: true
      });
      if (colorDomain && aggregation === "SUM") {
        const {
          viewport
        } = this.context;
        const metersPerPixel = viewport.distanceScales.metersPerUnit[2] * (commonBounds[2] - commonBounds[0]) / textureSize;
        this.state.colorDomain = colorDomain.map((x) => x * metersPerPixel * weightsScale);
      } else {
        this.state.colorDomain = colorDomain || DEFAULT_COLOR_DOMAIN;
      }
      const uniforms = {
        radiusPixels,
        commonBounds,
        textureWidth: textureSize,
        weightsScale
      };
      weightsTransform.update({
        elementCount: this.getNumInstances()
      });
      (0, import_core26.withParameters)(this.context.gl, {
        clearColor: [0, 0, 0, 0]
      }, () => {
        weightsTransform.run({
          uniforms,
          parameters: {
            blend: true,
            depthTest: false,
            blendFunc: [esm_default.ONE, esm_default.ONE],
            blendEquation: esm_default.FUNC_ADD
          },
          clearRenderTarget: true,
          attributes: this.getAttributes(),
          moduleSettings: this.getModuleSettings()
        });
      });
      this._updateMaxWeightValue();
      weightsTexture.setParameters({
        [esm_default.TEXTURE_MAG_FILTER]: esm_default.LINEAR,
        [esm_default.TEXTURE_MIN_FILTER]: esm_default.LINEAR
      });
    }
    _debouncedUpdateWeightmap(fromTimer = false) {
      let {
        updateTimer
      } = this.state;
      const {
        debounceTimeout
      } = this.props;
      if (fromTimer) {
        updateTimer = null;
        this._updateBounds(true);
        this._updateTextureRenderingBounds();
        this.setState({
          isWeightMapDirty: true
        });
      } else {
        this.setState({
          isWeightMapDirty: false
        });
        clearTimeout(updateTimer);
        updateTimer = setTimeout(this._debouncedUpdateWeightmap.bind(this, true), debounceTimeout);
      }
      this.setState({
        updateTimer
      });
    }
    _worldToCommonBounds(worldBounds, opts = {}) {
      const {
        useLayerCoordinateSystem = false
      } = opts;
      const [minLong, minLat, maxLong, maxLat] = worldBounds;
      const {
        viewport
      } = this.context;
      const {
        textureSize
      } = this.state;
      const {
        coordinateSystem
      } = this.props;
      const offsetMode = useLayerCoordinateSystem && (coordinateSystem === import_core27.COORDINATE_SYSTEM.LNGLAT_OFFSETS || coordinateSystem === import_core27.COORDINATE_SYSTEM.METER_OFFSETS);
      const offsetOriginCommon = offsetMode ? viewport.projectPosition(this.props.coordinateOrigin) : [0, 0];
      const size = textureSize * RESOLUTION / viewport.scale;
      let bottomLeftCommon;
      let topRightCommon;
      if (useLayerCoordinateSystem && !offsetMode) {
        bottomLeftCommon = this.projectPosition([minLong, minLat, 0]);
        topRightCommon = this.projectPosition([maxLong, maxLat, 0]);
      } else {
        bottomLeftCommon = viewport.projectPosition([minLong, minLat, 0]);
        topRightCommon = viewport.projectPosition([maxLong, maxLat, 0]);
      }
      return scaleToAspectRatio([bottomLeftCommon[0] - offsetOriginCommon[0], bottomLeftCommon[1] - offsetOriginCommon[1], topRightCommon[0] - offsetOriginCommon[0], topRightCommon[1] - offsetOriginCommon[1]], size, size);
    }
    _commonToWorldBounds(commonBounds) {
      const [xMin, yMin, xMax, yMax] = commonBounds;
      const {
        viewport
      } = this.context;
      const bottomLeftWorld = viewport.unprojectPosition([xMin, yMin]);
      const topRightWorld = viewport.unprojectPosition([xMax, yMax]);
      return bottomLeftWorld.slice(0, 2).concat(topRightWorld.slice(0, 2));
    }
  };
  __publicField(HeatmapLayer, "layerName", "HeatmapLayer");
  __publicField(HeatmapLayer, "defaultProps", defaultProps10);
  return __toCommonJS(bundle_exports);
})();
      return __exports__;
      });
