"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _triangleLayerVertex = _interopRequireDefault(require("./triangle-layer-vertex.glsl"));

var _triangleLayerFragment = _interopRequireDefault(require("./triangle-layer-fragment.glsl"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var TriangleLayer = function (_Layer) {
  (0, _inherits2.default)(TriangleLayer, _Layer);

  var _super = _createSuper(TriangleLayer);

  function TriangleLayer() {
    (0, _classCallCheck2.default)(this, TriangleLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(TriangleLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        vs: _triangleLayerVertex.default,
        fs: _triangleLayerFragment.default,
        modules: [_core2.project32]
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(_ref) {
      var gl = _ref.gl;
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        positions: {
          size: 3,
          noAlloc: true
        },
        texCoords: {
          size: 2,
          noAlloc: true
        }
      });
      this.setState({
        model: this._getModel(gl)
      });
    }
  }, {
    key: "_getModel",
    value: function _getModel(gl) {
      var vertexCount = this.props.vertexCount;
      return new _core.Model(gl, _objectSpread(_objectSpread({}, this.getShaders()), {}, {
        id: this.props.id,
        geometry: new _core.Geometry({
          drawMode: 6,
          vertexCount: vertexCount
        })
      }));
    }
  }, {
    key: "draw",
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var model = this.state.model;
      var _this$props = this.props,
          texture = _this$props.texture,
          maxTexture = _this$props.maxTexture,
          colorTexture = _this$props.colorTexture,
          intensity = _this$props.intensity,
          threshold = _this$props.threshold,
          aggregationMode = _this$props.aggregationMode,
          colorDomain = _this$props.colorDomain;
      model.setUniforms(_objectSpread(_objectSpread({}, uniforms), {}, {
        texture: texture,
        maxTexture: maxTexture,
        colorTexture: colorTexture,
        intensity: intensity,
        threshold: threshold,
        aggregationMode: aggregationMode,
        colorDomain: colorDomain
      })).draw();
    }
  }]);
  return TriangleLayer;
}(_core2.Layer);

exports.default = TriangleLayer;
(0, _defineProperty2.default)(TriangleLayer, "layerName", 'TriangleLayer');
//# sourceMappingURL=triangle-layer.js.map