import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer, AttributeManager, _compareProps as compareProps } from '@deck.gl/core';
import { cssToDeviceRatio } from '@luma.gl/core';
import { filterProps } from './utils/prop-utils';
export default class AggregationLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeAggregationLayer(dimensions) {
    super.initializeState(this.context);
    this.setState({
      ignoreProps: filterProps(this.constructor._propTypes, dimensions.data.props),
      dimensions
    });
  }

  updateState(opts) {
    super.updateState(opts);
    const {
      changeFlags
    } = opts;

    if (changeFlags.extensionsChanged) {
      const shaders = this.getShaders({});

      if (shaders && shaders.defines) {
        shaders.defines.NON_INSTANCED_MODEL = 1;
      }

      this.updateShaders(shaders);
    }

    this._updateAttributes();
  }

  updateAttributes(changedAttributes) {
    this.setState({
      changedAttributes
    });
  }

  getAttributes() {
    return this.getAttributeManager().getShaderAttributes();
  }

  getModuleSettings() {
    const {
      viewport,
      mousePosition,
      gl
    } = this.context;
    const moduleSettings = Object.assign(Object.create(this.props), {
      viewport,
      mousePosition,
      pickingActive: 0,
      devicePixelRatio: cssToDeviceRatio(gl)
    });
    return moduleSettings;
  }

  updateShaders(shaders) {}

  isAggregationDirty(updateOpts, params = {}) {
    const {
      props,
      oldProps,
      changeFlags
    } = updateOpts;
    const {
      compareAll = false,
      dimension
    } = params;
    const {
      ignoreProps
    } = this.state;
    const {
      props: dataProps,
      accessors = []
    } = dimension;
    const {
      updateTriggersChanged
    } = changeFlags;

    if (changeFlags.dataChanged) {
      return true;
    }

    if (updateTriggersChanged) {
      if (updateTriggersChanged.all) {
        return true;
      }

      for (const accessor of accessors) {
        if (updateTriggersChanged[accessor]) {
          return true;
        }
      }
    }

    if (compareAll) {
      if (changeFlags.extensionsChanged) {
        return true;
      }

      return compareProps({
        oldProps,
        newProps: props,
        ignoreProps,
        propTypes: this.constructor._propTypes
      });
    }

    for (const name of dataProps) {
      if (props[name] !== oldProps[name]) {
        return true;
      }
    }

    return false;
  }

  isAttributeChanged(name) {
    const {
      changedAttributes
    } = this.state;

    if (!name) {
      return !isObjectEmpty(changedAttributes);
    }

    return changedAttributes && changedAttributes[name] !== undefined;
  }

  _getAttributeManager() {
    return new AttributeManager(this.context.gl, {
      id: this.props.id,
      stats: this.context.stats
    });
  }

}

_defineProperty(AggregationLayer, "layerName", 'AggregationLayer');

function isObjectEmpty(obj) {
  let isEmpty = true;

  for (const key in obj) {
    isEmpty = false;
    break;
  }

  return isEmpty;
}
//# sourceMappingURL=aggregation-layer.js.map