import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { GridCellLayer } from '@deck.gl/layers';
import { defaultColorRange } from '../utils/color-utils';
import { pointToDensityGridDataCPU } from './grid-aggregator';
import CPUAggregator from '../utils/cpu-aggregator';
import AggregationLayer from '../aggregation-layer';

function nop() {}

const defaultProps = {
  colorDomain: null,
  colorRange: defaultColorRange,
  getColorValue: {
    type: 'accessor',
    value: null
  },
  getColorWeight: {
    type: 'accessor',
    value: 1
  },
  colorAggregation: 'SUM',
  lowerPercentile: {
    type: 'number',
    min: 0,
    max: 100,
    value: 0
  },
  upperPercentile: {
    type: 'number',
    min: 0,
    max: 100,
    value: 100
  },
  colorScaleType: 'quantize',
  onSetColorDomain: nop,
  elevationDomain: null,
  elevationRange: [0, 1000],
  getElevationValue: {
    type: 'accessor',
    value: null
  },
  getElevationWeight: {
    type: 'accessor',
    value: 1
  },
  elevationAggregation: 'SUM',
  elevationLowerPercentile: {
    type: 'number',
    min: 0,
    max: 100,
    value: 0
  },
  elevationUpperPercentile: {
    type: 'number',
    min: 0,
    max: 100,
    value: 100
  },
  elevationScale: {
    type: 'number',
    min: 0,
    value: 1
  },
  elevationScaleType: 'linear',
  onSetElevationDomain: nop,
  gridAggregator: pointToDensityGridDataCPU,
  cellSize: {
    type: 'number',
    min: 0,
    max: 1000,
    value: 1000
  },
  coverage: {
    type: 'number',
    min: 0,
    max: 1,
    value: 1
  },
  getPosition: {
    type: 'accessor',
    value: x => x.position
  },
  extruded: false,
  material: true,
  _filterData: {
    type: 'function',
    value: null,
    optional: true
  }
};
export default class CPUGridLayer extends AggregationLayer {
  initializeState() {
    const cpuAggregator = new CPUAggregator({
      getAggregator: props => props.gridAggregator,
      getCellSize: props => props.cellSize
    });
    this.state = {
      cpuAggregator,
      aggregatorState: cpuAggregator.state
    };
    const attributeManager = this.getAttributeManager();
    attributeManager.add({
      positions: {
        size: 3,
        type: 5130,
        accessor: 'getPosition'
      }
    });
  }

  updateState(opts) {
    super.updateState(opts);
    this.setState({
      aggregatorState: this.state.cpuAggregator.updateState(opts, {
        viewport: this.context.viewport,
        attributes: this.getAttributes(),
        numInstances: this.getNumInstances()
      })
    });
  }

  getPickingInfo({
    info
  }) {
    return this.state.cpuAggregator.getPickingInfo({
      info
    });
  }

  _onGetSublayerColor(cell) {
    return this.state.cpuAggregator.getAccessor('fillColor')(cell);
  }

  _onGetSublayerElevation(cell) {
    return this.state.cpuAggregator.getAccessor('elevation')(cell);
  }

  _getSublayerUpdateTriggers() {
    return this.state.cpuAggregator.getUpdateTriggers(this.props);
  }

  renderLayers() {
    const {
      elevationScale,
      extruded,
      cellSize,
      coverage,
      material,
      transitions
    } = this.props;
    const {
      cpuAggregator
    } = this.state;
    const SubLayerClass = this.getSubLayerClass('grid-cell', GridCellLayer);

    const updateTriggers = this._getSublayerUpdateTriggers();

    return new SubLayerClass({
      cellSize,
      coverage,
      material,
      elevationScale,
      extruded,
      getFillColor: this._onGetSublayerColor.bind(this),
      getElevation: this._onGetSublayerElevation.bind(this),
      transitions: transitions && {
        getFillColor: transitions.getColorValue || transitions.getColorWeight,
        getElevation: transitions.getElevationValue || transitions.getElevationWeight
      }
    }, this.getSubLayerProps({
      id: 'grid-cell',
      updateTriggers
    }), {
      data: cpuAggregator.state.layerData.data
    });
  }

}

_defineProperty(CPUGridLayer, "layerName", 'CPUGridLayer');

_defineProperty(CPUGridLayer, "defaultProps", defaultProps);
//# sourceMappingURL=cpu-grid-layer.js.map