import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import GPUGridAggregator from '../utils/gpu-grid-aggregation/gpu-grid-aggregator';
import GPUGridLayer from '../gpu-grid-layer/gpu-grid-layer';
import CPUGridLayer from '../cpu-grid-layer/cpu-grid-layer';
const defaultProps = { ...GPUGridLayer.defaultProps,
  ...CPUGridLayer.defaultProps,
  gpuAggregation: false
};
export default class GridLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeState() {
    this.state = {
      useGPUAggregation: true
    };
  }

  updateState({
    props
  }) {
    this.setState({
      useGPUAggregation: this.canUseGPUAggregation(props)
    });
  }

  renderLayers() {
    const {
      data,
      updateTriggers
    } = this.props;
    const id = this.state.useGPUAggregation ? 'GPU' : 'CPU';
    const LayerType = this.state.useGPUAggregation ? this.getSubLayerClass('GPU', GPUGridLayer) : this.getSubLayerClass('CPU', CPUGridLayer);
    return new LayerType(this.props, this.getSubLayerProps({
      id,
      updateTriggers
    }), {
      data
    });
  }

  canUseGPUAggregation(props) {
    const {
      gpuAggregation,
      lowerPercentile,
      upperPercentile,
      getColorValue,
      getElevationValue,
      colorScaleType
    } = props;

    if (!gpuAggregation) {
      return false;
    }

    if (!GPUGridAggregator.isSupported(this.context.gl)) {
      return false;
    }

    if (lowerPercentile !== 0 || upperPercentile !== 100) {
      return false;
    }

    if (getColorValue !== null || getElevationValue !== null) {
      return false;
    }

    if (colorScaleType === 'quantile' || colorScaleType === 'ordinal') {
      return false;
    }

    return true;
  }

}

_defineProperty(GridLayer, "layerName", 'GridLayer');

_defineProperty(GridLayer, "defaultProps", defaultProps);
//# sourceMappingURL=grid-layer.js.map