import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Model, Geometry } from '@luma.gl/core';
import { Layer, project32 } from '@deck.gl/core';
import vs from './triangle-layer-vertex.glsl';
import fs from './triangle-layer-fragment.glsl';
export default class TriangleLayer extends Layer {
  getShaders() {
    return {
      vs,
      fs,
      modules: [project32]
    };
  }

  initializeState({
    gl
  }) {
    const attributeManager = this.getAttributeManager();
    attributeManager.add({
      positions: {
        size: 3,
        noAlloc: true
      },
      texCoords: {
        size: 2,
        noAlloc: true
      }
    });
    this.setState({
      model: this._getModel(gl)
    });
  }

  _getModel(gl) {
    const {
      vertexCount
    } = this.props;
    return new Model(gl, { ...this.getShaders(),
      id: this.props.id,
      geometry: new Geometry({
        drawMode: 6,
        vertexCount
      })
    });
  }

  draw({
    uniforms
  }) {
    const {
      model
    } = this.state;
    const {
      texture,
      maxTexture,
      colorTexture,
      intensity,
      threshold,
      aggregationMode,
      colorDomain
    } = this.props;
    model.setUniforms({ ...uniforms,
      texture,
      maxTexture,
      colorTexture,
      intensity,
      threshold,
      aggregationMode,
      colorDomain
    }).draw();
  }

}

_defineProperty(TriangleLayer, "layerName", 'TriangleLayer');
//# sourceMappingURL=triangle-layer.js.map