import { Framebuffer, Texture2D, isWebGL2 } from '@luma.gl/core';
const DEFAULT_PARAMETERS = {
  [10240]: 9728,
  [10241]: 9728
};
export function getFloatTexture(gl, opts = {}) {
  const {
    width = 1,
    height = 1,
    data = null,
    unpackFlipY = true,
    parameters = DEFAULT_PARAMETERS
  } = opts;
  const texture = new Texture2D(gl, {
    data,
    format: isWebGL2(gl) ? 34836 : 6408,
    type: 5126,
    border: 0,
    mipmaps: false,
    parameters,
    dataFormat: 6408,
    width,
    height,
    unpackFlipY
  });
  return texture;
}
export function getFramebuffer(gl, opts) {
  const {
    id,
    width = 1,
    height = 1,
    texture
  } = opts;
  const fb = new Framebuffer(gl, {
    id,
    width,
    height,
    attachments: {
      [36064]: texture
    }
  });
  return fb;
}
export function getFloatArray(array, size, fillValue = 0) {
  if (!array || array.length < size) {
    return new Float32Array(size).fill(fillValue);
  }

  return array;
}
//# sourceMappingURL=resource-utils.js.map