/**
 * Use d3-hexbin to performs hexagonal binning from geo points to hexagons
 * @param {Iterable} data - array of points
 * @param {Number} radius - hexagon radius in meter
 * @param {function} getPosition - get points lon lat
 * @param {Object} viewport - current viewport object

 * @return {Object} - hexagons and countRange
 */
export function pointToHexbin(props: any, aggregationParams: any): any;
/**
 * Get the bounding box of all data points
 */
export function getPointsCenter(data: any, aggregationParams: any): number[] | null;
/**
 * Get radius in mercator world space coordinates from meter
 * @param {Number} radius - in meter
 * @param {Object} viewport - current viewport object
 * @param {Array<Number>} center - data center

 * @return {Number} radius in mercator world spcae coordinates
 */
export function getRadiusInCommon(radius: number, viewport: any, center: Array<number>): number;
//# sourceMappingURL=hexagon-aggregator.d.ts.map