"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CartoAPIError = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _wrapNativeSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapNativeSuper"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var CartoAPIError = function (_Error) {
  (0, _inherits2.default)(CartoAPIError, _Error);

  var _super = _createSuper(CartoAPIError);

  function CartoAPIError(error, errorContext, response) {
    var _this;

    (0, _classCallCheck2.default)(this, CartoAPIError);
    var responseString = 'Failed to connect';

    if (response) {
      responseString = 'Server returned: ';

      if (response.status === 400) {
        responseString += 'Bad request';
      } else if (response.status === 401 || response.status === 403) {
        responseString += 'Unauthorized access';
      } else if (response.status === 404) {
        responseString += 'Not found';
      } else {
        responseString += 'Error';
      }

      responseString += " (".concat(response.status, "):");
    }

    responseString += " ".concat(error.message || error);
    var message = "".concat(errorContext.requestType, " API request failed");
    message += "\n".concat(responseString);

    for (var _i = 0, _Object$keys = Object.keys(errorContext); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];
      if (key === 'requestType') continue;
      message += "\n".concat(formatErrorKey(key), ": ").concat(errorContext[key]);
    }

    message += '\n';
    _this = _super.call(this, message);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "error", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "errorContext", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "response", void 0);
    _this.name = 'CartoAPIError';
    _this.response = response;
    _this.error = error;
    _this.errorContext = errorContext;
    return _this;
  }

  return CartoAPIError;
}((0, _wrapNativeSuper2.default)(Error));

exports.CartoAPIError = CartoAPIError;

function formatErrorKey(key) {
  return key.replace(/([A-Z])/g, ' $1').replace(/^./, function (s) {
    return s.toUpperCase();
  });
}
//# sourceMappingURL=carto-api-error.js.map