"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayer = getLayer;
exports.layerFromTileDataset = layerFromTileDataset;
exports.opacityToAlpha = opacityToAlpha;
exports.getColorValueAccessor = getColorValueAccessor;
exports.getColorAccessor = getColorAccessor;
exports.getIconUrlAccessor = getIconUrlAccessor;
exports.getMaxMarkerSize = getMaxMarkerSize;
exports.negateAccessor = negateAccessor;
exports.getSizeAccessor = getSizeAccessor;
exports.getTextAccessor = getTextAccessor;
exports._domainFromValues = domainFromValues;
exports.OPACITY_MAP = exports.AGGREGATION = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _d3Array = require("d3-array");

var _d3Color = require("d3-color");

var _d3Scale = require("d3-scale");

var _d3Format = require("d3-format");

var _momentTimezone = _interopRequireDefault(require("moment-timezone"));

var _aggregationLayers = require("@deck.gl/aggregation-layers");

var _layers = require("@deck.gl/layers");

var _geoLayers = require("@deck.gl/geo-layers");

var _cartoTileLayer = _interopRequireDefault(require("../layers/carto-tile-layer"));

var _h3TileLayer = _interopRequireDefault(require("../layers/h3-tile-layer"));

var _quadbinTileLayer = _interopRequireDefault(require("../layers/quadbin-tile-layer"));

var _rasterTileLayer = _interopRequireDefault(require("../layers/raster-tile-layer"));

var _mapsApiCommon = require("./maps-api-common");

var _utils = require("../utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var SCALE_FUNCS = {
  linear: _d3Scale.scaleLinear,
  ordinal: _d3Scale.scaleOrdinal,
  log: _d3Scale.scaleLog,
  point: _d3Scale.scalePoint,
  quantile: _d3Scale.scaleQuantile,
  quantize: _d3Scale.scaleQuantize,
  sqrt: _d3Scale.scaleSqrt,
  custom: _d3Scale.scaleThreshold,
  identity: _utils.scaleIdentity
};

function identity(v) {
  return v;
}

var UNKNOWN_COLOR = '#868d91';
var AGGREGATION = {
  average: 'MEAN',
  maximum: 'MAX',
  minimum: 'MIN',
  sum: 'SUM'
};
exports.AGGREGATION = AGGREGATION;
var OPACITY_MAP = {
  getFillColor: 'opacity',
  getLineColor: 'strokeOpacity',
  getTextColor: 'opacity'
};
exports.OPACITY_MAP = OPACITY_MAP;
var AGGREGATION_FUNC = {
  'count unique': function countUnique(values, accessor) {
    return (0, _d3Array.groupSort)(values, function (v) {
      return v.length;
    }, accessor).length;
  },
  median: _d3Array.median,
  mode: function mode(values, accessor) {
    return (0, _d3Array.groupSort)(values, function (v) {
      return v.length;
    }, accessor).pop();
  },
  stddev: _d3Array.deviation,
  variance: _d3Array.variance
};

var hexToRGBA = function hexToRGBA(c) {
  var _rgb = (0, _d3Color.rgb)(c),
      r = _rgb.r,
      g = _rgb.g,
      b = _rgb.b,
      opacity = _rgb.opacity;

  return [r, g, b, 255 * opacity];
};

var sharedPropMap = {
  color: 'getFillColor',
  isVisible: 'visible',
  label: 'cartoLabel',
  textLabel: {
    alignment: 'getTextAlignmentBaseline',
    anchor: 'getTextAnchor',
    color: 'getTextColor',
    size: 'getTextSize'
  },
  visConfig: {
    enable3d: 'extruded',
    elevationScale: 'elevationScale',
    filled: 'filled',
    strokeColor: 'getLineColor',
    stroked: 'stroked',
    thickness: 'getLineWidth',
    radius: 'getPointRadius',
    wireframe: 'wireframe'
  }
};
var customMarkersPropsMap = {
  color: 'getIconColor',
  visConfig: {
    radius: 'getIconSize'
  }
};
var aggregationVisConfig = {
  colorAggregation: function colorAggregation(x) {
    return {
      colorAggregation: AGGREGATION[x] || AGGREGATION.sum
    };
  },
  colorRange: function colorRange(x) {
    return {
      colorRange: x.colors.map(hexToRGBA)
    };
  },
  coverage: 'coverage',
  elevationPercentile: ['elevationLowerPercentile', 'elevationUpperPercentile'],
  percentile: ['lowerPercentile', 'upperPercentile']
};
var defaultProps = {
  lineMiterLimit: 2,
  lineWidthUnits: 'pixels',
  pointRadiusUnits: 'pixels',
  rounded: true,
  wrapLongitude: false
};

function mergePropMaps() {
  var a = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var b = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return _objectSpread(_objectSpread(_objectSpread({}, a), b), {}, {
    visConfig: _objectSpread(_objectSpread({}, a.visConfig), b.visConfig)
  });
}

function getLayer(type, config, dataset) {
  var _config$visConfig, _config$columns;

  var basePropMap = sharedPropMap;

  if ((_config$visConfig = config.visConfig) !== null && _config$visConfig !== void 0 && _config$visConfig.customMarkers) {
    basePropMap = mergePropMaps(sharedPropMap, customMarkersPropsMap);
  }

  if (type === 'mvt' || type === 'tileset' || type === 'h3' || type === 'quadbin') {
    return getTileLayer(dataset, basePropMap);
  }

  var geoColumn = dataset === null || dataset === void 0 ? void 0 : dataset.geoColumn;

  var getPosition = function getPosition(d) {
    return d[geoColumn].coordinates;
  };

  var hexagonId = (_config$columns = config.columns) === null || _config$columns === void 0 ? void 0 : _config$columns.hex_id;
  var layerTypeDefs = {
    point: {
      Layer: _layers.GeoJsonLayer,
      propMap: {
        columns: {
          altitude: function altitude(x) {
            return {
              parameters: {
                depthTest: Boolean(x)
              }
            };
          }
        },
        visConfig: {
          outline: 'stroked'
        }
      }
    },
    geojson: {
      Layer: _layers.GeoJsonLayer
    },
    grid: {
      Layer: _aggregationLayers.CPUGridLayer,
      propMap: {
        visConfig: _objectSpread(_objectSpread({}, aggregationVisConfig), {}, {
          worldUnitSize: function worldUnitSize(x) {
            return {
              cellSize: 1000 * x
            };
          }
        })
      },
      defaultProps: {
        getPosition: getPosition
      }
    },
    heatmap: {
      Layer: _aggregationLayers.HeatmapLayer,
      propMap: {
        visConfig: _objectSpread(_objectSpread({}, aggregationVisConfig), {}, {
          radius: 'radiusPixels'
        })
      },
      defaultProps: {
        getPosition: getPosition
      }
    },
    hexagon: {
      Layer: _aggregationLayers.HexagonLayer,
      propMap: {
        visConfig: _objectSpread(_objectSpread({}, aggregationVisConfig), {}, {
          worldUnitSize: function worldUnitSize(x) {
            return {
              radius: 1000 * x
            };
          }
        })
      },
      defaultProps: {
        getPosition: getPosition
      }
    },
    hexagonId: {
      Layer: _geoLayers.H3HexagonLayer,
      propMap: {
        visConfig: {
          coverage: 'coverage'
        }
      },
      defaultProps: {
        getHexagon: function getHexagon(d) {
          return d[hexagonId];
        },
        stroked: false
      }
    }
  };
  var layer = layerTypeDefs[type];
  (0, _utils.assert)(layer, "Unsupported layer type: ".concat(type));
  return _objectSpread(_objectSpread({}, layer), {}, {
    propMap: mergePropMaps(basePropMap, layer.propMap),
    defaultProps: _objectSpread(_objectSpread({}, defaultProps), layer.defaultProps)
  });
}

function layerFromTileDataset() {
  var formatTiles = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _mapsApiCommon.TILE_FORMATS.MVT;
  var scheme = arguments.length > 1 ? arguments[1] : undefined;
  var type = arguments.length > 2 ? arguments[2] : undefined;

  if (type === 'raster') {
    return _rasterTileLayer.default;
  }

  if (scheme === 'h3') {
    return _h3TileLayer.default;
  }

  if (scheme === 'quadbin') {
    return _quadbinTileLayer.default;
  }

  if (formatTiles === 'mvt') {
    return _geoLayers.MVTLayer;
  }

  return _cartoTileLayer.default;
}

function getTileLayer(dataset, basePropMap) {
  var aggregationExp = dataset.aggregationExp,
      aggregationResLevel = dataset.aggregationResLevel,
      _dataset$data = dataset.data,
      scheme = _dataset$data.scheme,
      _dataset$data$tiles = (0, _slicedToArray2.default)(_dataset$data.tiles, 1),
      tileUrl = _dataset$data$tiles[0];

  var formatTiles = new URL(tileUrl).searchParams.get('formatTiles');
  return {
    Layer: layerFromTileDataset(formatTiles, scheme),
    propMap: basePropMap,
    defaultProps: _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, defaultProps), aggregationExp && {
      aggregationExp: aggregationExp
    }), aggregationResLevel && {
      aggregationResLevel: aggregationResLevel
    }), {}, {
      formatTiles: formatTiles,
      uniqueIdProperty: 'geoid'
    })
  };
}

function domainFromAttribute(attribute, scaleType, scaleLength) {
  if (scaleType === 'ordinal' || scaleType === 'point') {
    return attribute.categories.map(function (c) {
      return c.category;
    }).filter(function (c) {
      return c !== undefined && c !== null;
    });
  }

  if (scaleType === 'quantile' && attribute.quantiles) {
    return attribute.quantiles.global ? attribute.quantiles.global[scaleLength] : attribute.quantiles[scaleLength];
  }

  var min = attribute.min;

  if (scaleType === 'log' && min === 0) {
    min = 1e-5;
  }

  return [min, attribute.max];
}

function domainFromValues(values, scaleType) {
  if (scaleType === 'ordinal' || scaleType === 'point') {
    return (0, _d3Array.groupSort)(values, function (g) {
      return -g.length;
    }, function (d) {
      return d;
    });
  } else if (scaleType === 'quantile') {
    return values.sort(function (a, b) {
      return a - b;
    });
  } else if (scaleType === 'log') {
    var _extent = (0, _d3Array.extent)(values),
        _extent2 = (0, _slicedToArray2.default)(_extent, 2),
        d0 = _extent2[0],
        d1 = _extent2[1];

    return [d0 === 0 ? 1e-5 : d0, d1];
  }

  return (0, _d3Array.extent)(values);
}

function calculateDomain(data, name, scaleType, scaleLength) {
  if (data.tilestats) {
    var attributes = data.tilestats.layers[0].attributes;
    var attribute = attributes.find(function (a) {
      return a.attribute === name;
    });
    return domainFromAttribute(attribute, scaleType, scaleLength);
  } else if (data.features) {
    var values = data.features.map(function (_ref) {
      var properties = _ref.properties;
      return properties[name];
    });
    return domainFromValues(values, scaleType);
  } else if (Array.isArray(data) && data[0][name] !== undefined) {
    var _values = data.map(function (properties) {
      return properties[name];
    });

    return domainFromValues(_values, scaleType);
  }

  return [0, 1];
}

function normalizeAccessor(accessor, data) {
  if (data.features || data.tilestats) {
    return function (object, info) {
      if (object) {
        return accessor(object.properties || object.__source.object.properties);
      }

      var data = info.data,
          index = info.index;
      var proxy = (0, _utils.createBinaryProxy)(data, index);
      return accessor(proxy);
    };
  }

  return accessor;
}

function opacityToAlpha(opacity) {
  return opacity !== undefined ? Math.round(255 * Math.pow(opacity, 1 / 2.2)) : 255;
}

function getAccessorKeys(name, aggregation) {
  var keys = [name];

  if (aggregation) {
    keys = keys.concat([aggregation, aggregation.toUpperCase()].map(function (a) {
      return "".concat(name, "_").concat(a);
    }));
  }

  return keys;
}

function findAccessorKey(keys, properties) {
  var _iterator = _createForOfIteratorHelper(keys),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var key = _step.value;

      if (key in properties) {
        return [key];
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  throw new Error("Could not find property for any accessor key: ".concat(keys));
}

function getColorValueAccessor(_ref2, colorAggregation, data) {
  var name = _ref2.name;
  var aggregator = AGGREGATION_FUNC[colorAggregation];

  var accessor = function accessor(values) {
    return aggregator(values, function (p) {
      return p[name];
    });
  };

  return normalizeAccessor(accessor, data);
}

function getColorAccessor(_ref3, scaleType, _ref4, opacity, data) {
  var name = _ref3.name,
      colorColumn = _ref3.colorColumn;
  var aggregation = _ref4.aggregation,
      range = _ref4.range;
  var scale = calculateLayerScale(colorColumn || name, scaleType, range, data);
  var alpha = opacityToAlpha(opacity);
  var accessorKeys = getAccessorKeys(name, aggregation);

  var accessor = function accessor(properties) {
    if (!(accessorKeys[0] in properties)) {
      accessorKeys = findAccessorKey(accessorKeys, properties);
    }

    var propertyValue = properties[accessorKeys[0]];

    var _rgb2 = (0, _d3Color.rgb)(scale(propertyValue)),
        r = _rgb2.r,
        g = _rgb2.g,
        b = _rgb2.b;

    return [r, g, b, propertyValue === null ? 0 : alpha];
  };

  return normalizeAccessor(accessor, data);
}

function calculateLayerScale(name, scaleType, range, data) {
  var scale = SCALE_FUNCS[scaleType]();
  var domain = [];
  var scaleColor = [];

  if (scaleType !== 'identity') {
    var colorMap = range.colorMap,
        colors = range.colors;

    if (Array.isArray(colorMap)) {
      colorMap.forEach(function (_ref5) {
        var _ref6 = (0, _slicedToArray2.default)(_ref5, 2),
            value = _ref6[0],
            color = _ref6[1];

        domain.push(value);
        scaleColor.push(color);
      });
    } else {
      domain = calculateDomain(data, name, scaleType, colors.length);
      scaleColor = colors;
    }

    if (scaleType === 'ordinal') {
      domain = domain.slice(0, scaleColor.length);
    }
  }

  scale.domain(domain);
  scale.range(scaleColor);
  scale.unknown(UNKNOWN_COLOR);
  return scale;
}

var FALLBACK_ICON = 'data:image/svg+xml;charset=utf-8;base64,PHN2ZyB2aWV3Qm94PSIwIDAgMTAwIDEwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4NCiAgPGNpcmNsZSBjeD0iNTAiIGN5PSI1MCIgcj0iNTAiLz4NCjwvc3ZnPg==';

function getIconUrlAccessor(field, range, _ref7, data) {
  var fallbackUrl = _ref7.fallbackUrl,
      maxIconSize = _ref7.maxIconSize,
      useMaskedIcons = _ref7.useMaskedIcons;

  var urlToUnpackedIcon = function urlToUnpackedIcon(url) {
    return {
      id: "".concat(url, "@@").concat(maxIconSize),
      url: url,
      width: maxIconSize,
      height: maxIconSize,
      mask: useMaskedIcons
    };
  };

  var unknownValue = fallbackUrl || FALLBACK_ICON;

  if (range !== null && range !== void 0 && range.othersMarker) {
    unknownValue = range.othersMarker;
  }

  var unknownIcon = urlToUnpackedIcon(unknownValue);

  if (!range || !field) {
    return function () {
      return unknownIcon;
    };
  }

  var mapping = {};

  var _iterator2 = _createForOfIteratorHelper(range.markerMap),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var _step2$value = _step2.value,
          _value = _step2$value.value,
          markerUrl = _step2$value.markerUrl;

      if (markerUrl) {
        mapping[_value] = urlToUnpackedIcon(markerUrl);
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  var accessor = function accessor(properties) {
    var propertyValue = properties[field.name];
    return mapping[propertyValue] || unknownIcon;
  };

  return normalizeAccessor(accessor, data);
}

function getMaxMarkerSize(visConfig, visualChannels) {
  var radiusRange = visConfig.radiusRange,
      radius = visConfig.radius;
  var radiusField = visualChannels.radiusField,
      sizeField = visualChannels.sizeField;
  var field = radiusField || sizeField;
  return Math.ceil(radiusRange && field ? radiusRange[1] : radius);
}

function negateAccessor(accessor) {
  return typeof accessor === 'function' ? function (d, i) {
    return -accessor(d, i);
  } : -accessor;
}

function getSizeAccessor(_ref8, scaleType, aggregation, range, data) {
  var name = _ref8.name;
  var scale = scaleType ? SCALE_FUNCS[scaleType]() : identity;

  if (scaleType) {
    if (aggregation !== 'count') {
      scale.domain(calculateDomain(data, name, scaleType));
    }

    scale.range(range);
  }

  var accessorKeys = getAccessorKeys(name, aggregation);

  var accessor = function accessor(properties) {
    if (!(accessorKeys[0] in properties)) {
      accessorKeys = findAccessorKey(accessorKeys, properties);
    }

    var propertyValue = properties[accessorKeys[0]];
    return scale(propertyValue);
  };

  return normalizeAccessor(accessor, data);
}

var FORMATS = {
  date: function date(s) {
    return _momentTimezone.default.utc(s).format('MM/DD/YY HH:mm:ssa');
  },
  integer: (0, _d3Format.format)('i'),
  float: (0, _d3Format.format)('.5f'),
  timestamp: function timestamp(s) {
    return _momentTimezone.default.utc(s).format('X');
  },
  default: String
};

function getTextAccessor(_ref9, data) {
  var name = _ref9.name,
      type = _ref9.type;
  var format = FORMATS[type] || FORMATS.default;

  var accessor = function accessor(properties) {
    return format(properties[name]);
  };

  return normalizeAccessor(accessor, data);
}
//# sourceMappingURL=layer-map.js.map