"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeParameter = encodeParameter;
exports.FilterTypes = exports.REQUEST_TYPES = exports.SchemaFieldType = exports.TILE_FORMATS = exports.FORMATS = exports.GEO_COLUMN_SUPPORT = exports.COLUMNS_SUPPORT = exports.MAP_TYPES = exports.DEFAULT_MAPS_URL_FORMAT = exports.API_VERSIONS = exports.DEFAULT_REGION_COMPONENT_IN_URL = exports.DEFAULT_USER_COMPONENT_IN_URL = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _DEFAULT_MAPS_URL_FOR;

var DEFAULT_USER_COMPONENT_IN_URL = '{user}';
exports.DEFAULT_USER_COMPONENT_IN_URL = DEFAULT_USER_COMPONENT_IN_URL;
var DEFAULT_REGION_COMPONENT_IN_URL = '{region}';
exports.DEFAULT_REGION_COMPONENT_IN_URL = DEFAULT_REGION_COMPONENT_IN_URL;
var API_VERSIONS = {
  V1: 'v1',
  V2: 'v2',
  V3: 'v3'
};
exports.API_VERSIONS = API_VERSIONS;
var DEFAULT_MAPS_URL_FORMAT = (_DEFAULT_MAPS_URL_FOR = {}, (0, _defineProperty2.default)(_DEFAULT_MAPS_URL_FOR, API_VERSIONS.V1, "https://".concat(DEFAULT_USER_COMPONENT_IN_URL, ".carto.com/api/v1/map")), (0, _defineProperty2.default)(_DEFAULT_MAPS_URL_FOR, API_VERSIONS.V2, "https://maps-api-v2.".concat(DEFAULT_REGION_COMPONENT_IN_URL, ".carto.com/user/").concat(DEFAULT_USER_COMPONENT_IN_URL)), _DEFAULT_MAPS_URL_FOR);
exports.DEFAULT_MAPS_URL_FORMAT = DEFAULT_MAPS_URL_FORMAT;
var MAP_TYPES = {
  QUERY: 'query',
  TABLE: 'table',
  TILESET: 'tileset',
  RASTER: 'raster'
};
exports.MAP_TYPES = MAP_TYPES;
var COLUMNS_SUPPORT = [MAP_TYPES.QUERY, MAP_TYPES.TABLE];
exports.COLUMNS_SUPPORT = COLUMNS_SUPPORT;
var GEO_COLUMN_SUPPORT = [MAP_TYPES.QUERY, MAP_TYPES.TABLE];
exports.GEO_COLUMN_SUPPORT = GEO_COLUMN_SUPPORT;
var FORMATS = {
  GEOJSON: 'geojson',
  NDJSON: 'ndjson',
  TILEJSON: 'tilejson',
  JSON: 'json'
};
exports.FORMATS = FORMATS;
var TILE_FORMATS = {
  MVT: 'mvt',
  JSON: 'json',
  GEOJSON: 'geojson',
  BINARY: 'binary'
};
exports.TILE_FORMATS = TILE_FORMATS;
var SchemaFieldType;
exports.SchemaFieldType = SchemaFieldType;

(function (SchemaFieldType) {
  SchemaFieldType["Number"] = "number";
  SchemaFieldType["Bigint"] = "bigint";
  SchemaFieldType["String"] = "string";
  SchemaFieldType["Geometry"] = "geometry";
  SchemaFieldType["Timestamp"] = "timestamp";
  SchemaFieldType["Object"] = "object";
  SchemaFieldType["Boolean"] = "boolean";
  SchemaFieldType["Variant"] = "variant";
  SchemaFieldType["Unknown"] = "unknown";
})(SchemaFieldType || (exports.SchemaFieldType = SchemaFieldType = {}));

var REQUEST_TYPES = {
  DATA: 'Map data',
  INSTANTIATION: 'Map instantiation',
  PUBLIC_MAP: 'Public map',
  TILE_STATS: 'Tile stats'
};
exports.REQUEST_TYPES = REQUEST_TYPES;

function encodeParameter(name, value) {
  return "".concat(name, "=").concat(encodeURIComponent(value));
}

var FilterTypes;
exports.FilterTypes = FilterTypes;

(function (FilterTypes) {
  FilterTypes["In"] = "in";
  FilterTypes["Between"] = "between";
  FilterTypes["ClosedOpen"] = "closed_open";
  FilterTypes["Time"] = "time";
  FilterTypes["StringSearch"] = "stringSearch";
})(FilterTypes || (exports.FilterTypes = FilterTypes = {}));
//# sourceMappingURL=maps-api-common.js.map