"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataV2 = getDataV2;
exports.CONNECTIONS = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _config = require("../config");

var _mapsApiCommon = require("./maps-api-common");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var CONNECTIONS = {
  BIGQUERY: 'bigquery',
  CARTO: 'carto'
};
exports.CONNECTIONS = CONNECTIONS;
var BUFFER_SIZE = 16;
var TILE_EXTENT = 4096;

function getDataV2(_x) {
  return _getDataV.apply(this, arguments);
}

function _getDataV() {
  _getDataV = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee(_ref) {
    var type, source, credentials, defaultCredentials, apiVersion, localCreds, url, connection, mapConfig, layergroup;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            type = _ref.type, source = _ref.source, credentials = _ref.credentials;
            defaultCredentials = (0, _config.getDefaultCredentials)();
            apiVersion = (credentials === null || credentials === void 0 ? void 0 : credentials.apiVersion) || defaultCredentials.apiVersion;
            localCreds = _objectSpread(_objectSpread(_objectSpread({}, apiVersion === _mapsApiCommon.API_VERSIONS.V3 ? _config.defaultCloudNativeCredentials : _config.defaultClassicCredentials), {}, {
              mapsUrl: _mapsApiCommon.DEFAULT_MAPS_URL_FORMAT[apiVersion]
            }, defaultCredentials.apiVersion === apiVersion && defaultCredentials), credentials);
            connection = type === _mapsApiCommon.MAP_TYPES.TILESET ? CONNECTIONS.BIGQUERY : CONNECTIONS.CARTO;
            _context.t0 = apiVersion;
            _context.next = _context.t0 === _mapsApiCommon.API_VERSIONS.V1 ? 8 : _context.t0 === _mapsApiCommon.API_VERSIONS.V2 ? 14 : 18;
            break;

          case 8:
            mapConfig = createMapConfig(source);
            url = buildURLMapsAPIv1({
              mapConfig: mapConfig,
              credentials: localCreds
            });
            _context.next = 12;
            return request({
              url: url,
              credentials: localCreds
            });

          case 12:
            layergroup = _context.sent;
            return _context.abrupt("return", layergroup.metadata.tilejson.vector);

          case 14:
            url = buildURLMapsAPIv2({
              connection: connection,
              type: type,
              source: source,
              credentials: localCreds
            });
            _context.next = 17;
            return request({
              url: url,
              credentials: localCreds
            });

          case 17:
            return _context.abrupt("return", _context.sent);

          case 18:
            throw new Error("Invalid maps API version. It should be ".concat(_mapsApiCommon.API_VERSIONS.V1, " or ").concat(_mapsApiCommon.API_VERSIONS.V2));

          case 19:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _getDataV.apply(this, arguments);
}

function request(_x2) {
  return _request.apply(this, arguments);
}

function _request() {
  _request = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee2(_ref2) {
    var url, credentials, response, json;
    return _regenerator.default.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            url = _ref2.url, credentials = _ref2.credentials;
            _context2.prev = 1;
            _context2.next = 4;
            return fetch(url, {
              headers: {
                Accept: 'application/json'
              }
            });

          case 4:
            response = _context2.sent;
            _context2.next = 10;
            break;

          case 7:
            _context2.prev = 7;
            _context2.t0 = _context2["catch"](1);
            throw new Error("Failed to connect to Maps API: ".concat(_context2.t0));

          case 10:
            _context2.next = 12;
            return response.json();

          case 12:
            json = _context2.sent;

            if (!response.ok) {
              dealWithError({
                response: response,
                json: json,
                credentials: credentials
              });
            }

            return _context2.abrupt("return", json);

          case 15:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, null, [[1, 7]]);
  }));
  return _request.apply(this, arguments);
}

function dealWithError(_ref3) {
  var response = _ref3.response,
      json = _ref3.json,
      credentials = _ref3.credentials;

  switch (response.status) {
    case 401:
      throw new Error("Unauthorized access to Maps API: invalid combination of user ('".concat(credentials.username, "') and apiKey ('").concat(credentials.apiKey, "')"));

    case 403:
      throw new Error("Unauthorized access to dataset: the provided apiKey('".concat(credentials.apiKey, "') doesn't provide access to the requested data"));

    default:
      var e = credentials.apiVersion === _mapsApiCommon.API_VERSIONS.V1 ? JSON.stringify(json.errors) : json.error;
      throw new Error(e);
  }
}

function initURLParameters(credentials) {
  var encodedApiKey = (0, _mapsApiCommon.encodeParameter)('api_key', credentials.apiKey);
  var encodedClient = (0, _mapsApiCommon.encodeParameter)('client', 'deck-gl-carto');
  return [encodedApiKey, encodedClient];
}

function buildURLMapsAPIv1(_ref4) {
  var mapConfig = _ref4.mapConfig,
      credentials = _ref4.credentials;
  var parameters = initURLParameters(credentials);
  var cfg = JSON.stringify(mapConfig);
  return "".concat(mapsUrl(credentials), "?").concat(parameters.join('&'), "&").concat((0, _mapsApiCommon.encodeParameter)('config', cfg));
}

function buildURLMapsAPIv2(_ref5) {
  var connection = _ref5.connection,
      type = _ref5.type,
      source = _ref5.source,
      credentials = _ref5.credentials;
  var parameters = initURLParameters(credentials);
  var mapsApiType = type === _mapsApiCommon.MAP_TYPES.QUERY ? 'sql' : type;
  var url = "".concat(mapsUrl(credentials), "/").concat(connection, "/").concat(mapsApiType, "?");
  url += "".concat((0, _mapsApiCommon.encodeParameter)('source', source), "&format=tilejson&").concat(parameters.join('&'));
  return url;
}

function mapsUrl(credentials) {
  return credentials.mapsUrl.replace(_mapsApiCommon.DEFAULT_USER_COMPONENT_IN_URL, credentials.username).replace(_mapsApiCommon.DEFAULT_REGION_COMPONENT_IN_URL, credentials.region);
}

function createMapConfig(sql) {
  return {
    version: '1.3.1',
    buffersize: {
      mvt: BUFFER_SIZE
    },
    layers: [{
      type: 'mapnik',
      options: {
        sql: sql,
        vector_extent: TILE_EXTENT
      }
    }]
  };
}
//# sourceMappingURL=maps-client.js.map