"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapInstantiation = mapInstantiation;
exports.fetchLayerData = fetchLayerData;
exports.fetchMap = fetchMap;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _config = require("../config");

var _mapsApiCommon = require("./maps-api-common");

var _cartoApiError = require("./carto-api-error");

var _parseMap = require("./parseMap");

var _core = require("@deck.gl/core");

var _utils = require("../utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var MAX_GET_LENGTH = 8192;
var DEFAULT_CLIENT = 'deck-gl-carto';
var V3_MINOR_VERSION = '3.2';

function request(_x) {
  return _request.apply(this, arguments);
}

function _request() {
  _request = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee(_ref) {
    var method, url, customHeaders, accessToken, body, errorContext, headers;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            method = _ref.method, url = _ref.url, customHeaders = _ref.headers, accessToken = _ref.accessToken, body = _ref.body, errorContext = _ref.errorContext;
            headers = _objectSpread(_objectSpread({}, customHeaders), {}, {
              Accept: 'application/json'
            });

            if (accessToken) {
              headers.Authorization = "Bearer ".concat(accessToken);
            }

            if (method === 'POST') {
              headers['Content-Type'] = 'application/json';
            }

            _context.prev = 4;
            _context.next = 7;
            return fetch(url, {
              method: method,
              headers: headers,
              body: body
            });

          case 7:
            return _context.abrupt("return", _context.sent);

          case 10:
            _context.prev = 10;
            _context.t0 = _context["catch"](4);
            throw new _cartoApiError.CartoAPIError(_context.t0, errorContext);

          case 13:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[4, 10]]);
  }));
  return _request.apply(this, arguments);
}

function requestJson(_x2) {
  return _requestJson.apply(this, arguments);
}

function _requestJson() {
  _requestJson = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee2(_ref2) {
    var method, url, headers, accessToken, body, errorContext, response, json;
    return _regenerator.default.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            method = _ref2.method, url = _ref2.url, headers = _ref2.headers, accessToken = _ref2.accessToken, body = _ref2.body, errorContext = _ref2.errorContext;
            _context2.next = 3;
            return request({
              method: method,
              url: url,
              headers: headers,
              accessToken: accessToken,
              body: body,
              errorContext: errorContext
            });

          case 3:
            response = _context2.sent;
            _context2.prev = 4;
            _context2.next = 7;
            return response.json();

          case 7:
            json = _context2.sent;
            _context2.next = 13;
            break;

          case 10:
            _context2.prev = 10;
            _context2.t0 = _context2["catch"](4);
            json = {
              error: ''
            };

          case 13:
            if (response.ok) {
              _context2.next = 15;
              break;
            }

            throw new _cartoApiError.CartoAPIError(json.error, errorContext, response);

          case 15:
            return _context2.abrupt("return", json);

          case 16:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, null, [[4, 10]]);
  }));
  return _requestJson.apply(this, arguments);
}

function requestData(_x3) {
  return _requestData.apply(this, arguments);
}

function _requestData() {
  _requestData = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee3(_ref3) {
    var method, url, accessToken, format, body, errorContext, data;
    return _regenerator.default.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            method = _ref3.method, url = _ref3.url, accessToken = _ref3.accessToken, format = _ref3.format, body = _ref3.body, errorContext = _ref3.errorContext;

            if (!(format === _mapsApiCommon.FORMATS.NDJSON)) {
              _context3.next = 3;
              break;
            }

            return _context3.abrupt("return", request({
              method: method,
              url: url,
              accessToken: accessToken,
              body: body,
              errorContext: errorContext
            }));

          case 3:
            _context3.next = 5;
            return requestJson({
              method: method,
              url: url,
              accessToken: accessToken,
              body: body,
              errorContext: errorContext
            });

          case 5:
            data = _context3.sent;
            return _context3.abrupt("return", data.rows ? data.rows : data);

          case 7:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _requestData.apply(this, arguments);
}

function getParameters(_ref4) {
  var type = _ref4.type,
      source = _ref4.source,
      geoColumn = _ref4.geoColumn,
      columns = _ref4.columns,
      clientId = _ref4.clientId,
      aggregationExp = _ref4.aggregationExp,
      aggregationResLevel = _ref4.aggregationResLevel,
      queryParameters = _ref4.queryParameters,
      filters = _ref4.filters;
  var parameters = {
    client: clientId || DEFAULT_CLIENT,
    v: V3_MINOR_VERSION
  };
  var sourceName = type === _mapsApiCommon.MAP_TYPES.QUERY ? 'q' : 'name';
  parameters[sourceName] = source;

  if (queryParameters) {
    parameters.queryParameters = queryParameters;
  }

  if (geoColumn) {
    parameters.geo_column = geoColumn;
  }

  if (columns) {
    parameters.columns = columns.join(',');
  }

  if (aggregationExp) {
    parameters.aggregationExp = aggregationExp;
  } else if (isSpatialIndexGeoColumn(geoColumn)) {
    parameters.aggregationExp = '1 AS value';
  }

  if (aggregationResLevel) {
    parameters.aggregationResLevel = aggregationResLevel;
  }

  if (filters) {
    parameters.filters = filters;
  }

  return parameters;
}

function isSpatialIndexGeoColumn(geoColumn) {
  var spatialIndex = geoColumn === null || geoColumn === void 0 ? void 0 : geoColumn.split(':')[0];
  return spatialIndex === 'h3' || spatialIndex === 'quadbin';
}

function mapInstantiation(_x4) {
  return _mapInstantiation.apply(this, arguments);
}

function _mapInstantiation() {
  _mapInstantiation = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee4(_ref5) {
    var type, source, connection, credentials, geoColumn, columns, clientId, headers, aggregationExp, aggregationResLevel, queryParameters, filters, baseUrl, parameters, encodedParameters, url, accessToken, errorContext;
    return _regenerator.default.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            type = _ref5.type, source = _ref5.source, connection = _ref5.connection, credentials = _ref5.credentials, geoColumn = _ref5.geoColumn, columns = _ref5.columns, clientId = _ref5.clientId, headers = _ref5.headers, aggregationExp = _ref5.aggregationExp, aggregationResLevel = _ref5.aggregationResLevel, queryParameters = _ref5.queryParameters, filters = _ref5.filters;
            baseUrl = "".concat(credentials.mapsUrl, "/").concat(connection, "/").concat(type);
            parameters = getParameters({
              type: type,
              source: source,
              geoColumn: geoColumn,
              columns: columns,
              clientId: clientId,
              aggregationResLevel: aggregationResLevel,
              aggregationExp: aggregationExp,
              queryParameters: queryParameters,
              filters: filters
            });
            encodedParameters = Object.entries(parameters).map(function (_ref12) {
              var _ref13 = (0, _slicedToArray2.default)(_ref12, 2),
                  key = _ref13[0],
                  value = _ref13[1];

              if (typeof value !== 'string') {
                value = JSON.stringify(value);
              }

              return (0, _mapsApiCommon.encodeParameter)(key, value);
            });
            url = "".concat(baseUrl, "?").concat(encodedParameters.join('&'));
            accessToken = credentials.accessToken;
            errorContext = {
              requestType: _mapsApiCommon.REQUEST_TYPES.INSTANTIATION,
              connection: connection,
              type: type,
              source: source
            };

            if (!(url.length > MAX_GET_LENGTH && type === _mapsApiCommon.MAP_TYPES.QUERY)) {
              _context4.next = 11;
              break;
            }

            _context4.next = 10;
            return requestJson({
              method: 'POST',
              url: baseUrl,
              headers: headers,
              accessToken: accessToken,
              body: JSON.stringify(parameters),
              errorContext: errorContext
            });

          case 10:
            return _context4.abrupt("return", _context4.sent);

          case 11:
            _context4.next = 13;
            return requestJson({
              url: url,
              headers: headers,
              accessToken: accessToken,
              errorContext: errorContext
            });

          case 13:
            return _context4.abrupt("return", _context4.sent);

          case 14:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _mapInstantiation.apply(this, arguments);
}

function getUrlFromMetadata(metadata, format) {
  var m = metadata[format];

  if (m && !m.error && m.url) {
    return m.url[0];
  }

  return null;
}

function checkFetchLayerDataParameters(_ref6) {
  var type = _ref6.type,
      source = _ref6.source,
      connection = _ref6.connection,
      credentials = _ref6.credentials,
      geoColumn = _ref6.geoColumn,
      columns = _ref6.columns,
      aggregationExp = _ref6.aggregationExp,
      aggregationResLevel = _ref6.aggregationResLevel,
      filters = _ref6.filters;
  (0, _utils.assert)(connection, 'Must define connection');
  (0, _utils.assert)(type, 'Must define a type');
  (0, _utils.assert)(source, 'Must define a source');
  (0, _utils.assert)(credentials.apiVersion === _mapsApiCommon.API_VERSIONS.V3, 'Method only available for v3');
  (0, _utils.assert)(credentials.apiBaseUrl, 'Must define apiBaseUrl');
  (0, _utils.assert)(credentials.accessToken, 'Must define an accessToken');

  if (columns) {
    (0, _utils.assert)(_mapsApiCommon.COLUMNS_SUPPORT.includes(type), "The columns parameter is not supported by type ".concat(type));
  }

  if (geoColumn) {
    (0, _utils.assert)(_mapsApiCommon.GEO_COLUMN_SUPPORT.includes(type), "The geoColumn parameter is not supported by type ".concat(type));
  } else {
    (0, _utils.assert)(!aggregationExp, 'Have aggregationExp, but geoColumn parameter is missing');
    (0, _utils.assert)(!aggregationResLevel, 'Have aggregationResLevel, but geoColumn parameter is missing');
  }

  if (filters) {
    (0, _utils.assert)(type === _mapsApiCommon.MAP_TYPES.TABLE || type === _mapsApiCommon.MAP_TYPES.QUERY, 'The filters parameter is only supported by type table and query');
  }
}

function fetchLayerData(_x5) {
  return _fetchLayerData.apply(this, arguments);
}

function _fetchLayerData() {
  _fetchLayerData = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee5(_ref7) {
    var type, source, connection, credentials, geoColumn, columns, format, formatTiles, clientId, headers, aggregationExp, aggregationResLevel, queryParameters, filters, _yield$_fetchDataUrl, url, accessToken, mapFormat, metadata, errorContext, data, result;

    return _regenerator.default.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            type = _ref7.type, source = _ref7.source, connection = _ref7.connection, credentials = _ref7.credentials, geoColumn = _ref7.geoColumn, columns = _ref7.columns, format = _ref7.format, formatTiles = _ref7.formatTiles, clientId = _ref7.clientId, headers = _ref7.headers, aggregationExp = _ref7.aggregationExp, aggregationResLevel = _ref7.aggregationResLevel, queryParameters = _ref7.queryParameters, filters = _ref7.filters;
            _context5.next = 3;
            return _fetchDataUrl({
              type: type,
              source: source,
              connection: connection,
              credentials: credentials,
              geoColumn: geoColumn,
              columns: columns,
              format: format,
              formatTiles: formatTiles,
              clientId: clientId,
              headers: headers,
              aggregationExp: aggregationExp,
              aggregationResLevel: aggregationResLevel,
              queryParameters: queryParameters,
              filters: filters
            });

          case 3:
            _yield$_fetchDataUrl = _context5.sent;
            url = _yield$_fetchDataUrl.url;
            accessToken = _yield$_fetchDataUrl.accessToken;
            mapFormat = _yield$_fetchDataUrl.mapFormat;
            metadata = _yield$_fetchDataUrl.metadata;
            errorContext = {
              requestType: _mapsApiCommon.REQUEST_TYPES.DATA,
              connection: connection,
              type: type,
              source: source
            };
            _context5.next = 11;
            return requestData({
              url: url,
              format: mapFormat,
              accessToken: accessToken,
              errorContext: errorContext
            });

          case 11:
            data = _context5.sent;
            result = {
              data: data,
              format: mapFormat,
              schema: metadata.schema
            };
            return _context5.abrupt("return", result);

          case 14:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _fetchLayerData.apply(this, arguments);
}

function _fetchDataUrl(_x6) {
  return _fetchDataUrl2.apply(this, arguments);
}

function _fetchDataUrl2() {
  _fetchDataUrl2 = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee6(_ref8) {
    var type, source, connection, credentials, geoColumn, columns, format, formatTiles, clientId, headers, aggregationExp, aggregationResLevel, queryParameters, filters, defaultCredentials, localCreds, metadata, url, mapFormat, prioritizedFormats, _i, _prioritizedFormats, f, accessToken;

    return _regenerator.default.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            type = _ref8.type, source = _ref8.source, connection = _ref8.connection, credentials = _ref8.credentials, geoColumn = _ref8.geoColumn, columns = _ref8.columns, format = _ref8.format, formatTiles = _ref8.formatTiles, clientId = _ref8.clientId, headers = _ref8.headers, aggregationExp = _ref8.aggregationExp, aggregationResLevel = _ref8.aggregationResLevel, queryParameters = _ref8.queryParameters, filters = _ref8.filters;
            defaultCredentials = (0, _config.getDefaultCredentials)();
            localCreds = _objectSpread(_objectSpread({}, defaultCredentials.apiVersion === _mapsApiCommon.API_VERSIONS.V3 && defaultCredentials), credentials);
            checkFetchLayerDataParameters({
              type: type,
              source: source,
              connection: connection,
              credentials: localCreds,
              geoColumn: geoColumn,
              columns: columns,
              aggregationExp: aggregationExp,
              aggregationResLevel: aggregationResLevel,
              filters: filters
            });

            if (!localCreds.mapsUrl) {
              localCreds.mapsUrl = (0, _config.buildMapsUrlFromBase)(localCreds.apiBaseUrl);
            }

            _context6.next = 7;
            return mapInstantiation({
              type: type,
              source: source,
              connection: connection,
              credentials: localCreds,
              geoColumn: geoColumn,
              columns: columns,
              clientId: clientId,
              headers: headers,
              aggregationExp: aggregationExp,
              aggregationResLevel: aggregationResLevel,
              queryParameters: queryParameters,
              filters: filters
            });

          case 7:
            metadata = _context6.sent;
            url = null;

            if (!format) {
              _context6.next = 15;
              break;
            }

            mapFormat = format;
            url = getUrlFromMetadata(metadata, format);
            (0, _utils.assert)(url, "Format ".concat(format, " not available"));
            _context6.next = 27;
            break;

          case 15:
            prioritizedFormats = [_mapsApiCommon.FORMATS.GEOJSON, _mapsApiCommon.FORMATS.JSON, _mapsApiCommon.FORMATS.NDJSON, _mapsApiCommon.FORMATS.TILEJSON];
            _i = 0, _prioritizedFormats = prioritizedFormats;

          case 17:
            if (!(_i < _prioritizedFormats.length)) {
              _context6.next = 26;
              break;
            }

            f = _prioritizedFormats[_i];
            url = getUrlFromMetadata(metadata, f);

            if (!url) {
              _context6.next = 23;
              break;
            }

            mapFormat = f;
            return _context6.abrupt("break", 26);

          case 23:
            _i++;
            _context6.next = 17;
            break;

          case 26:
            (0, _utils.assert)(url && mapFormat, 'Unsupported data formats received from backend.');

          case 27:
            if (format === _mapsApiCommon.FORMATS.TILEJSON && formatTiles) {
              _core.log.assert(Object.values(_mapsApiCommon.TILE_FORMATS).includes(formatTiles), "Invalid value for formatTiles: ".concat(formatTiles, ". Use value from TILE_FORMATS"));

              url += "&".concat((0, _mapsApiCommon.encodeParameter)('formatTiles', formatTiles));
            }

            accessToken = localCreds.accessToken;
            return _context6.abrupt("return", {
              url: url,
              accessToken: accessToken,
              mapFormat: mapFormat,
              metadata: metadata
            });

          case 30:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));
  return _fetchDataUrl2.apply(this, arguments);
}

function _fetchMapDataset(_x7, _x8, _x9, _x10, _x11) {
  return _fetchMapDataset2.apply(this, arguments);
}

function _fetchMapDataset2() {
  _fetchMapDataset2 = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee7(dataset, accessToken, credentials, clientId, headers) {
    var aggregationExp, aggregationResLevel, connection, columns, format, geoColumn, source, type, queryParameters, _yield$_fetchDataUrl2, url, mapFormat, cache, errorContext;

    return _regenerator.default.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            aggregationExp = dataset.aggregationExp, aggregationResLevel = dataset.aggregationResLevel, connection = dataset.connectionName, columns = dataset.columns, format = dataset.format, geoColumn = dataset.geoColumn, source = dataset.source, type = dataset.type, queryParameters = dataset.queryParameters;
            _context7.next = 3;
            return _fetchDataUrl({
              aggregationExp: aggregationExp,
              aggregationResLevel: aggregationResLevel,
              clientId: clientId,
              credentials: _objectSpread(_objectSpread({}, credentials), {}, {
                accessToken: accessToken
              }),
              connection: connection,
              columns: columns,
              format: format,
              geoColumn: geoColumn,
              headers: headers,
              source: source,
              type: type,
              queryParameters: queryParameters
            });

          case 3:
            _yield$_fetchDataUrl2 = _context7.sent;
            url = _yield$_fetchDataUrl2.url;
            mapFormat = _yield$_fetchDataUrl2.mapFormat;
            cache = parseInt(new URL(url).searchParams.get('cache') || '', 10);

            if (!(cache && dataset.cache === cache)) {
              _context7.next = 9;
              break;
            }

            return _context7.abrupt("return", false);

          case 9:
            dataset.cache = cache;
            errorContext = {
              requestType: _mapsApiCommon.REQUEST_TYPES.DATA,
              connection: connection,
              type: type,
              source: source
            };
            _context7.next = 13;
            return requestData({
              url: url,
              format: mapFormat,
              accessToken: accessToken,
              errorContext: errorContext
            });

          case 13:
            dataset.data = _context7.sent;
            return _context7.abrupt("return", true);

          case 15:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7);
  }));
  return _fetchMapDataset2.apply(this, arguments);
}

function _fetchTilestats(_x12, _x13, _x14, _x15) {
  return _fetchTilestats2.apply(this, arguments);
}

function _fetchTilestats2() {
  _fetchTilestats2 = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee8(attribute, dataset, accessToken, credentials) {
    var connection, source, type, statsUrl, baseUrl, errorContext, url, stats, attributes, index;
    return _regenerator.default.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            connection = dataset.connectionName, source = dataset.source, type = dataset.type;
            statsUrl = (0, _config.buildStatsUrlFromBase)(credentials.apiBaseUrl);
            baseUrl = "".concat(statsUrl, "/").concat(connection, "/");

            if (type === _mapsApiCommon.MAP_TYPES.QUERY) {
              baseUrl += attribute;
            } else {
              baseUrl += "".concat(source, "/").concat(attribute);
            }

            errorContext = {
              requestType: _mapsApiCommon.REQUEST_TYPES.TILE_STATS,
              connection: connection,
              type: type,
              source: source
            };
            url = baseUrl;

            if (type === _mapsApiCommon.MAP_TYPES.QUERY) {
              url += "?".concat((0, _mapsApiCommon.encodeParameter)('q', source));
            }

            if (!(url.length > MAX_GET_LENGTH && type === _mapsApiCommon.MAP_TYPES.QUERY)) {
              _context8.next = 13;
              break;
            }

            _context8.next = 10;
            return requestJson({
              method: 'POST',
              url: baseUrl,
              accessToken: accessToken,
              body: JSON.stringify({
                q: source
              }),
              errorContext: errorContext
            });

          case 10:
            stats = _context8.sent;
            _context8.next = 16;
            break;

          case 13:
            _context8.next = 15;
            return requestJson({
              url: url,
              accessToken: accessToken,
              errorContext: errorContext
            });

          case 15:
            stats = _context8.sent;

          case 16:
            attributes = dataset.data.tilestats.layers[0].attributes;
            index = attributes.findIndex(function (d) {
              return d.attribute === attribute;
            });
            attributes[index] = stats;
            return _context8.abrupt("return", true);

          case 20:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  }));
  return _fetchTilestats2.apply(this, arguments);
}

function fillInMapDatasets(_x16, _x17, _x18, _x19) {
  return _fillInMapDatasets.apply(this, arguments);
}

function _fillInMapDatasets() {
  _fillInMapDatasets = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee9(_ref9, clientId, credentials, headers) {
    var datasets, token, promises;
    return _regenerator.default.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            datasets = _ref9.datasets, token = _ref9.token;
            promises = datasets.map(function (dataset) {
              return _fetchMapDataset(dataset, token, credentials, clientId, headers);
            });
            _context9.next = 4;
            return Promise.all(promises);

          case 4:
            return _context9.abrupt("return", _context9.sent);

          case 5:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));
  return _fillInMapDatasets.apply(this, arguments);
}

function fillInTileStats(_x20, _x21) {
  return _fillInTileStats.apply(this, arguments);
}

function _fillInTileStats() {
  _fillInTileStats = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee10(_ref10, credentials) {
    var datasets, keplerMapConfig, token, attributes, layers, _iterator, _step, _loop2, filteredAttributes, _loop, _i2, _attributes, promises;

    return _regenerator.default.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            datasets = _ref10.datasets, keplerMapConfig = _ref10.keplerMapConfig, token = _ref10.token;
            attributes = [];
            layers = keplerMapConfig.config.visState.layers;
            _iterator = _createForOfIteratorHelper(layers);

            try {
              _loop2 = function _loop2() {
                var layer = _step.value;

                for (var _i3 = 0, _Object$keys = Object.keys(layer.visualChannels); _i3 < _Object$keys.length; _i3++) {
                  var _layer$visualChannels;

                  var channel = _Object$keys[_i3];
                  var attribute = (_layer$visualChannels = layer.visualChannels[channel]) === null || _layer$visualChannels === void 0 ? void 0 : _layer$visualChannels.name;

                  if (attribute) {
                    var dataset = datasets.find(function (d) {
                      return d.id === layer.config.dataId;
                    });

                    if (dataset.data.tilestats && dataset.type !== _mapsApiCommon.MAP_TYPES.TILESET) {
                      attributes.push({
                        attribute: attribute,
                        dataset: dataset
                      });
                    }
                  }
                }
              };

              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                _loop2();
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }

            filteredAttributes = [];

            _loop = function _loop() {
              var a = _attributes[_i2];

              if (!filteredAttributes.find(function (_ref14) {
                var attribute = _ref14.attribute,
                    dataset = _ref14.dataset;
                return attribute === a.attribute && dataset === a.dataset;
              })) {
                filteredAttributes.push(a);
              }
            };

            for (_i2 = 0, _attributes = attributes; _i2 < _attributes.length; _i2++) {
              _loop();
            }

            promises = filteredAttributes.map(function (_ref15) {
              var attribute = _ref15.attribute,
                  dataset = _ref15.dataset;
              return _fetchTilestats(attribute, dataset, token, credentials);
            });
            _context10.next = 11;
            return Promise.all(promises);

          case 11:
            return _context10.abrupt("return", _context10.sent);

          case 12:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10);
  }));
  return _fillInTileStats.apply(this, arguments);
}

function fetchMap(_x22) {
  return _fetchMap.apply(this, arguments);
}

function _fetchMap() {
  _fetchMap = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee12(_ref11) {
    var cartoMapId, clientId, credentials, headers, autoRefresh, onNewData, defaultCredentials, localCreds, accessToken, url, errorContext, map, stopAutoRefresh, intervalId, geojsonLayers, geojsonDatasetIds, out, textLayers, font;
    return _regenerator.default.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            cartoMapId = _ref11.cartoMapId, clientId = _ref11.clientId, credentials = _ref11.credentials, headers = _ref11.headers, autoRefresh = _ref11.autoRefresh, onNewData = _ref11.onNewData;
            defaultCredentials = (0, _config.getDefaultCredentials)();
            localCreds = _objectSpread(_objectSpread({}, defaultCredentials.apiVersion === _mapsApiCommon.API_VERSIONS.V3 && defaultCredentials), credentials);
            accessToken = localCreds.accessToken;
            (0, _utils.assert)(cartoMapId, 'Must define CARTO map id: fetchMap({cartoMapId: "XXXX-XXXX-XXXX"})');
            (0, _utils.assert)(localCreds.apiVersion === _mapsApiCommon.API_VERSIONS.V3, 'Method only available for v3');
            (0, _utils.assert)(localCreds.apiBaseUrl, 'Must define apiBaseUrl');

            if (!localCreds.mapsUrl) {
              localCreds.mapsUrl = (0, _config.buildMapsUrlFromBase)(localCreds.apiBaseUrl);
            }

            if (autoRefresh || onNewData) {
              (0, _utils.assert)(onNewData, 'Must define `onNewData` when using autoRefresh');
              (0, _utils.assert)(typeof onNewData === 'function', '`onNewData` must be a function');
              (0, _utils.assert)(typeof autoRefresh === 'number' && autoRefresh > 0, '`autoRefresh` must be a positive number');
            }

            url = "".concat(localCreds.mapsUrl, "/public/").concat(cartoMapId);
            errorContext = {
              requestType: _mapsApiCommon.REQUEST_TYPES.PUBLIC_MAP,
              mapId: cartoMapId
            };
            _context12.next = 13;
            return requestJson({
              url: url,
              headers: headers,
              accessToken: accessToken,
              errorContext: errorContext
            });

          case 13:
            map = _context12.sent;

            if (autoRefresh) {
              intervalId = setInterval((0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee11() {
                var changed;
                return _regenerator.default.wrap(function _callee11$(_context11) {
                  while (1) {
                    switch (_context11.prev = _context11.next) {
                      case 0:
                        _context11.next = 2;
                        return fillInMapDatasets(map, clientId, localCreds, headers);

                      case 2:
                        changed = _context11.sent;

                        if (onNewData && changed.some(function (v) {
                          return v === true;
                        })) {
                          onNewData((0, _parseMap.parseMap)(map));
                        }

                      case 4:
                      case "end":
                        return _context11.stop();
                    }
                  }
                }, _callee11);
              })), autoRefresh * 1000);

              stopAutoRefresh = function stopAutoRefresh() {
                clearInterval(intervalId);
              };
            }

            geojsonLayers = map.keplerMapConfig.config.visState.layers.filter(function (_ref17) {
              var type = _ref17.type;
              return type === 'geojson' || type === 'point';
            });
            geojsonDatasetIds = geojsonLayers.map(function (_ref18) {
              var config = _ref18.config;
              return config.dataId;
            });
            map.datasets.forEach(function (dataset) {
              if (geojsonDatasetIds.includes(dataset.id)) {
                var _geojsonLayers$find = geojsonLayers.find(function (_ref19) {
                  var config = _ref19.config;
                  return config.dataId === dataset.id;
                }),
                    config = _geojsonLayers$find.config;

                dataset.format = 'geojson';

                if (!dataset.geoColumn && config.columns.geojson) {
                  dataset.geoColumn = config.columns.geojson;
                }
              }
            });
            _context12.next = 20;
            return fillInMapDatasets(map, clientId, localCreds, headers);

          case 20:
            _context12.next = 22;
            return fillInTileStats(map, localCreds);

          case 22:
            out = _objectSpread(_objectSpread({}, (0, _parseMap.parseMap)(map)), {
              stopAutoRefresh: stopAutoRefresh
            });
            textLayers = out.layers.filter(function (layer) {
              var pointType = layer.props.pointType || '';
              return pointType.includes('text');
            });

            if (!(textLayers.length && window.FontFace && !document.fonts.check('12px Inter'))) {
              _context12.next = 28;
              break;
            }

            font = new FontFace('Inter', 'url(https://fonts.gstatic.com/s/inter/v12/UcC73FwrK3iLTeHuS_fvQtMwCp50KnMa1ZL7W0Q5nw.woff2)');
            _context12.next = 28;
            return font.load().then(function (f) {
              return document.fonts.add(f);
            });

          case 28:
            return _context12.abrupt("return", out);

          case 29:
          case "end":
            return _context12.stop();
        }
      }
    }, _callee12);
  }));
  return _fetchMap.apply(this, arguments);
}
//# sourceMappingURL=maps-v3-client.js.map