"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMap = parseMap;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _layerMap = require("./layer-map");

var _pointLabelLayer = _interopRequireDefault(require("../layers/point-label-layer"));

var _core = require("@deck.gl/core");

var _extensions = require("@deck.gl/extensions");

var _utils = require("../utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var collisionFilterExtension = new _extensions.CollisionFilterExtension();

function parseMap(json) {
  var keplerMapConfig = json.keplerMapConfig,
      datasets = json.datasets,
      token = json.token;
  (0, _utils.assert)(keplerMapConfig.version === 'v1', 'Only support Kepler v1');
  var _keplerMapConfig$conf = keplerMapConfig.config,
      mapState = _keplerMapConfig$conf.mapState,
      mapStyle = _keplerMapConfig$conf.mapStyle;
  var _keplerMapConfig$conf2 = keplerMapConfig.config.visState,
      layers = _keplerMapConfig$conf2.layers,
      layerBlending = _keplerMapConfig$conf2.layerBlending,
      interactionConfig = _keplerMapConfig$conf2.interactionConfig;
  return {
    id: json.id,
    title: json.title,
    description: json.description,
    createdAt: json.createdAt,
    updatedAt: json.updatedAt,
    initialViewState: mapState,
    mapStyle: mapStyle,
    token: token,
    layers: layers.reverse().map(function (_ref) {
      var id = _ref.id,
          type = _ref.type,
          config = _ref.config,
          visualChannels = _ref.visualChannels;

      try {
        var dataId = config.dataId;
        var dataset = datasets.find(function (d) {
          return d.id === dataId;
        });
        (0, _utils.assert)(dataset, "No dataset matching dataId: ".concat(dataId));
        var data = dataset.data;
        (0, _utils.assert)(data, "No data loaded for dataId: ".concat(dataId));

        var _getLayer = (0, _layerMap.getLayer)(type, config, dataset),
            Layer = _getLayer.Layer,
            propMap = _getLayer.propMap,
            defaultProps = _getLayer.defaultProps;

        var styleProps = createStyleProps(config, propMap);
        return new Layer(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({
          id: id,
          data: data
        }, defaultProps), createInteractionProps(interactionConfig)), styleProps), createChannelProps(id, type, config, visualChannels, data)), createParametersProp(layerBlending, styleProps.parameters || {})), createLoadOptions(token)));
      } catch (e) {
        _core.log.error(e.message)();

        return undefined;
      }
    })
  };
}

function createParametersProp(layerBlending, parameters) {
  if (layerBlending === 'additive') {
    parameters.blendFunc = [770, 772];
    parameters.blendEquation = 32774;
  } else if (layerBlending === 'subtractive') {
    parameters.blendFunc = [1, 775, 770, 772];
    parameters.blendEquation = [32778, 32774];
  }

  return Object.keys(parameters).length ? {
    parameters: parameters
  } : {};
}

function createInteractionProps(interactionConfig) {
  var pickable = interactionConfig && interactionConfig.tooltip.enabled;
  return {
    autoHighlight: pickable,
    pickable: pickable
  };
}

function mapProps(source, target, mapping) {
  for (var sourceKey in mapping) {
    var sourceValue = source[sourceKey];
    var targetKey = mapping[sourceKey];

    if (sourceValue === undefined) {
      continue;
    }

    if (typeof targetKey === 'string') {
      target[targetKey] = sourceValue;
    } else if (typeof targetKey === 'function') {
      var _Object$entries$ = (0, _slicedToArray2.default)(Object.entries(targetKey(sourceValue))[0], 2),
          key = _Object$entries$[0],
          value = _Object$entries$[1];

      target[key] = value;
    } else if ((0, _typeof2.default)(targetKey) === 'object') {
      mapProps(sourceValue, target, targetKey);
    }
  }
}

function createStyleProps(config, mapping) {
  var result = {};
  mapProps(config, result, mapping);

  if (result.stroked && !result.getLineColor) {
    result.getLineColor = result.getFillColor;
  }

  for (var colorAccessor in _layerMap.OPACITY_MAP) {
    if (Array.isArray(result[colorAccessor])) {
      var color = (0, _toConsumableArray2.default)(result[colorAccessor]);
      var opacityKey = _layerMap.OPACITY_MAP[colorAccessor];
      var opacity = config.visConfig[opacityKey];
      color[3] = (0, _layerMap.opacityToAlpha)(opacity);
      result[colorAccessor] = color;
    }
  }

  result.highlightColor = config.visConfig.enable3d ? [255, 255, 255, 60] : [252, 242, 26, 255];
  return result;
}

function createChannelProps(id, type, config, visualChannels, data) {
  var colorField = visualChannels.colorField,
      colorScale = visualChannels.colorScale,
      radiusField = visualChannels.radiusField,
      radiusScale = visualChannels.radiusScale,
      sizeField = visualChannels.sizeField,
      sizeScale = visualChannels.sizeScale,
      strokeColorField = visualChannels.strokeColorField,
      strokeColorScale = visualChannels.strokeColorScale;
  var heightField = visualChannels.heightField,
      heightScale = visualChannels.heightScale;

  if (type === 'hexagonId') {
    heightField = sizeField;
    heightScale = sizeScale;
  }

  var textLabel = config.textLabel,
      visConfig = config.visConfig;
  var result = {};

  if (type === 'grid' || type === 'hexagon') {
    result.colorScaleType = colorScale;

    if (colorField) {
      var colorAggregation = config.visConfig.colorAggregation;

      if (!_layerMap.AGGREGATION[colorAggregation]) {
        result.getColorValue = (0, _layerMap.getColorValueAccessor)(colorField, colorAggregation, data);
      } else {
        result.getColorWeight = function (d) {
          return d[colorField.name];
        };
      }
    }
  } else if (colorField) {
    var aggregation = visConfig.colorAggregation,
        range = visConfig.colorRange;
    result.getFillColor = (0, _layerMap.getColorAccessor)(colorField, colorScale, {
      aggregation: aggregation,
      range: range
    }, visConfig.opacity, data);
  }

  if (type === 'point') {
    var _config$columns;

    var altitude = (_config$columns = config.columns) === null || _config$columns === void 0 ? void 0 : _config$columns.altitude;

    if (altitude) {
      result.dataTransform = function (data) {
        data.features.forEach(function (_ref2) {
          var geometry = _ref2.geometry,
              properties = _ref2.properties;
          var type = geometry.type,
              coordinates = geometry.coordinates;

          if (type === 'Point') {
            coordinates[2] = properties[altitude];
          }
        });
        return data;
      };
    }
  }

  if (radiusField || sizeField) {
    result.getPointRadius = (0, _layerMap.getSizeAccessor)(radiusField || sizeField, radiusScale || sizeScale, visConfig.sizeAggregation, visConfig.radiusRange || visConfig.sizeRange, data);
  }

  if (strokeColorField) {
    var fallbackOpacity = type === 'point' ? visConfig.opacity : 1;
    var opacity = visConfig.strokeOpacity !== undefined ? visConfig.strokeOpacity : fallbackOpacity;
    var _aggregation = visConfig.strokeColorAggregation,
        _range = visConfig.strokeColorRange;
    result.getLineColor = (0, _layerMap.getColorAccessor)(strokeColorField, strokeColorScale, {
      aggregation: _aggregation,
      range: _range
    }, opacity, data);
  }

  if (heightField && visConfig.enable3d) {
    result.getElevation = (0, _layerMap.getSizeAccessor)(heightField, heightScale, visConfig.heightAggregation, visConfig.heightRange || visConfig.sizeRange, data);
  }

  if (visConfig.customMarkers) {
    var maxIconSize = (0, _layerMap.getMaxMarkerSize)(visConfig, visualChannels);
    var getPointRadius = result.getPointRadius,
        getFillColor = result.getFillColor;
    var customMarkersUrl = visConfig.customMarkersUrl,
        customMarkersRange = visConfig.customMarkersRange,
        useMaskedIcons = visConfig.filled;
    result.pointType = 'icon';
    result.getIcon = (0, _layerMap.getIconUrlAccessor)(visualChannels.customMarkersField, customMarkersRange, {
      fallbackUrl: customMarkersUrl,
      maxIconSize: maxIconSize,
      useMaskedIcons: useMaskedIcons
    }, data);
    result._subLayerProps = {
      'points-icon': {
        loadOptions: {
          image: {
            type: 'imagebitmap'
          },
          imagebitmap: {
            resizeWidth: maxIconSize,
            resizeHeight: maxIconSize,
            resizeQuality: 'high'
          }
        }
      }
    };

    if (getFillColor && useMaskedIcons) {
      result.getIconColor = getFillColor;
    }

    if (getPointRadius) {
      result.getIconSize = getPointRadius;
    }

    if (visualChannels.rotationField) {
      result.getIconAngle = (0, _layerMap.negateAccessor)((0, _layerMap.getSizeAccessor)(visualChannels.rotationField, undefined, null, undefined, data));
    }
  } else if (type === 'point' || type === 'tileset') {
    result.pointType = 'circle';
  }

  if (textLabel && textLabel.length && textLabel[0].field) {
    var _textLabel = (0, _slicedToArray2.default)(textLabel, 2),
        mainLabel = _textLabel[0],
        secondaryLabel = _textLabel[1];

    var collisionGroup = id;
    result.getTextAlignmentBaseline = mainLabel.alignment;
    result.getTextAnchor = mainLabel.anchor;
    result.getTextColor = mainLabel.color;
    result.textOutlineColor = mainLabel.outlineColor;
    result.textSizeScale = mainLabel.size;

    var _ref3 = secondaryLabel || {},
        getSecondaryColor = _ref3.color,
        secondaryField = _ref3.field,
        secondaryOutlineColor = _ref3.outlineColor,
        secondarySizeScale = _ref3.size;

    result.getText = mainLabel.field && (0, _layerMap.getTextAccessor)(mainLabel.field, data);
    var getSecondaryText = secondaryField && (0, _layerMap.getTextAccessor)(secondaryField, data);
    result.pointType = "".concat(result.pointType, "+text");
    result.textCharacterSet = 'auto';
    result.textFontFamily = 'Inter, sans';
    result.textFontSettings = {
      sdf: true
    };
    result.textFontWeight = 600;
    result.textOutlineWidth = 3;
    result._subLayerProps = _objectSpread(_objectSpread({}, result._subLayerProps), {}, {
      'points-text': _objectSpread(_objectSpread({
        type: _pointLabelLayer.default,
        extensions: [collisionFilterExtension],
        collisionEnabled: true,
        collisionGroup: collisionGroup
      }, result.getPointRadius ? {
        getRadius: result.getPointRadius
      } : {
        radiusScale: visConfig.radius
      }), secondaryField && {
        getSecondaryText: getSecondaryText,
        getSecondaryColor: getSecondaryColor,
        secondarySizeScale: secondarySizeScale,
        secondaryOutlineColor: secondaryOutlineColor
      })
    });
  }

  return result;
}

function createLoadOptions(accessToken) {
  return {
    loadOptions: {
      fetch: {
        headers: {
          Authorization: "Bearer ".concat(accessToken)
        }
      }
    }
  };
}
//# sourceMappingURL=parseMap.js.map