"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDefaultCredentials = setDefaultCredentials;
exports.getDefaultCredentials = getDefaultCredentials;
exports.buildMapsUrlFromBase = buildMapsUrlFromBase;
exports.buildStatsUrlFromBase = buildStatsUrlFromBase;
exports.defaultCloudNativeCredentials = exports.defaultClassicCredentials = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _mapsApiCommon = require("./api/maps-api-common");

var _excluded = ["apiVersion"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var defaultClassicCredentials = {
  apiKey: 'default_public',
  region: 'us',
  username: 'public'
};
exports.defaultClassicCredentials = defaultClassicCredentials;
var defaultCloudNativeCredentials = {
  apiBaseUrl: 'https://gcp-us-east1.api.carto.com'
};
exports.defaultCloudNativeCredentials = defaultCloudNativeCredentials;
var credentials = {};
setDefaultCredentials({});

function setDefaultCredentials(_ref) {
  var apiVersion = _ref.apiVersion,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  apiVersion = apiVersion || _mapsApiCommon.API_VERSIONS.V3;

  switch (apiVersion) {
    case _mapsApiCommon.API_VERSIONS.V1:
    case _mapsApiCommon.API_VERSIONS.V2:
      credentials = _objectSpread(_objectSpread({
        apiVersion: apiVersion
      }, defaultClassicCredentials), rest);
      break;

    case _mapsApiCommon.API_VERSIONS.V3:
      credentials = _objectSpread(_objectSpread({
        apiVersion: apiVersion
      }, defaultCloudNativeCredentials), rest);
      break;

    default:
      throw new Error("Invalid API version ".concat(apiVersion, ". Use API_VERSIONS enum."));
  }
}

function getDefaultCredentials() {
  return credentials;
}

function buildUrlFromBase(apiBaseUrl, endpoint) {
  var suffix = "/v3/".concat(endpoint);

  if (apiBaseUrl.endsWith('/')) {
    suffix = suffix.substring(1);
  }

  return "".concat(apiBaseUrl).concat(suffix);
}

function buildMapsUrlFromBase(apiBaseUrl) {
  return buildUrlFromBase(apiBaseUrl, 'maps');
}

function buildStatsUrlFromBase(apiBaseUrl) {
  return buildUrlFromBase(apiBaseUrl, 'stats');
}
//# sourceMappingURL=config.js.map