"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _geoLayers = require("@deck.gl/geo-layers");

var _api = require("../api");

var _layerMap = require("../api/layer-map");

var _mapsApiCommon = require("../api/maps-api-common");

var _config = require("../config");

var _utils = require("../utils");

var _excluded = ["type", "data", "credentials", "connection"],
    _excluded2 = ["data"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  data: null,
  type: null,
  onDataLoad: {
    type: 'function',
    value: function value(data) {}
  },
  onDataError: {
    type: 'function',
    value: null,
    optional: true
  },
  uniqueIdProperty: 'cartodb_id',
  credentials: null,
  connection: null,
  format: null,
  formatTiles: null,
  clientId: null,
  geoColumn: null,
  columns: {
    type: 'array',
    value: null
  },
  headers: {
    type: 'object',
    value: {},
    optional: true
  },
  aggregationExp: null,
  aggregationResLevel: null,
  queryParameters: null
};

var CartoLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(CartoLayer, _CompositeLayer);

  var _super = _createSuper(CartoLayer);

  function CartoLayer() {
    (0, _classCallCheck2.default)(this, CartoLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(CartoLayer, [{
    key: "initializeState",
    value: function initializeState() {
      this.state = {
        data: null,
        apiVersion: null
      };
    }
  }, {
    key: "isLoaded",
    get: function get() {
      return this.getSubLayers().length > 0 && (0, _get2.default)((0, _getPrototypeOf2.default)(CartoLayer.prototype), "isLoaded", this);
    }
  }, {
    key: "_checkProps",
    value: function _checkProps(props) {
      var type = props.type,
          credentials = props.credentials,
          connection = props.connection,
          geoColumn = props.geoColumn,
          columns = props.columns;

      var localCreds = _objectSpread(_objectSpread({}, (0, _config.getDefaultCredentials)()), credentials);

      var apiVersion = localCreds.apiVersion;

      _core.log.assert(Object.values(_api.API_VERSIONS).includes(apiVersion), "Invalid apiVersion ".concat(apiVersion, ". Use API_VERSIONS enum."));

      if (apiVersion === _api.API_VERSIONS.V1 || apiVersion === _api.API_VERSIONS.V2) {
        _core.log.assert(type === _mapsApiCommon.MAP_TYPES.QUERY || type === _mapsApiCommon.MAP_TYPES.TILESET, "Invalid type ".concat(type, ". Use type MAP_TYPES.QUERY or MAP_TYPES.TILESET for apiVersion ").concat(apiVersion));

        _core.log.assert(!connection, "Connection prop is not supported for apiVersion ".concat(apiVersion));

        _core.log.assert(!geoColumn, "geoColumn prop is not supported for apiVersion ".concat(apiVersion));

        _core.log.assert(!columns, "columns prop is not supported for apiVersion ".concat(apiVersion));
      } else if (apiVersion === _api.API_VERSIONS.V3) {
        _core.log.assert(connection, 'Missing mandatory connection parameter');

        _core.log.assert(Object.values(_mapsApiCommon.MAP_TYPES).includes(type), "Invalid type ".concat(type, ". Use MAP_TYPES enum."));

        if (!_mapsApiCommon.COLUMNS_SUPPORT.includes(type)) {
          _core.log.assert(!columns, "columns prop is only supported for types: ".concat(_mapsApiCommon.COLUMNS_SUPPORT.join()));
        }

        if (!_mapsApiCommon.GEO_COLUMN_SUPPORT.includes(type)) {
          _core.log.assert(!geoColumn, "geoColumn prop is only supported for types: ".concat(_mapsApiCommon.GEO_COLUMN_SUPPORT.join()));
        }

        if (columns) {
          _core.log.assert(Array.isArray(columns), 'columns prop must be an Array');
        }
      }
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      this._checkProps(props);

      var shouldUpdateData = changeFlags.dataChanged || props.aggregationExp !== oldProps.aggregationExp || props.aggregationResLevel !== oldProps.aggregationResLevel || props.connection !== oldProps.connection || props.geoColumn !== oldProps.geoColumn || props.formatTiles !== oldProps.formatTiles || props.type !== oldProps.type || JSON.stringify(props.columns) !== JSON.stringify(oldProps.columns) || JSON.stringify(props.credentials) !== JSON.stringify(oldProps.credentials) || JSON.stringify(props.queryParameters) !== JSON.stringify(oldProps.queryParameters);

      if (shouldUpdateData) {
        this.setState({
          data: null,
          apiVersion: null
        });

        this._updateData();
      }
    }
  }, {
    key: "_updateData",
    value: function () {
      var _updateData2 = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee() {
        var _this$props$onDataLoa, _this$props2, _this$props, type, source, credentials, connection, rest, localConfig, apiVersion, result;

        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _this$props = this.props, type = _this$props.type, source = _this$props.data, credentials = _this$props.credentials, connection = _this$props.connection, rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
                localConfig = _objectSpread(_objectSpread({}, (0, _config.getDefaultCredentials)()), credentials);
                apiVersion = localConfig.apiVersion;

                if (!(apiVersion === _api.API_VERSIONS.V1 || apiVersion === _api.API_VERSIONS.V2)) {
                  _context.next = 11;
                  break;
                }

                _context.next = 7;
                return (0, _api.getDataV2)({
                  type: type,
                  source: source,
                  credentials: credentials
                });

              case 7:
                _context.t0 = _context.sent;
                result = {
                  data: _context.t0
                };
                _context.next = 14;
                break;

              case 11:
                _context.next = 13;
                return (0, _api.fetchLayerData)(_objectSpread(_objectSpread({
                  type: type,
                  source: source,
                  credentials: credentials,
                  connection: connection
                }, rest), {}, {
                  format: _mapsApiCommon.FORMATS.TILEJSON
                }));

              case 13:
                result = _context.sent;

              case 14:
                this.setState(_objectSpread(_objectSpread({}, result), {}, {
                  apiVersion: apiVersion
                }));
                (_this$props$onDataLoa = (_this$props2 = this.props).onDataLoad) === null || _this$props$onDataLoa === void 0 ? void 0 : _this$props$onDataLoa.call(_this$props2, result.data, {
                  propName: 'data',
                  layer: this
                });
                _context.next = 25;
                break;

              case 18:
                _context.prev = 18;
                _context.t1 = _context["catch"](0);

                if (!this.props.onDataError) {
                  _context.next = 24;
                  break;
                }

                this.props.onDataError(_context.t1);
                _context.next = 25;
                break;

              case 24:
                throw _context.t1;

              case 25:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 18]]);
      }));

      function _updateData() {
        return _updateData2.apply(this, arguments);
      }

      return _updateData;
    }()
  }, {
    key: "_getSubLayerAndProps",
    value: function _getSubLayerAndProps() {
      (0, _utils.assert)(this.state);
      var _this$state = this.state,
          data = _this$state.data,
          apiVersion = _this$state.apiVersion;
      var uniqueIdProperty = defaultProps.uniqueIdProperty;
      var _this$props3 = this.props,
          _notUsed = _this$props3.data,
          propsNoData = (0, _objectWithoutProperties2.default)(_this$props3, _excluded2);

      var props = _objectSpread({
        uniqueIdProperty: uniqueIdProperty
      }, propsNoData);

      if (apiVersion === _api.API_VERSIONS.V1 || apiVersion === _api.API_VERSIONS.V2) {
        return [_geoLayers.MVTLayer, props];
      }

      var tileUrl = new URL(data.tiles[0]);
      props.formatTiles = props.formatTiles || tileUrl.searchParams.get('formatTiles');
      return [(0, _layerMap.layerFromTileDataset)(props.formatTiles, data.scheme, props.type), props];
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      (0, _utils.assert)(this.state);
      var _this$state2 = this.state,
          apiVersion = _this$state2.apiVersion,
          data = _this$state2.data;
      if (!data) return null;
      var _this$props4 = this.props,
          credentials = _this$props4.credentials,
          updateTriggers = _this$props4.updateTriggers;
      var loadOptions = this.getLoadOptions() || {};

      if (apiVersion === _api.API_VERSIONS.V3) {
        var _loadOptions$fetch;

        var localConfig = _objectSpread(_objectSpread({}, (0, _config.getDefaultCredentials)()), credentials);

        var accessToken = localConfig.accessToken;
        loadOptions.fetch = _objectSpread(_objectSpread({}, loadOptions.fetch), {}, {
          headers: _objectSpread(_objectSpread({}, (_loadOptions$fetch = loadOptions.fetch) === null || _loadOptions$fetch === void 0 ? void 0 : _loadOptions$fetch.headers), {}, {
            Authorization: "Bearer ".concat(accessToken)
          })
        });
      }

      var _this$_getSubLayerAnd = this._getSubLayerAndProps(),
          _this$_getSubLayerAnd2 = (0, _slicedToArray2.default)(_this$_getSubLayerAnd, 2),
          layer = _this$_getSubLayerAnd2[0],
          props = _this$_getSubLayerAnd2[1];

      return new layer(props, this.getSubLayerProps({
        id: "carto-".concat(layer.layerName),
        data: data,
        loadOptions: loadOptions,
        updateTriggers: updateTriggers
      }));
    }
  }]);
  return CartoLayer;
}(_core.CompositeLayer);

exports.default = CartoLayer;
(0, _defineProperty2.default)(CartoLayer, "layerName", 'CartoLayer');
(0, _defineProperty2.default)(CartoLayer, "defaultProps", defaultProps);
//# sourceMappingURL=carto-layer.js.map