"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@loaders.gl/core");

var _cartoVectorTileLoader = _interopRequireDefault(require("./schema/carto-vector-tile-loader"));

var _extensions = require("@deck.gl/extensions");

var _geoLayers = require("@deck.gl/geo-layers");

var _layers = require("@deck.gl/layers");

var _gis = require("@loaders.gl/gis");

var _mapsApiCommon = require("../api/maps-api-common");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

(0, _core.registerLoaders)([_cartoVectorTileLoader.default]);
var defaultTileFormat = _mapsApiCommon.TILE_FORMATS.BINARY;

var defaultProps = _objectSpread(_objectSpread({}, _geoLayers.MVTLayer.defaultProps), {}, {
  formatTiles: defaultTileFormat
});

var CartoTileLayer = function (_MVTLayer) {
  (0, _inherits2.default)(CartoTileLayer, _MVTLayer);

  var _super = _createSuper(CartoTileLayer);

  function CartoTileLayer() {
    (0, _classCallCheck2.default)(this, CartoTileLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(CartoTileLayer, [{
    key: "initializeState",
    value: function initializeState() {
      (0, _get2.default)((0, _getPrototypeOf2.default)(CartoTileLayer.prototype), "initializeState", this).call(this);
      var binary = this.props.formatTiles === _mapsApiCommon.TILE_FORMATS.BINARY;
      this.setState({
        binary: binary
      });
    }
  }, {
    key: "getTileData",
    value: function getTileData(tile) {
      var url = (0, _geoLayers._getURLFromTemplate)(this.state.data, tile);

      if (!url) {
        return Promise.reject('Invalid URL');
      }

      var loadOptions = this.getLoadOptions();
      var fetch = this.props.fetch;
      var signal = tile.signal;
      return fetch(url, {
        propName: 'data',
        layer: this,
        loadOptions: loadOptions,
        signal: signal
      });
    }
  }, {
    key: "renderSubLayers",
    value: function renderSubLayers(props) {
      if (props.data === null) {
        return null;
      }

      var tileBbox = props.tile.bbox;
      var west = tileBbox.west,
          south = tileBbox.south,
          east = tileBbox.east,
          north = tileBbox.north;

      var subLayerProps = _objectSpread(_objectSpread({}, props), {}, {
        autoHighlight: false,
        extensions: [new _extensions.ClipExtension()].concat((0, _toConsumableArray2.default)(props.extensions || [])),
        clipBounds: [west, south, east, north]
      });

      var subLayer = new _layers.GeoJsonLayer(subLayerProps);
      return subLayer;
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(params) {
      var info = (0, _get2.default)((0, _getPrototypeOf2.default)(CartoTileLayer.prototype), "getPickingInfo", this).call(this, params);

      if (this.state.binary && info.index !== -1) {
        var data = params.sourceLayer.props.data;
        info.object = (0, _gis.binaryToGeojson)(data, {
          globalFeatureId: info.index
        });
      }

      return info;
    }
  }]);
  return CartoTileLayer;
}(_geoLayers.MVTLayer);

exports.default = CartoTileLayer;
(0, _defineProperty2.default)(CartoTileLayer, "layerName", 'CartoTileLayer');
(0, _defineProperty2.default)(CartoTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=carto-tile-layer.js.map