"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _geoLayers = require("@deck.gl/geo-layers");

var _h3Tileset2d = _interopRequireWildcard(require("./h3-tileset-2d"));

var _spatialIndexTileLayer = _interopRequireDefault(require("./spatial-index-tile-layer"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var renderSubLayers = function renderSubLayers(props) {
  var data = props.data;
  var index = props.tile.index;
  if (!data || !data.length) return null;
  return new _geoLayers.H3HexagonLayer(props, {
    getHexagon: function getHexagon(d) {
      return d.id;
    },
    centerHexagon: index,
    highPrecision: true
  });
};

var defaultProps = {
  aggregationResLevel: 4
};

var H3TileLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(H3TileLayer, _CompositeLayer);

  var _super = _createSuper(H3TileLayer);

  function H3TileLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, H3TileLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(H3TileLayer, [{
    key: "initializeState",
    value: function initializeState() {
      _geoLayers.H3HexagonLayer._checkH3Lib();

      this.setState({
        data: null,
        tileJSON: null
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var changeFlags = _ref.changeFlags;

      if (changeFlags.dataChanged) {
        var data = this.props.data;
        var tileJSON = data;
        data = tileJSON.tiles;
        this.setState({
          data: data,
          tileJSON: tileJSON
        });
      }
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$state = this.state,
          data = _this$state.data,
          tileJSON = _this$state.tileJSON;
      var minresolution = parseInt(tileJSON.minresolution);
      var maxresolution = parseInt(tileJSON.maxresolution);

      if (this.props.minZoom) {
        minresolution = Math.max(minresolution, (0, _h3Tileset2d.getHexagonResolution)({
          zoom: this.props.minZoom,
          latitude: 0
        }));
      }

      if (this.props.maxZoom) {
        maxresolution = Math.min(maxresolution, (0, _h3Tileset2d.getHexagonResolution)({
          zoom: this.props.maxZoom,
          latitude: 0
        }));
      }

      return [new _spatialIndexTileLayer.default(this.props, {
        id: "h3-tile-layer-".concat(this.props.id),
        data: data,
        TilesetClass: _h3Tileset2d.default,
        renderSubLayers: renderSubLayers,
        minZoom: minresolution,
        maxZoom: maxresolution,
        loadOptions: _objectSpread(_objectSpread({}, this.getLoadOptions()), {}, {
          cartoSpatialTile: {
            scheme: 'h3'
          }
        })
      })];
    }
  }]);
  return H3TileLayer;
}(_core.CompositeLayer);

exports.default = H3TileLayer;
(0, _defineProperty2.default)(H3TileLayer, "layerName", 'H3TileLayer');
(0, _defineProperty2.default)(H3TileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=h3-tile-layer.js.map