"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHexagonResolution = getHexagonResolution;
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _geoLayers = require("@deck.gl/geo-layers");

var _h3Js = require("h3-js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function getHexagonsInBoundingBox(_ref, resolution) {
  var west = _ref.west,
      north = _ref.north,
      east = _ref.east,
      south = _ref.south;
  var longitudeSpan = Math.abs(east - west);

  if (longitudeSpan > 180) {
    var nSegments = Math.ceil(longitudeSpan / 180);
    var _h3Indices = [];

    for (var s = 0; s < nSegments; s++) {
      var segmentEast = east + s * 180;
      var segmentWest = Math.min(segmentEast + 179.9999999, west);
      _h3Indices = _h3Indices.concat(getHexagonsInBoundingBox({
        west: segmentWest,
        north: north,
        east: segmentEast,
        south: south
      }, resolution));
    }

    return (0, _toConsumableArray2.default)(new Set(_h3Indices));
  }

  var oversample = 2;
  var h3Indices = (0, _h3Js.polyfill)([[[west, north], [west, south], [east, south], [east, north], [west, north]]], resolution + oversample, true);
  return oversample ? (0, _toConsumableArray2.default)(new Set(h3Indices.map(function (i) {
    return (0, _h3Js.h3ToParent)(i, resolution);
  }))) : h3Indices;
}

function tileToBoundingBox(index) {
  var coordinates = (0, _h3Js.h3ToGeoBoundary)(index);
  var latitudes = coordinates.map(function (c) {
    return c[0];
  });
  var longitudes = coordinates.map(function (c) {
    return c[1];
  });
  var west = Math.min.apply(Math, (0, _toConsumableArray2.default)(longitudes));
  var south = Math.min.apply(Math, (0, _toConsumableArray2.default)(latitudes));
  var east = Math.max.apply(Math, (0, _toConsumableArray2.default)(longitudes));
  var north = Math.max.apply(Math, (0, _toConsumableArray2.default)(latitudes));
  return {
    west: west,
    south: south,
    east: east,
    north: north
  };
}

var BIAS = 2;

function getHexagonResolution(viewport) {
  var hexagonScaleFactor = 2 / 3 * viewport.zoom;
  var latitudeScaleFactor = Math.log(1 / Math.cos(Math.PI * viewport.latitude / 180));
  return Math.max(0, Math.floor(hexagonScaleFactor + latitudeScaleFactor - BIAS));
}

var H3Tileset2D = function (_Tileset2D) {
  (0, _inherits2.default)(H3Tileset2D, _Tileset2D);

  var _super = _createSuper(H3Tileset2D);

  function H3Tileset2D() {
    (0, _classCallCheck2.default)(this, H3Tileset2D);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(H3Tileset2D, [{
    key: "getTileIndices",
    value: function getTileIndices(_ref2) {
      var viewport = _ref2.viewport,
          minZoom = _ref2.minZoom,
          maxZoom = _ref2.maxZoom;
      if (viewport.latitude === undefined) return [];

      var _viewport$getBounds = viewport.getBounds(),
          _viewport$getBounds2 = (0, _slicedToArray2.default)(_viewport$getBounds, 4),
          east = _viewport$getBounds2[0],
          south = _viewport$getBounds2[1],
          west = _viewport$getBounds2[2],
          north = _viewport$getBounds2[3];

      var z = getHexagonResolution(viewport);
      var indices;

      if (typeof minZoom === 'number' && Number.isFinite(minZoom) && z < minZoom) {
        return [];
      }

      if (typeof maxZoom === 'number' && Number.isFinite(maxZoom) && z > maxZoom) {
        z = maxZoom;
        var center = (0, _h3Js.geoToH3)(viewport.latitude, viewport.longitude, maxZoom);
        indices = (0, _h3Js.kRing)(center, 1);
      } else {
        indices = getHexagonsInBoundingBox({
          west: west,
          north: north,
          east: east,
          south: south
        }, z);
      }

      return indices.map(function (i) {
        return {
          i: i
        };
      });
    }
  }, {
    key: "getTileId",
    value: function getTileId(_ref3) {
      var i = _ref3.i;
      return i;
    }
  }, {
    key: "getTileMetadata",
    value: function getTileMetadata(_ref4) {
      var i = _ref4.i;
      return {
        bbox: tileToBoundingBox(i)
      };
    }
  }, {
    key: "getTileZoom",
    value: function getTileZoom(_ref5) {
      var i = _ref5.i;
      return (0, _h3Js.h3GetResolution)(i);
    }
  }, {
    key: "getParentIndex",
    value: function getParentIndex(index) {
      var resolution = (0, _h3Js.h3GetResolution)(index.i);
      var i = (0, _h3Js.h3ToParent)(index.i, resolution - 1);
      return {
        i: i
      };
    }
  }]);
  return H3Tileset2D;
}(_geoLayers._Tileset2D);

exports.default = H3Tileset2D;
//# sourceMappingURL=h3-tileset-2d.js.map